/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.biz.erp.service.impl;

import com.baijia.tianxiao.biz.erp.dto.OrgCourseInfoPcDto;
import com.baijia.tianxiao.biz.erp.dto.response.schedule.CommonInfoTipsDto;
import com.baijia.tianxiao.biz.erp.dto.response.schedule.CourseBaseInfoDto;
import com.baijia.tianxiao.biz.erp.dto.response.schedule.CourseNameAndIdDto;
import com.baijia.tianxiao.biz.erp.dto.response.schedule.VipClassDetailDto;
import com.baijia.tianxiao.biz.erp.service.ErpCourseService;
import com.baijia.tianxiao.biz.erp.service.ErpStudentService;
import com.baijia.tianxiao.dal.enums.CourseTypeEnum;
import com.baijia.tianxiao.dal.org.constant.DeleteStatus;
import com.baijia.tianxiao.dal.org.dao.OrgAccountDao;
import com.baijia.tianxiao.dal.org.dao.OrgClassLessonDao;
import com.baijia.tianxiao.dal.org.dao.OrgCourseConsumeRuleDao;
import com.baijia.tianxiao.dal.org.dao.OrgCourseDao;
import com.baijia.tianxiao.dal.org.dao.OrgCourseRoomDao;
import com.baijia.tianxiao.dal.org.dao.OrgCourseTeacherDao;
import com.baijia.tianxiao.dal.org.dao.OrgInfoDao;
import com.baijia.tianxiao.dal.org.dao.OrgLessonSignDao;
import com.baijia.tianxiao.dal.org.dao.OrgStudentCourseDao;
import com.baijia.tianxiao.dal.org.dao.TXCascadeAccountDao;
import com.baijia.tianxiao.dal.org.dao.TXCascadeCredentialDao;
import com.baijia.tianxiao.dal.org.po.OrgAccount;
import com.baijia.tianxiao.dal.org.po.OrgCourse;
import com.baijia.tianxiao.dal.org.po.OrgCourseConsumeRule;
import com.baijia.tianxiao.dal.org.po.OrgInfo;
import com.baijia.tianxiao.dal.org.po.TXCascadeAccount;
import com.baijia.tianxiao.dal.org.po.TXCascadeCredential;
import com.baijia.tianxiao.dto.IdNameDto;
import com.baijia.tianxiao.dto.PersonBaseDto;
import com.baijia.tianxiao.dto.UniverseErrorCode;
import com.baijia.tianxiao.enums.CommonErrorCode;
import com.baijia.tianxiao.exception.BussinessException;
import com.baijia.tianxiao.filter.TianxiaoMContext;
import com.baijia.tianxiao.filter.TianxiaoPCContext;
import com.baijia.tianxiao.sal.course.dto.OrgCourseInfoDto;
import com.baijia.tianxiao.sal.course.dto.response.TeacherResponseDto;
import com.baijia.tianxiao.sal.course.enums.CourseConsumeRuleEnum;
import com.baijia.tianxiao.sal.course.service.CourseStudentService;
import com.baijia.tianxiao.sal.course.service.CourseTeacherService;
import com.baijia.tianxiao.sal.course.service.OrgCourseService;
import com.baijia.tianxiao.sal.organization.constant.CascadeType;
import com.baijia.tianxiao.sal.organization.constant.DeviceType;
import com.baijia.tianxiao.sal.organization.constant.TXPermissionConst;
import com.baijia.tianxiao.sal.organization.org.service.TxAccountPermissionService;
import com.baijia.tianxiao.sal.room.dto.ClassRoomDto;
import com.baijia.tianxiao.sal.room.service.ClassRoomService;
import com.baijia.tianxiao.sal.student.enums.StudentErrorCode;
import com.baijia.tianxiao.sqlbuilder.dto.PageDto;
import com.baijia.tianxiao.util.BaseUtils;
import com.baijia.tianxiao.util.json.JacksonUtil;
import com.beust.jcommander.internal.Lists;
import com.google.common.base.Preconditions;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.annotation.Resource;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Transformer;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ErpCourseServiceImpl
implements ErpCourseService {
    private static final Logger log = LoggerFactory.getLogger(ErpCourseServiceImpl.class);
    private static final String DEFAULT_CLASS_MASTER = "\u672a\u8bbe\u7f6e";
    @Resource
    private OrgCourseDao orgCourseDao;
    @Resource
    private CourseTeacherService courseTeacherService;
    @Resource
    private TXCascadeAccountDao cascadeAccountDao;
    @Resource
    private ClassRoomService classRoomService;
    @Resource
    private TXCascadeCredentialDao credentialDao;
    @Resource
    private OrgCourseRoomDao orgCourseRoomDao;
    @Resource
    private OrgCourseTeacherDao orgCourseTeacherDao;
    @Resource
    private OrgStudentCourseDao orgStudentCourseDao;
    @Resource
    private OrgClassLessonDao orgClassLessonDao;
    @Resource
    private OrgCourseService orgCourseService;
    @Resource
    private ErpStudentService erpStudentService;
    @Resource
    private OrgCourseConsumeRuleDao orgCourseConsumeRuleDao;
    @Resource
    private OrgAccountDao orgAccountDao;
    @Resource
    private CourseStudentService courseStudentService;
    @Resource
    private OrgInfoDao orgInfoDao;
    @Resource
    private TxAccountPermissionService permissionService;
    @Resource
    private OrgLessonSignDao orgLessonSignDao;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public CourseBaseInfoDto getCourseDetailById(Long orgId, Long courseId) {
        Preconditions.checkArgument((orgId != null && orgId > 0L ? 1 : 0) != 0, (Object)"illegal orgId");
        Preconditions.checkArgument((courseId != null && courseId > 0L ? 1 : 0) != 0, (Object)"illegal courseId");
        CourseBaseInfoDto orgCourseInfoDto = new CourseBaseInfoDto();
        OrgCourse course = null;
        if (courseId != null && courseId > 0L && (course = (OrgCourse)this.orgCourseDao.getById((Serializable)courseId, new String[0])) != null) {
            orgCourseInfoDto.setCourseNumber(course.getNumber());
            orgCourseInfoDto.setCourseId(courseId);
            orgCourseInfoDto.setCourseName(course.getName());
            orgCourseInfoDto.setCoursePrice(course.getPrice());
            orgCourseInfoDto.setAddress(course.getAddress());
            orgCourseInfoDto.setStartTime(course.getBeginTime());
            orgCourseInfoDto.setEndTime(course.getEndTime());
            orgCourseInfoDto.setTotalLessons(course.getFreq() == null ? 0 : course.getFreq());
            orgCourseInfoDto.setTeacherInfo(this.getCourseTeacherTips(orgId, courseId));
            orgCourseInfoDto.setClassMaster(this.getAccountName(orgId, course.getCascadeId()));
            orgCourseInfoDto.setRoomInfo(this.getCourseRoomTips(orgId, courseId));
            orgCourseInfoDto.setFinishedLessons(this.getFinishedLessonCount(orgId, courseId));
            orgCourseInfoDto.setStudentCount(this.getCourseStudentCount(orgId, courseId));
            String consumRuleName = "\u672a\u8bbe\u7f6e\u8bfe\u6d88\u89c4\u5219";
            OrgCourseConsumeRule courseConsumRule = this.orgCourseConsumeRuleDao.getRuleByCourseId(orgId, courseId);
            if (courseConsumRule != null) {
                orgCourseInfoDto.setConsumRuleId(courseConsumRule.getId());
                int consumVal = courseConsumRule.getRuleValue();
                consumRuleName = CourseConsumeRuleEnum.getRuleDescByValue((Integer)consumVal);
            }
            orgCourseInfoDto.setConsumeRuleName(consumRuleName);
        }
        log.info("ErpCourseServiceImpl.getCourseDetailById.orgId:{}, courseId:{}, data:{}", new Object[]{orgId, courseId, orgCourseInfoDto});
        return orgCourseInfoDto;
    }

    @Override
    public VipClassDetailDto getVipClassDetailById(Long orgId, Long courseId) {
        Preconditions.checkArgument((orgId != null && orgId > 0L ? 1 : 0) != 0, (Object)"illegal orgId");
        Preconditions.checkArgument((courseId != null && courseId > 0L ? 1 : 0) != 0, (Object)"illegal courseId");
        VipClassDetailDto vipClassDetailDto = new VipClassDetailDto();
        OrgCourse classInfo = (OrgCourse)this.orgCourseDao.getById((Serializable)courseId, new String[0]);
        if (classInfo == null || classInfo.getIsClass() != CourseTypeEnum.IS_CLASS_TRUE.getCode() || classInfo.getIsDel().intValue() == DeleteStatus.DELETED.getValue()) {
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.NOT_FOUND, "\u73ed\u7ea7\u4e0d\u5b58\u5728\u6216\u5df2\u88ab\u5220\u9664");
        }
        OrgCourse orgCourseInfo = (OrgCourse)this.orgCourseDao.getById((Serializable)classInfo.getParentId(), new String[0]);
        vipClassDetailDto.setCourseId(classInfo.getId());
        vipClassDetailDto.setClassName(classInfo.getName());
        vipClassDetailDto.setTeacherInfo(this.getCourseTeacherTips(orgId, classInfo.getId()));
        vipClassDetailDto.setRoomInfo(this.getCourseRoomTips(orgId, classInfo.getId()));
        vipClassDetailDto.setClassMaster(this.getAccountName(orgId, classInfo.getCascadeId()));
        vipClassDetailDto.setFinishedLessons(this.getFinishedVipLessonCount(orgId, courseId, orgCourseInfo.getId()));
        vipClassDetailDto.setTotalLessons(classInfo.getFreq() == null ? 0 : classInfo.getFreq());
        vipClassDetailDto.setCoursePrice(classInfo.getPrice() == null ? 0.0 : classInfo.getPrice());
        vipClassDetailDto.setCreateTime(classInfo.getCreateTime());
        vipClassDetailDto.setStudentCount(this.getCourseStudentCount(orgId, courseId));
        vipClassDetailDto.setStudentStatus(vipClassDetailDto.getStudentCount() == 0 ? 1 : 0);
        vipClassDetailDto.setTotalPrice(0.0);
        vipClassDetailDto.setAddress(classInfo.getAddress());
        OrgCourseConsumeRule courseConsumRule = this.orgCourseConsumeRuleDao.getRuleByCourseId(orgId, orgCourseInfo.getId());
        if (courseConsumRule == null) {
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.NOT_FOUND, "\u8bfe\u6d88\u89c4\u5219\u672a\u8bbe\u7f6e");
        }
        int consumeVal = courseConsumRule.getRuleValue();
        vipClassDetailDto.setConsumeRuleId(consumeVal);
        vipClassDetailDto.setConsumeRuleName(CourseConsumeRuleEnum.getRuleDescByValue((Integer)consumeVal));
        return vipClassDetailDto;
    }

    private Integer getFinishedVipLessonCount(Long orgId, Long courseId, Long parentCourseId) {
        OrgCourseConsumeRule orgCourseConsumeRule = this.orgCourseConsumeRuleDao.getRuleByCourseId(orgId, parentCourseId);
        int ruleValue = orgCourseConsumeRule.getRuleValue();
        int count = this.orgLessonSignDao.getVipLessonSignCount(orgId, courseId, ruleValue);
        return count;
    }

    private String getAccountName(Long orgId, Integer cascadeId) {
        if (cascadeId != null && cascadeId > 0) {
            TXCascadeAccount cascadeAccount = (TXCascadeAccount)this.cascadeAccountDao.getById((Serializable)cascadeId, new String[0]);
            if (cascadeAccount == null || cascadeAccount.getIsdel() == 1 || cascadeAccount.getStatus() == 1) {
                log.warn("[Wechat] Message TXCascadeAccount is invalidate.cascadeAccount={}", (Object)cascadeAccount);
            } else {
                TXCascadeCredential credential = this.credentialDao.getTXCascadeCredentialByCredentialId(cascadeAccount.getCredentialId());
                if (credential != null) {
                    return credential.getName() == null ? credential.getMobile() : credential.getName();
                }
                log.error("[Wechat] Message TXCascadeCredential is invalidate.credentialId=" + cascadeAccount.getCredentialId());
            }
        } else if (cascadeId == 0) {
            OrgInfo orgInfo = this.orgInfoDao.getOrgInfo(Integer.valueOf(orgId.intValue()), new String[]{"contacts"});
            return orgInfo != null && StringUtils.isNotBlank((CharSequence)orgInfo.getContacts()) ? orgInfo.getContacts() : "";
        }
        return DEFAULT_CLASS_MASTER;
    }

    private CommonInfoTipsDto getCourseRoomTips(Long orgId, Long courseId) {
        List data = this.classRoomService.listOrgCourseRooms(orgId, courseId);
        CommonInfoTipsDto tips = null;
        if (CollectionUtils.isNotEmpty((Collection)data)) {
            tips = new CommonInfoTipsDto();
            int count = data.size();
            Set names = BaseUtils.getPropertiesList((List)data, (String)"roomName");
            tips.setCount(count);
            tips.setNames(names);
        }
        log.info("getCourseRoomTips.tips:{}", (Object)tips);
        return tips;
    }

    private CommonInfoTipsDto getCourseTeacherTips(Long orgId, Long courseId) {
        List data = this.courseTeacherService.listCourseTeacher(orgId, courseId);
        CommonInfoTipsDto tips = null;
        if (CollectionUtils.isNotEmpty((Collection)data)) {
            tips = new CommonInfoTipsDto();
            int count = data.size();
            Set names = BaseUtils.getPropertiesList((List)data, (String)"teacherName");
            tips.setCount(count);
            tips.setNames(names);
        }
        log.info("getCourseTeacherTips.tips:{}", (Object)tips);
        return tips;
    }

    private int getCourseStudentCount(Long orgId, Long courseId) {
        List studentIds = this.orgStudentCourseDao.getStudents(orgId, courseId, Integer.valueOf(0));
        return CollectionUtils.isNotEmpty((Collection)studentIds) ? studentIds.size() : 0;
    }

    private int getFinishedLessonCount(Long orgId, Long courseId) {
        int finishedLessonCount = this.orgClassLessonDao.getFinishLessonCount(orgId, courseId, Integer.valueOf(DeleteStatus.NORMAL.getValue()));
        return finishedLessonCount;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long saveOrUpdateCourse(Long orgId, OrgCourseInfoPcDto course) {
        Long courseId = this.orgCourseService.saveOrUpdateCourse(orgId, (OrgCourseInfoDto)course, true, true);
        if (courseId == null || courseId <= 0L) {
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.SYSTEM_ERROR, "\u4fdd\u5b58\u8bfe\u7a0b\u5931\u8d25");
        }
        List roomIds = Lists.newArrayList();
        List studentIds = Lists.newArrayList();
        try {
            if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{course.getRoomIds()})) {
                roomIds = JacksonUtil.str2List((String)course.getRoomIds(), Long.class);
            }
            if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{course.getStudentIds()})) {
                studentIds = JacksonUtil.str2List((String)course.getStudentIds(), Long.class);
            }
        }
        catch (Exception e) {
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u6559\u5ba4\u3001\u5b66\u751f\u53c2\u6570\u9519\u8bef");
        }
        this.classRoomService.saveCourseRooms(orgId, courseId, (Collection)roomIds);
        this.erpStudentService.saveCourseStudents(orgId, courseId, studentIds);
        if (course.getCascadeId() != null) {
            boolean hasPermission;
            Integer curCascadeId = TianxiaoPCContext.getTXCascadeId();
            if (curCascadeId != null && curCascadeId > 0 && !(hasPermission = this.permissionService.checkPermission(orgId, curCascadeId, DeviceType.PC, TXPermissionConst.FENPEI_BANZHUREN.getpCode()))) {
                throw new BussinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u6ca1\u6709\u5206\u914d\u73ed\u4e3b\u4efb\u7684\u6743\u9650");
            }
            OrgCourse orgCourse = this.orgCourseDao.getByCourseId(courseId, new String[]{"id", "cascadeId"});
            if (course.getCascadeId() == 0L) {
                orgCourse.setCascadeId(Integer.valueOf(0));
            } else if (course.getCascadeId() < 0L) {
                orgCourse.setCascadeId(Integer.valueOf(-1));
            } else {
                TXCascadeAccount cascadeAccount = this.cascadeAccountDao.getByIdAndOrgId(Integer.valueOf(course.getCascadeId().intValue()), Integer.valueOf(orgId.intValue()));
                if (cascadeAccount != null && cascadeAccount.getCredentialId() != null && cascadeAccount.getCredentialId() > 0) {
                    TXCascadeCredential txCascadeCredential = this.credentialDao.getTXCascadeCredentialByCredentialId(cascadeAccount.getCredentialId());
                    if (txCascadeCredential == null) {
                        throw new BussinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u5b50\u5e10\u53f7\u5f02\u5e38");
                    }
                    orgCourse.setCascadeId(cascadeAccount.getId());
                } else {
                    throw new BussinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u5b50\u5e10\u53f7\u5f02\u5e38");
                }
            }
            this.orgCourseDao.update((Object)orgCourse, Boolean.valueOf(false), new String[]{"cascadeId"});
        }
        return courseId;
    }

    @Override
    public List<CourseNameAndIdDto> fuzzyQuery(Long orgId, String courseName, Integer type, PageDto pageDto) {
        List<Long> courseIds = this.getCurrentUserCoursesIds();
        if (CollectionUtils.isEmpty(courseIds) && TianxiaoMContext.getTXCascadeId() != null) {
            TXCascadeAccount txCascadeAccount = (TXCascadeAccount)this.cascadeAccountDao.getById((Serializable)TianxiaoMContext.getTXCascadeId(), new String[0]);
            if (txCascadeAccount == null) {
                throw new BussinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u5b50\u5e10\u53f7\u4e0d\u5b58\u5728");
            }
            if (txCascadeAccount.getAccountType().intValue() == CascadeType.STAFF.getValue()) {
                return Lists.newArrayList();
            }
        }
        OrgAccount orgAccount = (OrgAccount)this.orgAccountDao.getById((Serializable)TianxiaoPCContext.getOrgId(), new String[0]);
        List courses = this.orgCourseDao.fuzzyQueryByCourseType(orgAccount.getNumber(), courseName, courseIds, type, pageDto);
        List data = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty((Collection)courses)) {
            data = (List)CollectionUtils.collect((Collection)courses, (Transformer)new Transformer(){

                public Object transform(Object input) {
                    CourseNameAndIdDto dto = new CourseNameAndIdDto();
                    OrgCourse course = (OrgCourse)input;
                    dto.setId(course.getId());
                    dto.setName(course.getName());
                    dto.setCourseType(course.getCourseType());
                    return dto;
                }
            });
        }
        return data;
    }

    private List<Long> getCurrentUserCoursesIds() {
        List courseIds = Lists.newArrayList();
        if (TianxiaoMContext.getTXCascadeId() != null) {
            TXCascadeAccount txCascadeAccount = (TXCascadeAccount)this.cascadeAccountDao.getById((Serializable)TianxiaoMContext.getTXCascadeId(), new String[0]);
            if (txCascadeAccount == null) {
                throw new BussinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u5b50\u5e10\u53f7\u4e0d\u5b58\u5728");
            }
            if (txCascadeAccount.getAccountType().intValue() == CascadeType.STAFF.getValue()) {
                log.debug("before clear courseIds:{}", (Object)courseIds);
                List tempIds = this.orgCourseDao.getCourseIdsByCascadeId(TianxiaoMContext.getTXCascadeId(), null, CourseTypeEnum.IS_CLASS_TRUE.getCode(), null);
                log.debug("user cascadeId={},courseIds={}", (Object)TianxiaoMContext.getTXCascadeId(), (Object)tempIds);
                if (CollectionUtils.isEmpty((Collection)courseIds)) {
                    courseIds.addAll(tempIds);
                } else if (!tempIds.containsAll(courseIds)) {
                    courseIds.clear();
                }
            }
        }
        return courseIds;
    }

    @Override
    public OrgCourseInfoPcDto getOrgCourseInfoPc(Long orgId, Long courseId) throws IllegalAccessException, InvocationTargetException {
        Preconditions.checkArgument((orgId != null && orgId > 0L ? 1 : 0) != 0, (Object)"orgId is illegal");
        Preconditions.checkArgument((courseId != null && courseId > 0L ? 1 : 0) != 0, (Object)"courseId is illegal");
        OrgAccount orgAccount = (OrgAccount)this.orgAccountDao.getById((Serializable)orgId, new String[]{"isDel", "mobile"});
        OrgInfo orgInfo = this.orgInfoDao.getOrgInfo(Integer.valueOf(orgId.intValue()), new String[]{"contacts"});
        if (orgAccount == null || orgAccount.getIsDel().intValue() == DeleteStatus.DELETED.getValue() || orgInfo == null) {
            throw new BussinessException((UniverseErrorCode)StudentErrorCode.ORG_NOT_EXIST);
        }
        OrgCourse orgCourse = this.orgCourseDao.getByCourseId(courseId, new String[]{"id", "cascadeId"});
        if (orgCourse == null) {
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u673a\u6784id\u9519\u8bef");
        }
        OrgCourseInfoPcDto courseDto = new OrgCourseInfoPcDto();
        OrgCourseInfoDto courseInfo = this.orgCourseService.getOrgCourseInfo(orgId, courseId);
        if (courseInfo == null) {
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u53c2\u6570\u9519\u8bef");
        }
        BeanUtils.copyProperties((Object)((Object)courseDto), (Object)courseInfo);
        List rooms = this.classRoomService.listOrgCourseRooms(orgId, courseId);
        List roomList = Lists.newArrayList();
        for (ClassRoomDto room : rooms) {
            IdNameDto roomDto = new IdNameDto();
            roomDto.setId(Integer.valueOf(room.getRoomId().intValue()));
            roomDto.setName(room.getRoomName());
            roomList.add(roomDto);
        }
        courseDto.setRooms(roomList);
        courseDto.setTotalLessons(courseInfo.getFreq() == null ? 0 : courseInfo.getFreq());
        Integer lessonCount = this.orgClassLessonDao.getLessonCount(orgId, courseId, Integer.valueOf(0));
        courseDto.setScheduleLessons(lessonCount == null ? 0 : lessonCount);
        List students = this.courseStudentService.getCourseStudentsBase(orgId, courseId);
        courseDto.setStudents(students);
        List teachers = courseInfo.getTeachers();
        List teacherList = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty((Collection)teachers)) {
            for (TeacherResponseDto teacher : teachers) {
                PersonBaseDto teacherDto = new PersonBaseDto();
                teacherDto.setId(teacher.getTeacherId());
                teacherDto.setName(teacher.getTeacherName());
                teacherDto.setAvatarUrl(teacher.getAvatar());
                teacherList.add(teacherDto);
            }
        }
        courseDto.setCourseTeachers(teacherList);
        if (orgCourse.getCascadeId() == null || orgCourse.getCascadeId() == 0) {
            courseDto.setCascadeId(0L);
            courseDto.setCascadeName(orgInfo.getContacts());
        } else if (orgCourse.getCascadeId() == -1) {
            courseDto.setCascadeId(-1L);
        } else {
            TXCascadeAccount cascadeAccount = this.cascadeAccountDao.getByIdAndOrgId(orgCourse.getCascadeId(), Integer.valueOf(orgId.intValue()));
            if (cascadeAccount.getCredentialId() != null && cascadeAccount.getCredentialId() > 0) {
                TXCascadeCredential cascadeCredential = this.credentialDao.getTXCascadeCredentialByCredentialId(cascadeAccount.getCredentialId());
                courseDto.setCascadeId(cascadeAccount.getId().longValue());
                if (cascadeCredential != null) {
                    courseDto.setCascadeName(cascadeCredential.getName());
                    if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{cascadeCredential.getAvatar()})) {
                        courseDto.setCascadeAvatarUrl(cascadeCredential.getAvatar());
                    } else {
                        courseDto.setCascadeAvatarUrl("http://img.gsxservice.com/11868865_wlpn1jd6.png");
                    }
                }
            }
        }
        return courseDto;
    }
}

