/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.biz.erp.service.impl;

import com.baijia.tianxiao.biz.erp.dto.response.AppCourseListInfoDto;
import com.baijia.tianxiao.biz.erp.dto.response.ClassListInfoDtoForVip;
import com.baijia.tianxiao.biz.erp.dto.response.CourseListInfoDto;
import com.baijia.tianxiao.biz.erp.dto.response.studentCenter.WeiKeListInfoDto;
import com.baijia.tianxiao.biz.erp.service.ErpCourseListService;
import com.baijia.tianxiao.dal.enums.CourseTypeEnum;
import com.baijia.tianxiao.dal.org.dao.OrgAccountDao;
import com.baijia.tianxiao.dal.org.dao.OrgClassLessonDao;
import com.baijia.tianxiao.dal.org.dao.OrgCourseDao;
import com.baijia.tianxiao.dal.org.dao.OrgCourseRoomDao;
import com.baijia.tianxiao.dal.org.dao.OrgCourseTeacherDao;
import com.baijia.tianxiao.dal.org.dao.OrgStudentCourseDao;
import com.baijia.tianxiao.dal.org.dao.TXCascadeAccountDao;
import com.baijia.tianxiao.dal.org.po.OrgAccount;
import com.baijia.tianxiao.dal.org.po.OrgCourse;
import com.baijia.tianxiao.dal.org.po.TXCascadeAccount;
import com.baijia.tianxiao.dto.FieldShow;
import com.baijia.tianxiao.dto.UniverseErrorCode;
import com.baijia.tianxiao.dto.query.QueryCondition;
import com.baijia.tianxiao.enums.CommonErrorCode;
import com.baijia.tianxiao.exception.BussinessException;
import com.baijia.tianxiao.filter.TianxiaoMContext;
import com.baijia.tianxiao.sal.course.dto.request.CourseListRequestDto;
import com.baijia.tianxiao.sal.course.dto.request.WeikeRequestDto;
import com.baijia.tianxiao.sal.course.dto.response.CourseListReponseDto;
import com.baijia.tianxiao.sal.course.dto.response.TeacherResponseDto;
import com.baijia.tianxiao.sal.course.enums.CourseConsumeRuleEnum;
import com.baijia.tianxiao.sal.course.service.CourseStudentService;
import com.baijia.tianxiao.sal.course.service.CourseTeacherService;
import com.baijia.tianxiao.sal.course.service.OrgCourseConsumeRuleService;
import com.baijia.tianxiao.sal.course.service.OrgCourseListService;
import com.baijia.tianxiao.sal.course.service.OrgLessonSignService;
import com.baijia.tianxiao.sal.organization.constant.CascadeType;
import com.baijia.tianxiao.sal.organization.org.service.TxCascadeCredentialService;
import com.baijia.tianxiao.sqlbuilder.dto.PageDto;
import com.baijia.tianxiao.util.BaseUtils;
import com.baijia.tianxiao.util.CollectorUtil;
import com.baijia.tianxiao.util.HanZiPinYinUtils;
import com.baijia.tianxiao.util.StringUtils;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.Serializable;
import java.sql.Blob;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ErpCourseListServiceImpl
implements ErpCourseListService {
    private static final Logger log = LoggerFactory.getLogger(ErpCourseListServiceImpl.class);
    @Resource
    private OrgAccountDao orgAccountDao;
    @Resource
    private OrgCourseDao orgCourseDao;
    @Resource
    private OrgCourseTeacherDao orgCourseTeacherDao;
    @Resource
    private OrgCourseRoomDao orgCourseRoomDao;
    @Resource
    private OrgCourseListService orgCourseListService;
    @Resource
    private OrgLessonSignService orgLessonSignService;
    @Resource
    private CourseTeacherService courseTeacherService;
    @Resource
    private OrgCourseConsumeRuleService orgCourseConsumeRuleService;
    @Resource
    private CourseStudentService courseStudentService;
    @Resource
    private TxCascadeCredentialService txCascadeCredentialService;
    @Autowired
    private TXCascadeAccountDao txCascadeAccountDao;
    @Resource
    private OrgClassLessonDao orgClassLessonDao;
    @Resource
    private OrgStudentCourseDao orgStudentCourseDao;

    private Long getOrgNumber(Long orgId) {
        OrgAccount account = this.orgAccountDao.getAccountById(orgId.intValue(), new String[]{"number"});
        if (account == null) {
            return null;
        }
        Integer number = account.getNumber();
        return number != null ? Long.valueOf(number.longValue()) : null;
    }

    private Map<Long, List<String>> getTeachersOfCourses(Long orgId, Collection<Long> courseIds) {
        log.info("orgId={},courseIds={}", (Object)orgId, courseIds);
        HashMap resultMap = Maps.newHashMap();
        Map courseTeachersMap = this.orgCourseTeacherDao.getTeacherMap(courseIds);
        HashSet teacherIdsSet = Sets.newHashSet();
        for (Long key : courseTeachersMap.keySet()) {
            teacherIdsSet.addAll((Collection)courseTeachersMap.get(key));
        }
        List teacherDtoList = this.courseTeacherService.getTeachers((Collection)teacherIdsSet, orgId);
        Map teacherMap = CollectorUtil.collectMap((Collection)teacherDtoList, (Function)new Function<TeacherResponseDto, Long>(){

            public Long apply(TeacherResponseDto from) {
                return from.getTeacherId();
            }
        }, (Function)new Function<TeacherResponseDto, String>(){

            public String apply(TeacherResponseDto from) {
                return from.getTeacherName();
            }
        });
        for (Long courseId : courseIds) {
            List teacherIds = (List)courseTeachersMap.get(courseId);
            ArrayList teacherList = Lists.newArrayList();
            if (!CollectionUtils.isNotEmpty((Collection)teacherIds)) continue;
            for (Long tid : teacherIds) {
                teacherList.add(teacherMap.get(tid));
            }
            resultMap.put(courseId, teacherList);
        }
        log.debug("resultMap={}", (Object)resultMap);
        return resultMap;
    }

    @Override
    public List<WeiKeListInfoDto> getWeikeList(Long orgId, WeikeRequestDto requestDto) {
        Preconditions.checkArgument((orgId != null && orgId > 0L ? 1 : 0) != 0, (Object)"illegal orgId");
        long l = System.currentTimeMillis();
        List dtos = this.orgCourseListService.getWeikeList(orgId, requestDto);
        log.debug("************getWeikeList cost={}", (Object)(System.currentTimeMillis() - l));
        if (CollectionUtils.isEmpty((Collection)dtos)) {
            return Collections.emptyList();
        }
        Collection courseIds = CollectorUtil.collect((Collection)dtos, (Function)new Function<CourseListReponseDto, Long>(){

            public Long apply(CourseListReponseDto input) {
                return input.getOrgCourseId();
            }
        });
        Map<Long, Integer> stuCntMap = this.queryStuCntMap(orgId, dtos);
        log.debug("org_id={},courseIds={},studentCntMap = {}", new Object[]{orgId, courseIds, stuCntMap});
        ArrayList responseDto = Lists.newArrayList();
        HashSet courseId = Sets.newHashSet();
        for (CourseListReponseDto courseListReponseDto : dtos) {
            WeiKeListInfoDto dto = new WeiKeListInfoDto();
            this.buildWeiKeListInfoDto(courseListReponseDto, dto, stuCntMap);
            courseId.add(courseListReponseDto.getOrgCourseId());
            responseDto.add(dto);
        }
        Map rulemap = this.orgCourseConsumeRuleService.queryCourseRuleMapByCourseIds(orgId, (Collection)courseId);
        for (WeiKeListInfoDto dto : responseDto) {
            dto.setConsumerRule(CourseConsumeRuleEnum.getRuleDescByValue((Integer)((Integer)rulemap.get(dto.getOrgCourseId()))));
        }
        return responseDto;
    }

    private Map<Long, Integer> queryStuCntMap(Long orgId, List<CourseListReponseDto> dtos) {
        ArrayList classCourseIds = Lists.newArrayList();
        ArrayList oneoneCourseIds = Lists.newArrayList();
        for (CourseListReponseDto courseDto : dtos) {
            Long courseId = courseDto.getOrgCourseId();
            if (courseDto.getCourseType() == CourseTypeEnum.COURSE_TYPE_1v1.getCode()) {
                oneoneCourseIds.add(courseId);
                continue;
            }
            classCourseIds.add(courseId);
        }
        HashMap coursestuCntMap = Maps.newHashMap();
        if (classCourseIds.size() > 0) {
            Map classCoursestuCntMap = this.orgStudentCourseDao.getStudentCountNoStatus(orgId, (Collection)classCourseIds, null);
            coursestuCntMap.putAll(classCoursestuCntMap);
        }
        if (oneoneCourseIds.size() > 0) {
            HashMap countCondition = Maps.newHashMap();
            countCondition.put("parentId", oneoneCourseIds);
            Map oneoneStuCntMap = this.orgCourseDao.groupCount((Map)countCondition, "id", "parentId", true, Long.class);
            coursestuCntMap.putAll(oneoneStuCntMap);
        }
        return coursestuCntMap;
    }

    private void buildWeiKeListInfoDto(CourseListReponseDto courseListReponseDto, WeiKeListInfoDto weiKeListInfoDto, Map<Long, Integer> stuCntMap) {
        weiKeListInfoDto.setCourseType(courseListReponseDto.getCourseType());
        weiKeListInfoDto.setCourseName(courseListReponseDto.getCourseName());
        weiKeListInfoDto.setCourseUrl(courseListReponseDto.getCourseUrl());
        weiKeListInfoDto.setCoverUrl(courseListReponseDto.getCoverUrl());
        weiKeListInfoDto.setMaxStudent(courseListReponseDto.getMaxStudent());
        weiKeListInfoDto.setOrgCourseId(courseListReponseDto.getOrgCourseId());
        weiKeListInfoDto.setStudentCount(stuCntMap.get(courseListReponseDto.getOrgCourseId()) == null ? 0 : stuCntMap.get(courseListReponseDto.getOrgCourseId()));
        weiKeListInfoDto.setPrice(courseListReponseDto.getPrice());
        weiKeListInfoDto.setStatus(courseListReponseDto.getStatus());
        weiKeListInfoDto.setCourseCount(courseListReponseDto.getFreq());
        weiKeListInfoDto.setIntroduction(courseListReponseDto.getIntroduction());
        weiKeListInfoDto.setBeginTime(courseListReponseDto.getStartTime());
        weiKeListInfoDto.setEndTime(courseListReponseDto.getEndTime());
        weiKeListInfoDto.setCreateTime(courseListReponseDto.getCreateTime());
        weiKeListInfoDto.setIsCourse(courseListReponseDto.getIsCourse());
        weiKeListInfoDto.setTeacherNames(courseListReponseDto.getTeacherNames());
    }

    @Override
    public <E> List<E> getCourseList(Long orgId, Date startTime, Date endTime, CourseListRequestDto params, PageDto pageDto, Class<E> clazz) {
        Long orgNumber = this.getOrgNumber(orgId);
        Integer courseType = params.getCourseType();
        String searchKey = params.getSearchKey();
        String teacherIds = params.getTeacherIds();
        String roomIds = params.getRoomIds();
        List roomCourseIds = null;
        HashSet roomIdSet = Sets.newHashSet();
        if (org.apache.commons.lang3.StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{roomIds})) {
            String[] arr;
            for (String str : arr = roomIds.split(",")) {
                roomIdSet.add(Long.parseLong(str));
            }
            roomCourseIds = Lists.newArrayList();
            if (CollectionUtils.isNotEmpty((Collection)roomIdSet)) {
                roomCourseIds = this.orgCourseRoomDao.getcoursIdsByRoomIds((Collection)roomIdSet);
            }
        }
        List teacherCourseIds = null;
        HashSet teacherIdSet = Sets.newHashSet();
        if (org.apache.commons.lang3.StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{teacherIds})) {
            String[] arr;
            for (String str : arr = teacherIds.split(",")) {
                teacherIdSet.add(Long.parseLong(str));
            }
            teacherCourseIds = Lists.newArrayList();
            if (CollectionUtils.isNotEmpty((Collection)teacherIdSet)) {
                teacherCourseIds = this.orgCourseTeacherDao.getCourseIdsByteacherIds((Collection)teacherIdSet);
            }
        }
        ArrayList courseIds = null;
        if (roomCourseIds == null && teacherCourseIds != null) {
            courseIds = new ArrayList();
            courseIds.addAll(teacherCourseIds);
        }
        if (teacherCourseIds == null && roomCourseIds != null) {
            courseIds = new ArrayList();
            courseIds.addAll(roomCourseIds);
        }
        if (teacherCourseIds != null && roomCourseIds != null) {
            courseIds = new ArrayList();
            for (Long tcId : teacherCourseIds) {
                for (Long rcid : roomCourseIds) {
                    if (tcId.longValue() != rcid.longValue()) continue;
                    courseIds.add(tcId);
                }
            }
        }
        OrgCourseDao.OrgCourseListParam param = new OrgCourseDao.OrgCourseListParam();
        param.setCourseType(courseType);
        param.setIsCourse(params.getIsCourse());
        param.setIsClass(params.getIsClass());
        param.setKey(searchKey);
        param.setStartTime(startTime);
        param.setEndTime(endTime);
        param.setPage(pageDto);
        param.setStatus(params.getStatus());
        param.setCascadeId(params.getCascadeId());
        Map fieldShowMap = FieldShow.getColumnShowMap(clazz);
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)params.getOrderField())) {
            FieldShow fieldShow = (FieldShow)fieldShowMap.get(params.getOrderField());
            String orderField = fieldShow != null ? fieldShow.getPoName() : null;
            param.setOrderField(orderField);
            param.setOrderType(params.getOrderType());
        }
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)params.getOrderField())) {
            param.setOrderField("createTime");
            param.setOrderType("DESC");
        }
        param.setQueryCondition(QueryCondition.andCondtions((Collection)params.getQueryConditions(), (Map)fieldShowMap));
        param.setIsDel(params.getIsDel());
        List courses = this.orgCourseDao.getCourseList(orgNumber, courseIds, param, new String[0]);
        List dtos = this.orgCourseListService.getCourseList(courses, orgId, true, false, true, Boolean.valueOf(true), true, true, true);
        log.debug("course List==={}", (Object)dtos);
        Map<Long, List<String>> courseTeachersMap = null;
        if (params.getLoadTeacherList() != null && params.getLoadTeacherList().booleanValue()) {
            courseIds = Lists.newArrayList();
            for (OrgCourse course : courses) {
                courseIds.add(course.getId());
            }
            courseTeachersMap = this.getTeachersOfCourses(orgId, courseIds);
        }
        Map cascadeMap = this.txCascadeCredentialService.getByTxCasCadeIds(orgId);
        HashSet courseIdSet = Sets.newHashSet();
        ArrayList responseDto = Lists.newArrayList();
        for (CourseListReponseDto courseListReponseDto : dtos) {
            List<String> teachers;
            CourseListInfoDto dto = new CourseListInfoDto();
            this.buildCourseListInfoDto(courseListReponseDto, dto);
            if (courseTeachersMap != null && CollectionUtils.isNotEmpty(teachers = courseTeachersMap.get(courseListReponseDto.getOrgCourseId()))) {
                String teacherNames = this.parseTeacherNamesToString(teachers);
                dto.setTeacherNames(teacherNames == null ? "" : teacherNames);
            }
            String pinyin = HanZiPinYinUtils.getLowerCasePinYin((String)courseListReponseDto.getCourseName());
            String str = "#";
            if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)pinyin)) {
                char init = pinyin.charAt(0);
                str = String.valueOf(init);
            }
            if (!StringUtils.letterValidate((String)str)) {
                str = "#";
            }
            dto.setCourseNamePinYin(str.toUpperCase());
            dto.setCascadeIdStr((String)cascadeMap.get(dto.getCascadeId().longValue()));
            courseIdSet.add(dto.getCourseId());
            responseDto.add(dto);
        }
        log.debug("start find all consume rule, orgId={},courseIds ={}", (Object)orgId, (Object)courseIdSet);
        Map rulemap = this.orgCourseConsumeRuleService.queryCourseRuleMapByCourseIds(orgId, (Collection)courseIdSet);
        log.debug("find all consume rule, orgId={},courseIds ={},result={}", new Object[]{orgId, courseIdSet, rulemap});
        for (Object obj : responseDto) {
            CourseListInfoDto dto = (CourseListInfoDto)obj;
            dto.setConsumerRule(CourseConsumeRuleEnum.getRuleDescByValue((Integer)((Integer)rulemap.get(dto.getCourseId()))));
        }
        if (clazz.equals(CourseListInfoDto.class)) {
            return responseDto;
        }
        if (clazz.equals(ClassListInfoDtoForVip.class)) {
            return this.transformToVipClass(orgId, responseDto);
        }
        return Lists.newArrayList();
    }

    private String parseTeacherNamesToString(List<String> teachers) {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < teachers.size(); ++i) {
            if (teachers.get(i) == null || teachers.get(i) == "") continue;
            builder.append(teachers.get(i));
            if (i >= teachers.size() - 1) continue;
            builder.append(",");
        }
        if (builder.toString().endsWith(",")) {
            builder.deleteCharAt(builder.length() - 1);
        }
        return builder.toString();
    }

    private List transformToVipClass(Long orgId, List<CourseListInfoDto> dtoList) {
        ArrayList result = Lists.newArrayList();
        for (CourseListInfoDto course : dtoList) {
            ClassListInfoDtoForVip classVip = new ClassListInfoDtoForVip();
            try {
                BeanUtils.copyProperties((Object)classVip, (Object)course);
                classVip.setClassName(course.getCourseName());
                classVip.setBuyLessonCount(course.getFreq() == null ? 0 : course.getFreq());
                classVip.setOneLessonPrice(course.getPrice() == null ? 0.0 : course.getPrice());
                result.add(classVip);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return result;
    }

    @Override
    public List<CourseListInfoDto> getCourseListWithAttendanceRate(Long orgId, String searchKey, PageDto pageDto) {
        Long orgNumber = this.getOrgNumber(orgId);
        List courses = null;
        if (TianxiaoMContext.getTXCascadeId() == null) {
            courses = this.orgCourseDao.getCourseList(orgNumber, null, searchKey, null, null, null, null, CourseTypeEnum.IS_CLASS_TRUE.getCode(), null, pageDto, new String[0]);
        } else {
            TXCascadeAccount txCascadeAccount = (TXCascadeAccount)this.txCascadeAccountDao.getById((Serializable)TianxiaoMContext.getTXCascadeId(), new String[0]);
            if (txCascadeAccount == null) {
                throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u5b50\u5e10\u53f7\u4e0d\u5b58\u5728");
            }
            courses = txCascadeAccount.getAccountType().intValue() == CascadeType.STAFF.getValue() ? this.orgCourseDao.getCourseList(txCascadeAccount.getId(), orgNumber, null, searchKey, null, null, null, null, CourseTypeEnum.IS_CLASS_TRUE.getCode(), null, pageDto, new String[0]) : this.orgCourseDao.getCourseList(orgNumber, null, searchKey, null, null, null, null, CourseTypeEnum.IS_CLASS_TRUE.getCode(), null, pageDto, new String[0]);
        }
        List<CourseListReponseDto> dtos = this.getCourseListWithAttendanceRate(courses, orgId);
        ArrayList responseDto = Lists.newArrayList();
        Map cascadeMap = this.txCascadeCredentialService.getByTxCasCadeIds(orgId);
        for (CourseListReponseDto courseListReponseDto : dtos) {
            CourseListInfoDto dto = new CourseListInfoDto();
            this.buildCourseListInfoDto(courseListReponseDto, dto);
            dto.setCascadeIdStr((String)cascadeMap.get(dto.getCascadeId()));
            responseDto.add(dto);
        }
        return responseDto;
    }

    private List<CourseListReponseDto> getCourseListWithAttendanceRate(List<OrgCourse> courses, Long orgId) {
        log.info("courses={},orgId={}", courses, (Object)orgId);
        Preconditions.checkArgument((orgId != null && orgId > 0L ? 1 : 0) != 0, (Object)"orgId not valid!");
        if (CollectionUtils.isEmpty(courses)) {
            return Collections.emptyList();
        }
        ArrayList dtos = Lists.newArrayList();
        ArrayList courseIds = Lists.newArrayList();
        for (OrgCourse course : courses) {
            courseIds.add(course.getId());
        }
        Map courseLessonMap = this.orgClassLessonDao.getCourseLessonCount(orgId, (Collection)courseIds, null, null, null);
        Map studentIdMap = null;
        studentIdMap = this.orgStudentCourseDao.getStudentIdMapBycourseIdsNoStatus((Collection)courseIds, orgId);
        Map rateMap = this.orgLessonSignService.getAttendanceRateOfCourses(orgId, (Collection)courseIds);
        for (OrgCourse course : courses) {
            Long courseId = course.getId();
            CourseListReponseDto dto = new CourseListReponseDto();
            dtos.add(dto);
            this.buildCourseListResponseDto(course, dto);
            Integer lessonCount = (Integer)courseLessonMap.get(courseId);
            if (lessonCount == null) {
                lessonCount = 0;
            }
            dto.setLessonCount(lessonCount);
            Integer studentCount = 0;
            List studentIdList = (List)studentIdMap.get(courseId);
            if (studentIdList != null) {
                studentCount = studentIdList.size();
            }
            dto.setStudentCount(studentCount);
            Double attendanceRate = (Double)rateMap.get(courseId);
            if (attendanceRate != null) {
                dto.setAttendanceRate(attendanceRate);
                continue;
            }
            dto.setAttendanceRate(Double.valueOf(0.0));
        }
        return dtos;
    }

    private void buildCourseListResponseDto(OrgCourse po, CourseListReponseDto dto) {
        dto.setOrgCourseId(po.getId());
        dto.setOrgCourseNumber(po.getNumber());
        dto.setColor(po.getColor());
        dto.setCourseName(po.getName());
        dto.setMaxStudent(po.getMaxStudent());
        dto.setFreq(po.getFreq());
        dto.setStartTime(po.getBeginTime());
        dto.setEndTime(po.getEndTime());
        dto.setPrice(po.getPrice());
        dto.setStatus(po.getStatus());
        String intro = BaseUtils.blobToString((Blob)po.getIntroduction(), (String)"UTF-8");
        dto.setIntroduction(intro);
        dto.setIsCourse(po.getIsCourse());
        dto.setIsClass(po.getIsClass());
        dto.setCourseType(po.getCourseType());
        dto.setIsFinish(po.getIsFinish());
    }

    private void buildCourseListInfoDto(CourseListReponseDto courseListReponseDto, CourseListInfoDto dto) {
        dto.setColor(courseListReponseDto.getColor());
        dto.setCourseName(courseListReponseDto.getCourseName());
        dto.setCourseUrl(courseListReponseDto.getCourseUrl());
        dto.setCoverUrl(courseListReponseDto.getCoverUrl());
        dto.setEndTime(courseListReponseDto.getEndTime());
        dto.setFreq(courseListReponseDto.getFreq());
        dto.setLessonCount(courseListReponseDto.getLessonCount());
        dto.setLessonFinish(courseListReponseDto.getLessonFinish());
        dto.setMaxStudent(courseListReponseDto.getMaxStudent());
        dto.setOrgCourseId(courseListReponseDto.getOrgCourseId());
        dto.setOrgCourseNumber(courseListReponseDto.getOrgCourseNumber());
        dto.setRoomCount(courseListReponseDto.getRoomCount());
        dto.setRoomNames(courseListReponseDto.getRoomNames());
        dto.setStudentNames(courseListReponseDto.getStudentNames());
        dto.setTeacherNames(courseListReponseDto.getTeacherNames());
        dto.setStartTime(courseListReponseDto.getStartTime());
        dto.setStudentCount(courseListReponseDto.getStudentCount());
        dto.setTeacherCount(courseListReponseDto.getTeacherCount());
        dto.setAttendanceRate(courseListReponseDto.getAttendanceRate());
        dto.setPrice(courseListReponseDto.getPrice());
        dto.setStatus(courseListReponseDto.getStatus());
        dto.setAddress(courseListReponseDto.getAddress());
        dto.setCreateTime(courseListReponseDto.getCreateTime());
        dto.setCascadeId(courseListReponseDto.getCascadeId());
        dto.setCourseType(courseListReponseDto.getCourseType());
        dto.setIsFinish(courseListReponseDto.getIsFinish());
    }

    @Override
    public CourseListInfoDto getCourseDetail(Long orgId, Long orgCourseId) {
        CourseListReponseDto dto = this.orgCourseListService.getCourseDetail(orgId, orgCourseId);
        CourseListInfoDto courseListInfoDto = new CourseListInfoDto();
        this.buildCourseListInfoDto(dto, courseListInfoDto);
        return courseListInfoDto;
    }

    @Override
    public List<AppCourseListInfoDto> getOnlyCourseList(Long orgId, Date startTime, Date endTime, CourseListRequestDto params, PageDto pageDto) {
        Long orgNumber = this.getOrgNumber(orgId);
        Integer courseType = params.getCourseType();
        String searchKey = params.getSearchKey();
        Object courseIds = null;
        OrgCourseDao.OrgCourseListParam param = new OrgCourseDao.OrgCourseListParam();
        param.setCourseType(courseType);
        param.setIsCourse(params.getIsCourse());
        param.setIsClass(params.getIsClass());
        param.setKey(searchKey);
        param.setStartTime(startTime);
        param.setEndTime(endTime);
        param.setPage(pageDto);
        param.setStatus(params.getStatus());
        param.setCascadeId(params.getCascadeId());
        Map fieldShowMap = FieldShow.getColumnShowMap(CourseListInfoDto.class);
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)params.getOrderField())) {
            FieldShow fieldShow = (FieldShow)fieldShowMap.get(params.getOrderField());
            String orderField = fieldShow != null ? fieldShow.getPoName() : null;
            param.setOrderField(orderField);
            param.setOrderType(params.getOrderType());
        }
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)params.getOrderField())) {
            param.setOrderField("createTime");
            param.setOrderType("DESC");
        }
        param.setQueryCondition(QueryCondition.andCondtions((Collection)params.getQueryConditions(), (Map)fieldShowMap));
        param.setIsDel(params.getIsDel());
        List courses = this.orgCourseDao.getCourseList(orgNumber, null, param, new String[0]);
        List dtos = this.orgCourseListService.getCourseList(courses, orgId, false, false, false, Boolean.valueOf(false), false, false, false);
        ArrayList responseDto = Lists.newArrayList();
        for (CourseListReponseDto courseListReponseDto : dtos) {
            AppCourseListInfoDto dto = new AppCourseListInfoDto();
            String pinyin = HanZiPinYinUtils.getLowerCasePinYin((String)courseListReponseDto.getCourseName());
            String str = "#";
            if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)pinyin)) {
                char init = pinyin.charAt(0);
                str = String.valueOf(init);
            }
            if (!StringUtils.letterValidate((String)str)) {
                str = "#";
            }
            dto.setCourseNamePinYin(str.toUpperCase());
            dto.setOrgCourseNumber(courseListReponseDto.getOrgCourseNumber());
            dto.setCourseName(courseListReponseDto.getCourseName());
            dto.setCourseType(courseListReponseDto.getCourseType());
            dto.setOrgCourseId(courseListReponseDto.getOrgCourseId());
            dto.setPrice(courseListReponseDto.getPrice());
            responseDto.add(dto);
        }
        return responseDto;
    }
}

