/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.biz.erp.service.impl;

import com.baijia.tianxiao.biz.erp.service.CourseClassService;
import com.baijia.tianxiao.dal.enums.CourseTypeEnum;
import com.baijia.tianxiao.dal.org.constant.DeleteStatus;
import com.baijia.tianxiao.dal.org.dao.OrgCourseDao;
import com.baijia.tianxiao.dal.org.dao.OrgCourseRoomDao;
import com.baijia.tianxiao.dal.org.dao.OrgCourseTeacherDao;
import com.baijia.tianxiao.dal.org.dao.OrgStudentCourseDao;
import com.baijia.tianxiao.dal.org.dao.OrgStudentDao;
import com.baijia.tianxiao.dal.org.po.OrgCourse;
import com.baijia.tianxiao.dal.org.po.OrgStudent;
import com.baijia.tianxiao.dal.org.po.OrgStudentCourse;
import com.baijia.tianxiao.dal.util.SerialNumberUtil;
import com.baijia.tianxiao.dto.UniverseErrorCode;
import com.baijia.tianxiao.enums.CommonErrorCode;
import com.baijia.tianxiao.exception.BussinessException;
import com.baijia.tianxiao.sal.course.service.CourseTeacherService;
import com.baijia.tianxiao.sal.room.service.ClassRoomService;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="courseClassService")
public class CourseClassServiceImpl
implements CourseClassService {
    private static final Logger log = LoggerFactory.getLogger(CourseClassServiceImpl.class);
    @Resource
    private OrgCourseDao orgCourseDao;
    @Resource
    private OrgStudentCourseDao orgStudentCourseDao;
    @Resource
    private OrgStudentDao orgStudentDao;
    @Resource
    private CourseTeacherService courseTeacherService;
    @Resource
    private OrgCourseTeacherDao orgCourseTeacherDao;
    @Resource
    private OrgCourseRoomDao orgCourseRoomDao;
    @Resource
    private ClassRoomService classRoomService;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public OrgCourse createClassFor1V1(Long orgId, Long signupPurchaseId, Long parentCourseId, Long studentUserId, Integer lessonCount) {
        List roomIds;
        OrgCourse orgCourse = (OrgCourse)this.orgCourseDao.getById((Serializable)parentCourseId, new String[0]);
        if (orgCourse == null) {
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u8bfe\u7a0b\u65e0\u6548");
        }
        boolean checkCourseTypeResult = this.isCourse1v1(orgCourse);
        if (!checkCourseTypeResult) {
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u8bfe\u7a0b\u65e0\u6548\uff0c\u4e0d\u80fd\u7531\u73ed\u7ea7\u521b\u5efa\u73ed\u7ea7");
        }
        OrgStudent orgStudent = this.orgStudentDao.getStudentByUserId(orgId, studentUserId, new String[0]);
        orgCourse.setSnapshotName(orgCourse.getName());
        orgCourse.setName(orgStudent.getName() + " " + orgCourse.getName());
        orgCourse.setNumber(Long.valueOf(System.nanoTime()));
        orgCourse.setId(null);
        orgCourse.setCreateTime(null);
        orgCourse.setCourseType(CourseTypeEnum.COURSE_TYPE_1v1.getCode());
        orgCourse.setIsCourse(CourseTypeEnum.IS_COURSE_FALSE.getCode());
        orgCourse.setIsClass(CourseTypeEnum.IS_CLASS_TRUE.getCode());
        orgCourse.setParentId(parentCourseId);
        orgCourse.setFreq(lessonCount);
        this.orgCourseDao.save((Object)orgCourse, new String[0]);
        Long newCourseId = orgCourse.getId();
        if (newCourseId != null && newCourseId > 0L) {
            long number = SerialNumberUtil.generateNumber((int)orgCourse.getId().intValue(), (int)99999999, (int)4);
            orgCourse.setNumber(Long.valueOf(number));
            this.orgCourseDao.saveOrUpdate((Object)orgCourse, new String[]{"number"});
        }
        OrgStudentCourse orgStudentCourse = new OrgStudentCourse();
        orgStudentCourse.setCourseId(newCourseId);
        orgStudentCourse.setCreateTime(new Date());
        orgStudentCourse.setDelStatus(Integer.valueOf(DeleteStatus.NORMAL.getValue()));
        orgStudentCourse.setOrgId(Long.valueOf(orgId));
        orgStudentCourse.setStudentMobile(orgStudent.getMobile());
        orgStudentCourse.setStudentName(orgStudent.getName());
        orgStudentCourse.setUserId(orgStudent.getUserId());
        orgStudentCourse.setLessonCount(lessonCount);
        orgStudentCourse.setSignupPurchaseId(Long.valueOf(signupPurchaseId == null ? 0L : signupPurchaseId));
        this.orgStudentCourseDao.save((Object)orgStudentCourse, new String[0]);
        List teacherUserIdList = this.orgCourseTeacherDao.getTeacherIdsByCourseId(parentCourseId);
        if (CollectionUtils.isNotEmpty((Collection)teacherUserIdList)) {
            this.courseTeacherService.addTeacherToCourse(orgId, newCourseId, (Collection)teacherUserIdList);
        }
        if (CollectionUtils.isNotEmpty((Collection)(roomIds = this.orgCourseRoomDao.getCourseRoomIds(orgId, parentCourseId)))) {
            this.classRoomService.addClassRoomCourse(orgId, newCourseId, (Collection)roomIds);
        }
        return orgCourse;
    }

    private boolean isCourse1v1(OrgCourse orgCourse) {
        boolean checkCourseTypeResult = orgCourse.getCourseType() == CourseTypeEnum.COURSE_TYPE_1v1.getCode() && orgCourse.getIsCourse() == CourseTypeEnum.IS_COURSE_TRUE.getCode() && orgCourse.getIsClass() == CourseTypeEnum.IS_CLASS_FALSE.getCode();
        return checkCourseTypeResult;
    }

    private boolean isClass1v1(OrgCourse orgCourse) {
        boolean checkCourseTypeResult = orgCourse.getCourseType() == CourseTypeEnum.COURSE_TYPE_1v1.getCode() && orgCourse.getIsCourse() == CourseTypeEnum.IS_COURSE_FALSE.getCode() && orgCourse.getIsClass() == CourseTypeEnum.IS_CLASS_TRUE.getCode();
        return checkCourseTypeResult;
    }

    @Override
    public void synClass1v1NameForStudentNameChange(Long orgId, Long studentUserId) {
        OrgStudent orgStudent = this.orgStudentDao.getStudentByUserId(orgId, studentUserId, new String[0]);
        if (orgStudent == null) {
            log.info("org student not exist orgId ={},studentUserId ={} ", (Object)orgId, (Object)studentUserId);
            return;
        }
        String studentName = orgStudent.getName();
        List studentCourseList = this.orgStudentCourseDao.getOrgCourseIds(orgId, studentUserId, null, null);
        ArrayList courseIds = Lists.newArrayList();
        for (OrgStudentCourse studentCourse : studentCourseList) {
            Long courseId = studentCourse.getCourseId();
            courseIds.add(courseId);
        }
        List courseList = this.orgCourseDao.getByIds((Collection)courseIds, new String[0]);
        for (OrgCourse orgCourse : courseList) {
            if (!this.isClass1v1(orgCourse) || orgCourse.getParentId() <= 0L) continue;
            orgCourse.setName(studentName + " " + orgCourse.getSnapshotName());
            this.orgCourseDao.update((Object)orgCourse, new String[]{"name"});
            log.info("org course update name finish new name ={}", (Object)orgCourse.getName());
        }
    }
}

