/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.biz.erp.thread;

import com.baijia.tianxiao.biz.erp.constant.UploadFileStatus;
import com.baijia.tianxiao.biz.erp.service.impl.ErpUploadServiceImpl;
import com.baijia.tianxiao.biz.erp.vo.ImportStudent;
import com.baijia.tianxiao.dal.constant.ChargeUnit;
import com.baijia.tianxiao.dal.org.constant.DeleteStatus;
import com.baijia.tianxiao.dal.org.dao.OrgClassLessonDao;
import com.baijia.tianxiao.dal.org.dao.OrgStudentLessonDao;
import com.baijia.tianxiao.dal.org.po.OrgClassLesson;
import com.baijia.tianxiao.dal.org.po.OrgCourse;
import com.baijia.tianxiao.dal.org.po.OrgStudentCourse;
import com.baijia.tianxiao.dal.org.po.OrgStudentLesson;
import com.baijia.tianxiao.dal.signup.po.OrgSignupCourse;
import com.baijia.tianxiao.dto.UniverseErrorCode;
import com.baijia.tianxiao.enums.CommonErrorCode;
import com.baijia.tianxiao.enums.RedisKeyEnums;
import com.baijia.tianxiao.exception.BussinessException;
import com.baijia.tianxiao.sal.course.service.OrgCourseService;
import com.baijia.tianxiao.sal.course.service.OrgSignupCourseLessonService;
import com.baijia.tianxiao.sal.course.service.OrgSignupCourseService;
import com.baijia.tianxiao.sal.student.api.OrgStudentCourseService;
import com.baijia.tianxiao.sal.student.api.OrgStudentService;
import com.baijia.tianxiao.sal.student.dto.StudentInfoDto;
import com.baijia.tianxiao.sal.student.dto.response.OrgStudentAddresponseDto;
import com.baijia.tianxiao.util.date.DateUtil;
import com.baijia.tianxiao.util.json.JacksonUtil;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.DataAccessException;
import org.springframework.data.redis.connection.RedisConnection;
import org.springframework.data.redis.core.RedisCallback;
import org.springframework.data.redis.core.StringRedisTemplate;

public class SaveStudentsThread
implements Runnable {
    private static final Logger log = LoggerFactory.getLogger(SaveStudentsThread.class);
    private StringRedisTemplate redisTemplate;
    private OrgStudentService orgStudentService;
    private OrgStudentCourseService orgStudentCourseService;
    private OrgStudentLessonDao orgStudentLessonDao;
    private OrgCourseService orgCourseService;
    private OrgClassLessonDao orgClassLessonDao;
    private OrgSignupCourseService orgSignupCourseService;
    private OrgSignupCourseLessonService signupCourseLessonService;
    private Integer orgId;
    private Integer cascadeId;
    private String taskId;
    private int id;
    private Map<Integer, Boolean> map;
    private List<ImportStudent> importStudents = Lists.newArrayList();

    public Integer getRealLessonCount(ImportStudent importStudent, Integer courseChargeUnit) {
        Integer lessonCount = 0;
        if (courseChargeUnit.intValue() == ChargeUnit.BY_TIMES.getCode()) {
            if (importStudent.getLessonCount() == null || importStudent.getLessonCount() <= 0) {
                throw new BussinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u6309\u6b21\u8ba1\u8d39\u73ed\u7ea7,\u5269\u4f59\u603b\u8bfe\u6b21\u4e3a\u5fc5\u586b\u9879");
            }
            lessonCount = importStudent.getLessonCount();
        } else {
            if (importStudent.getLessonCount() != null) {
                lessonCount = lessonCount + importStudent.getLessonCount() * 60;
            }
            if (importStudent.getLessonCountExtra() != null) {
                lessonCount = lessonCount + importStudent.getLessonCountExtra();
            }
        }
        if (lessonCount <= 0) {
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u5269\u4f59\u603b\u8bfe\u6b21\uff08\u65f6\uff09\u5fc5\u987b\u5927\u4e8e0");
        }
        return lessonCount;
    }

    @Override
    public void run() {
        block53: {
            try {
                ArrayList courseNames = Lists.newArrayList();
                ArrayList studentMobiles = Lists.newArrayList();
                for (ImportStudent importStudent : this.importStudents) {
                    courseNames.add(importStudent.getCourseName());
                    studentMobiles.add(importStudent.getStudentMobile());
                }
                long between0 = 0L;
                long between1 = 0L;
                long between2 = 0L;
                long addStudentTime = 0L;
                long addLessonTime = 0L;
                Date begin0 = new Date();
                Map orgCoursesMap = this.orgCourseService.getAllOrgCoursesMapByNames_class(Long.valueOf(this.orgId.longValue()), (List)courseNames);
                ArrayList orgCourseIds = Lists.newArrayList();
                for (OrgCourse orgCourse : orgCoursesMap.values()) {
                    orgCourseIds.add(orgCourse.getId());
                }
                Map allLessonsMap = this.orgClassLessonDao.querylessonsByStartTime(null, (Collection)orgCourseIds, Long.valueOf(this.orgId.longValue()));
                Map unStartLessonsMap = this.orgClassLessonDao.querylessonsByStartTime(new Date(), (Collection)orgCourseIds, Long.valueOf(this.orgId.longValue()));
                Date end0 = new Date();
                between0 = end0.getTime() - begin0.getTime();
                if (!CollectionUtils.isNotEmpty(this.importStudents)) break block53;
                for (ImportStudent importStudent : this.importStudents) {
                    OrgSignupCourse orgSignupCourse = null;
                    try {
                        Integer lessonCount;
                        Object lessonCount2;
                        String courseName = importStudent.getCourseName();
                        OrgCourse orgCourse = (OrgCourse)orgCoursesMap.get(courseName);
                        Long orgCourseId = orgCourse.getId();
                        List allLessons = new ArrayList();
                        List unStartLessons = new ArrayList();
                        if (MapUtils.isNotEmpty((Map)allLessonsMap)) {
                            allLessons = (List)allLessonsMap.get(orgCourseId);
                        }
                        if (MapUtils.isNotEmpty((Map)unStartLessonsMap)) {
                            unStartLessons = (List)unStartLessonsMap.get(orgCourseId);
                        }
                        Date begin1 = new Date();
                        StudentInfoDto orgStudent = null;
                        List dtos = this.orgStudentService.listOrgStudentByMobile(Long.valueOf(this.orgId.longValue()), importStudent.getStudentMobile().toString());
                        if (CollectionUtils.isNotEmpty((Collection)dtos)) {
                            for (StudentInfoDto dto : dtos) {
                                if (!importStudent.getStudentMobile().equals(dto.getMobile()) || !importStudent.getStudentName().equals(dto.getName())) continue;
                                log.debug("*************can find dto:{}", (Object)dto);
                                orgStudent = dto;
                            }
                        }
                        if (orgStudent == null) {
                            orgStudent = new StudentInfoDto();
                            orgStudent.setMobile(importStudent.getStudentMobile().toString());
                            orgStudent.setName(importStudent.getStudentName().toString());
                            orgStudent.setAddCascadeId(Integer.valueOf(this.cascadeId == null ? 0 : this.cascadeId));
                            OrgStudentAddresponseDto addDto = this.orgStudentService.addStudentIgnoreExistMobile(orgStudent, null, null, Long.valueOf(this.orgId.longValue()));
                            orgStudent.setStudentId(addDto.getUserId());
                        }
                        log.debug("**************orgStudent:{}", (Object)orgStudent);
                        Date end1 = new Date();
                        between1 = end1.getTime() - begin1.getTime();
                        addStudentTime += between1;
                        OrgStudentCourse orgStudentCourse = this.orgStudentCourseService.getBySidAndCid(Long.valueOf(this.orgId.longValue()), orgStudent.getStudentId(), orgCourse.getId());
                        if (orgStudentCourse == null) {
                            orgStudentCourse = new OrgStudentCourse();
                            orgStudentCourse.setCourseId(orgCourse.getId());
                            orgStudentCourse.setRealCourseId(orgCourse.getId());
                            orgStudentCourse.setCreateTime(new Date());
                            orgStudentCourse.setDelStatus(Integer.valueOf(DeleteStatus.NORMAL.getValue()));
                            orgStudentCourse.setOrgId(Long.valueOf(this.orgId.longValue()));
                            orgStudentCourse.setStudentMobile(orgStudent.getMobile());
                            orgStudentCourse.setStudentName(orgStudent.getName());
                            orgStudentCourse.setUserId(orgStudent.getStudentId());
                            Integer chargeUnit = orgCourse.getChargeUnit();
                            if (chargeUnit == null || chargeUnit.intValue() == ChargeUnit.BY_OTHER.getCode()) {
                                chargeUnit = ChargeUnit.BY_TIMES.getCode();
                            }
                            orgStudentCourse.setLessonCount(this.getRealLessonCount(importStudent, chargeUnit));
                            orgStudentCourse.setChargeUnit(chargeUnit);
                            orgStudentCourse.setStatus(Integer.valueOf(0));
                            this.orgStudentCourseService.saveOrgStudentCourse(orgStudentCourse);
                            Integer signupChargeUnit = orgCourse.getChargeUnit();
                            lessonCount2 = importStudent.getLessonCount();
                            Integer lessonCountExtra = importStudent.getLessonCountExtra();
                            if (orgCourse.getChargeUnit().intValue() != ChargeUnit.BY_TIMES.getCode() && lessonCountExtra != null && lessonCountExtra > 0) {
                                signupChargeUnit = ChargeUnit.BY_MINUTE.getCode();
                                if (lessonCount2 == null) {
                                    lessonCount2 = 0;
                                }
                                lessonCount2 = (Integer)lessonCount2 * 60 + lessonCountExtra;
                            }
                            orgSignupCourse = this.orgSignupCourseService.saveOrgSignupCourseByExcel(Long.valueOf(this.orgId.longValue()), null, orgCourse, orgStudent.getStudentId(), (Integer)lessonCount2, importStudent.getPayPrice(), signupChargeUnit);
                        } else {
                            if (orgStudentCourse.getDelStatus().intValue() != DeleteStatus.DELETED.getValue() && orgStudentCourse.getStatus() == 0) {
                                throw new BussinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u7cfb\u7edf\u4e2d\u8be5\u8bfe\u7a0b\u5df2\u6709\u8be5\u5b66\u5458\uff0c\u65e0\u6cd5\u5bfc\u5165");
                            }
                            if (orgStudentCourse.getDelStatus().intValue() == DeleteStatus.DELETED.getValue()) {
                                orgStudentCourse.setDelStatus(Integer.valueOf(DeleteStatus.NORMAL.getValue()));
                            }
                            if (orgStudentCourse.getStatus() != 0) {
                                orgStudentCourse.setStatus(Integer.valueOf(0));
                            }
                            orgStudentCourse.setLessonCount(Integer.valueOf(orgStudentCourse.getLessonCount() + this.getRealLessonCount(importStudent, orgStudentCourse.getChargeUnit())));
                            this.orgStudentCourseService.updateOrgStudentCourse(orgStudentCourse);
                            Integer signupChargeUnit = orgCourse.getChargeUnit();
                            lessonCount = importStudent.getLessonCount();
                            Integer lessonCountExtra = importStudent.getLessonCountExtra();
                            if (orgCourse.getChargeUnit().intValue() != ChargeUnit.BY_TIMES.getCode() && lessonCountExtra != null && lessonCountExtra > 0) {
                                signupChargeUnit = ChargeUnit.BY_MINUTE.getCode();
                                if (lessonCount == null) {
                                    lessonCount = 0;
                                }
                                lessonCount = lessonCount * 60 + lessonCountExtra;
                            }
                            orgSignupCourse = this.orgSignupCourseService.saveOrgSignupCourseByExcel(Long.valueOf(this.orgId.longValue()), null, orgCourse, orgStudent.getStudentId(), lessonCount, importStudent.getPayPrice(), signupChargeUnit);
                        }
                        if (CollectionUtils.isNotEmpty(unStartLessons)) {
                            ArrayList orgStudentLessons = Lists.newArrayList();
                            if (orgCourse.getChargeUnit().intValue() == ChargeUnit.BY_TIMES.getCode()) {
                                if (importStudent.getInsertCount() == null) {
                                    lessonCount = this.getRealLessonCount(importStudent, orgStudentCourse.getChargeUnit());
                                    if (lessonCount >= unStartLessons.size()) {
                                        for (OrgClassLesson orgClassLesson : unStartLessons) {
                                            orgStudentLessons.add(this.lessonInit(orgClassLesson, orgStudent));
                                        }
                                    } else {
                                        for (int i = 0; i < lessonCount; ++i) {
                                            OrgClassLesson orgClassLesson;
                                            orgClassLesson = (OrgClassLesson)unStartLessons.get(i);
                                            orgStudentLessons.add(this.lessonInit(orgClassLesson, orgStudent));
                                        }
                                    }
                                } else if (importStudent.getInsertCount() != null) {
                                    Integer insertCount = (int)importStudent.getInsertCount();
                                    lessonCount2 = this.getRealLessonCount(importStudent, orgStudentCourse.getChargeUnit());
                                    int start = insertCount - 1;
                                    int end = start + (Integer)lessonCount2;
                                    if (end > allLessons.size()) {
                                        end = allLessons.size();
                                    }
                                    while (start < end) {
                                        OrgClassLesson orgClassLesson = (OrgClassLesson)allLessons.get(start);
                                        orgStudentLessons.add(this.lessonInit(orgClassLesson, orgStudent));
                                        ++start;
                                    }
                                }
                            } else if (orgCourse.getChargeUnit().intValue() == ChargeUnit.BY_HOUR.getCode()) {
                                Long lessonMinute = this.getRealLessonCount(importStudent, orgCourse.getChargeUnit()).longValue();
                                if (importStudent.getLessonCount() != null && importStudent.getInsertCount() == null) {
                                    for (OrgClassLesson orgClassLesson : unStartLessons) {
                                        if ((lessonMinute = Long.valueOf(lessonMinute - orgClassLesson.getDurationMinute())) >= 0L) {
                                            orgStudentLessons.add(this.lessonInit(orgClassLesson, orgStudent));
                                            continue;
                                        }
                                        break;
                                    }
                                } else if (importStudent.getLessonCount() != null && importStudent.getInsertCount() != null) {
                                    Integer insertCount = (int)importStudent.getInsertCount();
                                    for (int start = insertCount - 1; start < allLessons.size(); ++start) {
                                        OrgClassLesson orgClassLesson = (OrgClassLesson)allLessons.get(start);
                                        if ((lessonMinute = Long.valueOf(lessonMinute - orgClassLesson.getDurationMinute())) >= 0L) {
                                            orgStudentLessons.add(this.lessonInit(orgClassLesson, orgStudent));
                                            continue;
                                        }
                                        break;
                                    }
                                }
                            } else {
                                throw new BussinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u672a\u77e5\u7684\u73ed\u7ea7\u8ba1\u8d39\u5355\u4f4d");
                            }
                            Long studentId = orgStudent.getStudentId();
                            HashMap orgStudentLessonMap = Maps.newHashMap();
                            for (OrgStudentLesson orgStudentLesson : orgStudentLessons) {
                                Long lessonId = orgStudentLesson.getLessonId();
                                orgStudentLessonMap.put(lessonId, orgStudentLesson);
                            }
                            List orgStudentLessonsList = this.orgStudentLessonDao.getLessonsOfStudent(Long.valueOf(this.orgId.longValue()), Long.valueOf(studentId), orgStudentLessonMap.keySet());
                            ArrayList updateList = Lists.newArrayList();
                            if (CollectionUtils.isNotEmpty((Collection)orgStudentLessonsList)) {
                                for (OrgStudentLesson orgStudentLessonDb : orgStudentLessonsList) {
                                    Long lessonDbId = orgStudentLessonDb.getLessonId();
                                    orgStudentLessonMap.remove(lessonDbId);
                                    if (orgStudentLessonDb.getDelStatus() != 1) continue;
                                    orgStudentLessonDb.setDelStatus(Integer.valueOf(0));
                                    orgStudentLessonDb.setStartStatus(Integer.valueOf(0));
                                    orgStudentLessonDb.setKexiaoStatus(Integer.valueOf(0));
                                    orgStudentLessonDb.setUpdateTime(new Date());
                                    updateList.add(orgStudentLessonDb);
                                }
                            }
                            if (CollectionUtils.isNotEmpty((Collection)updateList)) {
                                orgSignupCourse.setChargeUnit(orgCourse.getChargeUnit());
                                this.signupCourseLessonService.saveSignupCourseLessons(Long.valueOf(this.orgId.longValue()), orgCourseId, (Collection)updateList, orgSignupCourse);
                                for (OrgStudentLesson orgStudentLesson : updateList) {
                                    this.orgStudentLessonDao.update((Object)orgStudentLesson, new String[0]);
                                }
                            }
                            if (MapUtils.isNotEmpty((Map)orgStudentLessonMap)) {
                                orgSignupCourse.setChargeUnit(orgCourse.getChargeUnit());
                                this.signupCourseLessonService.saveSignupCourseLessons(Long.valueOf(this.orgId.longValue()), orgCourseId, orgStudentLessonMap.values(), orgSignupCourse);
                                for (OrgStudentLesson orgStudentLesson : orgStudentLessonMap.values()) {
                                    try {
                                        this.orgStudentLessonDao.save((Object)orgStudentLesson, new String[0]);
                                    }
                                    catch (Exception e) {
                                        log.error("save orgStudentLesson:{} failed", (Object)orgStudentLesson);
                                    }
                                }
                            }
                        }
                        Date end2 = new Date();
                        between2 = end2.getTime() - end1.getTime();
                        addLessonTime += between2;
                    }
                    catch (BussinessException be) {
                        importStudent.setErrReason(be.getMessage());
                        this.appendErrorData(this.taskId, importStudent);
                        this.redisTemplate.execute((RedisCallback)new RedisCallback<List<ImportStudent>>(){

                            public List<ImportStudent> doInRedis(RedisConnection connection) throws DataAccessException {
                                ArrayList data = Lists.newArrayList();
                                Long size = SaveStudentsThread.this.redisTemplate.opsForList().size((Object)SaveStudentsThread.this.getErrDataKey(SaveStudentsThread.this.taskId));
                                if (size != null && size > 0L) {
                                    int i = 0;
                                    while ((long)i < size) {
                                        try {
                                            String o = (String)SaveStudentsThread.this.redisTemplate.opsForList().rightPop((Object)SaveStudentsThread.this.getErrDataKey(SaveStudentsThread.this.taskId));
                                            if (o != null) {
                                                data.add(JacksonUtil.str2Obj((String)o, ImportStudent.class));
                                            }
                                        }
                                        catch (Exception e) {
                                            e.printStackTrace();
                                            log.error("getInValidStudentList getValidList error!", (Throwable)e);
                                        }
                                        ++i;
                                    }
                                }
                                log.debug("getInValidStudentList:{}", (Object)data);
                                if (CollectionUtils.isNotEmpty((Collection)data)) {
                                    for (ImportStudent importStudent : data) {
                                        SaveStudentsThread.this.redisTemplate.opsForList().leftPush((Object)SaveStudentsThread.this.getErrDataKey(SaveStudentsThread.this.taskId), (Object)JacksonUtil.obj2Str((Object)importStudent));
                                    }
                                }
                                return data;
                            }
                        });
                    }
                    catch (Exception e) {
                        importStudent.setErrReason("\u7cfb\u7edf\u65e0\u6cd5\u63d2\u5165\u6b64\u6570\u636e\uff0c\u8bf7\u8054\u7cfb\u5929\u6821\u5de5\u4f5c\u4eba\u5458\u4e3a\u60a8\u6392\u67e5");
                        this.appendErrorData(this.taskId, importStudent);
                    }
                }
                this.map.put(this.id, true);
                log.info("\u67e5\u8be2\u8017\u65f6\uff1a{} ms", (Object)between0);
                log.info("\u63d2\u5165\u5b66\u751f\u603b\u65f6\u95f4\uff1a{} ms", (Object)addStudentTime);
                log.info("\u63d2\u5165\u5b66\u751f\u8bfe\u7a0b\u3001\u8bfe\u7ed3\u7684\u603b\u65f6\u95f4\uff1a{} ms", (Object)addLessonTime);
            }
            catch (Throwable t) {
                log.error("save student to orgcourse error!", t);
                this.setTaskStatusError(this.taskId);
            }
        }
    }

    OrgStudentLesson lessonInit(OrgClassLesson orgClassLesson, StudentInfoDto orgStudent) {
        OrgStudentLesson orgStudentLesson = new OrgStudentLesson();
        orgStudentLesson.setCreateTime(new Date());
        orgStudentLesson.setDelStatus(Integer.valueOf(DeleteStatus.NORMAL.getValue()));
        orgStudentLesson.setLessonId(orgClassLesson.getId());
        orgStudentLesson.setOrgId(Long.valueOf(this.orgId.longValue()));
        orgStudentLesson.setStudentMobile(orgStudent.getMobile());
        orgStudentLesson.setStudentName(orgStudent.getName());
        orgStudentLesson.setUserId(orgStudent.getStudentId());
        orgStudentLesson.setCourseId(orgClassLesson.getCourseId());
        orgStudentLesson.setLessonDuration(Integer.valueOf(DateUtil.getMinuteDiff((Date)orgClassLesson.getStartTime(), (Date)orgClassLesson.getEndTime())));
        return orgStudentLesson;
    }

    protected void setTaskStatusError(final String taskId) {
        this.redisTemplate.execute((RedisCallback)new RedisCallback<Boolean>(){

            public Boolean doInRedis(RedisConnection connection) throws DataAccessException {
                connection.setEx(SaveStudentsThread.this.getStatusKey(taskId).getBytes(), ErpUploadServiceImpl.EXPIRE.longValue(), UploadFileStatus.ERROR.getCode().toString().getBytes());
                return true;
            }
        });
    }

    private final String getStatusKey(String taskId) {
        return RedisKeyEnums.ERP.STATUS_SUFFIX.getRedisKey() + taskId;
    }

    private final String getErrDataKey(String taskId) {
        return RedisKeyEnums.ERP.INVALID_LIST_SUFFIX.getRedisKey() + taskId;
    }

    private final String getErrDataSizeKey(String taskId) {
        return RedisKeyEnums.ERP.INVALID_LIST_SIZE_SUFFIX.getRedisKey() + taskId;
    }

    private final String getValidDataSizeKey(String taskId) {
        return RedisKeyEnums.ERP.VALID_LIST_SIZE_SUFFIX.getRedisKey() + taskId;
    }

    protected void appendErrorData(final String taskId, final Object data) {
        this.redisTemplate.execute((RedisCallback)new RedisCallback<Boolean>(){

            public Boolean doInRedis(RedisConnection connection) throws DataAccessException {
                SaveStudentsThread.this.redisTemplate.opsForList().leftPush((Object)SaveStudentsThread.this.getErrDataKey(taskId), (Object)JacksonUtil.obj2Str((Object)data));
                connection.expire(SaveStudentsThread.this.getErrDataKey(taskId).getBytes(), ErpUploadServiceImpl.EXPIRE.longValue());
                connection.incr(SaveStudentsThread.this.getErrDataSizeKey(taskId).getBytes());
                connection.expire(SaveStudentsThread.this.getErrDataSizeKey(taskId).getBytes(), ErpUploadServiceImpl.EXPIRE.longValue());
                connection.decr(SaveStudentsThread.this.getValidDataSizeKey(taskId).getBytes());
                connection.expire(SaveStudentsThread.this.getValidDataSizeKey(taskId).getBytes(), ErpUploadServiceImpl.EXPIRE.longValue());
                return true;
            }
        });
    }

    public StringRedisTemplate getRedisTemplate() {
        return this.redisTemplate;
    }

    public OrgStudentService getOrgStudentService() {
        return this.orgStudentService;
    }

    public OrgStudentCourseService getOrgStudentCourseService() {
        return this.orgStudentCourseService;
    }

    public OrgStudentLessonDao getOrgStudentLessonDao() {
        return this.orgStudentLessonDao;
    }

    public OrgCourseService getOrgCourseService() {
        return this.orgCourseService;
    }

    public OrgClassLessonDao getOrgClassLessonDao() {
        return this.orgClassLessonDao;
    }

    public OrgSignupCourseService getOrgSignupCourseService() {
        return this.orgSignupCourseService;
    }

    public OrgSignupCourseLessonService getSignupCourseLessonService() {
        return this.signupCourseLessonService;
    }

    public Integer getOrgId() {
        return this.orgId;
    }

    public Integer getCascadeId() {
        return this.cascadeId;
    }

    public String getTaskId() {
        return this.taskId;
    }

    public int getId() {
        return this.id;
    }

    public Map<Integer, Boolean> getMap() {
        return this.map;
    }

    public List<ImportStudent> getImportStudents() {
        return this.importStudents;
    }

    public void setRedisTemplate(StringRedisTemplate redisTemplate) {
        this.redisTemplate = redisTemplate;
    }

    public void setOrgStudentService(OrgStudentService orgStudentService) {
        this.orgStudentService = orgStudentService;
    }

    public void setOrgStudentCourseService(OrgStudentCourseService orgStudentCourseService) {
        this.orgStudentCourseService = orgStudentCourseService;
    }

    public void setOrgStudentLessonDao(OrgStudentLessonDao orgStudentLessonDao) {
        this.orgStudentLessonDao = orgStudentLessonDao;
    }

    public void setOrgCourseService(OrgCourseService orgCourseService) {
        this.orgCourseService = orgCourseService;
    }

    public void setOrgClassLessonDao(OrgClassLessonDao orgClassLessonDao) {
        this.orgClassLessonDao = orgClassLessonDao;
    }

    public void setOrgSignupCourseService(OrgSignupCourseService orgSignupCourseService) {
        this.orgSignupCourseService = orgSignupCourseService;
    }

    public void setSignupCourseLessonService(OrgSignupCourseLessonService signupCourseLessonService) {
        this.signupCourseLessonService = signupCourseLessonService;
    }

    public void setOrgId(Integer orgId) {
        this.orgId = orgId;
    }

    public void setCascadeId(Integer cascadeId) {
        this.cascadeId = cascadeId;
    }

    public void setTaskId(String taskId) {
        this.taskId = taskId;
    }

    public void setId(int id) {
        this.id = id;
    }

    public void setMap(Map<Integer, Boolean> map) {
        this.map = map;
    }

    public void setImportStudents(List<ImportStudent> importStudents) {
        this.importStudents = importStudents;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SaveStudentsThread)) {
            return false;
        }
        SaveStudentsThread other = (SaveStudentsThread)o;
        if (!other.canEqual(this)) {
            return false;
        }
        StringRedisTemplate this$redisTemplate = this.getRedisTemplate();
        StringRedisTemplate other$redisTemplate = other.getRedisTemplate();
        if (this$redisTemplate == null ? other$redisTemplate != null : !this$redisTemplate.equals(other$redisTemplate)) {
            return false;
        }
        OrgStudentService this$orgStudentService = this.getOrgStudentService();
        OrgStudentService other$orgStudentService = other.getOrgStudentService();
        if (this$orgStudentService == null ? other$orgStudentService != null : !this$orgStudentService.equals(other$orgStudentService)) {
            return false;
        }
        OrgStudentCourseService this$orgStudentCourseService = this.getOrgStudentCourseService();
        OrgStudentCourseService other$orgStudentCourseService = other.getOrgStudentCourseService();
        if (this$orgStudentCourseService == null ? other$orgStudentCourseService != null : !this$orgStudentCourseService.equals(other$orgStudentCourseService)) {
            return false;
        }
        OrgStudentLessonDao this$orgStudentLessonDao = this.getOrgStudentLessonDao();
        OrgStudentLessonDao other$orgStudentLessonDao = other.getOrgStudentLessonDao();
        if (this$orgStudentLessonDao == null ? other$orgStudentLessonDao != null : !this$orgStudentLessonDao.equals(other$orgStudentLessonDao)) {
            return false;
        }
        OrgCourseService this$orgCourseService = this.getOrgCourseService();
        OrgCourseService other$orgCourseService = other.getOrgCourseService();
        if (this$orgCourseService == null ? other$orgCourseService != null : !this$orgCourseService.equals(other$orgCourseService)) {
            return false;
        }
        OrgClassLessonDao this$orgClassLessonDao = this.getOrgClassLessonDao();
        OrgClassLessonDao other$orgClassLessonDao = other.getOrgClassLessonDao();
        if (this$orgClassLessonDao == null ? other$orgClassLessonDao != null : !this$orgClassLessonDao.equals(other$orgClassLessonDao)) {
            return false;
        }
        OrgSignupCourseService this$orgSignupCourseService = this.getOrgSignupCourseService();
        OrgSignupCourseService other$orgSignupCourseService = other.getOrgSignupCourseService();
        if (this$orgSignupCourseService == null ? other$orgSignupCourseService != null : !this$orgSignupCourseService.equals(other$orgSignupCourseService)) {
            return false;
        }
        OrgSignupCourseLessonService this$signupCourseLessonService = this.getSignupCourseLessonService();
        OrgSignupCourseLessonService other$signupCourseLessonService = other.getSignupCourseLessonService();
        if (this$signupCourseLessonService == null ? other$signupCourseLessonService != null : !this$signupCourseLessonService.equals(other$signupCourseLessonService)) {
            return false;
        }
        Integer this$orgId = this.getOrgId();
        Integer other$orgId = other.getOrgId();
        if (this$orgId == null ? other$orgId != null : !((Object)this$orgId).equals(other$orgId)) {
            return false;
        }
        Integer this$cascadeId = this.getCascadeId();
        Integer other$cascadeId = other.getCascadeId();
        if (this$cascadeId == null ? other$cascadeId != null : !((Object)this$cascadeId).equals(other$cascadeId)) {
            return false;
        }
        String this$taskId = this.getTaskId();
        String other$taskId = other.getTaskId();
        if (this$taskId == null ? other$taskId != null : !this$taskId.equals(other$taskId)) {
            return false;
        }
        if (this.getId() != other.getId()) {
            return false;
        }
        Map<Integer, Boolean> this$map = this.getMap();
        Map<Integer, Boolean> other$map = other.getMap();
        if (this$map == null ? other$map != null : !((Object)this$map).equals(other$map)) {
            return false;
        }
        List<ImportStudent> this$importStudents = this.getImportStudents();
        List<ImportStudent> other$importStudents = other.getImportStudents();
        return !(this$importStudents == null ? other$importStudents != null : !((Object)this$importStudents).equals(other$importStudents));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SaveStudentsThread;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        StringRedisTemplate $redisTemplate = this.getRedisTemplate();
        result = result * 59 + ($redisTemplate == null ? 43 : $redisTemplate.hashCode());
        OrgStudentService $orgStudentService = this.getOrgStudentService();
        result = result * 59 + ($orgStudentService == null ? 43 : $orgStudentService.hashCode());
        OrgStudentCourseService $orgStudentCourseService = this.getOrgStudentCourseService();
        result = result * 59 + ($orgStudentCourseService == null ? 43 : $orgStudentCourseService.hashCode());
        OrgStudentLessonDao $orgStudentLessonDao = this.getOrgStudentLessonDao();
        result = result * 59 + ($orgStudentLessonDao == null ? 43 : $orgStudentLessonDao.hashCode());
        OrgCourseService $orgCourseService = this.getOrgCourseService();
        result = result * 59 + ($orgCourseService == null ? 43 : $orgCourseService.hashCode());
        OrgClassLessonDao $orgClassLessonDao = this.getOrgClassLessonDao();
        result = result * 59 + ($orgClassLessonDao == null ? 43 : $orgClassLessonDao.hashCode());
        OrgSignupCourseService $orgSignupCourseService = this.getOrgSignupCourseService();
        result = result * 59 + ($orgSignupCourseService == null ? 43 : $orgSignupCourseService.hashCode());
        OrgSignupCourseLessonService $signupCourseLessonService = this.getSignupCourseLessonService();
        result = result * 59 + ($signupCourseLessonService == null ? 43 : $signupCourseLessonService.hashCode());
        Integer $orgId = this.getOrgId();
        result = result * 59 + ($orgId == null ? 43 : ((Object)$orgId).hashCode());
        Integer $cascadeId = this.getCascadeId();
        result = result * 59 + ($cascadeId == null ? 43 : ((Object)$cascadeId).hashCode());
        String $taskId = this.getTaskId();
        result = result * 59 + ($taskId == null ? 43 : $taskId.hashCode());
        result = result * 59 + this.getId();
        Map<Integer, Boolean> $map = this.getMap();
        result = result * 59 + ($map == null ? 43 : ((Object)$map).hashCode());
        List<ImportStudent> $importStudents = this.getImportStudents();
        result = result * 59 + ($importStudents == null ? 43 : ((Object)$importStudents).hashCode());
        return result;
    }

    public String toString() {
        return "SaveStudentsThread(redisTemplate=" + this.getRedisTemplate() + ", orgStudentService=" + this.getOrgStudentService() + ", orgStudentCourseService=" + this.getOrgStudentCourseService() + ", orgStudentLessonDao=" + this.getOrgStudentLessonDao() + ", orgCourseService=" + this.getOrgCourseService() + ", orgClassLessonDao=" + this.getOrgClassLessonDao() + ", orgSignupCourseService=" + this.getOrgSignupCourseService() + ", signupCourseLessonService=" + this.getSignupCourseLessonService() + ", orgId=" + this.getOrgId() + ", cascadeId=" + this.getCascadeId() + ", taskId=" + this.getTaskId() + ", id=" + this.getId() + ", map=" + this.getMap() + ", importStudents=" + this.getImportStudents() + ")";
    }
}

