/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.biz.erp.service.impl;

import com.baijia.tianxiao.biz.erp.constant.UCStudentFeedType;
import com.baijia.tianxiao.biz.erp.dto.response.studentCenter.LessonCommentFeed;
import com.baijia.tianxiao.biz.erp.dto.response.studentCenter.LessonSignFeed;
import com.baijia.tianxiao.biz.erp.dto.response.studentCenter.SignupCourseFeed;
import com.baijia.tianxiao.biz.erp.dto.response.studentCenter.StudentCommentFeed;
import com.baijia.tianxiao.biz.erp.dto.response.studentCenter.SystemDefaultFeed;
import com.baijia.tianxiao.biz.erp.dto.response.studentCenter.UCStudentFeed;
import com.baijia.tianxiao.biz.erp.service.UCStudentService;
import com.baijia.tianxiao.consants.UserRole;
import com.baijia.tianxiao.constant.Flag;
import com.baijia.tianxiao.constant.SignStatus;
import com.baijia.tianxiao.dal.comment.dao.OrgLessonCommentDao;
import com.baijia.tianxiao.dal.comment.po.OrgLessonComment;
import com.baijia.tianxiao.dal.constant.ChargeUnit;
import com.baijia.tianxiao.dal.org.constant.StudentType;
import com.baijia.tianxiao.dal.org.dao.OrgClassLessonDao;
import com.baijia.tianxiao.dal.org.dao.OrgCourseDao;
import com.baijia.tianxiao.dal.org.dao.OrgLessonSignDao;
import com.baijia.tianxiao.dal.org.dao.OrgStorageDao;
import com.baijia.tianxiao.dal.org.dao.OrgStudentDao;
import com.baijia.tianxiao.dal.org.dao.OrgTeacherLessonDao;
import com.baijia.tianxiao.dal.org.dao.TXCascadeCredentialDao;
import com.baijia.tianxiao.dal.org.po.OrgClassLesson;
import com.baijia.tianxiao.dal.org.po.OrgCourse;
import com.baijia.tianxiao.dal.org.po.OrgLessonSign;
import com.baijia.tianxiao.dal.org.po.OrgStorage;
import com.baijia.tianxiao.dal.org.po.OrgStudent;
import com.baijia.tianxiao.dal.org.po.TXCascadeCredential;
import com.baijia.tianxiao.dal.roster.dao.TxStudentCommentDao;
import com.baijia.tianxiao.dal.roster.po.TxStudentComment;
import com.baijia.tianxiao.dal.signup.constant.SignupCourseStatus;
import com.baijia.tianxiao.dal.signup.dao.OrgSignupCourseDao;
import com.baijia.tianxiao.dal.signup.po.OrgSignupCourse;
import com.baijia.tianxiao.sal.common.api.OrgStudentApiService;
import com.baijia.tianxiao.sal.common.api.OrgTeacherApiService;
import com.baijia.tianxiao.sal.organization.org.dto.OrgInfoSimpleDto;
import com.baijia.tianxiao.sal.organization.org.service.OrgInfoService;
import com.baijia.tianxiao.sal.student.api.OrgStudentCommentService;
import com.baijia.tianxiao.sal.student.dto.CommentInfoDto;
import com.baijia.tianxiao.util.TwoTuple;
import com.baijia.tianxiao.util.collection.CollectorUtil;
import com.baijia.tianxiao.util.json.JacksonUtil;
import com.baijia.tianxiao.util.storage.StorageUtil;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.io.Serializable;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class UCStudentServiceImpl
implements UCStudentService {
    private static final Logger log = LoggerFactory.getLogger(UCStudentServiceImpl.class);
    @Autowired
    private TxStudentCommentDao txStudentCommentDao;
    @Autowired
    private OrgLessonCommentDao orgLessonCommentDao;
    @Autowired
    private OrgLessonSignDao orgLessonSignDao;
    @Autowired
    private OrgSignupCourseDao orgSignupCourseDao;
    @Autowired
    private OrgStudentDao orgStudentDao;
    @Autowired
    private OrgInfoService orgInfoService;
    @Autowired(required=false)
    private OrgStudentCommentService orgStudentCommentService;
    @Autowired
    private OrgClassLessonDao orgClassLessonDao;
    @Autowired
    private OrgCourseDao orgCourseDao;
    @Autowired
    private TXCascadeCredentialDao txCascadeCredentialDao;
    @Autowired
    private OrgTeacherApiService orgTeacherApiService;
    @Autowired
    private OrgTeacherLessonDao orgTeacherLessonDao;
    @Autowired
    private OrgStudentApiService orgStudentApiService;
    @Autowired
    private OrgStorageDao orgStorageDao;
    private static final String SIGN_CONTENT_TEMPLATE = "%s\u540c\u5b66\uff0c\u60a8\u7684\u3010%s\u3011\u8bfe\u7a0b%s\uff01";
    private static final String SIGNUP_CONTENT_TEMPLATE = "%s\u540c\u5b66\uff0c\u60a8\u7684\u3010%s\u3011\u8bfe\u7a0b\u62a5\u540d\u6210\u529f\uff01";
    private static final String SYSTEM_CONTENT_TEMPLATE = "%s\u540c\u5b66\uff0c\u6b22\u8fce\u52a0\u5165%s\uff01";

    @Override
    public List<UCStudentFeed> getAllFeedsCatalog(Long orgId, Long studentId, Long userId) {
        ArrayList result = Lists.newArrayList();
        result.addAll(this.getLessonSignFeedsCatalog(orgId, studentId, userId));
        result.addAll(this.getLessonCommentFeedsCatalog(orgId, studentId, userId));
        result.addAll(this.getStudentCommentFeedsCatalog(orgId, studentId, userId));
        result.addAll(this.getSignupCourseFeedsCatalog(orgId, studentId, userId));
        Collections.sort(result, Comparator.comparing(UCStudentFeed::getCreateTime).reversed());
        OrgStudent orgStudent = (OrgStudent)this.orgStudentDao.getById((Serializable)studentId, new String[]{"id", "createTime"});
        UCStudentFeed feed = new UCStudentFeed();
        feed.setId(orgStudent.getId());
        feed.setCreateTime(orgStudent.getCreateTime());
        feed.setType(UCStudentFeedType.SYSTEM_NOTICE.getType());
        result.add(feed);
        return result;
    }

    private List<UCStudentFeed> getSignupCourseFeedsCatalog(Long orgId, Long studentId, Long userId) {
        List signupCourses = this.orgSignupCourseDao.getByCourseIdAndStudentId(orgId, userId, null, (Collection)SignupCourseStatus.VALIDATE_STATS, new String[0]);
        ArrayList result = Lists.newArrayList();
        for (OrgSignupCourse signupCourse : signupCourses) {
            UCStudentFeed feed = new UCStudentFeed();
            feed.setId(signupCourse.getId());
            feed.setCreateTime((Date)ObjectUtils.defaultIfNull((Object)signupCourse.getUpdateTime(), (Object)signupCourse.getCreateTime()));
            feed.setType(UCStudentFeedType.SIGNUP_COURSE.getType());
            result.add(feed);
        }
        log.info("[UCStudentFeed] find signup course feeds size:{} ", (Object)result.size());
        return result;
    }

    private List<UCStudentFeed> getLessonSignFeedsCatalog(Long orgId, Long studentId, Long userId) {
        List signs = this.orgLessonSignDao.listByUserAndStatus(orgId, userId, (Collection)SignStatus.OPERATED_STATUS, null, new String[]{"id", "updateTime"});
        ArrayList result = Lists.newArrayList();
        for (OrgLessonSign sign : signs) {
            UCStudentFeed feed = new UCStudentFeed();
            feed.setId(sign.getId());
            feed.setCreateTime((Date)ObjectUtils.defaultIfNull((Object)sign.getUpdateTime(), (Object)sign.getCreateTime()));
            feed.setType(UCStudentFeedType.LESSON_SIGN.getType());
            result.add(feed);
        }
        log.info("[UCStudentFeed] find lesson sign feeds size:{} ", (Object)result.size());
        return result;
    }

    private List<UCStudentFeed> getLessonCommentFeedsCatalog(Long orgId, Long studentId, Long userId) {
        ArrayList result = Lists.newArrayList();
        List sendComments = this.orgLessonCommentDao.getStudentComments(orgId, userId, null, null, new String[]{"id", "createTime"});
        for (OrgLessonComment comment : sendComments) {
            UCStudentFeed feed = new UCStudentFeed();
            feed.setId(comment.getId());
            feed.setCreateTime((Date)ObjectUtils.defaultIfNull((Object)comment.getUpdateTime(), (Object)comment.getCreateTime()));
            feed.setType(UCStudentFeedType.LESSON_SEND_COMMENT.getType());
            result.add(feed);
        }
        List recieveComment = this.orgLessonCommentDao.getTeacherCommentsOfStudent(orgId, userId, null, null, new String[]{"id", "createTime"});
        for (OrgLessonComment comment : recieveComment) {
            UCStudentFeed feed = new UCStudentFeed();
            feed.setId(comment.getId());
            feed.setCreateTime((Date)ObjectUtils.defaultIfNull((Object)comment.getUpdateTime(), (Object)comment.getCreateTime()));
            feed.setType(UCStudentFeedType.LESSON_RECIEVE_COMMENT.getType());
            result.add(feed);
        }
        log.info("[UCStudentFeed] find lesson comment feeds size:{} ", (Object)result.size());
        return result;
    }

    private List<UCStudentFeed> getStudentCommentFeedsCatalog(Long orgId, Long studentId, Long userId) {
        List comments = this.txStudentCommentDao.getCommentList(userId, orgId, Integer.valueOf(StudentType.ORG_STUDENTS.getCode()), null, Integer.valueOf(Flag.TRUE.getInt()), true, null, new String[]{"id", "createTime", "updateTime", "type", "isSystem"});
        ArrayList result = Lists.newArrayList();
        for (TxStudentComment comment : comments) {
            UCStudentFeed feed = new UCStudentFeed();
            feed.setId(comment.getId());
            feed.setCreateTime((Date)ObjectUtils.defaultIfNull((Object)comment.getUpdateTime(), (Object)comment.getCreateTime()));
            feed.setType(UCStudentFeedType.STUDENT_COMMENT_GROWTH_DOC.getType());
            result.add(feed);
        }
        log.info("[UCStudentFeed] find student comment feeds size:{} ", (Object)result.size());
        return result;
    }

    @Override
    public List<UCStudentFeed> getRichFeedsByCatalog(Long orgId, Long studentId, Long userId, List<UCStudentFeed> feedsCatalog) {
        if (CollectionUtils.isEmpty(feedsCatalog)) {
            return Lists.newArrayList();
        }
        ArrayList signIds = Lists.newArrayList();
        ArrayList signupIds = Lists.newArrayList();
        ArrayList lessonCommentIds = Lists.newArrayList();
        ArrayList growthDocIds = Lists.newArrayList();
        for (UCStudentFeed feed : feedsCatalog) {
            UCStudentFeedType type = UCStudentFeedType.getEnumByType(feed.getType());
            if (type == UCStudentFeedType.LESSON_SIGN) {
                signIds.add(feed.getId());
                continue;
            }
            if (type == UCStudentFeedType.SIGNUP_COURSE) {
                signupIds.add(feed.getId());
                continue;
            }
            if (type == UCStudentFeedType.STUDENT_COMMENT_GROWTH_DOC) {
                growthDocIds.add(feed.getId());
                continue;
            }
            if (type != UCStudentFeedType.LESSON_SEND_COMMENT && type != UCStudentFeedType.LESSON_RECIEVE_COMMENT) continue;
            lessonCommentIds.add(feed.getId());
        }
        List signs = this.orgLessonSignDao.getByIds((Collection)signIds, new String[0]);
        List signups = this.orgSignupCourseDao.getByIds((Collection)signupIds, new String[0]);
        List orgLessonComments = this.orgLessonCommentDao.getByIds((Collection)lessonCommentIds, new String[0]);
        List growthDocs = this.txStudentCommentDao.getByIds((Collection)growthDocIds, new String[0]);
        OrgStudent orgStudent = (OrgStudent)this.orgStudentDao.getById((Serializable)studentId, new String[0]);
        OrgInfoSimpleDto orgInfo = this.orgInfoService.getMOrgInfo(orgId);
        HashSet courseIds = Sets.newHashSet();
        HashSet lessonIds = Sets.newHashSet();
        HashSet teacherUserIds = Sets.newHashSet();
        signs.stream().forEach(a -> {
            courseIds.add(a.getCourseId());
            lessonIds.add(a.getLessonId());
            if (a.getTeacherId() > 0) {
                teacherUserIds.add(a.getTeacherId().longValue());
            }
        });
        signups.stream().forEach(a -> courseIds.add(a.getClassId()));
        orgLessonComments.stream().forEach(a -> {
            courseIds.add(a.getCourseId());
            lessonIds.add(a.getLessonId());
            teacherUserIds.add(a.getFromId());
            teacherUserIds.add(a.getToId());
        });
        Map lessonTeacherMap = this.orgTeacherLessonDao.queryLessonTeacherIdMap(orgId, (Collection)lessonIds);
        teacherUserIds.addAll(lessonTeacherMap.values());
        Map courseMap = CollectorUtil.collectMap((Collection)this.orgCourseDao.getByIds((Collection)courseIds, new String[0]), a -> a.getId());
        Map lessonMap = CollectorUtil.collectMap((Collection)this.orgClassLessonDao.getByIds((Collection)lessonIds, new String[0]), a -> a.getId());
        Map teacherMap = this.orgTeacherApiService.getNameAndAvatarByUserIds(orgId, (Collection)teacherUserIds);
        Map<Long, UCStudentFeed> growthDocFeedMap = this.getGrowthDocFeedMap(orgId, growthDocs);
        Map<Long, UCStudentFeed> signFeedMap = this.getSignFeedMap(orgStudent, orgInfo, signs, courseMap, lessonMap, null, teacherMap, lessonTeacherMap);
        Map<Long, UCStudentFeed> signupFeedMap = this.getSignupFeedMap(orgStudent, orgInfo, signups, courseMap);
        Map<Long, UCStudentFeed> lessonCommentFeedMap = this.getLessonCommentFeedMap(orgStudent, orgLessonComments, teacherMap, courseMap, lessonMap);
        ArrayList result = Lists.newArrayList();
        for (UCStudentFeed catalog : feedsCatalog) {
            UCStudentFeedType type = UCStudentFeedType.getEnumByType(catalog.getType());
            if (type == UCStudentFeedType.STUDENT_COMMENT_GROWTH_DOC) {
                result.add(growthDocFeedMap.get(catalog.getId()));
                continue;
            }
            if (type == UCStudentFeedType.LESSON_SIGN) {
                result.add(signFeedMap.get(catalog.getId()));
                continue;
            }
            if (type == UCStudentFeedType.LESSON_RECIEVE_COMMENT || type == UCStudentFeedType.LESSON_SEND_COMMENT) {
                result.add(lessonCommentFeedMap.get(catalog.getId()));
                continue;
            }
            if (type == UCStudentFeedType.SIGNUP_COURSE) {
                result.add(signupFeedMap.get(catalog.getId()));
                continue;
            }
            if (type != UCStudentFeedType.SYSTEM_NOTICE) continue;
            SystemDefaultFeed feed = new SystemDefaultFeed();
            feed.setId(orgStudent.getId());
            feed.setCreateTime(orgStudent.getCreateTime());
            feed.setType(UCStudentFeedType.SYSTEM_NOTICE.getType());
            SystemDefaultFeed.DefaultData data = new SystemDefaultFeed.DefaultData();
            data.setOpName(orgInfo.getShortName());
            data.setCreateTime(orgStudent.getCreateTime());
            data.setOpAvatar(orgInfo.getLogo());
            data.setContent(String.format(SYSTEM_CONTENT_TEMPLATE, orgStudent.getNotEmptyName(), orgInfo.getShortName()));
            feed.setData(data);
            result.add(feed);
        }
        return result;
    }

    private Map<Long, UCStudentFeed> getLessonCommentFeedMap(OrgStudent orgStudent, List<OrgLessonComment> orgLessonComments, Map<Long, TwoTuple<String, String>> teacherMap, Map<Long, OrgCourse> courseMap, Map<Long, OrgClassLesson> lessonMap) {
        HashMap result = Maps.newHashMap();
        Map studentAvatarMap = this.orgStudentApiService.batchGetStudentAvatarUrl((Collection)Lists.newArrayList((Object[])new OrgStudent[]{orgStudent}));
        for (OrgLessonComment comment : orgLessonComments) {
            LessonCommentFeed feed = new LessonCommentFeed();
            feed.setId(comment.getId());
            feed.setCreateTime(comment.getCreateTime());
            LessonCommentFeed.CommentData data = new LessonCommentFeed.CommentData();
            if (comment.getUserRole().intValue() == UserRole.STUDENT.getRole()) {
                feed.setType(UCStudentFeedType.LESSON_SEND_COMMENT.getType());
                data.setOpName(orgStudent.getName());
                data.setOpAvatar((String)studentAvatarMap.get(orgStudent.getId()));
            } else if (comment.getUserRole().intValue() == UserRole.TEACHER.getRole()) {
                feed.setType(UCStudentFeedType.LESSON_RECIEVE_COMMENT.getType());
                TwoTuple<String, String> teacher = teacherMap.get(comment.getFromId());
                data.setOpName((String)teacher.getFirst());
                data.setOpAvatar((String)teacher.getSecond());
            }
            data.setLessonId(comment.getLessonId());
            data.setCreateTime(comment.getCreateTime());
            data.setContent(comment.getContent());
            data.setCustomFastComment(comment.getCustomFastComment());
            if (StringUtils.isNotBlank((CharSequence)comment.getStorageIds())) {
                try {
                    List storageIds = JacksonUtil.str2List((String)("[" + comment.getStorageIds() + "]"), Long.TYPE);
                    Map storageMap = this.orgStorageDao.getOrgStorageMapByIds((Collection)storageIds);
                    for (Long key : storageMap.keySet()) {
                        OrgStorage storage = (OrgStorage)storageMap.get(key);
                        data.getPicUrls().add(StorageUtil.constructUrl((String)storage.getFid(), (String)storage.getSn(), (Integer)storage.getMimeType()));
                    }
                }
                catch (IOException e) {
                    log.error("error:{} ", (Throwable)e);
                }
            }
            data.setSoundLength(comment.getSoundLength());
            if (null != comment.getSoundId() && comment.getSoundId() > 0) {
                OrgStorage orgStorage = this.orgStorageDao.getById(comment.getSoundId().intValue());
                data.setSoundLink(StorageUtil.constructUrl((String)orgStorage.getFid(), (String)orgStorage.getSn(), (Integer)orgStorage.getMimeType()));
            }
            data.setStarScore(comment.getStarScore());
            OrgCourse course = courseMap.get(comment.getCourseId());
            OrgClassLesson lesson = lessonMap.get(comment.getLessonId());
            if (null != comment && null != lesson) {
                data.setCourseName(course.getName() + String.format("-\u7b2c%s\u8282\u8bfe", lesson.getNumber()));
            } else {
                data.setCourseName("-");
            }
            feed.setData(data);
            result.put(feed.getId(), feed);
        }
        return result;
    }

    private Map<Long, UCStudentFeed> getSignupFeedMap(OrgStudent orgStudent, OrgInfoSimpleDto orgInfo, List<OrgSignupCourse> signups, Map<Long, OrgCourse> courseMap) {
        HashMap result = Maps.newHashMap();
        for (OrgSignupCourse signupCourse : signups) {
            SignupCourseFeed feed = new SignupCourseFeed();
            feed.setId(signupCourse.getId());
            feed.setType(UCStudentFeedType.SIGNUP_COURSE.getType());
            feed.setCreateTime(signupCourse.getCreateTime());
            SignupCourseFeed.SignupData data = new SignupCourseFeed.SignupData();
            data.setOpName(orgInfo.getShortName());
            data.setOpAvatar(orgInfo.getLogo());
            data.setCreateTime(signupCourse.getCreateTime());
            OrgCourse course = courseMap.get(signupCourse.getClassId());
            data.setCourseName(null != course ? course.getName() : "");
            data.setContent(String.format(SIGNUP_CONTENT_TEMPLATE, orgStudent.getNotEmptyName(), null != course ? course.getName() : ""));
            data.setPrice("\uffe5" + signupCourse.getTotalPayPrice().doubleValue() / 100.0);
            if (signupCourse.getChargeUnit().intValue() == ChargeUnit.BY_TIMES.getCode()) {
                data.setAmount(signupCourse.getLessonCount() + "\u6b21");
            } else if (signupCourse.getChargeUnit().intValue() == ChargeUnit.BY_HOUR.getCode()) {
                data.setAmount(signupCourse.getLessonCount() + "\u5c0f\u65f6");
            } else if (signupCourse.getChargeUnit().intValue() == ChargeUnit.BY_MINUTE.getCode()) {
                data.setAmount(new DecimalFormat("#.0").format(signupCourse.getLessonCount().doubleValue() / 60.0) + "\u5c0f\u65f6");
            } else if (signupCourse.getChargeUnit().intValue() == ChargeUnit.BY_HALF_HOUR.getCode()) {
                data.setAmount(new DecimalFormat("#.0").format(signupCourse.getLessonCount().doubleValue() / 60.0) + "\u5c0f\u65f6");
            } else {
                data.setAmount(signupCourse.getCount().toString());
            }
            feed.setData(data);
            result.put(feed.getId(), feed);
        }
        return result;
    }

    private Map<Long, UCStudentFeed> getSignFeedMap(OrgStudent orgStudent, OrgInfoSimpleDto orgInfo, List<OrgLessonSign> signs, Map<Long, OrgCourse> courseMap, Map<Long, OrgClassLesson> lessonMap, Map<Integer, TXCascadeCredential> cascadeMap, Map<Long, TwoTuple<String, String>> teacherMap, Map<Long, Long> lessonTeacherMap) {
        HashMap result = Maps.newHashMap();
        for (OrgLessonSign sign : signs) {
            LessonSignFeed feed = new LessonSignFeed();
            feed.setId(sign.getId());
            feed.setCreateTime(sign.getUpdateTime());
            feed.setType(UCStudentFeedType.LESSON_SIGN.getType());
            LessonSignFeed.SignFeedData data = new LessonSignFeed.SignFeedData();
            data.setCreateTime(sign.getUpdateTime());
            data.setOpName(orgInfo.getShortName());
            data.setOpAvatar(orgInfo.getLogo());
            OrgCourse course = courseMap.get(sign.getCourseId());
            data.setCourseName(course.getName());
            OrgClassLesson lesson = lessonMap.get(sign.getLessonId());
            if (null == lesson) continue;
            data.setStartTime(lesson.getStartTime());
            data.setEndTime(lesson.getEndTime());
            TwoTuple<String, String> tuple = teacherMap.get(lessonTeacherMap.get(sign.getLessonId()));
            data.setTeacherName(null != tuple ? (String)tuple.getFirst() : "");
            if (sign.getStatus().intValue() == SignStatus.SIGNED.getCode()) {
                data.setContent(String.format(SIGN_CONTENT_TEMPLATE, orgStudent.getNotEmptyName(), data.getCourseName() + String.format("-\u7b2c%s\u8282\u8bfe", lesson.getNumber()), "\u7b7e\u5230\u6210\u529f"));
            } else if (sign.getStatus().intValue() == SignStatus.LEAVE.getCode()) {
                data.setContent(String.format(SIGN_CONTENT_TEMPLATE, orgStudent.getNotEmptyName(), data.getCourseName() + String.format("-\u7b2c%s\u8282\u8bfe", lesson.getNumber()), "\u5df2\u8bf7\u5047"));
            } else if (sign.getStatus().intValue() == SignStatus.ABSENT.getCode()) {
                data.setContent(String.format(SIGN_CONTENT_TEMPLATE, orgStudent.getNotEmptyName(), data.getCourseName() + String.format("-\u7b2c%s\u8282\u8bfe", lesson.getNumber()), "\u672a\u5230\u8bfe"));
            }
            feed.setData(data);
            result.put(feed.getId(), feed);
        }
        return result;
    }

    private Map<Long, UCStudentFeed> getGrowthDocFeedMap(Long orgId, List<TxStudentComment> growthDocs) {
        List list = this.orgStudentCommentService.buildCommentDto(orgId, growthDocs);
        HashMap feedMap = Maps.newHashMap();
        for (CommentInfoDto dto : list) {
            StudentCommentFeed feed = new StudentCommentFeed();
            feed.setId(dto.getCommentId());
            feed.setCreateTime(dto.getCreateTime());
            feed.setType(UCStudentFeedType.STUDENT_COMMENT_GROWTH_DOC.getType());
            feed.setData(dto);
            feedMap.put(feed.getId(), feed);
        }
        return feedMap;
    }
}

