/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.biz.erp.service.impl;

import com.baijia.tianxiao.biz.erp.dto.request.ListLessonsRequestDto;
import com.baijia.tianxiao.biz.erp.dto.request.TimeRangeRequestDto;
import com.baijia.tianxiao.biz.erp.dto.response.H5LessonResponseDto;
import com.baijia.tianxiao.biz.erp.dto.response.LessonResponseDto;
import com.baijia.tianxiao.biz.erp.dto.response.ListLessonResponseDto;
import com.baijia.tianxiao.biz.erp.dto.response.schedule.DateInfoDto;
import com.baijia.tianxiao.biz.erp.dto.response.schedule.DayLessonInfoDto;
import com.baijia.tianxiao.biz.erp.dto.response.schedule.ListLessonDtoInfo;
import com.baijia.tianxiao.biz.erp.service.CourseLessonService;
import com.baijia.tianxiao.biz.erp.service.ScheduleLessonService;
import com.baijia.tianxiao.constants.TianXiaoConstant;
import com.baijia.tianxiao.util.date.DateUtil;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class ScheduleLessonServiceImpl
implements ScheduleLessonService {
    private static final Logger log = LoggerFactory.getLogger(ScheduleLessonServiceImpl.class);
    @Resource
    private CourseLessonService courseLessonService;

    @Override
    public ListLessonDtoInfo getScheduleLessons(Long orgId, ListLessonsRequestDto requestDto, boolean needToday) {
        if (requestDto.getPageSize() == null || requestDto.getPageSize() <= 0) {
            requestDto.setPageSize(40);
        }
        if (requestDto.getFirstLessonStartTime() == null && requestDto.getLastLessonStartTime() == null) {
            requestDto.setFirstLessonStartTime(DateUtil.getCurrentDate().getTime());
        }
        requestDto.setNeedcourseName(true);
        requestDto.setNeedRoomName(true);
        requestDto.setNeedTeacherName(true);
        requestDto.setNeedSignInfo(true);
        ListLessonResponseDto response = this.courseLessonService.listLessons(orgId, requestDto, false);
        Map<String, List<LessonResponseDto>> lessonMap = this.groupLessonMap(response, needToday);
        List<DayLessonInfoDto> dayLessonsList = this.buildDayLessonInfoDtoList(lessonMap);
        ListLessonDtoInfo listLessonDtoInfo = new ListLessonDtoInfo(dayLessonsList, response.getCourseType(), response.getFirstLessonStartTime(), response.getLastLessonStartTime());
        return listLessonDtoInfo;
    }

    @Override
    public ListLessonDtoInfo getSignInScheduleLessons(Long orgId, ListLessonsRequestDto requestDto, boolean needToday) {
        if (requestDto.getPageSize() == null || requestDto.getPageSize() <= 0) {
            requestDto.setPageSize(40);
        }
        if (requestDto.getFirstLessonStartTime() == null && requestDto.getLastLessonStartTime() == null) {
            requestDto.setFirstLessonStartTime(DateUtil.getCurrentDate().getTime());
        }
        requestDto.setNeedcourseName(true);
        requestDto.setNeedRoomName(true);
        requestDto.setNeedTeacherName(true);
        requestDto.setNeedSignInfo(true);
        ListLessonResponseDto response = this.courseLessonService.listSignInLessons(orgId, requestDto);
        Map<String, List<LessonResponseDto>> lessonMap = this.groupLessonMap(response, needToday);
        List<DayLessonInfoDto> dayLessonsList = this.buildDayLessonInfoDtoList(lessonMap);
        ListLessonDtoInfo listLessonDtoInfo = new ListLessonDtoInfo(dayLessonsList, response.getCourseType(), response.getFirstLessonStartTime(), response.getLastLessonStartTime());
        return listLessonDtoInfo;
    }

    public Map<String, List<LessonResponseDto>> groupLessonMap(ListLessonResponseDto response, boolean needToday) {
        HashMap result = Maps.newHashMap();
        if (needToday) {
            String today = TianXiaoConstant.DAY_FORMAT.format(new Date());
            result.put(today, Lists.newArrayList());
        }
        Collections.sort(response.getList(), (o1, o2) -> o1.getLessonId().compareTo(o2.getLessonId()));
        for (LessonResponseDto dto : response.getList()) {
            H5LessonResponseDto h5Dto = H5LessonResponseDto.convert(dto);
            if (!result.containsKey(h5Dto.getDate())) {
                result.put(h5Dto.getDate(), Lists.newArrayList());
            }
            ((List)result.get(h5Dto.getDate())).add(h5Dto);
        }
        return result;
    }

    public List<DayLessonInfoDto> buildDayLessonInfoDtoList(Map<String, List<LessonResponseDto>> lessonMap) {
        ArrayList list = Lists.newArrayList();
        for (Map.Entry<String, List<LessonResponseDto>> entry : lessonMap.entrySet()) {
            String date = entry.getKey();
            List<LessonResponseDto> lessons = entry.getValue();
            DateInfoDto dateInfo = new DateInfoDto(date);
            DayLessonInfoDto dayLessonInfoDto = new DayLessonInfoDto(lessons, dateInfo);
            list.add(dayLessonInfoDto);
        }
        return list;
    }

    @Override
    public List<LessonResponseDto> getScheduleLessons(Long orgId, TimeRangeRequestDto requestDto) {
        List<LessonResponseDto> list = this.courseLessonService.findLessonBaseInfoByTimeRange(orgId, requestDto.getStartDate(), requestDto.getEndDate(), requestDto.getPageDto());
        return list;
    }
}

