/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.biz.erp.service.impl;

import com.baijia.tianxiao.biz.erp.dto.request.RankingRequest;
import com.baijia.tianxiao.biz.erp.dto.response.incomeRanking.IncomeRankingDto;
import com.baijia.tianxiao.biz.erp.dto.response.incomeRanking.StudentCountRankingDto;
import com.baijia.tianxiao.biz.erp.dto.response.incomeRanking.StudentTimesRankingDto;
import com.baijia.tianxiao.biz.erp.service.RankingService;
import com.baijia.tianxiao.dal.fee.dao.TxFeeIncomeDayDao;
import com.baijia.tianxiao.dal.fee.dao.TxFeeStudentDayDao;
import com.baijia.tianxiao.dal.fee.po.TxFeeIncomeDay;
import com.baijia.tianxiao.dal.fee.po.TxFeeStudentDay;
import com.baijia.tianxiao.dal.signup.dao.OrgSignupCourseDao;
import com.baijia.tianxiao.dal.signup.dao.OrgSignupInfoDao;
import com.baijia.tianxiao.sal.organization.org.service.OrgInfoService;
import com.baijia.tianxiao.sal.organization.org.service.OrgSubAccountService;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class RankingServiceImpl
implements RankingService {
    private static final Logger log = LoggerFactory.getLogger(RankingServiceImpl.class);
    @Autowired
    private OrgSignupInfoDao orgSignupInfoDao;
    @Autowired
    private OrgSignupCourseDao orgSignupCourseDao;
    @Autowired
    private OrgSubAccountService orgSubAccountService;
    @Autowired
    private OrgInfoService orgInfoService;
    @Autowired
    private TxFeeIncomeDayDao txFeeIncomeDayDao;
    @Autowired
    private TxFeeStudentDayDao txFeeStudentDayDao;

    @Override
    public List<StudentCountRankingDto> studentCount(Long orgId, RankingRequest rankingRequest) {
        List allOrgId = this.orgSubAccountService.getAllOrgId(orgId);
        boolean isMasterAccount = this.orgSubAccountService.isMasterAccount(orgId);
        List studentDayList = this.txFeeStudentDayDao.studentCountByDay(allOrgId, new Date(rankingRequest.getStartTime()), new Date(rankingRequest.getEndTime()));
        log.info("studentCount={},{},{}", new Object[]{orgId, rankingRequest, studentDayList});
        ArrayList result = Lists.newArrayList();
        int index = 0;
        int currentAccountIndex = 0;
        for (TxFeeStudentDay temp : studentDayList) {
            StudentCountRankingDto studentCountRankingDto = new StudentCountRankingDto();
            studentCountRankingDto.setCampusName(temp.getOrgName());
            studentCountRankingDto.setStudentCount(temp.getStudentimes());
            if (orgId.longValue() == temp.getOrgId().longValue()) {
                studentCountRankingDto.setCampusType(1);
                currentAccountIndex = index;
            }
            studentCountRankingDto.setIndex(++index);
            result.add(studentCountRankingDto);
        }
        if (!isMasterAccount) {
            for (int i = 0; i < result.size(); ++i) {
                if (i == currentAccountIndex - 1 || i == currentAccountIndex || i == currentAccountIndex + 1) continue;
                ((StudentCountRankingDto)((Object)result.get(i))).setStudentCount(-1);
                ((StudentCountRankingDto)((Object)result.get(i))).setShowType(1);
            }
        }
        return result;
    }

    @Override
    public List<StudentTimesRankingDto> studentTimes(Long orgId, RankingRequest rankingRequest) {
        List orgIds = this.orgSubAccountService.getAllOrgId(orgId);
        boolean isMasterAccount = this.orgSubAccountService.isMasterAccount(orgId);
        List studentDayList = this.txFeeStudentDayDao.studentTimesByDay(orgIds, new Date(rankingRequest.getStartTime()), new Date(rankingRequest.getEndTime()));
        log.info("studentTimes={},{},{}", new Object[]{orgId, rankingRequest, studentDayList});
        ArrayList result = Lists.newArrayList();
        int index = 0;
        int currentAccountIndex = 0;
        for (TxFeeStudentDay temp : studentDayList) {
            StudentTimesRankingDto studentTimesRankingDto = new StudentTimesRankingDto();
            studentTimesRankingDto.setCampusName(temp.getOrgName());
            studentTimesRankingDto.setStudentTimes(temp.getStudentimes());
            if (orgId.longValue() == temp.getOrgId().longValue()) {
                studentTimesRankingDto.setCampusType(1);
                currentAccountIndex = index;
            }
            studentTimesRankingDto.setIndex(++index);
            result.add(studentTimesRankingDto);
        }
        if (!isMasterAccount) {
            for (int i = 0; i < result.size(); ++i) {
                if (i == currentAccountIndex - 1 || i == currentAccountIndex || i == currentAccountIndex + 1) continue;
                ((StudentTimesRankingDto)((Object)result.get(i))).setStudentTimes(-1);
                ((StudentTimesRankingDto)((Object)result.get(i))).setShowType(1);
            }
        }
        return result;
    }

    @Override
    public List<IncomeRankingDto> income(Long orgId, RankingRequest rankingRequest) {
        List allOrgIds = this.orgSubAccountService.getAllOrgId(orgId);
        boolean isMasterAccount = this.orgSubAccountService.isMasterAccount(orgId);
        List txFeeIncomeDays = this.txFeeIncomeDayDao.listTopIncomeByOrg(allOrgIds, null, null, new Date(rankingRequest.getStartTime()), new Date(rankingRequest.getEndTime()), Integer.valueOf(1), null, null, null);
        log.info("income={},{},{},{}", new Object[]{orgId, rankingRequest, txFeeIncomeDays});
        ArrayList result = Lists.newArrayList();
        int index = 0;
        int currentAccountIndex = 0;
        for (TxFeeIncomeDay txFeeIncomeDay : txFeeIncomeDays) {
            IncomeRankingDto incomeRankingDto = new IncomeRankingDto();
            incomeRankingDto.setCampusName(txFeeIncomeDay.getOrgName());
            incomeRankingDto.setIncome(txFeeIncomeDay.getSignupAmount());
            if (orgId.longValue() == txFeeIncomeDay.getOrgId().longValue()) {
                incomeRankingDto.setCampusType(1);
                currentAccountIndex = index;
            }
            incomeRankingDto.setIndex(++index);
            result.add(incomeRankingDto);
        }
        if (!isMasterAccount) {
            for (int i = 0; i < result.size(); ++i) {
                if (i == currentAccountIndex - 1 || i == currentAccountIndex || i == currentAccountIndex + 1) continue;
                ((IncomeRankingDto)((Object)result.get(i))).setIncome(-1L);
                ((IncomeRankingDto)((Object)result.get(i))).setShowType(1);
            }
        }
        return result;
    }
}

