/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.biz.erp.service.impl;

import com.baijia.tianxiao.biz.erp.constant.CommentContentType;
import com.baijia.tianxiao.biz.erp.constant.CommentStatus;
import com.baijia.tianxiao.biz.erp.constant.UserCommentType;
import com.baijia.tianxiao.biz.erp.dto.request.CommentStudentRequest;
import com.baijia.tianxiao.biz.erp.dto.response.CommentStudentDto;
import com.baijia.tianxiao.biz.erp.dto.response.CommentStudentResponse;
import com.baijia.tianxiao.biz.erp.dto.response.studentCenter.CommentAddResponse;
import com.baijia.tianxiao.biz.erp.dto.response.studentCenter.StudentSendReceiveCommentsDto;
import com.baijia.tianxiao.biz.erp.service.ErpLessonCommentService;
import com.baijia.tianxiao.consants.DataStatus;
import com.baijia.tianxiao.consants.UserRole;
import com.baijia.tianxiao.constants.UserRoleEnum;
import com.baijia.tianxiao.constants.sms.TxSmsCodeType;
import com.baijia.tianxiao.dal.comment.dao.OrgLessonCommentDao;
import com.baijia.tianxiao.dal.comment.dao.OrgLessonCommentSmsDao;
import com.baijia.tianxiao.dal.comment.po.CommentAudit;
import com.baijia.tianxiao.dal.comment.po.CommentStatic;
import com.baijia.tianxiao.dal.comment.po.OrgLessonComment;
import com.baijia.tianxiao.dal.comment.po.OrgLessonCommentSms;
import com.baijia.tianxiao.dal.enums.CourseTypeEnum;
import com.baijia.tianxiao.dal.org.constant.CampusAccountType;
import com.baijia.tianxiao.dal.org.dao.OrgAccountDao;
import com.baijia.tianxiao.dal.org.dao.OrgClassLessonDao;
import com.baijia.tianxiao.dal.org.dao.OrgCourseDao;
import com.baijia.tianxiao.dal.org.dao.OrgInfoDao;
import com.baijia.tianxiao.dal.org.dao.OrgStorageDao;
import com.baijia.tianxiao.dal.org.dao.OrgStudentDao;
import com.baijia.tianxiao.dal.org.dao.OrgStudentLessonDao;
import com.baijia.tianxiao.dal.org.dao.OrgTeacherLessonDao;
import com.baijia.tianxiao.dal.org.dao.TXCascadeAccountDao;
import com.baijia.tianxiao.dal.org.dao.TXCascadeCredentialDao;
import com.baijia.tianxiao.dal.org.po.OrgAccount;
import com.baijia.tianxiao.dal.org.po.OrgClassLesson;
import com.baijia.tianxiao.dal.org.po.OrgCourse;
import com.baijia.tianxiao.dal.org.po.OrgInfo;
import com.baijia.tianxiao.dal.org.po.OrgStorage;
import com.baijia.tianxiao.dal.org.po.OrgStudent;
import com.baijia.tianxiao.dal.org.po.OrgStudentLesson;
import com.baijia.tianxiao.dal.org.po.OrgTeacher;
import com.baijia.tianxiao.dal.org.po.OrgTeacherLesson;
import com.baijia.tianxiao.dal.org.po.TXCascadeAccount;
import com.baijia.tianxiao.dal.user.dao.TeacherDao;
import com.baijia.tianxiao.dal.user.po.Teacher;
import com.baijia.tianxiao.dal.wechat.constant.WechateTemplateMsgType;
import com.baijia.tianxiao.dto.UniverseErrorCode;
import com.baijia.tianxiao.enums.CommonErrorCode;
import com.baijia.tianxiao.exception.BussinessException;
import com.baijia.tianxiao.image.AvatarUtil;
import com.baijia.tianxiao.sal.comment.dto.AddCommentReponse;
import com.baijia.tianxiao.sal.comment.dto.CommentAuditDto;
import com.baijia.tianxiao.sal.comment.dto.CommentInfoDto;
import com.baijia.tianxiao.sal.comment.dto.request.CommentAddRequestDto;
import com.baijia.tianxiao.sal.comment.dto.request.CommentListRequest;
import com.baijia.tianxiao.sal.comment.dto.response.AudioDto;
import com.baijia.tianxiao.sal.comment.dto.response.CommentListResponse;
import com.baijia.tianxiao.sal.comment.dto.response.CommentUserDto;
import com.baijia.tianxiao.sal.comment.dto.response.ImageDto;
import com.baijia.tianxiao.sal.comment.service.LessonCommentAudiService;
import com.baijia.tianxiao.sal.comment.service.LessonCommentService;
import com.baijia.tianxiao.sal.common.api.CommonMsgService;
import com.baijia.tianxiao.sal.common.api.OrgStudentApiService;
import com.baijia.tianxiao.sal.common.api.OrgTeacherApiService;
import com.baijia.tianxiao.sal.common.dto.WechatMsgTypeSuper;
import com.baijia.tianxiao.sal.common.dto.msg.SendMsgRequest;
import com.baijia.tianxiao.sal.common.dto.wechatMsgRequest.AfterCourseCommentMsg;
import com.baijia.tianxiao.sal.common.utils.NotifyMessageUtils;
import com.baijia.tianxiao.sal.common.utils.WechatTemplateMsgHelper;
import com.baijia.tianxiao.sal.course.constant.CourseErrorCode;
import com.baijia.tianxiao.sal.course.dto.response.TeacherResponseDto;
import com.baijia.tianxiao.sal.course.service.CourseTeacherService;
import com.baijia.tianxiao.sal.organization.org.service.TxCascadeCredentialService;
import com.baijia.tianxiao.sal.student.api.OrgStudentService;
import com.baijia.tianxiao.sal.student.dto.response.StudentInfoReponseDto;
import com.baijia.tianxiao.sal.teacher.api.OrgTeacherService;
import com.baijia.tianxiao.sal.teacher.api.TeacherService;
import com.baijia.tianxiao.sal.teacher.dto.OrgTeacherResponseDto;
import com.baijia.tianxiao.sqlbuilder.dto.PageDto;
import com.baijia.tianxiao.util.BaseUtils;
import com.baijia.tianxiao.util.ShortUrlUtil;
import com.baijia.tianxiao.util.SmsContentHelper;
import com.baijia.tianxiao.util.TwoTuple;
import com.baijia.tianxiao.util.collection.CollectorUtil;
import com.baijia.tianxiao.util.exception.BussinessPreconditions;
import com.baijia.tianxiao.util.mobile.MaskUtil;
import com.baijia.tianxiao.util.properties.PropertiesReader;
import com.baijia.tianxiao.util.storage.StorageUtil;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Resource;
import lombok.NonNull;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ErpLessonCommentServiceImpl
implements ErpLessonCommentService {
    private static final Logger log = LoggerFactory.getLogger(ErpLessonCommentServiceImpl.class);
    @Deprecated
    public static String lessonStartStudent = "%s\uff0c\u4f60\u5728%s\u7684%s\u5c06\u5728%s\u5f00\u59cb\u4e0a\u8bfe\u3002\u8d76\u5feb\u51fa\u53d1\u5427\u3002\u5982\u9700\u8bf7\u5047\uff0c\u8bf7\u62e8\u62534000122166\u8f6c%s\u3002";
    private static String defaultName = "-";
    private static String remark = "\u70b9\u51fb\u8fd9\u91cc\u53bb\u7ed9\u8001\u5e08\u8bc4\u4ef7\u5427";
    @Resource
    private OrgStudentLessonDao orgStudentLessonDao;
    @Resource
    private OrgTeacherLessonDao orgTeacherLessonDao;
    @Resource
    private OrgLessonCommentSmsDao orgLessonCommentSmsDao;
    @Resource
    private OrgClassLessonDao orgClassLessonDao;
    @Resource
    private OrgStudentDao orgStudentDao;
    @Resource
    private OrgCourseDao orgCourseDao;
    @Resource
    private TeacherDao teacherDao;
    @Resource
    private TeacherService teacherService;
    @Resource
    private LessonCommentService lessonCommentService;
    @Resource
    private LessonCommentAudiService LessonCommentAudiService;
    @Resource
    private OrgStudentService orgStudentService;
    @Resource
    private CourseTeacherService courseTeacherService;
    @Resource
    private OrgInfoDao orgInfoDao;
    @Autowired(required=false)
    private CommonMsgService commonMsgService;
    @Resource
    private Environment environment;
    @Autowired
    private OrgLessonCommentDao orgLessonCommentDao;
    @Autowired
    private OrgStorageDao orgStorageDao;
    @Autowired
    private TXCascadeCredentialDao txCascadeCredentialDao;
    @Autowired
    private OrgAccountDao orgAccountDao;
    @Autowired
    private OrgTeacherService orgTeacherService;
    @Autowired
    private OrgStudentApiService orgStudentApiService;
    @Autowired
    private OrgTeacherApiService orgTeacherApiService;
    @Autowired
    private TxCascadeCredentialService cascadeCredentialService;
    @Autowired
    private OrgStudentApiService studentApiService;
    @Autowired
    private TXCascadeAccountDao txCascadeAccountDao;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void sendStudentSms(Long orgId, Long lessonId) {
        Preconditions.checkArgument((orgId != null ? 1 : 0) != 0, (Object)"orgId is null!");
        Preconditions.checkArgument((lessonId != null ? 1 : 0) != 0, (Object)"lessonId is null!");
        OrgClassLesson lesson = (OrgClassLesson)this.orgClassLessonDao.getById((Serializable)lessonId, new String[0]);
        if (lesson == null) {
            throw new BussinessException((UniverseErrorCode)CourseErrorCode.LESSON_NOT_EXIST);
        }
        if (this.orgTeacherLessonDao.getByLessonId(orgId, lessonId) == null) {
            throw new BussinessException((UniverseErrorCode)CourseErrorCode.LESSON_NOT_SET_TEACHER_SMS);
        }
        List userIds = this.orgStudentLessonDao.getUserIds(lessonId, orgId);
        this.sendStudentCommentSms(orgId, lesson, userIds);
    }

    private void sendStudentCommentSms(Long orgId, OrgClassLesson lesson, Collection<Long> userIds) {
        log.debug("sendStudentCommentSms = {},{},{}", new Object[]{orgId, lesson, userIds});
        OrgInfo orgInfo = this.orgInfoDao.getOrgInfo(Integer.valueOf(orgId.intValue()), new String[0]);
        OrgAccount orgAccount = (OrgAccount)this.orgAccountDao.getById((Serializable)orgId, new String[0]);
        Map studentMap = this.orgStudentDao.getStudentMap(userIds, orgId, new String[0]);
        OrgCourse course = (OrgCourse)this.orgCourseDao.getById((Serializable)lesson.getCourseId(), new String[]{"name"});
        OrgTeacherLesson teacherLesson = this.orgTeacherLessonDao.getByLessonId(orgId, lesson.getId());
        Teacher teacher = null;
        if (teacherLesson != null) {
            teacher = this.teacherDao.getByUserId(teacherLesson.getTeacherId(), new String[0]);
        }
        for (Long userId : userIds) {
            OrgStudent student = (OrgStudent)studentMap.get(userId);
            if (student == null) continue;
            String url = this.getStudentCommentUrl(orgAccount.getNumber(), orgId, lesson.getCourseId(), course.getName(), student, lesson.getNumber(), lesson.getId());
            url = ShortUrlUtil.getShortUrl((String)url);
            String smsContent = SmsContentHelper.createNotifyCommentToStuSmsMsg((String)teacher.getRealName(), (long)lesson.getStartTime().getTime(), (String)url, (String)orgInfo.getShortName());
            String name = student.getName();
            if (StringUtils.isBlank((CharSequence)name)) {
                name = student.getNickName();
            }
            if (StringUtils.isBlank((CharSequence)name)) {
                name = MaskUtil.maskMobile((String)student.getMobile());
            }
            AfterCourseCommentMsg msg = AfterCourseCommentMsg.newInstance((String)name, (String)course.getName(), (String)teacher.getRealName(), (String)url);
            SendMsgRequest createSendMsgRequestToStu = WechatTemplateMsgHelper.createSendMsgRequestToStu((Long)orgId, (String)student.getMobile(), (Long)student.getId(), (String)student.getWeixin(), (String)smsContent, (WechateTemplateMsgType)WechateTemplateMsgType.COURSE_EVALUATION_TO_STU, (WechatMsgTypeSuper)msg);
            try {
                createSendMsgRequestToStu.setSmsCodeType(TxSmsCodeType.NOTIFY_TO_COMMENT);
                if (!this.commonMsgService.sendMsg(createSendMsgRequestToStu)) continue;
                this.updateSmsCount(orgId, userId, lesson.getId());
            }
            catch (Exception e) {
                log.error(e.getMessage());
            }
        }
    }

    @Override
    public void sendStudentSmsByLessonStudentId(final Long orgId, Long lessonId, String studentIds) {
        log.debug("sendStudentSmsByLessonStudentId params = {},{},{}", new Object[]{orgId, lessonId, studentIds});
        Preconditions.checkArgument((orgId != null ? 1 : 0) != 0, (Object)"orgId is null!");
        Preconditions.checkArgument((lessonId != null ? 1 : 0) != 0, (Object)"lessonId is null!");
        final OrgClassLesson lesson = (OrgClassLesson)this.orgClassLessonDao.getById((Serializable)lessonId, new String[0]);
        if (lesson == null) {
            throw new BussinessException((UniverseErrorCode)CourseErrorCode.LESSON_NOT_EXIST);
        }
        if (this.orgTeacherLessonDao.getByLessonId(orgId, lessonId) == null) {
            throw new BussinessException((UniverseErrorCode)CourseErrorCode.LESSON_NOT_SET_TEACHER_SMS);
        }
        List studentLongIds = BaseUtils.strToLongList((String)studentIds, (String)",");
        if (CollectionUtils.isEmpty((Collection)studentLongIds)) {
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u63d0\u9192\u5b66\u5458\u4e0d\u80fd\u4e3a\u7a7a");
        }
        final Map studentUserMaps = this.orgStudentService.getStudentIdUserIdMap((Collection)studentLongIds);
        log.debug("sendStudentSmsByLessonStudentId ={},{}", (Object)studentUserMaps, studentUserMaps.values());
        new Thread(new Runnable(){

            @Override
            public void run() {
                log.debug("thread test = {},{},{}", new Object[]{orgId, lesson, studentUserMaps});
                ErpLessonCommentServiceImpl.this.sendStudentCommentSms(orgId, lesson, studentUserMaps.values());
            }
        }).start();
    }

    @Deprecated
    private SendMsgRequest getStudentCommentRemend(String teacherName, String smsContent, String content, OrgClassLesson lesson, OrgCourse course, OrgInfo orgInfo, OrgStudent student, String url) {
        SendMsgRequest request = new SendMsgRequest();
        request.setOrgId(Long.valueOf(orgInfo.getOrgId().longValue()));
        request.setMobile(student.getMobile());
        request.setCountSms(false);
        request.setReceiverId(student.getId());
        request.setWeixinOpenId(student.getWeixin());
        request.setReceiverRole(UserRoleEnum.STUDENT);
        request.setSenderId(Long.valueOf(orgInfo.getOrgId().longValue()));
        request.setSenderRole(UserRoleEnum.ORG);
        request.setWechatTemplateId(Integer.valueOf(WechateTemplateMsgType.COURSE_EVALUATION_TO_STU.getValue()));
        HashMap params = Maps.newHashMap();
        request.setSmsContent(smsContent);
        params.put("first", content);
        params.put("remark", remark);
        params.put("keyword1", this.getStringValue(student.getName()));
        params.put("keyword2", this.getStringValue(course.getName()) + NotifyMessageUtils.generateLessonName((String)lesson.getName(), (boolean)true));
        params.put("keyword3", this.getStringValue(teacherName));
        params.put("url", url);
        request.setWechatParams((Map)params);
        log.debug("remind student comment the course! data={}", (Object)request);
        return request;
    }

    private String getStringValue(String message) {
        if (StringUtils.isBlank((CharSequence)message)) {
            return defaultName;
        }
        return message;
    }

    @Transactional(readOnly=true)
    public String getStudentSmsContent(Integer orgNumber, Long orgId, Long courseId, String courseName, String lessonName, OrgStudent student, Integer index, Long lessonId, boolean withUrl) {
        String url = this.getStudentCommentUrl(orgNumber, orgId, courseId, courseName, student, index, lessonId);
        String name = student.getName();
        if (StringUtils.isBlank((CharSequence)name)) {
            name = student.getNickName();
        }
        if (StringUtils.isBlank((CharSequence)name)) {
            name = MaskUtil.maskMobile((String)student.getMobile());
        }
        url = ShortUrlUtil.getShortUrl((String)url);
        StringBuilder sb = new StringBuilder();
        sb.append(String.format("%s\u4f60\u597d\uff0c\u4f60\u5df2\u5728%s%s\u5b8c\u6210\u4e00\u6b21\u8bfe\u3002\u662f\u5426\u5bf9\u672c\u6b21\u8bfe\u6ee1\u610f\u5462\uff1f\u5feb\u53bb\u7ed9\u8001\u5e08\u6253\u5206\u5427\u3002", name, courseName, NotifyMessageUtils.generateLessonName((String)lessonName, (boolean)false)));
        if (withUrl) {
            return sb.append(String.format("\u5730\u5740:%s", url)).toString();
        }
        return sb.toString();
    }

    private String getStudentCommentUrl(Integer orgNumber, Long orgId, Long courseId, String courseName, OrgStudent student, Integer index, Long lessonId) {
        try {
            String url = PropertiesReader.getValue((String)"config", (String)"usercenter.link");
            url = url + orgNumber + String.format("/stu/lesson/detail.do?lessonId=%s&studentId=%s&checkLogin=true", lessonId, student.getId());
            return url;
        }
        catch (Exception e) {
            log.warn("get lesson student comment error", (Throwable)e);
            return null;
        }
    }

    public static void main(String[] args) throws Exception {
        String str = "\ud83d\udc36\ud83c\udf39\u6536\u5230\u7684";
        String searchKey = "ff";
        String result = null;
        int keyIndex = str.toLowerCase().indexOf(searchKey.toLowerCase());
        if (keyIndex != -1 && str.length() > 20) {
            result = keyIndex + searchKey.length() <= 20 ? ErpLessonCommentServiceImpl.emojiSubstring(str, 0, 20) + "..." : (str.length() - 20 < keyIndex ? "..." + ErpLessonCommentServiceImpl.emojiSubstring(str, str.length() - 20, str.length()) : "..." + ErpLessonCommentServiceImpl.emojiSubstring(str, keyIndex - 5, keyIndex + 20) + "...");
        } else if (str.length() > 20) {
            result = ErpLessonCommentServiceImpl.emojiSubstring(str, 0, 20) + "...";
        }
        System.out.println(result);
    }

    public static String emojiSubstring(String source, int start, int end) {
        String result;
        try {
            result = source.substring(source.offsetByCodePoints(0, start), source.offsetByCodePoints(0, end));
        }
        catch (Exception e) {
            result = "";
        }
        return result;
    }

    private void updateSmsCount(Long orgId, Long userId, Long lessonId) {
        OrgLessonCommentSms sms = this.orgLessonCommentSmsDao.getCommentSms(orgId, lessonId, userId, Integer.valueOf(UserRole.STUDENT.getRole()));
        if (sms == null) {
            sms = new OrgLessonCommentSms();
            sms.setLessonId(lessonId);
            sms.setOrgId(orgId);
            sms.setSend(Integer.valueOf(1));
            sms.setUserId(userId);
            sms.setUserRole(Integer.valueOf(UserRole.STUDENT.getRole()));
            this.orgLessonCommentSmsDao.save((Object)sms, new String[0]);
        } else {
            sms.setSend(Integer.valueOf(sms.getSend() + 1));
            this.orgLessonCommentSmsDao.update((Object)sms, new String[]{"send"});
        }
    }

    @Override
    public List<CommentInfoDto> queryComments(Long orgId, Collection<Long> courseIds, Collection<Long> teacherIds, Integer commentReqType, Boolean isSystem, Integer userRole, PageDto pageDto) {
        List comments = this.lessonCommentService.queryComments(orgId, courseIds, teacherIds, commentReqType, isSystem, userRole, pageDto);
        HashSet fromIds = Sets.newHashSet();
        HashSet toIds = Sets.newHashSet();
        for (CommentInfoDto commentInfoDto : comments) {
            fromIds.add(commentInfoDto.getFromId());
            toIds.add(commentInfoDto.getToId());
        }
        this.getAndSetNameAndAVatar(orgId, fromIds, toIds, userRole, comments);
        return comments;
    }

    @Override
    @Transactional(readOnly=true)
    public CommentInfoDto getCommentByCommentId(Long orgId, Long commentId) {
        CommentInfoDto dto = this.lessonCommentService.getComment(orgId, commentId);
        if (null != dto) {
            HashSet fromIds = Sets.newHashSet();
            HashSet toIds = Sets.newHashSet();
            fromIds.add(dto.getFromId());
            toIds.add(dto.getToId());
            this.getAndSetNameAndAVatar(orgId, fromIds, toIds, dto.getUserRole(), Lists.newArrayList((Object[])new CommentInfoDto[]{dto}));
            return dto;
        }
        return null;
    }

    @Override
    @Transactional(readOnly=true)
    public StudentSendReceiveCommentsDto getStudentSendAndRecieveComments(@NonNull Long orgId, @NonNull Long lessonId, @NonNull Long studentUserId) {
        if (orgId == null) {
            throw new NullPointerException("orgId");
        }
        if (lessonId == null) {
            throw new NullPointerException("lessonId");
        }
        if (studentUserId == null) {
            throw new NullPointerException("studentUserId");
        }
        StudentSendReceiveCommentsDto result = new StudentSendReceiveCommentsDto();
        OrgTeacherLesson teacherLesson = this.orgTeacherLessonDao.getByLessonId(orgId, lessonId);
        OrgStudentLesson studentLesson = this.orgStudentLessonDao.getByLessonIdAndUserId(lessonId, studentUserId);
        if (null != studentLesson && null != teacherLesson) {
            List revieveComments;
            List sendComments = this.lessonCommentService.getComments(orgId, lessonId, (List)Lists.newArrayList((Object[])new Long[]{studentUserId}), null, Integer.valueOf(UserRole.STUDENT.getRole()));
            if (CollectionUtils.isNotEmpty((Collection)sendComments)) {
                HashSet fromIds = Sets.newHashSet();
                HashSet toIds = Sets.newHashSet();
                for (CommentInfoDto commentInfoDto : sendComments) {
                    fromIds.add(commentInfoDto.getFromId());
                    toIds.add(commentInfoDto.getToId());
                }
                this.getAndSetNameAndAVatar(orgId, fromIds, toIds, UserRole.STUDENT.getRole(), sendComments);
                result.setSendComments(sendComments);
            }
            if (CollectionUtils.isNotEmpty((Collection)(revieveComments = this.lessonCommentService.getComments(orgId, lessonId, null, (List)Lists.newArrayList((Object[])new Long[]{studentUserId}), Integer.valueOf(UserRole.TEACHER.getRole()))))) {
                HashSet fromIds = Sets.newHashSet();
                HashSet toIds = Sets.newHashSet();
                for (CommentInfoDto commentInfoDto : revieveComments) {
                    fromIds.add(commentInfoDto.getFromId());
                    toIds.add(commentInfoDto.getToId());
                }
                this.getAndSetNameAndAVatar(orgId, fromIds, toIds, UserRole.TEACHER.getRole(), revieveComments);
                result.setReceiveComments(revieveComments);
            }
        }
        return result;
    }

    private void getAndSetNameAndAVatar(Long orgId, Collection<Long> fromIds, Collection<Long> toIds, Integer userRole, List<CommentInfoDto> comments) {
        if (userRole.intValue() == UserRole.STUDENT.getRole()) {
            Map studentMap = this.orgStudentService.getUserIdStudentDtoMap(fromIds, orgId);
            Map teacherMap = this.teacherService.getOrgTeacherMap(orgId, toIds);
            log.debug("studentMap={}", (Object)studentMap);
            log.debug("teachermap={}", (Object)teacherMap);
            for (CommentInfoDto commentInfoDto : comments) {
                StudentInfoReponseDto student = (StudentInfoReponseDto)studentMap.get(commentInfoDto.getFromId());
                OrgTeacherResponseDto teacher = (OrgTeacherResponseDto)teacherMap.get(commentInfoDto.getToId());
                if (student != null) {
                    commentInfoDto.setFromName(student.getName());
                    commentInfoDto.setFromAvatar(student.getAvatarUrl());
                }
                if (teacher == null) continue;
                commentInfoDto.setToName(teacher.getTeacherName());
                commentInfoDto.setToAvatar(teacher.getAvatar());
            }
        } else {
            Map studentMap = this.orgStudentService.getUserIdStudentDtoMap(toIds, orgId);
            Map teacherMap = this.teacherService.getOrgTeacherMap(orgId, fromIds);
            log.debug("studentMap={}", (Object)studentMap);
            log.debug("teachermap={}", (Object)teacherMap);
            for (CommentInfoDto commentInfoDto : comments) {
                StudentInfoReponseDto student = (StudentInfoReponseDto)studentMap.get(commentInfoDto.getToId());
                OrgTeacherResponseDto teacher = (OrgTeacherResponseDto)teacherMap.get(commentInfoDto.getFromId());
                if (teacher != null) {
                    commentInfoDto.setFromName(teacher.getTeacherName());
                    commentInfoDto.setFromAvatar(teacher.getAvatar());
                }
                if (student == null) continue;
                commentInfoDto.setToName(student.getName());
                commentInfoDto.setToAvatar(student.getAvatarUrl());
            }
        }
    }

    @Override
    public List<CommentAuditDto> getTeacherAuditList(Long orgId, Integer userRole, Boolean isSystem, PageDto pageDto) {
        List teachers = this.courseTeacherService.listOrgTeacher(null, orgId, null, null, pageDto);
        Map teacherMap = CollectorUtil.collectMap((Collection)teachers, (Function)new Function<TeacherResponseDto, Long>(){

            public Long apply(TeacherResponseDto arg0) {
                return arg0.getTeacherId();
            }
        });
        List comments = this.LessonCommentAudiService.getTeacherAuditList(orgId, teacherMap.keySet(), userRole, isSystem);
        for (CommentAuditDto commentAuditDto : comments) {
            TeacherResponseDto teacher = (TeacherResponseDto)teacherMap.get(commentAuditDto.getId());
            if (teacher == null) continue;
            commentAuditDto.setAvatarUrl(teacher.getAvatar());
            commentAuditDto.setName(teacher.getTeacherName());
        }
        return comments;
    }

    @Override
    @Transactional(readOnly=true)
    public List<CommentInfoDto> getLessonCommentsWithLessonInfo(Long orgId, Long studentId, Integer userRole, PageDto pageDto) {
        List list = this.lessonCommentService.getLessonCommentsWithLessonInfo(orgId, studentId, userRole, pageDto);
        HashSet fromIds = Sets.newHashSet();
        HashSet toIds = Sets.newHashSet();
        for (CommentInfoDto commentInfoDto : list) {
            fromIds.add(commentInfoDto.getFromId());
            toIds.add(commentInfoDto.getToId());
        }
        this.getAndSetNameAndAVatar(orgId, fromIds, toIds, userRole, list);
        return list;
    }

    @Override
    public List<CommentListResponse> commentList(Long orgId, CommentListRequest commentListRequest) {
        log.info("Collent List request = {},{}", (Object)orgId, (Object)commentListRequest);
        List<Long> classIds = this.getClassIdList(orgId, commentListRequest);
        List<Long> lessonIds = this.getLessonIdList(orgId, commentListRequest);
        Date beginDate = CommentListRequest.getBeginTimeByType((int)commentListRequest.getTimeType());
        Date endDate = CommentListRequest.getEndTimeByType((int)commentListRequest.getTimeType());
        log.info("Collent List request = {},{},{},{},{}", new Object[]{orgId, commentListRequest, lessonIds, beginDate, endDate});
        List lessonComments = this.orgLessonCommentDao.listComment(orgId, classIds, lessonIds, commentListRequest.getTeacherId(), commentListRequest.getCurrentCascadeTeacherUserId(), beginDate, endDate, commentListRequest.getSourceType(), commentListRequest.getScoreType(), commentListRequest.getLastId(), commentListRequest.getPageSize());
        return this.buildCommentDeailList(orgId, lessonComments, commentListRequest.getSearchKey(), CommentContentType.LIST_CONTENT);
    }

    private List<CommentListResponse> buildCommentDeailList(Long orgId, List<OrgLessonComment> lessonComments, String searchKey, CommentContentType contentType) {
        if (CollectionUtils.isEmpty(lessonComments)) {
            return Lists.newArrayList();
        }
        ArrayList studentIds = Lists.newArrayList();
        ArrayList teacherIds = Lists.newArrayList();
        ArrayList storagetIds = Lists.newArrayList();
        ArrayList classIds = Lists.newArrayList();
        ArrayList commentLessonIds = Lists.newArrayList();
        for (OrgLessonComment lessonComment : lessonComments) {
            List imageStorageIds;
            if (lessonComment.getUserRole().intValue() == UserRoleEnum.TEACHER.getCode()) {
                teacherIds.add(lessonComment.getFromId());
                studentIds.add(lessonComment.getToId());
            }
            if (lessonComment.getUserRole().intValue() == UserRoleEnum.STUDENT.getCode()) {
                studentIds.add(lessonComment.getFromId());
                teacherIds.add(lessonComment.getToId());
            }
            if (lessonComment.getSoundId() != null && lessonComment.getSoundId() > 0) {
                storagetIds.add(lessonComment.getSoundId().longValue());
            }
            if (CollectionUtils.isNotEmpty((Collection)(imageStorageIds = BaseUtils.strToLongList((String)lessonComment.getStorageIds(), (String)",")))) {
                storagetIds.addAll(imageStorageIds);
            }
            classIds.add(lessonComment.getCourseId());
            commentLessonIds.add(lessonComment.getLessonId());
        }
        Map studentMap = this.orgStudentService.getUserIdStudentDtoMap((Collection)studentIds, orgId);
        Map teacherMap = this.teacherService.getOrgTeacherMap(orgId, (Collection)teacherIds);
        Map storageMap = this.orgStorageDao.getOrgStorageMapByIds((Collection)storagetIds);
        Map courseMap = this.orgCourseDao.getOrgCourseMap((Collection)classIds, new String[0]);
        Map lessonMap = this.orgClassLessonDao.getClassLessonMap(orgId, (Collection)commentLessonIds, Integer.valueOf(DataStatus.NORMAL.getValue()), new String[0]);
        OrgAccount orgAccount = this.orgAccountDao.getAccountById(orgId.intValue(), new String[0]);
        ArrayList result = Lists.newArrayList();
        for (OrgLessonComment lessonComment : lessonComments) {
            CommentListResponse dto = this.buildCommmentDetail(orgAccount, lessonComment, courseMap, lessonMap, studentMap, teacherMap, storageMap);
            this.subCommentContent(dto, searchKey, contentType);
            result.add(dto);
        }
        return result;
    }

    private void subCommentContent(CommentListResponse dto, String searchKey, CommentContentType contentType) {
        if (contentType == CommentContentType.SEARCH_CONTENT) {
            int keyIndex = dto.getContent().toLowerCase().toLowerCase().indexOf(searchKey.toLowerCase());
            if (keyIndex != -1 && dto.getContent().length() > 20) {
                if (keyIndex + searchKey.length() <= 20) {
                    dto.setContent(ErpLessonCommentServiceImpl.emojiSubstring(dto.getContent(), 0, 20) + "...");
                } else if (dto.getContent().length() - 20 < keyIndex) {
                    dto.setContent("..." + ErpLessonCommentServiceImpl.emojiSubstring(dto.getContent(), dto.getContent().length() - 20, dto.getContent().length()));
                } else {
                    dto.setContent("..." + ErpLessonCommentServiceImpl.emojiSubstring(dto.getContent(), keyIndex - 5, keyIndex + 20) + "...");
                }
            } else if (dto.getContent().length() > 20) {
                dto.setContent(ErpLessonCommentServiceImpl.emojiSubstring(dto.getContent(), 0, 20) + "...");
            }
        } else if (contentType == CommentContentType.LIST_CONTENT && dto.getContent().length() > 100) {
            dto.setContent(ErpLessonCommentServiceImpl.emojiSubstring(dto.getContent(), 0, 100));
        }
    }

    private List<Long> getLessonIdList(Long orgId, CommentListRequest commentListRequest) {
        List<Long> lessonIds = null;
        return lessonIds;
    }

    private List<Long> getClassIdList(Long orgId, CommentListRequest commentListRequest) {
        List hasMasterCourse;
        TXCascadeAccount txCascadeAccount;
        ArrayList classIds = null;
        if (commentListRequest.getCascadeId() != null && commentListRequest.getCascadeId() > 0 && (txCascadeAccount = this.txCascadeAccountDao.getByIdAndOrgId(commentListRequest.getCascadeId(), Integer.valueOf(orgId.intValue()), new String[0])) != null && txCascadeAccount.getAccountType() == CampusAccountType.STAFF.getCode() && CollectionUtils.isNotEmpty((Collection)(hasMasterCourse = this.orgCourseDao.getCourseIdsByCascadeId(commentListRequest.getCascadeId(), null, CourseTypeEnum.IS_CLASS_TRUE.getCode(), null)))) {
            classIds = Lists.newArrayList((Iterable)hasMasterCourse);
        }
        return classIds;
    }

    private CommentListResponse buildCommmentDetail(OrgAccount orgAccount, OrgLessonComment orgLessonComment, Map<Long, OrgCourse> courseMap, Map<Long, OrgClassLesson> lessonMap, Map<Long, StudentInfoReponseDto> studentMap, Map<Long, OrgTeacherResponseDto> teacherMap, Map<Long, OrgStorage> storageMap) {
        List imageStorageIds;
        OrgClassLesson orgClassLesson;
        CommentListResponse response = new CommentListResponse();
        response.setCommentId(orgLessonComment.getId());
        response.setSourceType(orgLessonComment.getUserRole());
        response.setScore(orgLessonComment.getStarScore());
        response.setClassId(orgLessonComment.getCourseId());
        response.setContent(orgLessonComment.getContent() == null ? "" : orgLessonComment.getContent());
        response.setUpdateTime(orgLessonComment.getUpdateTime());
        response.setLessonId(orgLessonComment.getLessonId());
        OrgCourse orgCourse = courseMap.get((long)orgLessonComment.getCourseId());
        if (orgCourse != null) {
            response.setClassName(orgCourse.getName());
        }
        if ((orgClassLesson = lessonMap.get((long)orgLessonComment.getLessonId())) != null) {
            response.setLessonIndex(orgClassLesson.getNumber());
        }
        OrgTeacherResponseDto teacherResponseDto = null;
        StudentInfoReponseDto studentInfoReponseDto = null;
        if (orgLessonComment.getUserRole().intValue() == UserRoleEnum.TEACHER.getCode()) {
            teacherResponseDto = teacherMap.get((long)orgLessonComment.getFromId());
            studentInfoReponseDto = studentMap.get((long)orgLessonComment.getToId());
        }
        if (orgLessonComment.getUserRole().intValue() == UserRoleEnum.STUDENT.getCode()) {
            teacherResponseDto = teacherMap.get((long)orgLessonComment.getToId());
            studentInfoReponseDto = studentMap.get((long)orgLessonComment.getFromId());
        }
        if (studentInfoReponseDto != null) {
            CommentUserDto commentStudent = new CommentUserDto();
            commentStudent.setId(studentInfoReponseDto.getStudentId());
            commentStudent.setName(studentInfoReponseDto.getName());
            commentStudent.setAvatarUrl(studentInfoReponseDto.getAvatarUrl());
            if (commentStudent.getAvatarUrl() == null) {
                commentStudent.setAvatarUrl(AvatarUtil.getUserAvatar((long)(studentInfoReponseDto == null ? 0L : studentInfoReponseDto.getStudentId())));
            }
            if (StringUtils.isNotEmpty((CharSequence)studentInfoReponseDto.getWeixin())) {
                commentStudent.setBindWeiXinStatus(Integer.valueOf(1));
            }
            response.setStudent(commentStudent);
        }
        if (teacherResponseDto != null) {
            CommentUserDto commentTeacher = new CommentUserDto();
            commentTeacher.setId(teacherResponseDto.getUserId());
            commentTeacher.setName(teacherResponseDto.getTeacherName());
            commentTeacher.setMobile(teacherResponseDto.getMobile());
            commentTeacher.setAvatarUrl(teacherResponseDto.getAvatar());
            response.setTeacher(commentTeacher);
        }
        if (orgLessonComment.getSoundId() != null && orgLessonComment.getSoundId() > 0) {
            AudioDto audioDto = new AudioDto();
            audioDto.setLength(orgLessonComment.getSoundLength());
            audioDto.setStorageId(orgLessonComment.getSoundId());
            OrgStorage soundStorage = storageMap.get(orgLessonComment.getSoundId().longValue());
            if (soundStorage != null) {
                audioDto.setUrl(StorageUtil.constructUrl((String)soundStorage.getFid(), (String)soundStorage.getSn(), (Integer)soundStorage.getMimeType()));
            }
            response.setAudio(audioDto);
        }
        if (CollectionUtils.isNotEmpty((Collection)(imageStorageIds = BaseUtils.strToLongList((String)orgLessonComment.getStorageIds(), (String)",")))) {
            ArrayList imageDtoList = Lists.newArrayList();
            for (Long imageStorageId : imageStorageIds) {
                ImageDto imageDto = new ImageDto();
                imageDto.setStorageId(imageStorageId);
                OrgStorage orgStorage = storageMap.get((long)imageStorageId);
                if (orgStorage != null) {
                    imageDto.setUrl(StorageUtil.constructUrl((String)orgStorage.getFid(), (String)orgStorage.getSn(), (Integer)orgStorage.getMimeType()));
                }
                imageDtoList.add(imageDto);
            }
            response.setImages((List)imageDtoList);
        }
        response.setSharePosterUrl(PropertiesReader.getValue((String)"config", (String)"usercenter.link") + String.format("%s/stu/comment/poster.do?commentId=%s", orgAccount.getNumber(), response.getCommentId()));
        return response;
    }

    @Override
    public List<CommentListResponse> lessonCommentList(Long orgId, Integer cascadeId, Long lessonId, Long studentId) {
        log.info("Collent List request = {},{},{},{}", new Object[]{orgId, cascadeId, lessonId, studentId});
        OrgStudent orgStudent = (OrgStudent)this.orgStudentDao.getById((Serializable)studentId, new String[0]);
        if (orgStudent == null) {
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u5b66\u751f\u4e0d\u5b58\u5728");
        }
        List hasMasterCourse = this.orgCourseDao.getCourseIdsByCascadeId(cascadeId, null, CourseTypeEnum.IS_CLASS_TRUE.getCode(), null);
        boolean onlyTeacherAccount = this.cascadeCredentialService.onlyTeacherAccount(orgId, cascadeId);
        Long teacherUserId = this.cascadeCredentialService.getTeacherUserIdByAccount(orgId, cascadeId);
        OrgTeacherLesson orgTeacherLesson = this.orgTeacherLessonDao.getByLessonId(orgId, lessonId);
        List lessonComments = this.orgLessonCommentDao.listCommentByStudent(orgId, lessonId, orgStudent.getUserId());
        List<CommentListResponse> result = this.buildCommentDeailList(orgId, lessonComments, null, CommentContentType.DETAIL_CONTENT);
        boolean hasTeacherComment = false;
        boolean hasStudentComment = false;
        CommentListResponse studentListResponse = null;
        ArrayList newDataResult = Lists.newArrayList();
        for (int i = 0; i < result.size(); ++i) {
            CommentListResponse commentListResponse = result.get(i);
            if (commentListResponse.getSourceType().intValue() == UserRoleEnum.TEACHER.getCode()) {
                log.debug("is can edit comment params {},{},{}", new Object[]{orgId, teacherUserId, commentListResponse});
                if (!onlyTeacherAccount) {
                    commentListResponse.setEditStatus(Integer.valueOf(1));
                } else if (commentListResponse.getTeacher() != null && commentListResponse.getTeacher().getId() != null && teacherUserId > 0L && commentListResponse.getTeacher().getId().longValue() == teacherUserId.longValue()) {
                    commentListResponse.setEditStatus(Integer.valueOf(1));
                } else if (hasMasterCourse.contains((long)commentListResponse.getClassId())) {
                    commentListResponse.setEditStatus(Integer.valueOf(1));
                }
                if (orgTeacherLesson != null && commentListResponse.getTeacher() != null && (long)orgTeacherLesson.getTeacherId().intValue() == commentListResponse.getTeacher().getId()) {
                    hasTeacherComment = true;
                }
                newDataResult.add(commentListResponse);
            }
            if (commentListResponse.getSourceType().intValue() != UserRoleEnum.STUDENT.getCode()) continue;
            hasStudentComment = true;
            studentListResponse = commentListResponse;
        }
        if (!hasTeacherComment) {
            CommentListResponse teacherCommentResponse = new CommentListResponse();
            teacherCommentResponse.setSourceType(Integer.valueOf(UserRoleEnum.TEACHER.getCode()));
            OrgTeacherLesson teacherLesson = this.orgTeacherLessonDao.getByLessonId(orgId, lessonId);
            BussinessPreconditions.checkArgument((null != teacherLesson ? 1 : 0) != 0, (Object)"\u627e\u4e0d\u5230\u8bfe\u8282\u8001\u5e08");
            OrgTeacher orgTeacher = this.orgTeacherService.getByUserIdIgnorUserStatus(teacherLesson.getTeacherId().longValue());
            BussinessPreconditions.checkArgument((null != orgTeacher ? 1 : 0) != 0, (Object)("\u627e\u4e0d\u5230\u8bfe\u8282\u8001\u5e08" + teacherLesson.getTeacherId()));
            OrgClassLesson orgClassLesson = (OrgClassLesson)this.orgClassLessonDao.getById((Serializable)lessonId, new String[0]);
            log.debug("Org Teacher lessson params={},{}", (Object)teacherLesson, (Object)orgTeacher);
            Map teacherNameAvatar = Maps.newHashMap();
            if (orgTeacher != null) {
                teacherNameAvatar = this.orgTeacherApiService.getNameAndAvatarByUserIds(orgId, (Collection)Lists.newArrayList((Object[])new Long[]{orgTeacher.getUserId()}));
            }
            TwoTuple tuple = (TwoTuple)teacherNameAvatar.get(orgTeacher.getUserId());
            CommentUserDto teacher = new CommentUserDto(orgTeacher.getUserId(), (String)tuple.getFirst(), (String)tuple.getSecond());
            teacher.setMobile(orgTeacher.getMobile());
            teacherCommentResponse.setTeacher(teacher);
            log.debug("is can edit comment params {},{},{}", new Object[]{orgId, teacherUserId, teacher});
            if (!onlyTeacherAccount) {
                teacherCommentResponse.setEditStatus(Integer.valueOf(1));
            } else if (teacher.getId().longValue() == teacherUserId.longValue()) {
                teacherCommentResponse.setEditStatus(Integer.valueOf(1));
            } else if (hasMasterCourse.contains((long)orgClassLesson.getCourseId())) {
                teacherCommentResponse.setEditStatus(Integer.valueOf(1));
            }
            log.debug("list add newDataResult ={},dto={}", (Object)newDataResult, (Object)teacherCommentResponse);
            newDataResult.add(teacherCommentResponse);
        }
        if (studentListResponse != null) {
            newDataResult.add(studentListResponse);
        }
        if (!hasStudentComment) {
            CommentListResponse studentCommentResponse = new CommentListResponse();
            studentCommentResponse.setSourceType(Integer.valueOf(UserRoleEnum.STUDENT.getCode()));
            CommentUserDto student = new CommentUserDto();
            student.setId(orgStudent.getId());
            student.setName(orgStudent.getName());
            Map studentAvatarMap = this.orgStudentApiService.batchGetStudentAvatarUrl((Collection)Lists.newArrayList((Object[])new OrgStudent[]{orgStudent}));
            student.setAvatarUrl((String)studentAvatarMap.get((long)orgStudent.getId()));
            if (StringUtils.isNotEmpty((CharSequence)orgStudent.getWeixin())) {
                student.setBindWeiXinStatus(Integer.valueOf(1));
            }
            studentCommentResponse.setStudent(student);
            newDataResult.add(studentCommentResponse);
        }
        return newDataResult;
    }

    @Override
    public List<CommentListResponse> commentSearchList(Long orgId, CommentListRequest commentListRequest) {
        log.info("Collent List request = {},{}", (Object)orgId, (Object)commentListRequest);
        List<Long> classIds = this.getClassIdList(orgId, commentListRequest);
        List<Long> lessonIds = this.getLessonIdList(orgId, commentListRequest);
        Set teacherIds = this.orgTeacherLessonDao.getTeacherIdsByLessonIds(orgId, lessonIds);
        Set studentIds = this.orgStudentLessonDao.getStudentIdsByLessonIds(orgId, lessonIds);
        log.debug("student service = {},{},{},{}", new Object[]{orgId, lessonIds, studentIds, teacherIds});
        Map studentMap = this.orgStudentService.getUserIdStudentDtoMap((Collection)studentIds, orgId);
        Map teacherMap = this.teacherService.getOrgTeacherMap(orgId, (Collection)teacherIds);
        ArrayList teacherUserId = Lists.newArrayList((Object[])new Long[]{-1L});
        ArrayList studentUserId = Lists.newArrayList((Object[])new Long[]{-1L});
        for (StudentInfoReponseDto studentInfoReponseDto : studentMap.values()) {
            if (studentInfoReponseDto.getName().indexOf(commentListRequest.getSearchKey()) == -1) continue;
            studentUserId.add(studentInfoReponseDto.getStudentUserId());
        }
        for (OrgTeacherResponseDto teacherResponseDto : teacherMap.values()) {
            if (teacherResponseDto.getTeacherName().indexOf(commentListRequest.getSearchKey()) == -1) continue;
            teacherUserId.add(teacherResponseDto.getUserId());
        }
        List lessonComments = this.orgLessonCommentDao.listSearchComment(orgId, commentListRequest.getCurrentCascadeTeacherUserId(), classIds, lessonIds, (List)teacherUserId, (List)studentUserId, commentListRequest.getSearchKey(), Integer.valueOf(10));
        return this.buildCommentDeailList(orgId, lessonComments, commentListRequest.getSearchKey(), CommentContentType.SEARCH_CONTENT);
    }

    @Override
    public CommentStatic commentListStatic(Long orgId, CommentListRequest commentListRequest) {
        log.info("Collent List request = {},{}", (Object)orgId, (Object)commentListRequest);
        List<Long> classIds = this.getClassIdList(orgId, commentListRequest);
        List<Long> lessonIds = this.getLessonIdList(orgId, commentListRequest);
        Date beginDate = CommentListRequest.getBeginTimeByType((int)commentListRequest.getTimeType());
        Date endDate = CommentListRequest.getEndTimeByType((int)commentListRequest.getTimeType());
        log.info("Collent List request = {},{},{},{},{}", new Object[]{orgId, commentListRequest, lessonIds, beginDate, endDate});
        CommentStatic commentStatic = this.orgLessonCommentDao.listCommentStatic(orgId, classIds, lessonIds, commentListRequest.getTeacherId(), commentListRequest.getCurrentCascadeTeacherUserId(), beginDate, endDate, commentListRequest.getSourceType(), commentListRequest.getScoreType());
        if (commentStatic != null && commentStatic.getAverageScore() != null && commentStatic.getAverageScore() != 0L && commentStatic.getCount() != 0) {
            commentStatic.setAverageScore(Long.valueOf(commentStatic.getAverageScore() / (long)commentStatic.getCount().intValue()));
        }
        return commentStatic;
    }

    @Override
    public CommentStudentResponse lessonStudentList(Long orgId, CommentStudentRequest commentStudentRequest) {
        log.info("lesson student list search = {},{}", (Object)orgId, (Object)commentStudentRequest);
        CommentStudentResponse result = new CommentStudentResponse();
        ArrayList commentStudentDtoList = Lists.newArrayList();
        List lessonUserIds = this.orgStudentLessonDao.getUserIds(commentStudentRequest.getLessonId(), orgId);
        log.debug("Lesson student user id = {}", (Object)lessonUserIds);
        if (CollectionUtils.isNotEmpty((Collection)lessonUserIds)) {
            List studentList = this.orgStudentDao.getStudentByUserIdsAndKey(orgId, (Collection)lessonUserIds, commentStudentRequest.getSearchKey(), new String[0]);
            log.debug("Lesson student list info = {}", (Object)studentList);
            List teacherCommentList = this.orgLessonCommentDao.getLessonTeacherComments(commentStudentRequest.getLessonId(), Boolean.valueOf(false), new String[0]);
            List studentCommentList = this.orgLessonCommentDao.getLessonStudentComments(commentStudentRequest.getLessonId(), Boolean.valueOf(false), new String[0]);
            CommentAudit commentAudit = this.orgLessonCommentDao.starScoreLessonCommentAudit(commentStudentRequest.getLessonId(), orgId, Boolean.valueOf(false));
            log.debug("\u5b66\u751f\u8bc4\u5206\u7edf\u8ba1={}", (Object)commentAudit);
            if (commentAudit != null && commentAudit.getNum() != 0) {
                result.setCount(commentAudit.getNum());
                result.setAverageScore(commentAudit.getTotalScore() / commentAudit.getNum());
            }
            Map teacherCommentMap = CollectorUtil.collectMap((Collection)teacherCommentList, (Function)new Function<OrgLessonComment, Long>(){

                public Long apply(OrgLessonComment orgLessonComment) {
                    return orgLessonComment.getToId();
                }
            });
            Map studentCommentMap = CollectorUtil.collectMap((Collection)studentCommentList, (Function)new Function<OrgLessonComment, Long>(){

                public Long apply(OrgLessonComment orgLessonComment) {
                    return orgLessonComment.getFromId();
                }
            });
            Map studentMap = this.orgStudentDao.getStudentMap((Collection)lessonUserIds, orgId, new String[0]);
            Map studentAvatarUrlMap = this.studentApiService.batchGetStudentAvatarUrl(studentMap.values());
            Map smsMap = this.orgLessonCommentSmsDao.getSendMap(orgId, commentStudentRequest.getLessonId(), (Collection)lessonUserIds, Integer.valueOf(UserRole.STUDENT.getRole()));
            log.debug("Lesson comment sms number is = {}", new Object[]{orgId, commentStudentRequest.getLessonId(), lessonUserIds, smsMap});
            for (OrgStudent orgStudent : studentList) {
                CommentStudentDto commentStudentDto = new CommentStudentDto();
                if (teacherCommentMap.get((long)orgStudent.getUserId()) != null) {
                    commentStudentDto.setTeacherCommentStatus(CommentStatus.HAS_COMMENT.getCode());
                }
                if (studentCommentMap.get((long)orgStudent.getUserId()) != null) {
                    commentStudentDto.setStudentCommentStatus(CommentStatus.HAS_COMMENT.getCode());
                }
                if (smsMap.get((long)orgStudent.getUserId()) != null) {
                    commentStudentDto.setNotifiedCount((Integer)smsMap.get((long)orgStudent.getUserId()));
                }
                log.debug("CommentStudentDto = {},check={},{}", new Object[]{commentStudentDto, commentStudentDto.getStudentCommentStatus().intValue() == CommentStatus.HAS_COMMENT.getCode().intValue() && commentStudentRequest.getType().intValue() == UserCommentType.STUDENT_NOT_COMMENT.getCode().intValue(), commentStudentDto.getTeacherCommentStatus().intValue() == CommentStatus.HAS_COMMENT.getCode().intValue() && commentStudentRequest.getType().intValue() == UserCommentType.TEACHER_NOT_COMMENT.getCode().intValue()});
                if (commentStudentDto.getStudentCommentStatus().intValue() == CommentStatus.HAS_COMMENT.getCode().intValue() && commentStudentRequest.getType().intValue() == UserCommentType.STUDENT_NOT_COMMENT.getCode().intValue() || commentStudentDto.getTeacherCommentStatus().intValue() == CommentStatus.HAS_COMMENT.getCode().intValue() && commentStudentRequest.getType().intValue() == UserCommentType.TEACHER_NOT_COMMENT.getCode().intValue()) continue;
                CommentUserDto student = new CommentUserDto();
                student.setId(orgStudent.getId());
                student.setName(orgStudent.getName());
                student.setAvatarUrl((String)studentAvatarUrlMap.get(orgStudent.getId()));
                if (StringUtils.isNotEmpty((CharSequence)orgStudent.getWeixin())) {
                    student.setBindWeiXinStatus(Integer.valueOf(1));
                }
                commentStudentDto.setStudent(student);
                commentStudentDtoList.add(commentStudentDto);
            }
            result.setStudentNotCommentCount(lessonUserIds.size() - studentCommentMap.keySet().size());
            result.setTeacherNotCommentCount(lessonUserIds.size() - teacherCommentMap.keySet().size());
            result.setCount(lessonUserIds.size());
        }
        result.setStudentList(commentStudentDtoList);
        return result;
    }

    @Override
    @Transactional
    public CommentAddResponse addComment(Long orgId, Long cascadeId, Long lessonId, Long studentId, Integer starScore, String content, List<ImageDto> imageDtos, AudioDto audioDto) {
        OrgAccount orgAccount = (OrgAccount)this.orgAccountDao.getById((Serializable)orgId, new String[]{"mobile", "number"});
        OrgStudent orgStudent = (OrgStudent)this.orgStudentDao.getById((Serializable)studentId, new String[0]);
        Map studentAvatarMap = this.orgStudentApiService.batchGetStudentAvatarUrl((Collection)Lists.newArrayList((Object[])new OrgStudent[]{orgStudent}));
        OrgTeacherLesson teacherLesson = this.orgTeacherLessonDao.getByLessonId(orgId, lessonId);
        BussinessPreconditions.checkArgument((null != teacherLesson ? 1 : 0) != 0, (Object)"\u627e\u4e0d\u5230\u8bfe\u8282\u8001\u5e08");
        OrgTeacher orgTeacher = this.orgTeacherService.getByUserIdIgnorUserStatus(teacherLesson.getTeacherId().longValue());
        BussinessPreconditions.checkArgument((null != orgTeacher ? 1 : 0) != 0, (Object)"\u627e\u4e0d\u5230\u8bfe\u8282\u8001\u5e08");
        Map teacherNameAvatar = this.orgTeacherApiService.getNameAndAvatarByUserIds(orgId, (Collection)Lists.newArrayList((Object[])new Long[]{orgTeacher.getUserId()}));
        CommentAddRequestDto dto = new CommentAddRequestDto();
        dto.setStarScore(starScore);
        dto.setFromId(teacherLesson.getTeacherId());
        dto.setToId(orgStudent.getId());
        dto.setLessonId(lessonId);
        dto.setContent(content);
        dto.setUserRole(Integer.valueOf(UserRole.TEACHER.getRole()));
        if (CollectionUtils.isNotEmpty(imageDtos)) {
            dto.setStorageIds(imageDtos.stream().map(imageDto -> imageDto.getStorageId().toString()).reduce((aLong, aLong2) -> aLong + "," + aLong2).orElse(""));
        }
        if (null != audioDto) {
            dto.setSoundId(audioDto.getStorageId());
            dto.setSoundLength(audioDto.getLength());
        }
        dto.setCustomFastComment("");
        dto.setScore(Double.valueOf(starScore.doubleValue() / 100.0));
        AddCommentReponse reponse = this.lessonCommentService.addComment(dto, orgId, this.environment.getProperty("student_center_comment_detail.url"));
        CommentAddResponse addResponse = new CommentAddResponse();
        addResponse.setCommentId(reponse.getCommentId());
        addResponse.setAudio(audioDto);
        addResponse.setImages(imageDtos);
        addResponse.setContent(content);
        addResponse.setEditStatus(1);
        addResponse.setScore(starScore);
        addResponse.setSourceType(UserRole.TEACHER.getRole());
        CommentUserDto student = new CommentUserDto(orgStudent.getId(), orgStudent.getNotEmptyName(), (String)studentAvatarMap.get(orgStudent.getId()));
        addResponse.setStudent(student);
        TwoTuple tuple = (TwoTuple)teacherNameAvatar.get(orgTeacher.getUserId());
        CommentUserDto teacher = new CommentUserDto(orgTeacher.getUserId(), (String)tuple.getFirst(), (String)tuple.getSecond());
        addResponse.setTeacher(teacher);
        addResponse.setUpdateTime(new Date());
        addResponse.setSharePosterUrl(PropertiesReader.getValue((String)"config", (String)"usercenter.link") + String.format("%s/stu/comment/poster.do?commentId=%s", orgAccount.getNumber(), addResponse.getCommentId()));
        return addResponse;
    }

    @Override
    @Transactional
    public CommentAddResponse updateComment(Long orgId, Long cascadeId, Long commentId, Integer starScore, String content, List<ImageDto> imageDtos, AudioDto audioDto) {
        OrgAccount orgAccount = (OrgAccount)this.orgAccountDao.getById((Serializable)orgId, new String[]{"mobile", "number"});
        OrgLessonComment comment = this.orgLessonCommentDao.getByIdAndOrgId(commentId, orgId);
        BussinessPreconditions.checkArgument((null != comment && comment.getUserRole().intValue() == UserRole.TEACHER.getRole() ? 1 : 0) != 0, (Object)"\u627e\u4e0d\u5230\u8be5\u8bc4\u4ef7");
        OrgStudent orgStudent = this.orgStudentDao.getStudentByUserId(orgId, comment.getToId(), new String[0]);
        Map studentAvatarMap = this.orgStudentApiService.batchGetStudentAvatarUrl((Collection)Lists.newArrayList((Object[])new OrgStudent[]{orgStudent}));
        OrgTeacher orgTeacher = this.orgTeacherService.getByUserIdIgnorUserStatus(comment.getFromId().longValue());
        BussinessPreconditions.checkArgument((null != orgTeacher ? 1 : 0) != 0, (Object)"\u627e\u4e0d\u5230\u8bfe\u8282\u8001\u5e08");
        Map teacherNameAvatar = this.orgTeacherApiService.getNameAndAvatarByUserIds(orgId, (Collection)Lists.newArrayList((Object[])new Long[]{orgTeacher.getUserId()}));
        comment.setStarScore(starScore);
        comment.setScore(starScore);
        comment.setContent(content);
        if (CollectionUtils.isNotEmpty(imageDtos)) {
            comment.setStorageIds(imageDtos.stream().map(imageDto -> imageDto.getStorageId().toString()).reduce((aLong, aLong2) -> aLong + "," + aLong2).orElse(""));
        }
        if (null != audioDto) {
            comment.setSoundId(audioDto.getStorageId());
            comment.setSoundLength(audioDto.getLength());
        }
        comment.setUpdateTime(new Date());
        this.orgLessonCommentDao.update((Object)comment, new String[0]);
        CommentAddResponse addResponse = new CommentAddResponse();
        addResponse.setCommentId(comment.getId());
        addResponse.setAudio(audioDto);
        addResponse.setImages(imageDtos);
        addResponse.setContent(content);
        addResponse.setEditStatus(1);
        addResponse.setScore(starScore);
        addResponse.setSourceType(UserRole.TEACHER.getRole());
        CommentUserDto student = new CommentUserDto(orgStudent.getId(), orgStudent.getNotEmptyName(), (String)studentAvatarMap.get(orgStudent.getId()));
        addResponse.setStudent(student);
        TwoTuple tuple = (TwoTuple)teacherNameAvatar.get(orgTeacher.getUserId());
        CommentUserDto teacher = new CommentUserDto(orgTeacher.getUserId(), (String)tuple.getFirst(), (String)tuple.getSecond());
        addResponse.setTeacher(teacher);
        addResponse.setUpdateTime(new Date());
        addResponse.setSharePosterUrl(PropertiesReader.getValue((String)"config", (String)"usercenter.link") + String.format("%s/stu/comment/poster.do?commentId=%s", orgAccount.getNumber(), addResponse.getCommentId()));
        return addResponse;
    }
}

