/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.biz.erp.service.impl;

import com.baijia.tianxiao.biz.erp.constant.CourseSignStatus;
import com.baijia.tianxiao.biz.erp.constant.StudentStatus;
import com.baijia.tianxiao.biz.erp.dto.LessonTime;
import com.baijia.tianxiao.biz.erp.dto.request.AddCourseLessonRequestDto;
import com.baijia.tianxiao.biz.erp.dto.request.AddCourseLessonRequestDtoForPC;
import com.baijia.tianxiao.biz.erp.dto.request.EditLessonRequestDto;
import com.baijia.tianxiao.biz.erp.dto.request.FastSignInLessonEditRequestDto;
import com.baijia.tianxiao.biz.erp.dto.request.FastSignInLessonsEditRequestDto;
import com.baijia.tianxiao.biz.erp.dto.request.ListLessonsRequestDto;
import com.baijia.tianxiao.biz.erp.dto.response.H5LessonResponseDto;
import com.baijia.tianxiao.biz.erp.dto.response.LessonCalendarResponse;
import com.baijia.tianxiao.biz.erp.dto.response.LessonConflictCheckListDto;
import com.baijia.tianxiao.biz.erp.dto.response.LessonConflictInfoDto;
import com.baijia.tianxiao.biz.erp.dto.response.LessonResponseDto;
import com.baijia.tianxiao.biz.erp.dto.response.LessonTimeTableResponseDto;
import com.baijia.tianxiao.biz.erp.dto.response.ListLessonResponseDto;
import com.baijia.tianxiao.biz.erp.dto.response.StudentCenterLessonDetailDto;
import com.baijia.tianxiao.biz.erp.dto.response.exportCourse.DayScheduleDto;
import com.baijia.tianxiao.biz.erp.dto.response.exportCourse.LessonScheduleDto;
import com.baijia.tianxiao.biz.erp.dto.response.schedule.ConflictInfoDto;
import com.baijia.tianxiao.biz.erp.dto.response.schedule.LessonBaseInfoDto;
import com.baijia.tianxiao.biz.erp.dto.response.schedule.LessonScheduleInfoDto;
import com.baijia.tianxiao.biz.erp.dto.response.schedule.NameAndIdDto;
import com.baijia.tianxiao.biz.erp.enums.BatchOperateType;
import com.baijia.tianxiao.biz.erp.service.CourseLessonService;
import com.baijia.tianxiao.biz.erp.teacherCenter.service.ExcelCourseExportService;
import com.baijia.tianxiao.consants.DataStatus;
import com.baijia.tianxiao.consants.UserRole;
import com.baijia.tianxiao.constant.LessonStatus;
import com.baijia.tianxiao.constant.SignStatus;
import com.baijia.tianxiao.constants.TianXiaoConstant;
import com.baijia.tianxiao.constants.UserRoleEnum;
import com.baijia.tianxiao.constants.org.BizConf;
import com.baijia.tianxiao.dal.comment.constant.CommentStatus;
import com.baijia.tianxiao.dal.comment.dao.OrgLessonCommentDao;
import com.baijia.tianxiao.dal.enums.CourseTypeEnum;
import com.baijia.tianxiao.dal.org.constant.DeleteStatus;
import com.baijia.tianxiao.dal.org.dao.OrgAccountDao;
import com.baijia.tianxiao.dal.org.dao.OrgClassLessonDao;
import com.baijia.tianxiao.dal.org.dao.OrgClassRoomDao;
import com.baijia.tianxiao.dal.org.dao.OrgCourseDao;
import com.baijia.tianxiao.dal.org.dao.OrgCourseTeacherDao;
import com.baijia.tianxiao.dal.org.dao.OrgInfoDao;
import com.baijia.tianxiao.dal.org.dao.OrgLessonConflictDao;
import com.baijia.tianxiao.dal.org.dao.OrgLessonSignDao;
import com.baijia.tianxiao.dal.org.dao.OrgStudentCourseDao;
import com.baijia.tianxiao.dal.org.dao.OrgStudentDao;
import com.baijia.tianxiao.dal.org.dao.OrgStudentLessonDao;
import com.baijia.tianxiao.dal.org.dao.OrgTeacherLessonDao;
import com.baijia.tianxiao.dal.org.dao.TXCascadeAccountDao;
import com.baijia.tianxiao.dal.org.dto.DropDownListRequestDto;
import com.baijia.tianxiao.dal.org.dto.TimeTableRequestDto;
import com.baijia.tianxiao.dal.org.po.OrgAccount;
import com.baijia.tianxiao.dal.org.po.OrgClassLesson;
import com.baijia.tianxiao.dal.org.po.OrgClassRoom;
import com.baijia.tianxiao.dal.org.po.OrgCourse;
import com.baijia.tianxiao.dal.org.po.OrgCourseTeacher;
import com.baijia.tianxiao.dal.org.po.OrgLessonConflict;
import com.baijia.tianxiao.dal.org.po.OrgLessonSign;
import com.baijia.tianxiao.dal.org.po.OrgStudent;
import com.baijia.tianxiao.dal.org.po.OrgStudentCourse;
import com.baijia.tianxiao.dal.org.po.OrgStudentLesson;
import com.baijia.tianxiao.dal.org.po.OrgTeacherLesson;
import com.baijia.tianxiao.dal.org.po.TXCascadeAccount;
import com.baijia.tianxiao.dal.solr.dto.TimeRange;
import com.baijia.tianxiao.dal.user.dao.TeacherDao;
import com.baijia.tianxiao.dal.user.po.Teacher;
import com.baijia.tianxiao.dto.UniverseErrorCode;
import com.baijia.tianxiao.dto.smstoken.StudentSmsTokenDto;
import com.baijia.tianxiao.enums.CommonErrorCode;
import com.baijia.tianxiao.enums.DropdownListType;
import com.baijia.tianxiao.enums.PermissionType;
import com.baijia.tianxiao.excel.dto.ExportField;
import com.baijia.tianxiao.exception.BussinessException;
import com.baijia.tianxiao.filter.TianxiaoMContext;
import com.baijia.tianxiao.filter.TianxiaoPCContext;
import com.baijia.tianxiao.sal.comment.constant.CommentErrorCode;
import com.baijia.tianxiao.sal.comment.service.LessonCommentService;
import com.baijia.tianxiao.sal.common.api.OrgTeacherApiService;
import com.baijia.tianxiao.sal.course.constant.ArrangeStatus;
import com.baijia.tianxiao.sal.course.dto.HeaderDto;
import com.baijia.tianxiao.sal.course.dto.request.LessonConflictCheckDto;
import com.baijia.tianxiao.sal.course.dto.response.OrgStudentsChooseListDto;
import com.baijia.tianxiao.sal.course.dto.response.TeacherResponseDto;
import com.baijia.tianxiao.sal.course.enums.LessonConflictEnum;
import com.baijia.tianxiao.sal.course.service.CourseStudentService;
import com.baijia.tianxiao.sal.course.service.CourseTeacherService;
import com.baijia.tianxiao.sal.course.service.OrgCourseListService;
import com.baijia.tianxiao.sal.course.service.OrgLessonConflictService;
import com.baijia.tianxiao.sal.course.service.OrgSignupCourseLessonService;
import com.baijia.tianxiao.sal.elastic.service.FilterSoftDelTeacherService;
import com.baijia.tianxiao.sal.organization.constant.CascadeType;
import com.baijia.tianxiao.sal.organization.constant.DeviceType;
import com.baijia.tianxiao.sal.organization.constant.TXPermissionConst;
import com.baijia.tianxiao.sal.organization.org.service.TxAccountPermissionService;
import com.baijia.tianxiao.sal.room.dto.ClassRoomDto;
import com.baijia.tianxiao.sal.room.service.ClassRoomService;
import com.baijia.tianxiao.sal.teacher.api.OrgTeacherService;
import com.baijia.tianxiao.sqlbuilder.dto.PageDto;
import com.baijia.tianxiao.util.BaseUtils;
import com.baijia.tianxiao.util.CollectionHelper;
import com.baijia.tianxiao.util.TwoTuple;
import com.baijia.tianxiao.util.collection.CollectorUtil;
import com.baijia.tianxiao.util.date.DateUtil;
import com.baijia.tianxiao.util.date.TimeStamp;
import com.baijia.tianxiao.util.json.JacksonUtil;
import com.fasterxml.jackson.core.type.TypeReference;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import lombok.NonNull;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.collections.Transformer;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class CourseLessonServiceImpl
implements CourseLessonService {
    private static final Logger log = LoggerFactory.getLogger(CourseLessonServiceImpl.class);
    private static final String DEFAULT_ROOM_OR_TEACHER_NAME = "\u672a\u8bbe\u7f6e";
    @Resource
    private OrgClassLessonDao orgClassLessonDao;
    @Resource
    private OrgTeacherLessonDao orgTeacherLessonDao;
    @Resource
    private OrgStudentLessonDao orgStudentLessonDao;
    @Resource
    private OrgLessonSignDao orgLessonSignDao;
    @Resource
    private OrgCourseDao orgCourseDao;
    @Resource
    private OrgStudentDao orgStudentDao;
    @Resource
    private TeacherDao teacherDao;
    @Resource
    private OrgClassRoomDao orgClassRoomDao;
    @Resource
    private OrgLessonCommentDao orgLessonCommentDao;
    @Resource
    private OrgCourseListService orgCourseListService;
    @Resource
    private CourseStudentService courseStudentService;
    @Resource
    private CourseTeacherService courseTeacherService;
    @Resource
    private ClassRoomService classRoomService;
    @Resource
    private OrgInfoDao orgInfoDao;
    @Resource
    private OrgStudentCourseDao orgStudentCourseDao;
    @Autowired
    private TXCascadeAccountDao txCascadeAccountDao;
    @Autowired
    private OrgAccountDao orgAccountDao;
    @Resource
    private OrgCourseTeacherDao orgCourseTeacherDao;
    @Resource
    private OrgLessonConflictService orgLessonConflictService;
    @Resource
    private OrgLessonConflictDao orgLessonConflictDao;
    @Resource
    private TXCascadeAccountDao cascadeAccountDao;
    @Resource
    private OrgSignupCourseLessonService signupCourseLessonService;
    @Autowired
    private TxAccountPermissionService permissionService;
    @Autowired
    private FilterSoftDelTeacherService filterSoftDelTeacherService;
    @Autowired
    private OrgCourseTeacherDao courseTeacherDao;
    @Autowired
    private OrgTeacherService teacherService;
    @Autowired
    private LessonCommentService lessonCommentService;
    @Autowired
    private OrgTeacherApiService orgTeacherApiService;

    @Override
    @Transactional(readOnly=true)
    public LessonCalendarResponse getLessonCalendar(@NonNull Long orgId, @NonNull Date startDate, @NonNull Date endDate, Long teacherId, Long roomId, Integer courseType) {
        if (orgId == null) {
            throw new NullPointerException("orgId");
        }
        if (startDate == null) {
            throw new NullPointerException("startDate");
        }
        if (endDate == null) {
            throw new NullPointerException("endDate");
        }
        LessonCalendarResponse result = this.buildEmptyCalendarByTimeRange(startDate, endDate);
        log.info("the calendar map is:{}", (Object)result);
        Map<Object, Object> lessonTeacherMap = Maps.newHashMap();
        if (teacherId != null && teacherId > 0L && ((lessonTeacherMap = this.queryLessonIdByTeacherId(orgId, Arrays.asList(teacherId))) == null || lessonTeacherMap.isEmpty())) {
            return result;
        }
        List lessons = this.orgClassLessonDao.getLessonDates(orgId, lessonTeacherMap.keySet(), roomId, startDate, endDate, new String[0]);
        HashSet courseIds = Sets.newHashSet();
        for (OrgClassLesson lesson : lessons) {
            courseIds.add(lesson.getCourseId());
        }
        List courseList = this.orgCourseDao.getByIds((Collection)courseIds, new String[]{"id", "status", "courseType", "isDel"});
        HashMap<Long, OrgCourse> courseMap = new HashMap<Long, OrgCourse>();
        for (OrgCourse course : courseList) {
            courseMap.put(course.getId(), course);
        }
        LinkedHashSet dateStrs = Sets.newLinkedHashSet();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        for (OrgClassLesson lesson : lessons) {
            OrgCourse course = (OrgCourse)courseMap.get(lesson.getCourseId());
            if (course.getIsDel().intValue() == DeleteStatus.DELETED.getValue()) continue;
            if (courseType != null) {
                if (courseType != course.getCourseType()) continue;
                dateStrs.add(sdf.format(lesson.getStartTime()));
                continue;
            }
            dateStrs.add(sdf.format(lesson.getStartTime()));
        }
        this.buildCalendarMap(result, dateStrs);
        return result;
    }

    private void buildCalendarMap(LessonCalendarResponse calendar, Collection<String> dateStrs) {
        Integer year = null;
        Integer month = null;
        Integer day = null;
        Map<Integer, Map<Integer, List<Integer>>> calendarMap = calendar.getCalendarMap();
        for (String dateStr : dateStrs) {
            String[] ymd = dateStr.split("-");
            year = Integer.valueOf(ymd[0].trim());
            month = Integer.valueOf(ymd[1].trim());
            day = Integer.valueOf(ymd[2].trim());
            Map<Integer, List<Integer>> monthMap = calendarMap.get(year);
            if (monthMap.containsKey(month)) {
                monthMap.get(month).add(day);
                continue;
            }
            monthMap.put(month, Lists.newArrayList((Object[])new Integer[]{day}));
        }
    }

    private LessonCalendarResponse buildEmptyCalendarByTimeRange(Date startDate, Date endDate) {
        LessonCalendarResponse calendar = new LessonCalendarResponse();
        calendar.setCalendarMap(Maps.newTreeMap());
        int startYear = new DateTime((Object)startDate).getYear();
        int endYear = new DateTime(endDate.getTime() - 1L).getYear();
        Integer i = startYear;
        while (i <= endYear) {
            calendar.getCalendarMap().put(i, Maps.newTreeMap());
            Integer n = i;
            Integer n2 = i = Integer.valueOf(i + 1);
        }
        return calendar;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void addClassLessons(Long orgId, Date startDay, Date endDay, AddCourseLessonRequestDto dto) {
        AddCourseLessonRequestDtoForPC dtoForPC = new AddCourseLessonRequestDtoForPC();
        try {
            BeanUtils.copyProperties((Object)dtoForPC, (Object)dto);
            if (CollectionUtils.isNotEmpty(dto.getStudentIds())) {
                dtoForPC.setStudentIds(StringUtils.join((Object[])dto.getStudentIds().toArray(), (String)","));
            }
            dtoForPC.setRepeatUnit(dto.getRepeatUnit().getCode());
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        this.addClassLessonsForPC(orgId, startDay, endDay, dtoForPC);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void addClassLessonsForPC(Long orgId, Date startDay, Date endDay, AddCourseLessonRequestDtoForPC dto) {
        Preconditions.checkArgument((orgId != null && orgId > 0L ? 1 : 0) != 0, (Object)"orgId is illegal");
        Preconditions.checkArgument((startDay != null ? 1 : 0) != 0, (Object)"start day can not be null");
        Preconditions.checkArgument((dto != null ? 1 : 0) != 0, (Object)"class lessons param is illegal");
        Preconditions.checkArgument((dto.getCourseId() != null && dto.getCourseId() > 0L ? 1 : 0) != 0, (Object)"courseId is illegal");
        Preconditions.checkArgument((dto.getLessonName() != null && dto.getLessonName().length() < 21 ? 1 : 0) != 0, (Object)"the lesson name is null or too long");
        OrgCourse orgCourse = this.orgCourseDao.getByCourseId(dto.getCourseId(), new String[0]);
        if (orgCourse.getCourseType() == CourseTypeEnum.COURSE_TYPE_1v1.getCode() && orgCourse.getIsClass() == CourseTypeEnum.IS_CLASS_FALSE.getCode()) {
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u5f53\u524d\u7248\u672c\u4e0d\u652f\u6301\uff0c\u8bf7\u5347\u7ea7\u65b0\u7248\u672c");
        }
        List<Calendar> calens = dto.getRepeatUnit().getAvaliableDays(startDay, dto.getRepeatCount(), dto.getRepeatRange(), dto.getWeekDays(), dto.getCalendarDays());
        TimeStamp startTime = TimeStamp.parse((String)dto.getStartTime());
        TimeStamp endTime = TimeStamp.parse((String)dto.getEndTime());
        OrgClassLesson lesson = null;
        ArrayList lessons = Lists.newArrayList();
        ArrayList lessonConflicts = Lists.newArrayList();
        int index = 1;
        for (Calendar cal : calens) {
            LessonTime lessonTime = new LessonTime(cal, startTime, endTime);
            lesson = new OrgClassLesson();
            lesson.setStartTime(lessonTime.getStartTime());
            lesson.setEndTime(lessonTime.getEndTime());
            lesson.setCourseId(dto.getCourseId());
            lesson.setCreateTime(new Date());
            lesson.setDelStatus(Integer.valueOf(DataStatus.NORMAL.getValue()));
            lesson.setLayoutId(Long.valueOf(0L));
            lesson.setRoomId(Long.valueOf(dto.getRoomId() != null ? dto.getRoomId() : 0L));
            lesson.setUpdateTime(new Date());
            lesson.setNumber(Integer.valueOf(index));
            lesson.setName(dto.getLessonName());
            lesson.setOrgId(orgId);
            lessons.add(lesson);
            ++index;
        }
        log.info("save {} lessons into db,params:{}", (Object)lessons.size(), (Object)dto);
        this.orgClassLessonDao.saveAll((List)lessons, new String[]{"startTime", "endTime", "courseId", "createTime", "delStatus", "layoutId", "roomId", "updateTime", "orgId", "name"});
        if (orgCourse.getArrangeLesson().intValue() == ArrangeStatus.UNARRANGE.getCode()) {
            orgCourse.setArrangeLesson(Integer.valueOf(ArrangeStatus.ARRANGEED.getCode()));
            this.orgCourseDao.update((Object)orgCourse, new String[]{"arrangeLesson"});
        }
        HashSet roomIds = Sets.newHashSet();
        roomIds.add(dto.getRoomId() != null ? dto.getRoomId() : 0L);
        this.classRoomService.addClassRoomCourse(Long.valueOf(orgId), dto.getCourseId(), (Collection)roomIds);
        this.resetLessonNumber(orgId, dto.getCourseId());
        for (OrgClassLesson classLesson : lessons) {
            this.courseStudentService.addStudentToLesson(orgId, classLesson.getCourseId(), classLesson.getId(), dto.getStudentIds(), true);
            HashSet teacherIds = Sets.newHashSet();
            HashSet tempTeacherIds = Sets.newHashSet();
            if (dto.getTeacherId() != null && dto.getTeacherId() > 0L) {
                teacherIds.add(dto.getTeacherId());
                tempTeacherIds.addAll(teacherIds);
                this.courseTeacherService.addTeacherToCourse(orgId, classLesson.getCourseId(), (Collection)teacherIds);
                this.courseTeacherService.addTeacherToLesson(orgId, classLesson.getCourseId(), classLesson.getId(), (Collection)tempTeacherIds);
            }
            OrgLessonConflict conflict = new OrgLessonConflict();
            conflict.setLessonId(classLesson.getId());
            conflict.setOrgId(orgId);
            conflict.setRoomId(Long.valueOf(classLesson.getRoomId() == null ? 0L : classLesson.getRoomId()));
            conflict.setStartTime(classLesson.getStartTime());
            conflict.setEndTime(classLesson.getEndTime());
            if (tempTeacherIds.size() > 1) {
                int i = 1;
                Iterator teacherIt = tempTeacherIds.iterator();
                while (teacherIt.hasNext()) {
                    if (i > 1) {
                        try {
                            OrgLessonConflict cloneConflict = (OrgLessonConflict)BeanUtils.cloneBean((Object)conflict);
                            cloneConflict.setTeacherId((Long)teacherIt.next());
                            lessonConflicts.add(cloneConflict);
                        }
                        catch (Exception e) {
                            throw new RuntimeException("clone bean error:", e);
                        }
                    } else {
                        conflict.setTeacherId((Long)teacherIt.next());
                        lessonConflicts.add(conflict);
                    }
                    ++i;
                }
                continue;
            }
            conflict.setTeacherId(Long.valueOf(dto.getTeacherId() == null ? 0L : dto.getTeacherId()));
            lessonConflicts.add(conflict);
        }
        this.orgLessonConflictService.saveOrgLessonConflicts((List)lessonConflicts);
    }

    @Override
    @Transactional(readOnly=true)
    public ListLessonResponseDto listLessons(Long orgId, ListLessonsRequestDto params, boolean includeDelCourse) {
        Preconditions.checkArgument((orgId != null && orgId > 0L ? 1 : 0) != 0, (Object)"orgId is illegal");
        HashSet courseIds = Sets.newHashSet();
        HashSet roomIds = Sets.newHashSet();
        HashSet lessonIds = Sets.newHashSet();
        List<OrgClassLesson> lessons = this.queryLesson(orgId, null, params, true, includeDelCourse);
        ListLessonResponseDto result = new ListLessonResponseDto();
        if (CollectionUtils.isNotEmpty(lessons)) {
            Collections.sort(lessons, new Comparator<OrgClassLesson>(){

                @Override
                public int compare(OrgClassLesson o1, OrgClassLesson o2) {
                    return o1.getNumber().compareTo(o2.getNumber());
                }
            });
            for (OrgClassLesson lesson : lessons) {
                courseIds.add(lesson.getCourseId());
                roomIds.add(lesson.getRoomId());
                lessonIds.add(lesson.getId());
            }
            Map<Object, Object> courseMap = Maps.newHashMap();
            courseMap = this.getOrgCourseMap(orgId, courseIds);
            HashMap lessonIdTeacherNameMap = Maps.newHashMap();
            if (params.isNeedTeacherName()) {
                Map lessonIdTeacherIdMap = this.orgTeacherLessonDao.queryLessonTeacherIdMap(orgId, (Collection)lessonIds);
                Map teacherNameAvatarMap = this.orgTeacherApiService.getNameAndAvatarByUserIds(orgId, lessonIdTeacherIdMap.values());
                for (Long lessonId : lessonIdTeacherIdMap.keySet()) {
                    lessonIdTeacherNameMap.put(lessonId, teacherNameAvatarMap.get(lessonIdTeacherIdMap.get(lessonId)));
                }
            }
            log.debug("lessonIdTeacherNameMap = {}", (Object)lessonIdTeacherNameMap);
            Map<Object, Object> classRoomMap = Maps.newHashMap();
            if (params.isNeedRoomName()) {
                classRoomMap = this.getOrgClassRoomMap(roomIds);
            }
            Map studentCountMap = this.orgStudentLessonDao.queryLessonStudentCountMap(orgId, (Collection)lessonIds);
            Map signedStudentCountMap = Maps.newHashMap();
            Map allSignStudentCountMap = Maps.newHashMap();
            if (!params.isNeedStudentSignStatus() && params.isNeedSignInfo()) {
                signedStudentCountMap = this.orgLessonSignDao.querySignedLessonStudentCountMap(orgId, (Collection)lessonIds);
                allSignStudentCountMap = this.orgLessonSignDao.querySignLessonStudentCountMap(orgId, (Collection)lessonIds);
            }
            Map commentCount = Maps.newHashMap();
            Map teacherCommentCount = Maps.newHashMap();
            Map lessonSignStatus = Maps.newHashMap();
            if (params.isNeedStudentSignStatus()) {
                Preconditions.checkArgument((params.getStudentId() != null && params.getStudentId() > 0L ? 1 : 0) != 0, (Object)"\u5b66\u751fID\u4e0d\u6b63\u786e");
                Long userId = this.orgStudentDao.getUserId(params.getStudentId());
                List lessonSign = this.orgLessonSignDao.getStudentSign(orgId, userId, Integer.valueOf(UserRole.STUDENT.getRole()), (Collection)lessonIds, new String[]{"lessonId", "status"});
                if (CollectionUtils.isNotEmpty((Collection)lessonSign)) {
                    lessonSignStatus = CollectorUtil.collectMap((Collection)lessonSign, (Function)new Function<OrgLessonSign, Long>(){

                        public Long apply(OrgLessonSign input) {
                            return input.getLessonId();
                        }
                    }, (Function)new Function<OrgLessonSign, Integer>(){

                        public Integer apply(OrgLessonSign input) {
                            return input.getStatus();
                        }
                    });
                    log.debug("student lesson sign:{}", (Object)lessonSignStatus);
                }
                commentCount = this.orgLessonCommentDao.getLessonCommentCountMap((Collection)lessonIds, orgId, userId, null, Integer.valueOf(UserRole.STUDENT.getRole()), Boolean.valueOf(false));
                teacherCommentCount = this.orgLessonCommentDao.getLessonCommentCountMap((Collection)lessonIds, orgId, null, userId, Integer.valueOf(UserRole.TEACHER.getRole()), Boolean.valueOf(false));
            }
            result = this.buildListLessonResponseDto(lessons, courseMap, lessonIdTeacherNameMap, classRoomMap, studentCountMap, allSignStudentCountMap, signedStudentCountMap, commentCount, teacherCommentCount, lessonSignStatus);
            int lastRow = result.getList().size() - 1;
            Date now = new Date();
            if (lastRow >= 0) {
                result.setNewLessonId(result.getList().get(lastRow).getLessonId());
                for (LessonResponseDto lesson : result.getList()) {
                    if (!now.before(lesson.getLessonEndTime())) continue;
                    result.setNewLessonId(lesson.getLessonId());
                    break;
                }
            }
        } else {
            result.setFirstLessonStartTime(params.getFirstLessonStartTime());
            result.setLastLessonStartTime(params.getLastLessonStartTime());
            if (params.getFirstLessonStartTime() == null && params.getLastLessonStartTime() == null) {
                result.setFirstLessonStartTime(DateUtil.getCurrentDate());
            }
        }
        return result;
    }

    @Override
    @Transactional(readOnly=true)
    public ListLessonResponseDto listSignInLessons(Long orgId, ListLessonsRequestDto params) {
        Preconditions.checkArgument((orgId != null && orgId > 0L ? 1 : 0) != 0, (Object)"orgId is illegal");
        HashSet courseIds = Sets.newHashSet();
        HashSet roomIds = Sets.newHashSet();
        HashSet lessonIds = Sets.newHashSet();
        List<OrgClassLesson> lessons = this.querySignInLesson(orgId, null, params, true);
        ListLessonResponseDto result = new ListLessonResponseDto();
        if (CollectionUtils.isNotEmpty(lessons)) {
            Collections.sort(lessons, new Comparator<OrgClassLesson>(){

                @Override
                public int compare(OrgClassLesson o1, OrgClassLesson o2) {
                    return o1.getNumber().compareTo(o2.getNumber());
                }
            });
            for (OrgClassLesson lesson : lessons) {
                courseIds.add(lesson.getCourseId());
                roomIds.add(lesson.getRoomId());
                lessonIds.add(lesson.getId());
            }
            Map<Object, Object> courseMap = Maps.newHashMap();
            courseMap = this.getOrgCourseMap(orgId, courseIds);
            HashMap lessonIdTeacherNameMap = Maps.newHashMap();
            if (params.isNeedTeacherName()) {
                Map lessonIdTeacherIdMap = this.orgTeacherLessonDao.queryLessonTeacherIdMap(orgId, (Collection)lessonIds);
                Map teacherNameAvatarMap = this.orgTeacherApiService.getNameAndAvatarByUserIds(orgId, lessonIdTeacherIdMap.values());
                for (Long lessonId : lessonIdTeacherIdMap.keySet()) {
                    lessonIdTeacherNameMap.put(lessonId, teacherNameAvatarMap.get(lessonIdTeacherIdMap.get(lessonId)));
                }
            }
            log.debug("lessonIdTeacherNameMap = {}", (Object)lessonIdTeacherNameMap);
            Map<Object, Object> classRoomMap = Maps.newHashMap();
            if (params.isNeedRoomName()) {
                classRoomMap = this.getOrgClassRoomMap(roomIds);
            }
            Map studentCountMap = this.orgStudentLessonDao.queryLessonStudentCountMap(orgId, (Collection)lessonIds);
            Map signStudentCountMap = Maps.newHashMap();
            Map signedStudentCountMap = Maps.newHashMap();
            if (!params.isNeedStudentSignStatus() && params.isNeedSignInfo()) {
                signStudentCountMap = this.orgLessonSignDao.querySignLessonStudentCountMap(orgId, (Collection)lessonIds);
                signedStudentCountMap = this.orgLessonSignDao.querySignedLessonStudentCountMap(orgId, (Collection)lessonIds);
            }
            Map commentCount = Maps.newHashMap();
            Map teacherCommentCount = Maps.newHashMap();
            Map lessonSignStatus = Maps.newHashMap();
            if (params.isNeedStudentSignStatus()) {
                Preconditions.checkArgument((params.getStudentId() != null && params.getStudentId() > 0L ? 1 : 0) != 0, (Object)"\u5b66\u751fID\u4e0d\u6b63\u786e");
                Long userId = this.orgStudentDao.getUserId(params.getStudentId());
                commentCount = this.orgLessonCommentDao.getLessonCommentCountMap((Collection)lessonIds, orgId, userId, null, Integer.valueOf(UserRole.STUDENT.getRole()), Boolean.valueOf(false));
                teacherCommentCount = this.orgLessonCommentDao.getLessonCommentCountMap((Collection)lessonIds, orgId, null, userId, Integer.valueOf(UserRole.TEACHER.getRole()), Boolean.valueOf(false));
                List lessonSign = this.orgLessonSignDao.getStudentSign(orgId, userId, Integer.valueOf(UserRole.STUDENT.getRole()), (Collection)lessonIds, new String[]{"lessonId", "status"});
                if (CollectionUtils.isNotEmpty((Collection)lessonSign)) {
                    lessonSignStatus = CollectorUtil.collectMap((Collection)lessonSign, (Function)new Function<OrgLessonSign, Long>(){

                        public Long apply(OrgLessonSign input) {
                            return input.getLessonId();
                        }
                    }, (Function)new Function<OrgLessonSign, Integer>(){

                        public Integer apply(OrgLessonSign input) {
                            return input.getStatus();
                        }
                    });
                    log.debug("student lesson sign:{}", (Object)lessonSignStatus);
                }
            }
            result = this.buildListLessonResponseDto(lessons, courseMap, lessonIdTeacherNameMap, classRoomMap, studentCountMap, signStudentCountMap, signedStudentCountMap, commentCount, teacherCommentCount, lessonSignStatus);
        } else {
            result.setFirstLessonStartTime(params.getFirstLessonStartTime());
            result.setLastLessonStartTime(params.getLastLessonStartTime());
            if (params.getFirstLessonStartTime() == null && params.getLastLessonStartTime() == null) {
                result.setFirstLessonStartTime(DateUtil.getCurrentDate());
            }
        }
        return result;
    }

    private Map<Long, String> getLessonIdTeacherName(Long orgId, Collection<Long> lessonIds, Map<Long, Long> lessonTeacherIdMap) {
        long l = System.currentTimeMillis();
        if (MapUtils.isEmpty(lessonTeacherIdMap)) {
            lessonTeacherIdMap = this.orgTeacherLessonDao.queryLessonTeacherIdMap(orgId, lessonIds);
        }
        Map teacherNameMap = this.teacherDao.getTeacherRealNameMap(lessonTeacherIdMap.values());
        HashMap<Long, String> lessonIdTeacherNameMap = new HashMap<Long, String>(lessonTeacherIdMap.size());
        for (Long lessonId : lessonTeacherIdMap.keySet()) {
            String name = (String)teacherNameMap.get(lessonTeacherIdMap.get(lessonId));
            if (name == null) continue;
            lessonIdTeacherNameMap.put(lessonId, name);
        }
        return lessonIdTeacherNameMap;
    }

    private List<OrgClassLesson> queryLesson(Long orgId, Map<Long, Long> lessonIdTeacherIdMap, ListLessonsRequestDto params, boolean isTimeTable, boolean includeDelCourse) {
        log.debug("Query class lesson not master = {},{},{}", new Object[]{orgId, lessonIdTeacherIdMap, params, includeDelCourse});
        Preconditions.checkArgument((orgId != null && orgId > 0L ? 1 : 0) != 0, (Object)"orgId is illegal");
        HashSet courseIds = Sets.newHashSet();
        HashSet roomIds = Sets.newHashSet();
        HashSet teacherIds = Sets.newHashSet();
        HashSet lessonIds = Sets.newHashSet();
        if (params.getCourseId() != null) {
            courseIds.add(params.getCourseId());
        }
        if (TianxiaoMContext.getTXCascadeId() != null && isTimeTable) {
            TXCascadeAccount txCascadeAccount = (TXCascadeAccount)this.txCascadeAccountDao.getById((Serializable)TianxiaoMContext.getTXCascadeId(), new String[0]);
            if (txCascadeAccount == null) {
                throw new BussinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u5b50\u5e10\u53f7\u4e0d\u5b58\u5728");
            }
            if (txCascadeAccount.getAccountType().intValue() == CascadeType.STAFF.getValue()) {
                this.handleStaffCourseIds(orgId, TianxiaoMContext.getTXCascadeId(), courseIds);
                if (CollectionUtils.isEmpty((Collection)courseIds)) {
                    return Collections.EMPTY_LIST;
                }
            }
        }
        if (params.getRoomId() != null) {
            roomIds.add(params.getRoomId());
        }
        if (params.getTeacherId() != null) {
            teacherIds.add(params.getTeacherId());
        }
        if (params.getStudentId() != null) {
            lessonIds.addAll(this.courseStudentService.getStudentLessonIds(orgId, params.getStudentId()));
            if (CollectionUtils.isEmpty((Collection)lessonIds)) {
                return Collections.emptyList();
            }
        }
        lessonIdTeacherIdMap = this.queryLessonIdByTeacherId(orgId, teacherIds);
        if (CollectionUtils.isNotEmpty((Collection)teacherIds) && lessonIdTeacherIdMap.isEmpty()) {
            return Collections.emptyList();
        }
        lessonIds.addAll(lessonIdTeacherIdMap.keySet());
        Date startTime = params.getStartTime();
        Date endTime = params.getEndTime();
        if (isTimeTable) {
            startTime = params.getFirstLessonStartTime();
            endTime = params.getLastLessonStartTime();
        }
        List notInCourseIds = Lists.transform((List)this.orgCourseDao.getCoursesByOrgNumber(Long.valueOf(((OrgAccount)this.orgAccountDao.getById((Serializable)orgId, new String[]{"number"})).getNumber().longValue()), Integer.valueOf(DeleteStatus.DELETED.getValue()), new String[]{"id", "courseType"}), (Function)new Function<OrgCourse, Long>(){

            public Long apply(OrgCourse input) {
                return input.getId();
            }
        });
        log.debug("Query class lesson not master = {},{},{},{},{},{},{},{}", new Object[]{orgId, notInCourseIds, courseIds, roomIds, lessonIds, startTime, endTime, params});
        List lessons = this.orgClassLessonDao.queryLessons((Collection)notInCourseIds, orgId, (Collection)courseIds, (Collection)roomIds, (Collection)lessonIds, startTime, endTime, params.getPageDto(), null, new String[0]);
        return lessons;
    }

    @Override
    @Transactional(readOnly=true)
    public void handleStaffCourseIds(Long orgId, Integer cascadeId, Set<Long> courseIds) {
        HashSet courseIdSet = new HashSet();
        List tmpIds = this.orgCourseDao.getCourseIdsByCascadeId(cascadeId, null, CourseTypeEnum.IS_CLASS_TRUE.getCode(), null);
        courseIdSet.addAll(tmpIds);
        Long teacherId = this.teacherService.getUserIdByCascadeId(orgId, cascadeId);
        if (teacherId != null) {
            courseIdSet.addAll(this.courseTeacherDao.getCourseIdByTeacherId(teacherId));
        }
        if (CollectionUtils.isEmpty(courseIds)) {
            courseIds.addAll(courseIdSet);
        } else if (!courseIdSet.containsAll(courseIds)) {
            courseIds.clear();
        }
        log.debug("after set courseIds:{}", courseIds);
    }

    private List<OrgClassLesson> querySignInLesson(Long orgId, Map<Long, Long> lessonIdTeacherIdMap, ListLessonsRequestDto params, boolean isTimeTable) {
        Preconditions.checkArgument((orgId != null && orgId > 0L ? 1 : 0) != 0, (Object)"orgId is illegal");
        HashSet courseIds = Sets.newHashSet();
        HashSet roomIds = Sets.newHashSet();
        HashSet teacherIds = Sets.newHashSet();
        HashSet lessonIds = Sets.newHashSet();
        Long number = ((OrgAccount)this.orgAccountDao.getById((Serializable)orgId, new String[]{"number"})).getNumber().longValue();
        List delCourseIds = Lists.transform((List)this.orgCourseDao.getCoursesByOrgNumber(number, Integer.valueOf(DeleteStatus.DELETED.getValue()), new String[]{"id"}), (Function)new Function<OrgCourse, Long>(){

            public Long apply(OrgCourse input) {
                return input.getId();
            }
        });
        if (params.getCourseId() != null) {
            courseIds.add(params.getCourseId());
            courseIds.removeAll(delCourseIds);
        }
        if (TianxiaoMContext.getTXCascadeId() != null) {
            TXCascadeAccount txCascadeAccount = (TXCascadeAccount)this.txCascadeAccountDao.getById((Serializable)TianxiaoMContext.getTXCascadeId(), new String[0]);
            if (txCascadeAccount == null) {
                throw new BussinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u5b50\u5e10\u53f7\u4e0d\u5b58\u5728");
            }
            if (txCascadeAccount.getAccountType().intValue() == CascadeType.STAFF.getValue()) {
                this.handleStaffCourseIds(orgId, TianxiaoMContext.getTXCascadeId(), courseIds);
                if (CollectionUtils.isEmpty((Collection)courseIds)) {
                    return Collections.EMPTY_LIST;
                }
            }
        }
        if (params.getRoomId() != null) {
            roomIds.add(params.getRoomId());
        }
        if (params.getTeacherId() != null) {
            teacherIds.add(params.getTeacherId());
        }
        if (params.getStudentId() != null) {
            lessonIds.addAll(this.courseStudentService.getStudentLessonIds(orgId, params.getStudentId()));
            if (CollectionUtils.isEmpty((Collection)lessonIds)) {
                return Collections.emptyList();
            }
        }
        lessonIdTeacherIdMap = this.queryLessonIdByTeacherId(orgId, teacherIds);
        if (CollectionUtils.isNotEmpty((Collection)teacherIds) && lessonIdTeacherIdMap.isEmpty()) {
            return Collections.emptyList();
        }
        lessonIds.addAll(lessonIdTeacherIdMap.keySet());
        Date startTime = params.getStartTime();
        Date endTime = params.getEndTime();
        if (isTimeTable) {
            startTime = params.getFirstLessonStartTime();
            endTime = params.getLastLessonStartTime();
        }
        List lessons = this.orgClassLessonDao.querySignInLessons(orgId, (Collection)courseIds, (Collection)delCourseIds, (Collection)roomIds, (Collection)lessonIds, startTime, endTime, params.getPageDto(), params.getLessonId(), new String[0]);
        return lessons;
    }

    @Override
    @Transactional(readOnly=true)
    public List<LessonTimeTableResponseDto> queryTimeTable(Long orgId, ListLessonsRequestDto params) {
        Preconditions.checkArgument((params.getStartTime() != null && params.getEndTime() != null ? 1 : 0) != 0, (Object)"start time or end time is null");
        Preconditions.checkArgument((boolean)params.getEndTime().after(params.getStartTime()), (Object)"time condition error");
        HashSet courseIds = Sets.newHashSet();
        HashSet roomIds = Sets.newHashSet();
        Map<Long, Long> lessonIdTeacherIdMap = new HashMap<Long, Long>();
        List<OrgClassLesson> lessons = this.queryLesson(orgId, lessonIdTeacherIdMap, params, false, false);
        if (CollectionUtils.isNotEmpty(lessons)) {
            HashSet lessonIds = Sets.newHashSet();
            for (OrgClassLesson lesson : lessons) {
                courseIds.add(lesson.getCourseId());
                roomIds.add(lesson.getRoomId());
                lessonIds.add(lesson.getId());
            }
            if (lessonIdTeacherIdMap.isEmpty()) {
                lessonIdTeacherIdMap = this.orgTeacherLessonDao.queryLessonTeacherIdMap(orgId, (Collection)lessonIds);
                log.debug("query lessonId teacherId map:{}by lessonIds:{}", lessonIdTeacherIdMap, (Object)lessonIds);
            }
            Map<Long, OrgCourse> courseMap = this.getOrgCourseMap(orgId, courseIds);
            Map teacherNameMap = this.teacherDao.getTeacherRealNameMap(lessonIdTeacherIdMap.values());
            Set orgCourseTeacherUserIds = teacherNameMap.keySet();
            this.filterSoftDelTeacherService.filterOrgCourseTeacherWithUserIds(orgId, orgCourseTeacherUserIds);
            Map<Long, OrgClassRoom> classRoomMap = this.getOrgClassRoomMap(roomIds);
            ArrayList result = Lists.newArrayList();
            Date currentDate = new Date();
            for (OrgClassLesson lesson : lessons) {
                OrgCourse tempCourse;
                boolean needShow;
                Long teacherId = lessonIdTeacherIdMap.get(lesson.getId());
                String teacherName = "";
                boolean bl = needShow = orgCourseTeacherUserIds.contains(teacherId) || lesson.getEndTime().compareTo(currentDate) < 0;
                if (needShow) {
                    teacherName = (String)teacherNameMap.get(teacherId);
                }
                if ((tempCourse = courseMap.get(lesson.getCourseId())) == null || tempCourse.getIsDel() != 0 || params.getCourseType() != null && params.getCourseType() != tempCourse.getCourseType()) continue;
                LessonTimeTableResponseDto dto = this.buildTimeTableDto(lesson, tempCourse, classRoomMap.get(lesson.getRoomId()), teacherId, teacherName);
                result.add(dto);
            }
            return result;
        }
        return Collections.emptyList();
    }

    private Map<Long, OrgClassRoom> getOrgClassRoomMap(Collection<Long> roomIds) {
        List classRooms = this.orgClassRoomDao.getByIds(roomIds, new String[]{"id", "roomName", "roomSize", "recycleStatus"});
        return CollectorUtil.collectMap((Collection)classRooms, (Function)new Function<OrgClassRoom, Long>(){

            public Long apply(OrgClassRoom input) {
                return input.getId();
            }
        });
    }

    private Map<Long, OrgCourse> getOrgCourseMap(Long orgId, Collection<Long> courseIds) {
        List courseList = this.orgCourseDao.getByIds(courseIds, new String[]{"id", "cover", "name", "color", "isDel", "courseType"});
        this.orgCourseListService.getCourseList(courseList, orgId, false, false, false, Boolean.valueOf(false), false, false, false);
        return CollectorUtil.collectMap((Collection)courseList, (Function)new Function<OrgCourse, Long>(){

            public Long apply(OrgCourse input) {
                return input.getId();
            }
        });
    }

    private LessonTimeTableResponseDto buildTimeTableDto(OrgClassLesson lesson, OrgCourse course, OrgClassRoom classRoom, Long teacherId, String teacherName) {
        LessonTimeTableResponseDto dto = new LessonTimeTableResponseDto();
        dto.setCourseId(lesson.getCourseId());
        if (course != null) {
            dto.setCourseColor(course.getColor());
            dto.setCourseName(course.getName());
        }
        dto.setCreateTime(lesson.getCreateTime());
        dto.setEndTime(lesson.getEndTime());
        dto.setLessonId(lesson.getId());
        dto.setIndex(lesson.getNumber());
        dto.setRoomId(lesson.getRoomId());
        if (classRoom != null && classRoom.getRecycleStatus().intValue() != DeleteStatus.DELETED.getValue()) {
            dto.setRoomName(classRoom.getRoomName());
        }
        dto.setCourseType(course.getCourseType());
        dto.setLessonName(lesson.getName());
        dto.setStartTime(lesson.getStartTime());
        dto.setUpdateTime(lesson.getUpdateTime());
        dto.setTeacherId(teacherId);
        dto.setTeacherName(teacherName == null ? "" : teacherName);
        return dto;
    }

    private ListLessonResponseDto buildListLessonResponseDto(List<OrgClassLesson> lessons, Map<Long, OrgCourse> courseMap, Map<Long, TwoTuple<String, String>> lessonIdTeacherNameMap, Map<Long, OrgClassRoom> classRoomMap, Map<Long, Integer> studentCountMap, Map<Long, Integer> signStudentCountMap, Map<Long, Integer> signedStudentCountMap, Map<Long, Integer> commentCount, Map<Long, Integer> teacherCommentCount, Map<Long, Integer> lessonSignStatus) {
        ListLessonResponseDto result = new ListLessonResponseDto();
        if (CollectionUtils.isNotEmpty(lessons)) {
            Date now = new Date();
            for (OrgClassLesson lesson : lessons) {
                TwoTuple<String, String> nameAndAvatar;
                if (result.getFirstLessonStartTime() == null || result.getFirstLessonStartTime().after(lesson.getStartTime())) {
                    result.setFirstLessonStartTime(lesson.getStartTime());
                }
                if (result.getLastLessonStartTime() == null || result.getLastLessonStartTime().before(lesson.getStartTime())) {
                    result.setLastLessonStartTime(lesson.getStartTime());
                }
                LessonResponseDto dto = new LessonResponseDto();
                dto.setCourseId(lesson.getCourseId());
                dto.setIndex(lesson.getNumber());
                OrgCourse course = courseMap.get(lesson.getCourseId());
                if (course == null) continue;
                if (StringUtils.isNotBlank((CharSequence)course.getName())) {
                    dto.setCourseName(course.getName());
                }
                dto.setCourseType((int)course.getCourseType());
                OrgClassRoom classRoom = classRoomMap.get((long)lesson.getRoomId());
                dto.setRoomId(lesson.getRoomId());
                if (classRoom != null) {
                    dto.setRoomName(classRoom.getRoomName());
                }
                dto.setTeacherName(null == (nameAndAvatar = lessonIdTeacherNameMap.get((long)lesson.getId())) ? "" : (String)nameAndAvatar.getFirst());
                dto.setTeacherAvatar(null == nameAndAvatar ? null : (String)nameAndAvatar.getSecond());
                dto.setLessonEndTime(lesson.getEndTime());
                dto.setLessonId(lesson.getId());
                dto.setLessonStartTime(lesson.getStartTime());
                dto.setLessonName(lesson.getName());
                CourseSignStatus signStatus = CourseSignStatus.HAS_NOT_STARTED;
                if (now.after(lesson.getEndTime())) {
                    signStatus = CourseSignStatus.NO_SIGN;
                    dto.setIsOver(1);
                }
                if (now.after(lesson.getStartTime()) && now.before(lesson.getEndTime())) {
                    signStatus = CourseSignStatus.SIGNING;
                }
                Integer signCount = signStudentCountMap.get(lesson.getId());
                Integer inClassCount = signedStudentCountMap.get(lesson.getId());
                SignStatus stuSignStatus = SignStatus.getSignStatusByCode((Integer)lessonSignStatus.get(lesson.getId()));
                if (stuSignStatus != null) {
                    log.debug("lessonId:{},lessonSignStatus:{},status:{}", new Object[]{lesson.getId(), lessonSignStatus, stuSignStatus});
                    dto.setSignStatusEnum(stuSignStatus);
                } else {
                    if (signCount != null && signCount > 0) {
                        signStatus = CourseSignStatus.SIGNED;
                    }
                    dto.setCourseSignStatusEnum(signStatus);
                }
                Integer commentCnt = commentCount.get(lesson.getId());
                if (commentCnt != null && commentCnt > 0) {
                    dto.setCommentEnum(CommentStatus.COMMENTED);
                } else {
                    dto.setCommentEnum(CommentStatus.getCommentStatusByTime((Date)lesson.getStartTime(), (Date)lesson.getEndTime(), (boolean)true));
                }
                Integer teacherCommentCnt = teacherCommentCount.get(lesson.getId());
                if (teacherCommentCnt != null && teacherCommentCnt > 0) {
                    dto.setTeacherCommentEnum(CommentStatus.COMMENTED);
                } else {
                    dto.setTeacherCommentEnum(CommentStatus.getCommentStatusByTime((Date)lesson.getStartTime(), (Date)lesson.getEndTime(), (boolean)true));
                }
                Integer studentCount = studentCountMap.get(lesson.getId());
                dto.setSignCount(inClassCount != null ? inClassCount : 0);
                dto.setTotalSignCount(signCount != null ? signCount : 0);
                dto.setStudentCount(studentCount != null ? studentCount : 0);
                result.getList().add(dto);
            }
        }
        return result;
    }

    private Map<Long, Long> queryLessonIdByTeacherId(Long orgId, Collection<Long> teacherIds) {
        if (CollectionUtils.isEmpty(teacherIds)) {
            return Collections.emptyMap();
        }
        List teacherLessons = this.orgTeacherLessonDao.queryTeacherLessons(orgId, teacherIds, new String[]{"lessonId", "teacherId"});
        if (CollectionUtils.isNotEmpty((Collection)teacherLessons)) {
            HashMap<Long, Long> result = new HashMap<Long, Long>();
            for (OrgTeacherLesson orgTeacherLesson : teacherLessons) {
                result.put(orgTeacherLesson.getLessonId(), orgTeacherLesson.getTeacherId());
            }
            return result;
        }
        return Collections.emptyMap();
    }

    @Override
    @Transactional(readOnly=true)
    public LessonTimeTableResponseDto lessonInfo(Long orgId, Long lessonId) {
        Preconditions.checkArgument((orgId != null && orgId > 0L ? 1 : 0) != 0, (Object)"orgId is illegal");
        Preconditions.checkArgument((lessonId != null && lessonId > 0L ? 1 : 0) != 0, (Object)"lessonId is illegal");
        OrgClassLesson lesson = (OrgClassLesson)this.orgClassLessonDao.getById((Serializable)lessonId, new String[0]);
        Date now = new Date();
        if (lesson == null || !orgId.equals(lesson.getOrgId())) {
            log.warn("lesson id:{} is illegal,query lesson:{}", (Object)lessonId, (Object)lesson);
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u8bfe\u8282ID\u4e0d\u6b63\u786e");
        }
        LessonTimeTableResponseDto dto = new LessonTimeTableResponseDto();
        OrgCourse course = this.orgCourseDao.getByCourseId(lesson.getCourseId(), new String[]{"id", "name", "courseType", "color", "isFinish"});
        if (course == null) {
            log.warn("can not found course by lesson:{}", (Object)lesson);
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.SYSTEM_ERROR, "\u65e0\u6cd5\u627e\u5230\u5bf9\u5e94\u73ed\u7ea7");
        }
        dto.setCourseColor(course.getColor());
        dto.setCourseId(course.getId());
        dto.setCourseType((int)course.getCourseType());
        dto.setCourseName(course.getName());
        dto.setCourseFinish(course.getIsFinish());
        dto.setCreateTime(lesson.getCreateTime());
        dto.setEndTime(lesson.getEndTime());
        dto.setIndex(lesson.getNumber());
        dto.setLessonId(lesson.getId());
        dto.setLessonName(lesson.getName());
        CourseSignStatus signStatus = CourseSignStatus.HAS_NOT_STARTED;
        if (now.after(lesson.getStartTime())) {
            signStatus = CourseSignStatus.NO_SIGN;
            if (now.before(lesson.getEndTime())) {
                signStatus = CourseSignStatus.SIGNING;
            }
        }
        dto.setRoomId(lesson.getRoomId());
        dto.setSignStatusEnum(signStatus);
        dto.setStartTime(lesson.getStartTime());
        dto.setUpdateTime(lesson.getUpdateTime());
        return dto;
    }

    @Override
    public StudentCenterLessonDetailDto lessonDetail(Long orgId, Long lessonId, String smsToken, boolean needStudentSign) {
        try {
            Date now;
            StudentSmsTokenDto token = StudentSmsTokenDto.fromTokenStr((String)smsToken);
            LessonTimeTableResponseDto lessonTimeTableResponseDto = this.lessonDetail(orgId, lessonId, needStudentSign);
            StudentCenterLessonDetailDto dto = new StudentCenterLessonDetailDto();
            dto.setLessonId(lessonTimeTableResponseDto.getLessonId());
            dto.setLessonName(lessonTimeTableResponseDto.getLessonName());
            dto.setStartTime(lessonTimeTableResponseDto.getStartTime());
            dto.setEndTime(lessonTimeTableResponseDto.getEndTime());
            dto.setBeginTimeStr(lessonTimeTableResponseDto.getBeginTimeStr());
            dto.setEndTimeStr(lessonTimeTableResponseDto.getEndTimeStr());
            dto.setIndex(lessonTimeTableResponseDto.getIndex());
            dto.setTeacherId(lessonTimeTableResponseDto.getTeacherId());
            dto.setTeacherName(lessonTimeTableResponseDto.getTeacherName());
            dto.setRoomId(lessonTimeTableResponseDto.getRoomId());
            dto.setRoomName(lessonTimeTableResponseDto.getRoomName());
            dto.setSignRemark(lessonTimeTableResponseDto.getSignRemark());
            dto.setSignStatus(lessonTimeTableResponseDto.getSignStatus());
            dto.setSignStatusStr(lessonTimeTableResponseDto.getSignStatusStr());
            for (OrgStudentsChooseListDto student : lessonTimeTableResponseDto.getStudents()) {
                if (student.getStudentId().longValue() != token.getStudentId().longValue()) continue;
                dto.setStudentAvatarUrl(student.getAvatarUrl());
                dto.setStudentName(student.getName());
                Map commentMap = this.lessonCommentService.getStudentLessonCommentMap(student.getUserId(), (Collection)Lists.newArrayList((Object[])new Long[]{lessonId}));
                dto.setHasComment((Boolean)commentMap.get((long)lessonId));
                OrgLessonSign orgLessonSign = this.orgLessonSignDao.getStudentLessonSign(orgId, lessonTimeTableResponseDto.getCourseId(), lessonTimeTableResponseDto.getLessonId(), student.getUserId(), Integer.valueOf(UserRole.STUDENT.getRole()));
                if (orgLessonSign == null) break;
                dto.setSignRemark(orgLessonSign.getSignRemark());
                dto.setSignStatus(orgLessonSign.getStatus());
                dto.setSignStatusStr(SignStatus.getSignStatusByCode((Integer)orgLessonSign.getStatus()).getMessage());
                break;
            }
            if ((now = new Date()).after(lessonTimeTableResponseDto.getEndTime())) {
                dto.setIsOver(1);
            }
            return dto;
        }
        catch (Exception e) {
            log.warn("lesson detail warn = {}", (Throwable)e);
            return null;
        }
    }

    @Override
    @Transactional(readOnly=true)
    public LessonTimeTableResponseDto lessonDetail(Long orgId, Long lessonId, boolean needStudentSign) {
        LessonTimeTableResponseDto dto = this.lessonInfo(orgId, lessonId);
        dto.setStudents(this.courseStudentService.getLessonStudent(orgId, lessonId, needStudentSign));
        for (OrgStudentsChooseListDto student : dto.getStudents()) {
            if (student.getSignStatus() == null || SignStatus.SIGNED.getCode() != student.getSignStatus().intValue()) continue;
            dto.increaseSignStudent();
        }
        List teacherDtos = this.courseTeacherService.getLessonTeacher(orgId, lessonId);
        if (CollectionUtils.isNotEmpty((Collection)teacherDtos)) {
            TeacherResponseDto teacherDto = (TeacherResponseDto)teacherDtos.get(0);
            dto.setTeacherId(teacherDto.getTeacherId());
            dto.setTeacherName(teacherDto.getTeacherName());
        }
        if (dto.getRoomId() != null && dto.getRoomId() > 0L) {
            OrgClassRoom classRoom = (OrgClassRoom)this.orgClassRoomDao.getById((Serializable)dto.getRoomId(), new String[]{"id", "roomName", "recycleStatus"});
            log.debug("[lesson detail.classroom status]=", (Object)classRoom.getRecycleStatus());
            if (classRoom.getRecycleStatus().intValue() == DeleteStatus.NORMAL.getValue()) {
                dto.setRoomName(classRoom.getRoomName());
            } else {
                OrgClassLesson lesson = (OrgClassLesson)this.orgClassLessonDao.getById((Serializable)lessonId, new String[0]);
                if (DateUtil.compare((Date)lesson.getStartTime(), (Date)new Date())) {
                    dto.setRoomName(classRoom.getRoomName());
                } else {
                    dto.setRoomName(null);
                    dto.setRoomId(null);
                }
            }
        }
        dto.setEditable(this.hasPermission(orgId, dto.getCourseId(), lessonId, TXPermissionConst.IF_CLASS_ARRANGE).getType());
        dto.setSignable(this.hasPermission(orgId, dto.getCourseId(), lessonId, TXPermissionConst.IF_SIGNUP).getType());
        dto.setCommentable(dto.getSignable());
        if (CourseTypeEnum.isOneToOne((Integer)dto.getCourseType()) && dto.getStudents() != null && dto.getStudents().size() > 0) {
            boolean isFinish = this.isFinished(orgId, dto.getCourseId(), dto.getStudents().get(0).getUserId());
            dto.setCourseFinish(isFinish ? 1 : 0);
        }
        return dto;
    }

    private boolean isFinished(Long orgId, Long courseId, Long userId) {
        OrgStudentCourse studentCourse = this.orgStudentCourseDao.getStudentCourse(orgId, courseId, userId);
        return studentCourse == null || studentCourse.getStatus() != 0;
    }

    private PermissionType hasPermission(Long orgId, Long courseId, Long lessonId, TXPermissionConst permissionConst) {
        Integer cascadeId = TianxiaoMContext.getTXCascadeId();
        PermissionType type = PermissionType.FORBIDDEN;
        if (cascadeId != null && cascadeId > 0) {
            TXCascadeAccount txCascadeAccount = (TXCascadeAccount)this.txCascadeAccountDao.getById((Serializable)cascadeId, new String[0]);
            boolean hasPermission = this.permissionService.checkPermission(orgId, cascadeId, DeviceType.APP, Long.valueOf(permissionConst.getPCode()));
            if (hasPermission) {
                List teacherIds = null;
                if (txCascadeAccount.getAccountType().intValue() == CascadeType.STAFF.getValue()) {
                    teacherIds = permissionConst == TXPermissionConst.IF_SIGNUP ? this.orgClassLessonDao.listCourseLessonTeacherId(lessonId.longValue()) : this.courseTeacherDao.getTeacherIdsByCourseId(courseId);
                    Long teacherId = this.teacherService.getUserIdByCascadeId(orgId, cascadeId);
                    if (teacherId != null && teacherIds.contains(teacherId)) {
                        return PermissionType.ALLOWED;
                    }
                    List tempIds = this.orgCourseDao.getCourseIdsByCascadeId(cascadeId, null, CourseTypeEnum.IS_CLASS_TRUE.getCode(), null);
                    type = CollectionUtils.isEmpty((Collection)tempIds) || !tempIds.contains(courseId) ? PermissionType.FORBIDDEN : PermissionType.ALLOWED;
                } else {
                    type = PermissionType.ALLOWED;
                }
            } else {
                type = PermissionType.FORBIDDEN;
            }
        } else {
            type = PermissionType.ALLOWED;
        }
        return type;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void delLesson(Long orgId, Long lessonId) {
        Preconditions.checkArgument((orgId != null && orgId > 0L ? 1 : 0) != 0, (Object)"orgId is illegal");
        Preconditions.checkArgument((lessonId != null && lessonId > 0L ? 1 : 0) != 0, (Object)"lessonId is illegal");
        OrgClassLesson lesson = (OrgClassLesson)this.orgClassLessonDao.getById((Serializable)lessonId, new String[0]);
        if (lesson == null || !orgId.equals(lesson.getOrgId())) {
            log.warn("lesson id:{} is illegal,query lesson:{}", (Object)lessonId, (Object)lesson);
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u8bfe\u8282\u4e0d\u5b58\u5728\u6216\u5df2\u88ab\u5220\u9664");
        }
        this.hasDeleteLessonPermission(lesson.getCourseId());
        if (CollectionUtils.isNotEmpty((Collection)this.orgLessonCommentDao.getLessonComments(lessonId, (Boolean)null, null, new String[]{"id"}))) {
            throw new BussinessException((UniverseErrorCode)CommentErrorCode.LESSON_WITH_COMMENT);
        }
        if (CollectionUtils.isNotEmpty((Collection)this.orgLessonSignDao.getLessonSignList(orgId, null, lessonId, null, null, null, false, null, null, new String[]{"id"}))) {
            throw new BussinessException((UniverseErrorCode)CommentErrorCode.LESSON_WITH_SIGN);
        }
        this.courseStudentService.deleteStudentFromLesson(orgId, lessonId, null);
        this.courseTeacherService.delTeacherFromLesson(orgId, lessonId, null);
        ArrayList lessonIds = Lists.newArrayList();
        lessonIds.add(lessonId);
        this.orgClassLessonDao.updateDelByLessonIds(orgId, (Collection)lessonIds);
        this.resetLessonNumber(orgId, lesson.getCourseId());
        this.signupCourseLessonService.deleteClassLessons(orgId, (Collection)lessonIds);
        this.orgLessonConflictService.delByLessonIds(orgId, (List)lessonIds);
    }

    void hasDeleteLessonPermission(Long courseId) {
        if (TianxiaoMContext.getTXCascadeId() != null) {
            List tempIds;
            TXCascadeAccount txCascadeAccount = (TXCascadeAccount)this.txCascadeAccountDao.getById((Serializable)TianxiaoMContext.getTXCascadeId(), new String[0]);
            if (txCascadeAccount == null) {
                throw new BussinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u5b50\u5e10\u53f7\u4e0d\u5b58\u5728");
            }
            if (txCascadeAccount.getAccountType().intValue() == CascadeType.STAFF.getValue() && (CollectionUtils.isEmpty((Collection)(tempIds = this.orgCourseDao.getCourseIdsByCascadeId(TianxiaoMContext.getTXCascadeId(), null, CourseTypeEnum.IS_CLASS_TRUE.getCode(), null))) || !tempIds.contains(courseId))) {
                throw new BussinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u65e0\u6743\u64cd\u4f5c");
            }
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void editLesson(Long orgId, EditLessonRequestDto editDto) {
        Preconditions.checkNotNull((Object)editDto, (Object)"param can not be null");
        editDto.validate();
        OrgClassLesson lesson = (OrgClassLesson)this.orgClassLessonDao.getById((Serializable)editDto.getLessonId(), new String[0]);
        if (lesson == null || !orgId.equals(lesson.getOrgId())) {
            log.warn("lesson id:{} is illegal,query lesson:{}", (Object)editDto.getLessonId(), (Object)lesson);
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u8bfe\u8282ID\u4e0d\u6b63\u786e");
        }
        this.editValidate(orgId, lesson.getCourseId());
        lesson.setDelStatus(Integer.valueOf(DataStatus.NORMAL.getValue()));
        boolean needRearrange = false;
        if (!editDto.getEndTime().equals(lesson.getEndTime()) || !editDto.getStartTime().equals(lesson.getStartTime())) {
            lesson.setEndTime(editDto.getEndTime());
            lesson.setStartTime(editDto.getStartTime());
            needRearrange = true;
        }
        ArrayList teacherIds = Lists.newArrayList();
        if (editDto.getRoomId() == null) {
            editDto.setRoomId(0L);
        }
        if (editDto.getTeacherId() == null) {
            editDto.setTeacherId(0L);
        } else {
            teacherIds.add(editDto.getTeacherId());
        }
        lesson.setRoomId(editDto.getRoomId());
        lesson.setUpdateTime(new Date());
        lesson.setName(editDto.getLessonName());
        this.orgClassLessonDao.update((Object)lesson, new String[0]);
        if (needRearrange) {
            this.resetLessonNumber(orgId, lesson.getCourseId());
            Integer duration = DateUtil.getMinuteDiff((Date)lesson.getStartTime(), (Date)lesson.getEndTime());
            List userIds = this.orgStudentLessonDao.getUserIds(editDto.getLessonId(), orgId);
            this.orgStudentLessonDao.batchUpdateLessonDuration((Collection)userIds, duration, editDto.getLessonId());
            this.signupCourseLessonService.updateLessonDuration(orgId, lesson);
        }
        HashSet roomIds = Sets.newHashSet();
        roomIds.add(editDto.getRoomId() != null ? editDto.getRoomId() : 0L);
        this.classRoomService.addClassRoomCourse(Long.valueOf(orgId), lesson.getCourseId(), (Collection)roomIds);
        this.courseTeacherService.resetLessonTeacher(orgId, lesson.getCourseId(), lesson.getId(), (Collection)teacherIds);
        OrgLessonConflict conflict = new OrgLessonConflict();
        conflict.setOrgId(orgId);
        conflict.setTeacherId(editDto.getTeacherId());
        conflict.setRoomId(editDto.getRoomId());
        conflict.setLessonId(editDto.getLessonId());
        conflict.setStartTime(editDto.getStartTime());
        conflict.setEndTime(editDto.getEndTime());
        conflict.setDelStatus(Integer.valueOf(DataStatus.NORMAL.getValue()));
        this.orgLessonConflictService.updateOrgLessonConflictsForce(conflict);
    }

    void editValidate(Long orgId, Long courseId) {
        if (TianxiaoMContext.getTXCascadeId() != null) {
            TXCascadeAccount txCascadeAccount = (TXCascadeAccount)this.cascadeAccountDao.getById((Serializable)TianxiaoMContext.getTXCascadeId(), new String[0]);
            if (txCascadeAccount == null) {
                throw new BussinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u5b50\u5e10\u53f7\u4e0d\u5b58\u5728");
            }
            if (txCascadeAccount.getAccountType().intValue() == CascadeType.STAFF.getValue()) {
                ArrayList courseIds = new ArrayList();
                List tempIds = this.orgCourseDao.getCourseIdsByCascadeId(TianxiaoMContext.getTXCascadeId(), null, null, null);
                courseIds.addAll(tempIds);
                Long teacherId = this.teacherService.getUserIdByCascadeId(orgId, TianxiaoMContext.getTXCascadeId());
                List teacherCourseIds = null;
                if (teacherId != null) {
                    teacherCourseIds = this.courseTeacherDao.getCourseIdByTeacherId(teacherId);
                }
                if (teacherCourseIds != null && teacherCourseIds.size() > 0) {
                    courseIds.addAll(teacherCourseIds);
                }
                if (CollectionUtils.isEmpty(courseIds) || !courseIds.contains(courseId)) {
                    throw new BussinessException((UniverseErrorCode)CommonErrorCode.PERMISSION_DENY, "\u65e0\u6743\u64cd\u4f5c\u4e0d\u5c5e\u4e8e\u60a8\u7684\u8bfe\u8282");
                }
            }
        }
    }

    private void resetLessonNumber(Long orgId, Long courseId) {
        List lessons = this.orgClassLessonDao.queryLessons(orgId, (Collection)Lists.newArrayList((Object[])new Long[]{courseId}), null, null, null, null, null, null, new String[]{"id"});
        if (CollectionUtils.isNotEmpty((Collection)lessons)) {
            int index = 1;
            Map[] params = new Map[lessons.size()];
            for (OrgClassLesson lesson : lessons) {
                HashMap<String, Number> param = new HashMap<String, Number>();
                param.put("id", lesson.getId());
                param.put("number", index);
                params[index - 1] = param;
                ++index;
            }
            this.orgClassLessonDao.batchUpdateLessonNumber(params);
        }
    }

    @Override
    @Transactional(readOnly=true)
    public Long getTeacherId(Long orgId, Long lessonId) {
        OrgTeacherLesson teacherLesson = this.orgTeacherLessonDao.getByLessonId(orgId, lessonId);
        if (teacherLesson != null) {
            return teacherLesson.getTeacherId();
        }
        return null;
    }

    @Override
    @Transactional(readOnly=true)
    public List<Long> getLessonStudentUserIds(Long orgId, Collection<Long> lessonIds) {
        if (CollectionUtils.isEmpty(lessonIds)) {
            return Lists.newArrayList();
        }
        return this.orgStudentLessonDao.getUserIdsByLessonIds(orgId, lessonIds);
    }

    @Override
    public void export(HttpServletResponse response, Long orgId, ListLessonsRequestDto param, List<LessonTimeTableResponseDto> dtoList) {
        Preconditions.checkArgument((param.getStartTime() != null ? 1 : 0) != 0, (Object)"\u5f00\u59cb\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a");
        Preconditions.checkArgument((param.getEndTime() != null ? 1 : 0) != 0, (Object)"\u7ed3\u675f\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a");
        Preconditions.checkArgument((orgId != null && orgId > 0L ? 1 : 0) != 0, (Object)"\u673a\u6784ID\u4e0d\u80fd\u4e3a\u7a7a");
        String orgName = this.orgInfoDao.getOrgShortNameByOrgId(Integer.valueOf(orgId.intValue()));
        String startTimeStr = TianXiaoConstant.DAY_FORMAT.format(param.getStartTime());
        String endTimeStr = TianXiaoConstant.DAY_FORMAT.format(param.getEndTime());
        String fileName = orgName + "-\u8bfe\u8868\u7edf\u8ba1-" + startTimeStr + "~" + endTimeStr + ".xlsx";
        SXSSFWorkbook workbook = null;
        List dates = DateUtil.getDateBetween((Date)param.getStartTime(), (Date)param.getEndTime());
        try {
            workbook = new SXSSFWorkbook(200);
            HashMap<String, CellStyle> cellStyleMap = new HashMap<String, CellStyle>();
            ArrayList summaryFields = Lists.newArrayList();
            summaryFields.add(new ExportField(" ", "@", 5620));
            for (Date date : dates) {
                summaryFields.add(new ExportField("\u5468" + DateUtil.getChineseWeekDay((Date)date) + "(" + DateUtil.getDayStr((Date)date) + ")", "@", 5120));
            }
            ArrayList titles = Lists.newArrayList();
            titles.add(startTimeStr + "~" + endTimeStr + "\u8bfe\u8868\u7edf\u8ba1");
            ExcelCourseExportService.createSheet((Workbook)workbook, "\u8bfe\u8868\u7edf\u8ba1", titles, cellStyleMap, summaryFields, dtoList, param.getStartTime());
            ExcelCourseExportService.exportExcel(response, (Workbook)workbook, fileName);
            log.debug("course lesson export success");
        }
        catch (Exception var20) {
            log.error("export catch exception:", (Throwable)var20);
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u5bfc\u51fa\u6570\u636e\u5904\u7406\u5f02\u5e38");
        }
        finally {
            try {
                workbook.close();
            }
            catch (IOException var19) {
                log.error("close workbook catch error:", (Throwable)var19);
            }
        }
    }

    public static void main(String[] args) throws IOException {
        String json = FileUtils.readFileToString((File)new File("/Users/wengshengli/Downloads/response.json"));
        List dtoList = JacksonUtil.str2List((String)json, LessonTimeTableResponseDto.class);
        Date startDate = new Date(1465747200682L);
        Date endDate = new Date(1466351999682L);
        System.out.println(DateUtil.getDateDiff((Date)startDate, (Date)endDate));
        List dates = DateUtil.getDateBetween((Date)startDate, (Date)endDate);
        SXSSFWorkbook workbook = new SXSSFWorkbook(200);
        HashMap<String, CellStyle> cellStyleMap = new HashMap<String, CellStyle>();
        ArrayList summaryFields = Lists.newArrayList();
        summaryFields.add(new ExportField("", "@", 5620));
        for (Date date : dates) {
            summaryFields.add(new ExportField("\u5468" + DateUtil.getChineseWeekDay((Date)date) + "(" + DateUtil.getDayStr((Date)date) + ")", "@", 5120));
        }
        ArrayList titles = Lists.newArrayList();
        titles.add("\u8bfe\u8282\u6c47\u603b\u8868");
        ExcelCourseExportService.createSheet((Workbook)workbook, "\u8bfe\u8282\u6c47\u603b", titles, cellStyleMap, summaryFields, dtoList, startDate);
        File excelFile = new File("/Users/wengshengli/Documents/test1.xlsx");
        workbook.write((OutputStream)new FileOutputStream(excelFile));
    }

    @Override
    public HeaderDto getHeaderInfo() {
        HeaderDto dto = new HeaderDto();
        Integer txCascadeAccountId = TianxiaoMContext.getTXCascadeId();
        if (txCascadeAccountId == null) {
            return dto;
        }
        OrgAccount orgAccount = this.orgAccountDao.getAccountById(TianxiaoMContext.getOrgId().intValue(), new String[0]);
        if (orgAccount == null) {
            log.info("orgAccount doesn't exist! orgAccountId:{}", (Object)TianxiaoMContext.getOrgId());
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u60a8\u65e0\u6743\u4f7f\u7528\u6b64\u529f\u80fd");
        }
        TXCascadeAccount txCascadeAccount = (TXCascadeAccount)this.txCascadeAccountDao.getById((Serializable)txCascadeAccountId, new String[0]);
        if (txCascadeAccount == null) {
            log.info("txCascadeAccount doesn't exist! txCascadeAccountId:{}", (Object)txCascadeAccountId);
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u60a8\u65e0\u6743\u4f7f\u7528\u6b64\u529f\u80fd");
        }
        List courseIds = Lists.newArrayList();
        Integer notSignCount = 0;
        if (txCascadeAccount.getAccountType().intValue() == CascadeType.STAFF.getValue() && CollectionUtils.isNotEmpty((Collection)(courseIds = this.orgCourseDao.getCourseIdsByCascadeId(txCascadeAccountId, null, CourseTypeEnum.IS_CLASS_TRUE.getCode(), null)))) {
            notSignCount = this.orgClassLessonDao.getLessonCount(orgAccount.getId(), courseIds, new Date());
        }
        if (txCascadeAccount.getAccountType().intValue() == CascadeType.MANAGER.getValue()) {
            notSignCount = this.orgClassLessonDao.getLessonCount(orgAccount.getId(), courseIds, new Date());
            courseIds = this.orgCourseDao.getCourseIds(Long.valueOf(orgAccount.getNumber().longValue()), null, null, CourseTypeEnum.IS_CLASS_TRUE.getCode(), null);
        }
        Integer totalCount = courseIds.size();
        dto.setClassCount(totalCount);
        dto.setSignCount(notSignCount);
        return dto;
    }

    @Override
    @Transactional(readOnly=true)
    public ListLessonResponseDto queryCourseLessons(Long orgId, ListLessonsRequestDto params) {
        OrgStudent orgStudent;
        ListLessonResponseDto result = new ListLessonResponseDto();
        List<Object> lessons = new ArrayList();
        HashMap<Long, Long> lessonIdTeacherIdMap = new HashMap<Long, Long>();
        boolean isMaster = false;
        if (params.isTeacherLesson()) {
            Integer cascadeId = TianxiaoMContext.getTXCascadeId();
            if (TianxiaoMContext.getTXCascadeId() != null) {
                TXCascadeAccount txCascadeAccount = (TXCascadeAccount)this.txCascadeAccountDao.getById((Serializable)TianxiaoMContext.getTXCascadeId(), new String[0]);
                if (txCascadeAccount == null) {
                    throw new BussinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u5b50\u5e10\u53f7\u4e0d\u5b58\u5728");
                }
                if (txCascadeAccount.getAccountType().intValue() == CascadeType.STAFF.getValue()) {
                    Long teacherId = this.teacherService.getUserIdByCascadeId(orgId, TianxiaoMContext.getTXCascadeId());
                    params.setTeacherId(teacherId == null ? 0L : teacherId);
                    List masterCourseIds = this.orgCourseDao.getCourseIdsByCascadeId(cascadeId, null, CourseTypeEnum.IS_CLASS_TRUE.getCode(), null);
                    if (masterCourseIds.contains(params.getCourseId())) {
                        isMaster = true;
                    }
                }
            }
        }
        List studentLessonIds = null;
        if (params.getStudentId() != null && params.getStudentId().intValue() > 0 && (orgStudent = (OrgStudent)this.orgStudentDao.getById((Serializable)params.getStudentId(), new String[0])) != null) {
            Map studentLessonMap = this.orgStudentLessonDao.getStudentCourseLessonMap(orgId, params.getCourseId(), (Collection)Lists.newArrayList((Object[])new Long[]{orgStudent.getUserId()}));
            log.debug("studentLessonMap = {}{}{}{}", new Object[]{orgId, params, orgStudent, studentLessonMap});
            studentLessonIds = (List)studentLessonMap.get(orgStudent.getUserId());
            if (studentLessonIds == null) {
                studentLessonIds = Lists.newArrayList();
            }
        }
        if (isMaster || params.isNeedCourseMaster()) {
            List masterLessons = this.orgClassLessonDao.queryLessons(orgId, Arrays.asList(params.getCourseId()), null, studentLessonIds, null, null, null, null, new String[0]);
            lessons = masterLessons;
        } else {
            lessons = this.queryLesson(orgId, lessonIdTeacherIdMap, params, true, false);
        }
        log.debug("course lessons list params = {},{},{},result={}", new Object[]{orgId, params, studentLessonIds, lessons});
        ArrayList<Long> courseIds = new ArrayList<Long>();
        HashSet roomIds = Sets.newHashSet();
        HashSet lessonIds = Sets.newHashSet();
        if (CollectionUtils.isNotEmpty(lessons)) {
            Collections.sort(lessons, new Comparator<OrgClassLesson>(){

                @Override
                public int compare(OrgClassLesson o1, OrgClassLesson o2) {
                    return o1.getNumber().compareTo(o2.getNumber());
                }
            });
            for (OrgClassLesson orgClassLesson : lessons) {
                courseIds.add(orgClassLesson.getCourseId());
                roomIds.add(orgClassLesson.getRoomId());
                lessonIds.add(orgClassLesson.getId());
            }
            Map<Long, OrgCourse> courseMap = this.getOrgCourseMap(orgId, courseIds);
            Map map = this.orgStudentLessonDao.queryLessonStudentCountMap(orgId, (Collection)lessonIds);
            log.info("******** params:{},{},result:{}", new Object[]{orgId, lessonIds, map});
            Map signStudentCountMap = Maps.newHashMap();
            Map signedStudentCountMap = Maps.newHashMap();
            if (!params.isNeedStudentSignStatus() && params.isNeedSignInfo()) {
                signStudentCountMap = this.orgLessonSignDao.querySignLessonStudentCountMap(orgId, (Collection)lessonIds);
                signedStudentCountMap = this.orgLessonSignDao.querySignedLessonStudentCountMap(orgId, (Collection)lessonIds);
            }
            HashMap commentCount = Maps.newHashMap();
            HashMap teacherCommentCount = Maps.newHashMap();
            Map lessonSignStatus = Maps.newHashMap();
            if (params.isNeedStudentSignStatus()) {
                Preconditions.checkArgument((params.getStudentId() != null && params.getStudentId() > 0L ? 1 : 0) != 0, (Object)"\u5b66\u751fID\u4e0d\u6b63\u786e");
                Long userId = this.orgStudentDao.getUserId(params.getStudentId());
                List lessonSign = this.orgLessonSignDao.getStudentSign(orgId, userId, Integer.valueOf(UserRole.STUDENT.getRole()), (Collection)lessonIds, new String[]{"lessonId", "status"});
                if (CollectionUtils.isNotEmpty((Collection)lessonSign)) {
                    lessonSignStatus = CollectorUtil.collectMap((Collection)lessonSign, (Function)new Function<OrgLessonSign, Long>(){

                        public Long apply(OrgLessonSign input) {
                            return input.getLessonId();
                        }
                    }, (Function)new Function<OrgLessonSign, Integer>(){

                        public Integer apply(OrgLessonSign input) {
                            return input.getStatus();
                        }
                    });
                    log.debug("student lesson sign:{}", (Object)lessonSignStatus);
                }
            }
            HashMap lessonIdTeacherNameMap = Maps.newHashMap();
            if (params.isNeedTeacherName()) {
                Map tempLessonIdTeacherIdMap = this.orgTeacherLessonDao.queryLessonTeacherIdMap(orgId, (Collection)lessonIds);
                Map teacherNameAvatarMap = this.orgTeacherApiService.getNameAndAvatarByUserIds(orgId, tempLessonIdTeacherIdMap.values());
                for (Long lessonId : tempLessonIdTeacherIdMap.keySet()) {
                    lessonIdTeacherNameMap.put(lessonId, teacherNameAvatarMap.get(tempLessonIdTeacherIdMap.get(lessonId)));
                }
            }
            log.debug("lessonIdTeacherNameMap = {}", (Object)lessonIdTeacherNameMap);
            Map<Object, Object> classRoomMap = Maps.newHashMap();
            if (params.isNeedRoomName()) {
                classRoomMap = this.getOrgClassRoomMap(roomIds);
            }
            result = this.buildListLessonResponseDto(lessons, courseMap, lessonIdTeacherNameMap, classRoomMap, map, signStudentCountMap, signedStudentCountMap, commentCount, teacherCommentCount, lessonSignStatus);
            Date now = new Date();
            int lastRow = result.getList().size() - 1;
            if (lastRow >= 0) {
                result.setNewLessonId(result.getList().get(lastRow).getLessonId());
                for (LessonResponseDto lesson : result.getList()) {
                    if (!now.before(lesson.getLessonEndTime())) continue;
                    result.setNewLessonId(lesson.getLessonId());
                    break;
                }
            }
        } else {
            result.setFirstLessonStartTime(params.getFirstLessonStartTime());
            result.setLastLessonStartTime(params.getLastLessonStartTime());
            if (params.getFirstLessonStartTime() == null && params.getLastLessonStartTime() == null) {
                result.setFirstLessonStartTime(DateUtil.getCurrentDate());
            }
        }
        return result;
    }

    @Override
    public List<LessonScheduleInfoDto> queryCourseLessonsByParams(Long orgId, TimeTableRequestDto params, PageDto pageDto) {
        List teacherLessons;
        Collection lessonIds = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty((Collection)params.getTeacherIds()) && CollectionUtils.isNotEmpty((Collection)(teacherLessons = this.orgTeacherLessonDao.queryTeacherLessons(orgId, (Collection)params.getTeacherIds(), new String[]{"lessonId"})))) {
            lessonIds = BaseUtils.getPropertiesList((List)teacherLessons, (String)"lessonId");
        }
        Long number = ((OrgAccount)this.orgAccountDao.getById((Serializable)Integer.valueOf(orgId.intValue()), new String[]{"number"})).getNumber().longValue();
        List delIds = Lists.transform((List)this.orgCourseDao.getCoursesByOrgNumber(number, Integer.valueOf(DeleteStatus.DELETED.getValue()), new String[]{"id"}), (Function)new Function<OrgCourse, Long>(){

            public Long apply(OrgCourse input) {
                return input.getId();
            }
        });
        List lessons = this.orgClassLessonDao.getOrgClassLessonByParams((Collection)delIds, orgId, params, lessonIds, pageDto);
        ArrayList data = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty((Collection)lessons)) {
            ListLessonResponseDto ret = this.wrap(orgId, lessons);
            List<LessonResponseDto> result = ret.getList();
            LessonScheduleInfoDto item = null;
            if (CollectionUtils.isNotEmpty(result)) {
                Set roomIds = BaseUtils.getPropertiesList(result, (String)"roomId");
                Map<Long, OrgClassRoom> roomCache = this.getAndCachedClassRoom(roomIds);
                Date now = new Date();
                Set courseIds = BaseUtils.getPropertiesList(result, (String)"courseId");
                Map<Long, Integer> cache = this.getAndCachedFinishedLessonCount(orgId, courseIds);
                List courseList = this.orgCourseDao.getByIds((Collection)courseIds, new String[0]);
                HashMap map = Maps.newHashMap();
                for (OrgCourse course : courseList) {
                    map.put(course.getId(), course);
                }
                for (LessonResponseDto dto : result) {
                    if (((OrgCourse)map.get(dto.getCourseId())).getCourseType() == CourseTypeEnum.COURSE_TYPE_1v1.getCode() && dto.getStudentCount() == 0 || params.getCourseType() != null && ((OrgCourse)map.get(dto.getCourseId())).getCourseType() != params.getCourseType()) continue;
                    Long courseId = dto.getCourseId();
                    item = new LessonScheduleInfoDto();
                    item.setEndTime(dto.getLessonEndTime().getTime());
                    item.setStartTime(dto.getLessonStartTime().getTime());
                    item.setLessonId(dto.getLessonId());
                    item.setRoomId(dto.getRoomId());
                    item.setLessonName(dto.getLessonName());
                    if (dto.getRoomId() == null || dto.getRoomId() <= 0L) {
                        item.setRoomName(DEFAULT_ROOM_OR_TEACHER_NAME);
                    } else {
                        item.setRoomName(dto.getRoomName());
                    }
                    item.setStudentCount(dto.getStudentCount());
                    item.setTeacherId(dto.getTeacherId());
                    if (dto.getTeacherId() == null || dto.getTeacherId() <= 0L) {
                        item.setTeacherName(DEFAULT_ROOM_OR_TEACHER_NAME);
                    } else {
                        item.setTeacherName(dto.getTeacherName());
                    }
                    item.setCourseId(courseId);
                    item.setCourseName(dto.getCourseName());
                    item.setTotalStudents(dto.getStudentCount());
                    item.setIndex(dto.getIndex());
                    if (now.before(dto.getLessonStartTime())) {
                        item.setLessonStatus(LessonStatus.UN_START.getStatus());
                    } else if (now.after(dto.getLessonEndTime())) {
                        item.setLessonStatus(LessonStatus.FINISHED.getStatus());
                    } else {
                        item.setLessonStatus(LessonStatus.ONGOING.getStatus());
                    }
                    if (cache.containsKey(courseId)) {
                        item.setFinishedLessons(cache.get(courseId));
                    }
                    item.setCourseType(dto.getCourseType() == null ? CourseTypeEnum.COURSE_TYPE_CLASS.getCode() : dto.getCourseType());
                    long roomId = dto.getRoomId();
                    if (roomCache.containsKey(dto.getRoomId())) {
                        item.setRoomCapacity(roomCache.containsKey(roomId) ? roomCache.get(roomId).getRoomSize() : 0);
                    }
                    data.add(item);
                }
                if (CollectionUtils.isNotEmpty((Collection)data)) {
                    this.buildConflictInfo(orgId, params.getStartTime(), params.getEndTime(), data);
                    ArrayList tempList = Lists.newArrayList();
                    for (LessonScheduleInfoDto dto : data) {
                        if (params.getIsConflict() == BizConf.TRUE.intValue() && dto.getIsConflict() == BizConf.FALSE.intValue()) continue;
                        tempList.add(dto);
                    }
                    log.info("end buildConflictInfo orgId:{},params={},data.size={},tempList.size={}", new Object[]{orgId, params, data.size(), tempList.size()});
                    data = tempList;
                }
            }
        }
        log.info("queryCourseLessonsByCourseId.orgId:{}, params:{}, data:{}", new Object[]{orgId, params, data});
        return data;
    }

    private void buildConflictInfo(Long orgId, Long startTime, Long endTime, List<LessonScheduleInfoDto> lessonScheduleDto) {
        HashSet teacherIdSet = Sets.newHashSet();
        HashSet roomIdSet = Sets.newHashSet();
        boolean needFindTime = false;
        if (startTime == null || endTime == null) {
            needFindTime = true;
        }
        if (CollectionUtils.isEmpty(lessonScheduleDto)) {
            return;
        }
        for (LessonScheduleInfoDto dto : lessonScheduleDto) {
            if (dto.getTeacherId() != null && dto.getTeacherId() > 0L) {
                teacherIdSet.add(dto.getTeacherId());
            }
            if (dto.getRoomId() != null && dto.getRoomId() > 0L) {
                roomIdSet.add(dto.getRoomId());
            }
            if (!needFindTime) continue;
            if (startTime == null || startTime > dto.getStartTime()) {
                startTime = dto.getStartTime();
            }
            if (endTime != null && endTime >= dto.getEndTime()) continue;
            endTime = dto.getEndTime();
        }
        Date startDate = new Date(startTime);
        Date endDate = new Date(endTime);
        Map teacherConflictMap = this.orgLessonConflictDao.queryConfilctByTeacherIdsAndTimeRange(orgId, (Collection)teacherIdSet, startDate, endDate);
        Map roomConflictMap = this.orgLessonConflictDao.queryConfilctByClassRoomIdsAndTimeRange(orgId, (Collection)roomIdSet, startDate, endDate);
        Map<Long, Integer> lessonTeacherConflictCount = this.checkConflictCount(teacherConflictMap);
        log.info("finish build lessonTeacherConflictCount,orgId={},result={}", (Object)orgId, lessonTeacherConflictCount);
        Map<Long, Integer> lessonRoomConflictCount = this.checkConflictCount(roomConflictMap);
        log.info("finish build lessonRoomConflictCount,orgId={},result={}", (Object)orgId, lessonRoomConflictCount);
        for (LessonScheduleInfoDto dto : lessonScheduleDto) {
            Integer roomConflictNum;
            LessonConflictEnum conflict = LessonConflictEnum.NO_CONFLICT;
            Integer teacherConflictNum = lessonTeacherConflictCount.get(dto.getLessonId());
            if (teacherConflictNum == null) {
                teacherConflictNum = 0;
            }
            if ((roomConflictNum = lessonRoomConflictCount.get(dto.getLessonId())) == null) {
                roomConflictNum = 0;
            }
            if (teacherConflictNum > 0 && roomConflictNum > 0) {
                conflict = LessonConflictEnum.TEACHER_AND_ROOM;
            } else if (teacherConflictNum > 0) {
                conflict = LessonConflictEnum.TEACHER;
            } else if (roomConflictNum > 0) {
                conflict = LessonConflictEnum.ROOM;
            }
            ConflictInfoDto conflictInfo = null;
            if (conflict != null && conflict != LessonConflictEnum.NO_CONFLICT) {
                conflictInfo = new ConflictInfoDto();
                conflictInfo.setConflictType(conflict.getCode());
                conflictInfo.setConflictTypeStr(conflict.getNote());
                dto.setIsConflict(BizConf.TRUE);
            } else {
                dto.setIsConflict(BizConf.FALSE);
            }
            dto.setConflictInfo(conflictInfo);
        }
    }

    public Map<Long, Integer> checkConflictCount(Map<Long, List<OrgLessonConflict>> conflictMap) {
        HashMap conflictLessonCountMap = Maps.newHashMap();
        for (List<OrgLessonConflict> list : conflictMap.values()) {
            int size = list.size();
            for (int i = 0; i < size - 1; ++i) {
                OrgLessonConflict conflict = list.get(i);
                for (int j = i + 1; j < size; ++j) {
                    OrgLessonConflict temp = list.get(j);
                    if (conflict.getEndTime().getTime() <= temp.getStartTime().getTime() || conflict.getStartTime().getTime() >= temp.getEndTime().getTime()) continue;
                    Integer count = (Integer)conflictLessonCountMap.get(conflict.getLessonId());
                    if (count == null) {
                        count = new Integer(0);
                    }
                    Integer n = count;
                    Integer n2 = count = Integer.valueOf(count + 1);
                    conflictLessonCountMap.put(conflict.getLessonId(), count);
                    Integer count2 = (Integer)conflictLessonCountMap.get(temp.getLessonId());
                    if (count2 == null) {
                        count2 = new Integer(0);
                    }
                    n2 = count2;
                    Integer n3 = count2 = Integer.valueOf(count2 + 1);
                    conflictLessonCountMap.put(temp.getLessonId(), count2);
                }
            }
        }
        return conflictLessonCountMap;
    }

    Map<Long, Integer> getAndCachedFinishedLessonCount(Long orgId, Collection<Long> courseIds) {
        Map cache = Maps.newHashMap();
        if (CollectionUtils.isNotEmpty(courseIds)) {
            cache = this.orgClassLessonDao.getFinishLessonCount(orgId, courseIds, Integer.valueOf(DeleteStatus.NORMAL.getValue()));
        }
        return cache;
    }

    void wrapConflictInfo(Long orgId, LessonScheduleInfoDto dto) {
        LessonConflictCheckDto lessonConflictCheckDto = new LessonConflictCheckDto();
        lessonConflictCheckDto.setEndTimeDate(new Date(dto.getEndTime()));
        lessonConflictCheckDto.setLessonId(dto.getLessonId());
        lessonConflictCheckDto.setPageNum(1);
        lessonConflictCheckDto.setPageSize(20);
        lessonConflictCheckDto.setRoomId(dto.getRoomId());
        lessonConflictCheckDto.setStartTimeDate(new Date(dto.getStartTime()));
        lessonConflictCheckDto.setTeacherId(dto.getTeacherId());
        LessonConflictEnum conflict = this.orgLessonConflictService.lessonConflictFlagCheck(orgId, lessonConflictCheckDto);
        ConflictInfoDto conflictInfo = null;
        if (conflict != null && conflict != LessonConflictEnum.NO_CONFLICT) {
            conflictInfo = new ConflictInfoDto();
            conflictInfo.setConflictType(conflict.getCode());
            conflictInfo.setConflictTypeStr(conflict.getNote());
            dto.setIsConflict(BizConf.TRUE);
        } else {
            dto.setIsConflict(BizConf.FALSE);
        }
        dto.setConflictInfo(conflictInfo);
    }

    private ListLessonResponseDto wrap(Long orgId, List<OrgClassLesson> lessons) {
        HashMap lessonSignStatus;
        HashMap teacherCommentCount;
        HashMap commentCount;
        Map signedStudentCountMap;
        Map signStudentCountMap;
        Map studentCountMap;
        HashSet courseIds = Sets.newHashSet();
        HashSet roomIds = Sets.newHashSet();
        HashSet lessonIds = Sets.newHashSet();
        ListLessonResponseDto result = new ListLessonResponseDto();
        Collections.sort(lessons, new Comparator<OrgClassLesson>(){

            @Override
            public int compare(OrgClassLesson o1, OrgClassLesson o2) {
                return o1.getNumber().compareTo(o2.getNumber());
            }
        });
        for (OrgClassLesson lesson : lessons) {
            courseIds.add(lesson.getCourseId());
            roomIds.add(lesson.getRoomId());
            lessonIds.add(lesson.getId());
        }
        Map<Object, Object> courseMap = Maps.newHashMap();
        courseMap = this.getOrgCourseMap(orgId, courseIds);
        HashMap lessonIdTeacherNameMap = Maps.newHashMap();
        Map lessonIdTeacherIdMap = this.orgTeacherLessonDao.queryLessonTeacherIdMap(orgId, (Collection)lessonIds);
        Map teacherNameAvatarMap = this.orgTeacherApiService.getNameAndAvatarByUserIds(orgId, lessonIdTeacherIdMap.values());
        for (Long lessonId : lessonIdTeacherIdMap.keySet()) {
            lessonIdTeacherNameMap.put(lessonId, teacherNameAvatarMap.get(lessonIdTeacherIdMap.get(lessonId)));
        }
        Map<Object, Object> classRoomMap = Maps.newHashMap();
        classRoomMap = this.getOrgClassRoomMap(roomIds);
        result = this.buildListLessonResponseDto(lessons, courseMap, lessonIdTeacherNameMap, classRoomMap, studentCountMap = this.orgStudentLessonDao.queryLessonStudentCountMap(orgId, (Collection)lessonIds), signStudentCountMap = this.orgLessonSignDao.querySignLessonStudentCountMap(orgId, (Collection)lessonIds), signedStudentCountMap = this.orgLessonSignDao.querySignedLessonStudentCountMap(orgId, (Collection)lessonIds), commentCount = Maps.newHashMap(), teacherCommentCount = Maps.newHashMap(), lessonSignStatus = Maps.newHashMap());
        if (CollectionUtils.isNotEmpty(result.getList())) {
            lessonIdTeacherIdMap = this.orgTeacherLessonDao.queryLessonTeacherIdMap(orgId, (Collection)lessonIds);
            for (LessonResponseDto dto : result.getList()) {
                if (!lessonIdTeacherIdMap.containsKey(dto.getLessonId())) continue;
                dto.setTeacherId((Long)lessonIdTeacherIdMap.get(dto.getLessonId()));
            }
        }
        return result;
    }

    Map<Long, OrgClassRoom> getAndCachedClassRoom(Collection<Long> roomIds) {
        List rooms = this.orgClassRoomDao.getByIds(roomIds, new String[]{"id", "roomName", "roomSize"});
        Map cache = Maps.newHashMap();
        if (CollectionUtils.isNotEmpty((Collection)rooms)) {
            cache = BaseUtils.listToMap((List)rooms, (String)"id");
        }
        return cache;
    }

    @Override
    @Transactional
    public void batchOperateLesson(Long orgId, Long courseId, List<Long> lessonIds, BatchOperateType operateType, String targetId) {
        if (CollectionUtils.isNotEmpty(lessonIds)) {
            if (operateType == BatchOperateType.del_lesson) {
                this.delLesson(orgId, courseId, lessonIds, targetId);
            } else if (operateType == BatchOperateType.add_student) {
                this.addStudent(orgId, courseId, lessonIds, targetId);
            } else if (operateType == BatchOperateType.del_student) {
                this.delStudent(orgId, courseId, lessonIds, targetId);
            } else if (operateType == BatchOperateType.change_teacher) {
                Long teacherId = Long.valueOf(targetId);
                this.changeTeacher(orgId, courseId, lessonIds, teacherId);
            } else if (operateType == BatchOperateType.change_classroom) {
                Long roomId = Long.valueOf(targetId);
                this.changeClassroom(orgId, courseId, lessonIds, roomId);
            } else if (operateType == BatchOperateType.change_time) {
                String[] time = targetId.split(",");
                String startTimeStr = time[0];
                String endTimeStr = time[1];
                this.changeTime(orgId, courseId, lessonIds, startTimeStr, endTimeStr);
            } else if (operateType == BatchOperateType.change_lesson_name) {
                Preconditions.checkArgument((null != targetId && targetId.length() < 21 ? 1 : 0) != 0, (Object)"\u6279\u91cf\u4fee\u6539\u8bfe\u8282\u540d\u79f0\u4e3a\u7a7a\u6216\u8d85\u8fc720\u5b57\u7b26");
                this.orgClassLessonDao.batchUpdateLessonName(lessonIds, targetId);
            }
        }
    }

    private void delLesson(Long orgId, Long courseId, List<Long> lessonIds, String targetId) {
        ArrayList statusList = Lists.newArrayList();
        statusList.add(SignStatus.SIGNED.getCode());
        statusList.add(SignStatus.LEAVE.getCode());
        statusList.add(SignStatus.ABSENT.getCode());
        HashMap<String, Object> countCondition = new HashMap<String, Object>();
        countCondition.put("orgId", orgId);
        countCondition.put("courseId", courseId);
        countCondition.put("lessonId", lessonIds);
        countCondition.put("status", statusList);
        int count = this.orgLessonSignDao.countByCondition(countCondition, "userId", false);
        if (count > 0) {
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u8bfe\u7a0b\u5df2\u7b7e\u5230\uff0c\u4e0d\u80fd\u5220\u9664");
        }
        this.orgClassLessonDao.updateDelByLessonIds(orgId, lessonIds);
        this.signupCourseLessonService.deleteClassLessons(orgId, lessonIds);
        HashMap condition = Maps.newHashMap();
        condition.put("orgId", orgId);
        condition.put("lessonId", lessonIds);
        condition.put("delStatus", "1");
        this.orgStudentLessonDao.update((Map)condition, new String[]{"delStatus"});
        HashMap<String, List<Long>> delCondition = new HashMap<String, List<Long>>();
        delCondition.put("lessonId", lessonIds);
        this.orgTeacherLessonDao.delByCondition(delCondition);
        this.orgLessonConflictService.delByLessonIds(orgId, lessonIds);
        this.resetLessonNumber(orgId, courseId);
    }

    private void addStudent(Long orgId, Long courseId, List<Long> lessonIds, String targetId) {
        OrgCourse orgCourse = (OrgCourse)this.orgCourseDao.getById((Serializable)courseId, new String[0]);
        if (orgCourse == null) {
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u73ed\u7ea7\u4e0d\u5b58\u5728");
        }
        if (orgCourse.getCourseType() == CourseTypeEnum.COURSE_TYPE_1v1.getCode()) {
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "1\u5bf91\u8bfe\u7a0b\u4e0d\u80fd\u6dfb\u52a0\u5b66\u751f\uff0c\u8bf7\u4e0b\u8f7d\u65b0\u7248\u5929\u6821");
        }
        ArrayList studentIds = null;
        try {
            studentIds = (ArrayList)JacksonUtil.str2Obj((String)targetId, (TypeReference)new TypeReference<List<Long>>(){});
        }
        catch (Exception e1) {
            log.warn("json class cast exception");
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u5b66\u751fid\u8f6c\u6362\u5f02\u5e38");
        }
        if (CollectionUtils.isEmpty((Collection)studentIds)) {
            log.warn("add student ids is empty");
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u5b66\u751fid\u4e3a\u7a7a");
        }
        Map userIdMap = this.orgStudentDao.getStudentIdUserIdMap((Collection)studentIds);
        if (MapUtils.isEmpty((Map)userIdMap)) {
            log.warn("add student ids is empty");
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u5b66\u751fid\u4e3a\u7a7a");
        }
        studentIds = new ArrayList(userIdMap.values());
        List courseStudents = this.orgStudentCourseDao.getStudents(orgId, courseId, Integer.valueOf(0));
        if (!courseStudents.containsAll(studentIds)) {
            studentIds.retainAll(courseStudents);
            log.warn("lesson studeng:{} is not all course student ids:{}", studentIds, (Object)courseStudents);
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u5fc5\u987b\u4ece\u8bfe\u7a0b\u5b66\u751f\u4e2d\u6dfb\u52a0\u8bfe\u8282\u5b66\u751f");
        }
        List classLessons = this.orgClassLessonDao.getByIds(lessonIds, new String[]{"startTime", "endTime", "id"});
        final Map classLessonMap = CollectionHelper.toIdMap((Collection)classLessons);
        Map lessonStudentIds = this.orgStudentLessonDao.getLessonStudentList(lessonIds);
        List delLessonStudent = this.orgStudentLessonDao.getLessonStudentListDelStatus(lessonIds);
        HashMap lesseonStudentMap = Maps.newHashMap();
        for (OrgStudentLesson orgStudentLesson : delLessonStudent) {
            String tempKey = orgStudentLesson.getUserId() + "|" + orgStudentLesson.getLessonId();
            lesseonStudentMap.put(tempKey, orgStudentLesson);
        }
        log.info("check orgStudentLessonDao.getLessonStudentList(lessonIds):{},result={}", lessonIds, (Object)lessonStudentIds);
        ArrayList saveStudentLessons = Lists.newArrayList();
        ArrayList updateStudentLessons = Lists.newArrayList();
        ArrayList studentLessons = Lists.newArrayList();
        for (Long lessonId : lessonIds) {
            List addedStuIds;
            ArrayList tempStudentIds = new ArrayList(studentIds);
            if (lessonStudentIds.containsKey(lessonId) && CollectionUtils.isNotEmpty((Collection)(addedStuIds = (List)lessonStudentIds.get(lessonId)))) {
                tempStudentIds.removeAll(addedStuIds);
            }
            OrgClassLesson classLesson = (OrgClassLesson)classLessonMap.get(lessonId);
            int lessonDuration = DateUtil.getMinuteDiff((Date)classLesson.getStartTime(), (Date)classLesson.getEndTime());
            OrgStudentLesson po = null;
            for (Long studentId : tempStudentIds) {
                po = new OrgStudentLesson();
                po.setCreateTime(new Date());
                po.setLessonId(lessonId);
                po.setOrgId(orgId);
                po.setUserId(studentId);
                po.setCourseId(courseId);
                po.setLessonDuration(Integer.valueOf(lessonDuration));
                String tempKey = studentId + "|" + lessonId;
                if (lesseonStudentMap.containsKey(tempKey)) {
                    OrgStudentLesson tempStudentLesson = (OrgStudentLesson)lesseonStudentMap.get(tempKey);
                    po.setId(tempStudentLesson.getId());
                    po.setDelStatus(Integer.valueOf(0));
                    po.setStartStatus(Integer.valueOf(0));
                    updateStudentLessons.add(po);
                } else {
                    saveStudentLessons.add(po);
                }
                studentLessons.add(po);
            }
        }
        Collections.sort(studentLessons, new Comparator<OrgStudentLesson>(){

            @Override
            public int compare(OrgStudentLesson o1, OrgStudentLesson o2) {
                OrgClassLesson lesson1 = (OrgClassLesson)classLessonMap.get(o1.getLessonId());
                OrgClassLesson lesson2 = (OrgClassLesson)classLessonMap.get(o2.getLessonId());
                return lesson1.getStartTime().compareTo(lesson2.getStartTime());
            }
        });
        if (!studentLessons.isEmpty()) {
            this.signupCourseLessonService.saveSignupCourseLessons(orgId, courseId, (Collection)studentLessons);
        }
        log.info("save students :{} to lessonid:{}", (Object)saveStudentLessons, lessonIds);
        this.orgStudentLessonDao.saveAll((List)saveStudentLessons, new String[]{"courseId", "createTime", "lessonId", "orgId", "userId", "lessonType", "lessonDuration", "kexiaoDuration"});
        for (OrgStudentLesson updateStudentLesson : updateStudentLessons) {
            this.orgStudentLessonDao.update((Object)updateStudentLesson, new String[]{"delStatus", "startStatus", "courseId", "lessonType", "lessonDuration", "kexiaoDuration"});
        }
    }

    private int delStudent(Long orgId, Long courseId, List<Long> lessonIds, String targetId) {
        OrgCourse orgCourse = (OrgCourse)this.orgCourseDao.getById((Serializable)courseId, new String[0]);
        if (orgCourse == null) {
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u73ed\u7ea7\u4e0d\u5b58\u5728");
        }
        if (orgCourse.getCourseType() == CourseTypeEnum.COURSE_TYPE_1v1.getCode()) {
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "1\u5bf91\u8bfe\u7a0b\u4e0d\u80fd\u5220\u9664\u5b66\u751f\uff0c\u8bf7\u4e0b\u8f7d\u65b0\u7248\u5929\u6821");
        }
        ArrayList studentIds = null;
        try {
            studentIds = (ArrayList)JacksonUtil.str2Obj((String)targetId, (TypeReference)new TypeReference<List<Long>>(){});
        }
        catch (Exception e1) {
            log.warn("json class cast exception");
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u5b66\u751fid\u8f6c\u6362\u5f02\u5e38");
        }
        if (CollectionUtils.isEmpty((Collection)studentIds)) {
            log.warn("add student ids is empty");
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u5b66\u751fid\u4e3a\u7a7a");
        }
        Map userIdMap = this.orgStudentDao.getStudentIdUserIdMap((Collection)studentIds);
        if (MapUtils.isEmpty((Map)userIdMap)) {
            log.warn("add student ids is empty");
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u5b66\u751fid\u4e3a\u7a7a");
        }
        studentIds = new ArrayList(userIdMap.values());
        List courseStudents = this.orgStudentCourseDao.getStudents(orgId, courseId, Integer.valueOf(0));
        if (!courseStudents.containsAll(studentIds)) {
            log.warn("lesson teacher:{} is not all course teacher ids:{}", studentIds, (Object)courseStudents);
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u5fc5\u987b\u4ece\u8bfe\u7a0b\u5b66\u751f\u4e2d\u5220\u9664\u8bfe\u8282\u5b66\u751f");
        }
        ArrayList statusList = Lists.newArrayList();
        statusList.add(SignStatus.SIGNED.getCode());
        statusList.add(SignStatus.LEAVE.getCode());
        statusList.add(SignStatus.ABSENT.getCode());
        HashMap<String, Object> countCondition = new HashMap<String, Object>();
        countCondition.put("orgId", orgId);
        countCondition.put("courseId", courseId);
        countCondition.put("lessonId", lessonIds);
        countCondition.put("userId", studentIds);
        countCondition.put("status", statusList);
        countCondition.put("userRole", UserRoleEnum.STUDENT.getCode());
        int count = this.orgLessonSignDao.countByCondition(countCondition, "userId", false);
        if (count > 0) {
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u5df2\u7ecf\u7b7e\u5230\u7684\u5b66\u751f\u4e0d\u80fd\u5220\u9664");
        }
        if (!studentIds.isEmpty() && !lessonIds.isEmpty()) {
            this.signupCourseLessonService.deleteStudentLessons(orgId, studentIds, lessonIds);
        } else {
            log.info("studentIds={},lessonIds={}", studentIds, lessonIds);
        }
        return this.orgStudentLessonDao.delStudentFromLesson(orgId, lessonIds, studentIds);
    }

    private void changeTeacher(Long orgId, Long courseId, List<Long> lessonIds, Long teacherId) {
        HashMap<String, List<Long>> delCondition = new HashMap<String, List<Long>>();
        delCondition.put("lessonId", lessonIds);
        int result = this.orgTeacherLessonDao.delByCondition(delCondition);
        log.info("del from org teacher lesson by lessonId:{},result:{}", lessonIds, (Object)result);
        ArrayList saveLessonTeachers = Lists.newArrayList();
        OrgTeacherLesson po = null;
        for (Long lessonId : lessonIds) {
            po = new OrgTeacherLesson();
            po.setCreateTime(new Date());
            po.setLessonId(lessonId);
            po.setOrgId(orgId);
            po.setTeacherId(teacherId);
            saveLessonTeachers.add(po);
        }
        log.info("save teachers :{} to lessonId:{}", (Object)saveLessonTeachers, lessonIds);
        this.orgTeacherLessonDao.saveAll((List)saveLessonTeachers, new String[]{"createTime", "lessonId", "orgId", "teacherId"});
        List courseTeachers = this.orgCourseTeacherDao.getTeacher(orgId, courseId);
        HashSet userIds = Sets.newHashSet();
        for (OrgCourseTeacher courseTeacher : courseTeachers) {
            userIds.add(courseTeacher.getUserId());
        }
        if (!userIds.contains(teacherId)) {
            ArrayList<Long> teacherIds = new ArrayList<Long>();
            teacherIds.add(teacherId);
            this.courseTeacherService.addTeacherToCourse(orgId, courseId, teacherIds);
        }
        ArrayList conflictList = Lists.newArrayList();
        for (Long lessonId : lessonIds) {
            OrgLessonConflict conflict = new OrgLessonConflict();
            conflict.setOrgId(orgId);
            conflict.setLessonId(lessonId);
            conflict.setTeacherId(teacherId);
            conflictList.add(conflict);
        }
        this.orgLessonConflictService.updateOrgLessonConflictForTeacherChange((List)conflictList);
    }

    private void changeClassroom(Long orgId, Long courseId, List<Long> lessonIds, Long roomId) {
        this.orgClassLessonDao.updateLessonClassRoom(orgId, lessonIds, roomId);
        List roomList = this.classRoomService.listOrgCourseRooms(orgId, courseId);
        ArrayList<Long> currentRoomIds = new ArrayList<Long>();
        for (ClassRoomDto dto : roomList) {
            currentRoomIds.add(dto.getRoomId());
        }
        if (!currentRoomIds.contains(roomId)) {
            ArrayList<Long> newCourseIds = new ArrayList<Long>();
            newCourseIds.add(roomId);
            this.classRoomService.addClassRoomCourse(orgId, courseId, newCourseIds);
        }
        for (Long lessonId : lessonIds) {
            OrgLessonConflict conflict = new OrgLessonConflict();
            conflict.setOrgId(orgId);
            conflict.setLessonId(lessonId);
            conflict.setRoomId(roomId);
            this.orgLessonConflictService.updateOrgLessonConflictForRoomOrTimeChange(conflict);
        }
    }

    private void changeTime(Long orgId, Long courseId, List<Long> lessonIds, String startTimeStr, String endTimeStr) {
        TimeStamp startTime = TimeStamp.parse((String)startTimeStr);
        TimeStamp endTime = TimeStamp.parse((String)endTimeStr);
        List list = this.orgClassLessonDao.getByIds(lessonIds, new String[0]);
        for (OrgClassLesson lesson : list) {
            Calendar cal = Calendar.getInstance();
            cal.setTime(lesson.getStartTime());
            LessonTime lessonTime = new LessonTime(cal, startTime, endTime);
            HashMap<String, Comparable<Long>> map = new HashMap<String, Comparable<Long>>();
            map.put("id", lesson.getId());
            map.put("startTime", lessonTime.getStartTime());
            map.put("endTime", lessonTime.getEndTime());
            this.orgClassLessonDao.update(map, new String[]{"startTime", "endTime"});
            OrgLessonConflict conflict = new OrgLessonConflict();
            conflict.setOrgId(orgId);
            conflict.setLessonId(lesson.getId());
            conflict.setStartTime(lessonTime.getStartTime());
            conflict.setEndTime(lessonTime.getEndTime());
            this.orgLessonConflictService.updateOrgLessonConflictForRoomOrTimeChange(conflict);
            Integer duration = DateUtil.getMinuteDiff((Date)lessonTime.getStartTime(), (Date)lessonTime.getEndTime());
            List userIds = this.orgStudentLessonDao.getUserIds(lesson.getId(), orgId);
            this.orgStudentLessonDao.batchUpdateLessonDuration((Collection)userIds, duration, lesson.getId());
            this.signupCourseLessonService.updateLessonDuration(orgId, lesson);
        }
        this.resetLessonNumber(orgId, courseId);
    }

    private void changeTime(Long orgId, Long courseId, List<Long> lessonIds, Date startTime, Date endTime) {
        List list = this.orgClassLessonDao.getByIds(lessonIds, new String[0]);
        for (OrgClassLesson lesson : list) {
            HashMap<String, Comparable<Long>> map = new HashMap<String, Comparable<Long>>();
            map.put("id", lesson.getId());
            map.put("startTime", startTime);
            map.put("endTime", endTime);
            this.orgClassLessonDao.update(map, new String[]{"startTime", "endTime"});
            OrgLessonConflict conflict = new OrgLessonConflict();
            conflict.setOrgId(orgId);
            conflict.setLessonId(lesson.getId());
            conflict.setStartTime(startTime);
            conflict.setEndTime(endTime);
            this.orgLessonConflictService.updateOrgLessonConflictForRoomOrTimeChange(conflict);
        }
        this.resetLessonNumber(orgId, courseId);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public List<Long> addClassLessonsBatchForFastSignIn(Long orgId, Long courseId, List<TimeRange> timeRangeList, Collection<Long> studentIds) {
        Preconditions.checkArgument((orgId != null && orgId > 0L ? 1 : 0) != 0, (Object)"orgId is illegal");
        Preconditions.checkArgument((courseId != null && courseId > 0L ? 1 : 0) != 0, (Object)"courseId is illegal");
        Long defaultTeacherId = 0L;
        Long defaultRoomId = 0L;
        ArrayList lessons = Lists.newArrayList();
        OrgClassLesson lesson = null;
        int i = 1;
        for (TimeRange timeRange : timeRangeList) {
            lesson = new OrgClassLesson();
            lesson.setStartTime(timeRange.getStartTime());
            lesson.setEndTime(timeRange.getEndTime());
            lesson.setCourseId(courseId);
            lesson.setCreateTime(new Date());
            lesson.setDelStatus(Integer.valueOf(DataStatus.NORMAL.getValue()));
            lesson.setLayoutId(Long.valueOf(0L));
            lesson.setRoomId(Long.valueOf(defaultRoomId != null ? defaultRoomId : 0L));
            lesson.setUpdateTime(new Date());
            lesson.setNumber(Integer.valueOf(i++));
            lesson.setOrgId(orgId);
            lessons.add(lesson);
        }
        log.info("save {} lessons into db,params:{}", (Object)lessons.size(), (Object)("courseId=" + courseId));
        this.orgClassLessonDao.saveAll((List)lessons, new String[]{"startTime", "endTime", "courseId", "createTime", "delStatus", "layoutId", "roomId", "updateTime", "orgId"});
        this.resetLessonNumber(orgId, courseId);
        ArrayList newLessonsIds = Lists.newArrayList();
        for (OrgClassLesson classLesson : lessons) {
            newLessonsIds.add(classLesson.getId());
            this.courseStudentService.addStudentToLesson(orgId, classLesson.getCourseId(), classLesson.getId(), studentIds, true);
            if (defaultTeacherId == null || defaultTeacherId <= 0L) continue;
            ArrayList tearcherIds = Lists.newArrayList();
            tearcherIds.add(defaultTeacherId);
            this.courseTeacherService.addTeacherToLesson(orgId, classLesson.getCourseId(), classLesson.getId(), (Collection)tearcherIds);
        }
        return newLessonsIds;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void batchEditLessonsForFastSignIn(FastSignInLessonsEditRequestDto dto) {
        ArrayList lessonIds = Lists.newArrayList((Object[])new Long[]{dto.getLessonId()});
        Long orgId = dto.getOrgId();
        Long courseId = dto.getCourseId();
        Long roomId = dto.getRoomId();
        Long teacherId = dto.getTeacherId();
        String startTimeStr = dto.getStartTime();
        String endTimeStr = dto.getEndTime();
        String lessonName = dto.getLessonName();
        if (CollectionUtils.isNotEmpty((Collection)lessonIds)) {
            if (roomId != null && roomId > 0L) {
                this.changeClassroom(orgId, courseId, lessonIds, roomId);
            }
            if (teacherId != null && teacherId > 0L) {
                this.changeTeacher(orgId, courseId, lessonIds, teacherId);
            }
            if (StringUtils.isNotBlank((CharSequence)startTimeStr) && StringUtils.isNotBlank((CharSequence)endTimeStr)) {
                this.changeTime(orgId, courseId, (List<Long>)lessonIds, startTimeStr, endTimeStr);
            }
            if (null != dto.getLessonName()) {
                this.orgClassLessonDao.updateLessonName(orgId, (Collection)lessonIds, lessonName);
            }
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void batchEditLessonsForFastSignIn(List<FastSignInLessonEditRequestDto> dtos) {
        log.debug("request1 is :{}", dtos);
        Long orgId = TianxiaoMContext.getOrgId().longValue();
        for (FastSignInLessonEditRequestDto dto : dtos) {
            if (dto.getRoomId() != null && dto.getRoomId() > 0L) {
                this.changeClassroom(orgId, dto.getCourseId(), Lists.newArrayList((Object[])new Long[]{dto.getLessonId()}), dto.getRoomId());
            }
            if (dto.getTeacherId() != null && dto.getTeacherId() > 0L) {
                this.changeTeacher(orgId, dto.getCourseId(), Lists.newArrayList((Object[])new Long[]{dto.getLessonId()}), dto.getTeacherId());
            }
            if (null != dto.getStartTime() && null != dto.getEndTime()) {
                this.changeTime(orgId, dto.getCourseId(), (List<Long>)Lists.newArrayList((Object[])new Long[]{dto.getLessonId()}), dto.getStartTime(), dto.getEndTime());
            }
            if (null == dto.getLessonName()) continue;
            this.orgClassLessonDao.updateLessonName(orgId, (Collection)Lists.newArrayList((Object[])new Long[]{dto.getLessonId()}), dto.getLessonName());
        }
    }

    @Override
    @Transactional(readOnly=true)
    public List<LessonResponseDto> findLessonBaseInfoByLessonIds(Long orgId, Long courseId, List<Long> lessonIds, Date startTime, Date endTime, PageDto pageDto) {
        List lessons = this.orgClassLessonDao.queryLessons(orgId, (Collection)Lists.newArrayList((Object[])new Long[]{courseId}), null, lessonIds, startTime, endTime, pageDto, Boolean.valueOf(true), new String[0]);
        return this.buildLessonBaseInfoList(orgId, lessons);
    }

    @Override
    @Transactional
    public List<LessonResponseDto> findLessonBaseInfoByEndTime(Long orgId, Long courseId, Date endTime, PageDto pageDto) {
        List lessons = this.orgClassLessonDao.queryLessonsByEndTime(orgId, (Collection)Lists.newArrayList((Object[])new Long[]{courseId}), endTime, pageDto);
        return this.buildLessonBaseInfoList(orgId, lessons);
    }

    @Override
    @Transactional(readOnly=true)
    public List<LessonResponseDto> buildLessonBaseInfoList(Long orgId, List<OrgClassLesson> lessons) {
        HashSet courseIds = Sets.newHashSet();
        HashSet roomIds = Sets.newHashSet();
        HashSet lessonIds = Sets.newHashSet();
        for (OrgClassLesson lesson : lessons) {
            courseIds.add(lesson.getCourseId());
            lessonIds.add(lesson.getId());
            if (lesson.getRoomId() == null || lesson.getRoomId() <= 0L) continue;
            roomIds.add(lesson.getRoomId());
        }
        List courseList = this.orgCourseDao.getByIds((Collection)courseIds, new String[]{"id", "name", "courseType", "status"});
        HashMap courseMap = Maps.newHashMap();
        for (OrgCourse course : courseList) {
            courseMap.put(course.getId(), course);
        }
        Map lessonTeacherIdMap = this.orgTeacherLessonDao.queryLessonTeacherIdMap(orgId, (Collection)lessonIds);
        Map teacherNameAvatarMap = this.orgTeacherApiService.getNameAndAvatarByUserIds(orgId, lessonTeacherIdMap.values());
        HashMap<Long, Object> lessonIdTeacherNameMap = new HashMap<Long, Object>(lessonTeacherIdMap.size());
        List signList = this.orgLessonSignDao.getCourseLessonSignIn(orgId, (List)Lists.newArrayList((Iterable)courseIds));
        Map studentCountMap = this.orgStudentLessonDao.queryLessonStudentCountMap(orgId, (Collection)lessonIds);
        Map courseLessonSignInCount = this.orgLessonSignDao.querySignLessonStudentCountMap(orgId, (Collection)lessonIds);
        Map courseLessonSignedCount = this.orgLessonSignDao.querySignedLessonStudentCountMap(orgId, (Collection)lessonIds);
        log.debug("sign count. signList:{}, SignInCount:{}, SignedCount:{}", new Object[]{signList.size(), courseLessonSignInCount.size(), courseLessonSignedCount.size()});
        Map lessonSignStatus = Maps.newHashMap();
        if (CollectionUtils.isNotEmpty((Collection)signList)) {
            lessonSignStatus = CollectorUtil.collectMap((Collection)signList, input -> input.getLessonId(), input -> input.getStatus());
        }
        for (Long lessonId : lessonTeacherIdMap.keySet()) {
            lessonIdTeacherNameMap.put(lessonId, ((TwoTuple)teacherNameAvatarMap.get(lessonTeacherIdMap.get(lessonId))).getFirst());
        }
        Map<Long, OrgClassRoom> lessonRoomMap = this.getOrgClassRoomMap(roomIds);
        ArrayList<LessonResponseDto> dtoList = new ArrayList<LessonResponseDto>();
        Date now = new Date();
        for (OrgClassLesson lesson : lessons) {
            Long teacherId;
            SignStatus stuSignStatus;
            H5LessonResponseDto dto = new H5LessonResponseDto();
            dto.setCourseId(lesson.getCourseId());
            OrgCourse course = (OrgCourse)courseMap.get(lesson.getCourseId());
            dto.setCourseName(course.getName());
            dto.setCourseType(course.getCourseType());
            dto.setLessonId(lesson.getId());
            dto.setLessonName(lesson.getName());
            dto.setIndex(lesson.getNumber());
            Long roomId = lesson.getRoomId();
            Integer signCount = (Integer)courseLessonSignInCount.get(lesson.getId());
            Integer inClassCount = (Integer)courseLessonSignedCount.get(lesson.getId());
            Integer studentCount = (Integer)studentCountMap.get(lesson.getId());
            dto.setTotalSignCount(signCount != null ? signCount : 0);
            dto.setSignCount(inClassCount != null ? inClassCount : 0);
            dto.setStudentCount(studentCount != null ? studentCount : 0);
            CourseSignStatus signStatus = CourseSignStatus.HAS_NOT_STARTED;
            if (now.after(lesson.getEndTime())) {
                signStatus = CourseSignStatus.NO_SIGN;
                dto.setIsOver(1);
            }
            if (now.after(lesson.getStartTime()) && now.before(lesson.getEndTime())) {
                signStatus = CourseSignStatus.SIGNING;
            }
            if ((stuSignStatus = SignStatus.getSignStatusByCode((Integer)((Integer)lessonSignStatus.get(lesson.getId())))) != null) {
                dto.setSignStatusEnum(stuSignStatus);
            } else {
                if (signCount != null && signCount > 0) {
                    signStatus = CourseSignStatus.SIGNED;
                }
                dto.setCourseSignStatusEnum(signStatus);
            }
            OrgClassRoom classRoom = lessonRoomMap.get(roomId);
            if (classRoom != null) {
                dto.setRoomId(roomId);
                dto.setRoomName(classRoom.getRoomName());
            }
            if ((teacherId = (Long)lessonTeacherIdMap.get(lesson.getId())) != null && teacherId > 0L) {
                TwoTuple tuple = (TwoTuple)teacherNameAvatarMap.get(teacherId);
                dto.setTeacherId(teacherId);
                dto.setTeacherName(tuple == null ? "" : (String)tuple.getFirst());
                dto.setTeacherAvatar(tuple == null ? null : (String)tuple.getSecond());
            }
            ((LessonResponseDto)dto).setLessonStartTime(lesson.getStartTime());
            ((LessonResponseDto)dto).setLessonEndTime(lesson.getEndTime());
            dtoList.add(dto);
        }
        return dtoList;
    }

    @Override
    @Transactional(readOnly=true)
    public LessonConflictCheckListDto lessonConflictCheck(Long orgId, LessonConflictCheckDto lessonConflictCheckDto) {
        List roomConflictList;
        int num;
        List teacherConflictList;
        PageDto pageDto = new PageDto();
        pageDto.setPageNum(Integer.valueOf(lessonConflictCheckDto.getPageNum()));
        pageDto.setPageSize(Integer.valueOf(lessonConflictCheckDto.getPageSize()));
        LessonConflictCheckListDto lessonConflictCheckListDto = new LessonConflictCheckListDto();
        Long teacherId = lessonConflictCheckDto.getTeacherId();
        Long roomId = lessonConflictCheckDto.getRoomId();
        Date startTime = lessonConflictCheckDto.getStartTimeDate();
        Date endTime = lessonConflictCheckDto.getEndTimeDate();
        Long lessonId = lessonConflictCheckDto.getLessonId();
        if (teacherId != null && teacherId > 0L && CollectionUtils.isNotEmpty((Collection)(teacherConflictList = this.orgLessonConflictService.checkTeacherConflict(orgId, teacherId, startTime, endTime, lessonId, pageDto)))) {
            num = this.orgLessonConflictService.queryTeacherConflictNum(orgId, teacherId, startTime, endTime, lessonId);
            try {
                PageDto tpageDto = (PageDto)BeanUtils.cloneBean((Object)pageDto);
                tpageDto.setCount(Integer.valueOf(num));
                lessonConflictCheckListDto.setTeacherConflictPageDto(tpageDto);
            }
            catch (Exception e) {
                throw new BussinessException((UniverseErrorCode)CommonErrorCode.SYSTEM_ERROR);
            }
            lessonConflictCheckListDto.setTeacherConflictData(this.change(teacherConflictList));
        }
        if (roomId != null && roomId > 0L && CollectionUtils.isNotEmpty((Collection)(roomConflictList = this.orgLessonConflictService.checkRoomConflict(orgId, roomId, startTime, endTime, lessonId, pageDto)))) {
            num = this.orgLessonConflictService.queryRoomConflictNum(orgId, roomId, startTime, endTime, lessonId);
            try {
                PageDto rpageDto = (PageDto)BeanUtils.cloneBean((Object)pageDto);
                rpageDto.setCount(Integer.valueOf(num));
                lessonConflictCheckListDto.setRoomConflictPageDto(rpageDto);
            }
            catch (Exception e) {
                throw new BussinessException((UniverseErrorCode)CommonErrorCode.SYSTEM_ERROR);
            }
            lessonConflictCheckListDto.setRoomConflictData(this.change(roomConflictList));
        }
        return lessonConflictCheckListDto;
    }

    @Override
    public void flushConflictData() {
        log.info("flushConflictData start load mysql data!!!!!!!!!!!!!!!!!!!!");
        List list = this.orgClassLessonDao.getflushConflictData();
        log.info("flushConflictData load mysql data finished!!!!!!!!!!!!!!!!!!!!");
        Collections.sort(list, new Comparator<OrgLessonConflict>(){

            @Override
            public int compare(OrgLessonConflict o1, OrgLessonConflict o2) {
                if (o1.getLessonId() < o2.getLessonId()) {
                    return -1;
                }
                if (o1.getLessonId() > o2.getLessonId()) {
                    return 1;
                }
                return 0;
            }
        });
        log.info("flushConflictData start lessonId :" + ((OrgLessonConflict)list.get(0)).getLessonId() + " , end lessonId:" + ((OrgLessonConflict)list.get(list.size() - 1)).getLessonId());
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            Set courseIds = BaseUtils.getPropertiesList((List)list, (String)"courseId");
            int i = 0;
            int index = 0;
            ArrayList courseList = Lists.newArrayList();
            HashSet querySet = null;
            for (Object cid : courseIds) {
                if (i == 0) {
                    querySet = Sets.newHashSet();
                }
                querySet.add(cid);
                if (++i != 10000 && ++index != courseIds.size()) continue;
                List queryCourseList = this.orgCourseDao.getByIds((Collection)querySet, new String[0]);
                courseList.addAll(queryCourseList);
                i = 0;
            }
            ConcurrentMap courseMap = Maps.newConcurrentMap();
            if (CollectionUtils.isNotEmpty((Collection)courseList)) {
                for (OrgCourse course : courseList) {
                    if (course.getIsDel().intValue() != DataStatus.NORMAL.getValue()) continue;
                    courseMap.putIfAbsent(course.getId(), course);
                }
                courseList = null;
                Iterator it = list.iterator();
                while (it.hasNext()) {
                    OrgLessonConflict conflict = (OrgLessonConflict)it.next();
                    if (courseMap.containsKey(conflict.getCourseId())) continue;
                    it.remove();
                }
                courseMap = null;
                if (CollectionUtils.isNotEmpty((Collection)list)) {
                    log.info("flushConflictData start insert mysql!!!!!!!!!!!!!!!!!!!!");
                    this.orgLessonConflictService.saveOrgLessonConflicts(list);
                    log.info("flushConflictData insert mysql finished!!!!!!!!!!!!!!!!!!!!");
                }
            }
        }
        list = null;
    }

    @Override
    @Transactional(readOnly=true)
    public List<LessonResponseDto> findLessonBaseInfoByTimeRange(Long orgId, Date startDate, Date endDate, PageDto pageDto) {
        Long number = ((OrgAccount)this.orgAccountDao.getById((Serializable)Integer.valueOf(orgId.intValue()), new String[]{"number"})).getNumber().longValue();
        List delIds = Lists.transform((List)this.orgCourseDao.getCoursesByOrgNumber(number, Integer.valueOf(DeleteStatus.DELETED.getValue()), new String[]{"id"}), (Function)new Function<OrgCourse, Long>(){

            public Long apply(OrgCourse input) {
                return input.getId();
            }
        });
        Integer cascadeId = TianxiaoMContext.getTXCascadeId();
        List<Object> lessons = new ArrayList();
        if (cascadeId != null && cascadeId > 0) {
            lessons = this.listStaffClassLessons(orgId, cascadeId, delIds, startDate, endDate, pageDto);
            if (lessons.isEmpty()) {
                return Lists.newArrayList();
            }
        } else {
            lessons = this.orgClassLessonDao.queryLessons((Collection)delIds, orgId, null, startDate, endDate, pageDto, Boolean.valueOf(true), new String[0]);
        }
        return this.buildLessonBaseInfoList(orgId, lessons);
    }

    @Override
    @Transactional(readOnly=true)
    public List<OrgClassLesson> listStaffClassLessons(Long orgId, Integer cascadeId, List<Long> delIds, Date startTime, Date endTime, PageDto pageDto) {
        TXCascadeAccount txCascadeAccount = (TXCascadeAccount)this.txCascadeAccountDao.getById((Serializable)cascadeId, new String[0]);
        if (txCascadeAccount == null) {
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u5b50\u5e10\u53f7\u4e0d\u5b58\u5728");
        }
        List lessons = new ArrayList();
        List courseIds = null;
        log.info("Param:orgId={},cascadeId={},delIds={}", new Object[]{orgId, cascadeId, delIds});
        if (txCascadeAccount.getAccountType().intValue() == CascadeType.STAFF.getValue()) {
            courseIds = this.orgCourseDao.getCourseIdsByCascadeId(cascadeId, null, CourseTypeEnum.IS_CLASS_TRUE.getCode(), null);
            if (CollectionUtils.isNotEmpty((Collection)courseIds)) {
                courseIds.removeAll(delIds);
                List masterLessons = this.orgClassLessonDao.queryLessons(delIds, orgId, (Collection)courseIds, startTime, endTime, null, Boolean.valueOf(true), new String[0]);
                lessons.addAll(masterLessons);
            }
            Long teacherId = this.teacherService.getUserIdByCascadeId(orgId, TianxiaoMContext.getTXCascadeId());
            List teacherLessons = new ArrayList();
            if (teacherId != null && teacherId > 0L) {
                teacherLessons = this.orgClassLessonDao.listTeacherLessons(teacherId.longValue(), startTime, endTime);
            }
            HashSet<Long> lessonIds = new HashSet<Long>();
            for (OrgClassLesson lesson : lessons) {
                lessonIds.add(lesson.getId());
            }
            for (OrgClassLesson lesson : teacherLessons) {
                if (lessonIds.contains(lesson.getId()) || delIds.contains(lesson.getCourseId())) continue;
                lessons.add((OrgClassLesson)lesson);
            }
            Collections.sort(lessons, new Comparator<OrgClassLesson>(){

                @Override
                public int compare(OrgClassLesson o1, OrgClassLesson o2) {
                    return o1.getStartTime().compareTo(o2.getStartTime());
                }
            });
            if (pageDto != null) {
                pageDto.setCount(Integer.valueOf(lessons.size()));
                int from = Math.min((pageDto.getPageNum() - 1) * pageDto.getPageSize(), lessons.size());
                int to = Math.min(pageDto.getPageNum() * pageDto.getPageSize(), lessons.size());
                lessons = lessons.subList(from, to);
            }
        } else {
            lessons = this.orgClassLessonDao.queryLessons(delIds, orgId, null, startTime, endTime, pageDto, Boolean.valueOf(true), new String[0]);
        }
        return lessons;
    }

    private List<LessonConflictInfoDto> change(List<OrgLessonConflict> source) {
        ArrayList dest = Lists.newArrayList();
        for (OrgLessonConflict conflict : source) {
            LessonConflictInfoDto info = new LessonConflictInfoDto();
            info.setLessonId(conflict.getLessonId());
            OrgClassLesson lesson = (OrgClassLesson)this.orgClassLessonDao.getById((Serializable)conflict.getLessonId(), new String[0]);
            info.setIndex(lesson.getNumber());
            info.setLessonEndTime(lesson.getEndTime().getTime());
            info.setLessonStartTime(lesson.getStartTime().getTime());
            OrgCourse course = (OrgCourse)this.orgCourseDao.getById((Serializable)lesson.getCourseId(), new String[0]);
            info.setCourseName(course.getName());
            dest.add(info);
        }
        return dest;
    }

    @Override
    public List<NameAndIdDto> getLessonCalendarQueryDropDownList(Long orgId, DropDownListRequestDto params) {
        List<Object> result = Lists.newArrayList();
        if (params.getReqType() == DropdownListType.TEACHER.getType()) {
            Set lessonIds;
            List lessonTeachers;
            List lessons = this.orgClassLessonDao.getOrgClassLessonByParams(null, orgId, params.getParams(), null, null);
            if (CollectionUtils.isNotEmpty((Collection)lessons) && CollectionUtils.isNotEmpty((Collection)(lessonTeachers = this.orgTeacherLessonDao.queryByLessonIds(orgId, (Collection)(lessonIds = BaseUtils.getPropertiesList((List)lessons, (String)"id")))))) {
                Set teacherIds = BaseUtils.getPropertiesList((List)lessonTeachers, (String)"teacherId");
                List teachers = this.teacherDao.fuzzyQueryByNameAndMobile(orgId, (Collection)teacherIds, params.getSearch());
                result = this.collectTeacherInfo(teachers);
            }
        } else if (params.getReqType() == DropdownListType.ROOM.getType()) {
            List<OrgClassLesson> lessons = this.getOrgLessonByParams(orgId, params.getParams());
            Set roomIds = Sets.newHashSet();
            if (CollectionUtils.isNotEmpty(lessons)) {
                roomIds = BaseUtils.getPropertiesList(lessons, (String)"roomId");
            }
            result = this.collectRoomInfo(orgId, roomIds, params.getSearch());
        } else if (params.getReqType() == DropdownListType.COURSE.getType()) {
            List<OrgClassLesson> lessons = this.getOrgLessonByParams(orgId, params.getParams());
            Set courseIds = Sets.newHashSet();
            if (CollectionUtils.isNotEmpty(lessons)) {
                courseIds = BaseUtils.getPropertiesList(lessons, (String)"courseId");
            }
            OrgAccount orgAccount = (OrgAccount)this.orgAccountDao.getById((Serializable)TianxiaoPCContext.getOrgId(), new String[0]);
            result = this.collectCourseInfo(orgAccount.getNumber(), params.getSearch(), courseIds);
        }
        return result;
    }

    private List<OrgClassLesson> getOrgLessonByParams(Long orgId, TimeTableRequestDto params) {
        List teachers;
        List lessons = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty((Collection)params.getTeacherIds()) && CollectionUtils.isNotEmpty((Collection)(teachers = this.orgTeacherLessonDao.queryTeacherLessons(orgId, (Collection)params.getTeacherIds(), new String[]{"lessonId"})))) {
            Set lessonIds = BaseUtils.getPropertiesList((List)teachers, (String)"lessonId");
            lessons = this.orgClassLessonDao.getOrgClassLessonByParams(null, orgId, params, (Collection)lessonIds, null);
        }
        return lessons;
    }

    private List<NameAndIdDto> collectTeacherInfo(List<Teacher> teachers) {
        List idAndNames = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty(teachers)) {
            idAndNames = (List)CollectionUtils.collect(teachers, (Transformer)new Transformer(){

                public Object transform(Object input) {
                    NameAndIdDto idAndName = new NameAndIdDto();
                    Teacher teacher = (Teacher)input;
                    idAndName.setId(teacher.getUserId());
                    idAndName.setName(teacher.getRealName());
                    return idAndName;
                }
            });
        }
        return idAndNames;
    }

    private List<NameAndIdDto> collectCourseInfo(Integer orgNumber, String query, Collection<Long> courseIds) {
        List idAndNames = Lists.newArrayList();
        List courses = this.orgCourseDao.fuzzyQuery(orgNumber, query, courseIds, null);
        if (CollectionUtils.isNotEmpty((Collection)courses)) {
            idAndNames = (List)CollectionUtils.collect((Collection)courses, (Transformer)new Transformer(){

                public Object transform(Object input) {
                    OrgCourse course = (OrgCourse)input;
                    NameAndIdDto idAndName = new NameAndIdDto();
                    idAndName.setId(course.getId());
                    idAndName.setName(course.getName());
                    return idAndName;
                }
            });
        }
        return idAndNames;
    }

    private List<NameAndIdDto> collectRoomInfo(Long orgId, Collection<Long> roomIds, String query) {
        List idAndNames = Lists.newArrayList();
        List rooms = this.orgClassRoomDao.getOrgClassRoomByNameAndIds(orgId, roomIds, query);
        if (CollectionUtils.isNotEmpty((Collection)rooms)) {
            idAndNames = (List)CollectionUtils.collect((Collection)rooms, (Transformer)new Transformer(){

                public Object transform(Object input) {
                    OrgClassRoom room = (OrgClassRoom)input;
                    NameAndIdDto idAndName = new NameAndIdDto();
                    idAndName.setId(room.getId());
                    idAndName.setName(room.getRoomName());
                    return idAndName;
                }
            });
        }
        return idAndNames;
    }

    @Override
    public LessonScheduleInfoDto lessonDetail(Long orgId, Long lessonId) {
        OrgClassLesson lesson = (OrgClassLesson)this.orgClassLessonDao.getById((Serializable)lessonId, new String[0]);
        if (lesson == null) {
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u8bfe\u8282\u4e0d\u5b58\u5728\u6216\u5df2\u88ab\u5220\u9664");
        }
        if (lesson.getDelStatus() == 1) {
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u8bfe\u8282\u4e0d\u5b58\u5728\u6216\u5df2\u88ab\u5220\u9664");
        }
        ArrayList lessons = Lists.newArrayList((Object[])new OrgClassLesson[]{lesson});
        ArrayList data = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty((Collection)lessons)) {
            ListLessonResponseDto ret = this.wrap(orgId, lessons);
            List<LessonResponseDto> result = ret.getList();
            LessonScheduleInfoDto item = null;
            if (CollectionUtils.isNotEmpty(result)) {
                Set roomIds = BaseUtils.getPropertiesList(result, (String)"roomId");
                Map<Long, OrgClassRoom> roomCache = this.getAndCachedClassRoom(roomIds);
                Date now = new Date();
                Set courseIds = BaseUtils.getPropertiesList(result, (String)"courseId");
                Map<Long, Integer> cache = this.getAndCachedFinishedLessonCount(orgId, courseIds);
                List recycleClassRoomIds = this.orgClassRoomDao.getRecycleRoomId(orgId, (Collection)roomIds);
                log.debug("[all class room id]=", (Object)roomIds);
                log.debug("[deleted class room id]=", (Object)recycleClassRoomIds);
                for (LessonResponseDto dto : result) {
                    OrgCourse course;
                    Long courseId = dto.getCourseId();
                    item = new LessonScheduleInfoDto();
                    item.setEndTime(dto.getLessonEndTime().getTime());
                    item.setStartTime(dto.getLessonStartTime().getTime());
                    item.setLessonId(dto.getLessonId());
                    item.setLessonName(dto.getLessonName());
                    if (recycleClassRoomIds.contains(dto.getRoomId())) {
                        if (DateUtil.compare((Date)lesson.getStartTime(), (Date)new Date())) {
                            item.setRoomId(dto.getRoomId());
                            item.setRoomName(dto.getRoomName());
                        } else {
                            item.setRoomId(null);
                            item.setRoomName(null);
                        }
                    } else {
                        item.setRoomId(dto.getRoomId());
                        item.setRoomName(dto.getRoomName());
                    }
                    item.setStudentCount(dto.getStudentCount());
                    item.setTeacherId(dto.getTeacherId());
                    item.setTeacherName(dto.getTeacherName());
                    item.setCourseId(courseId);
                    item.setCourseName(dto.getCourseName());
                    item.setTotalStudents(dto.getStudentCount());
                    item.setIndex(dto.getIndex());
                    item.setCourseType(dto.getCourseType() == null ? 0 : dto.getCourseType());
                    item.setLessonStatus(now.before(dto.getLessonStartTime()) ? LessonStatus.UN_START.getStatus() : (now.before(dto.getLessonEndTime()) ? LessonStatus.ONGOING.getStatus() : LessonStatus.FINISHED.getStatus()));
                    if (cache.containsKey(courseId)) {
                        item.setFinishedLessons(cache.get(courseId));
                    }
                    long roomId = dto.getRoomId();
                    if (roomCache.containsKey(dto.getRoomId())) {
                        item.setRoomCapacity(roomCache.containsKey(roomId) ? roomCache.get(roomId).getRoomSize() : 0);
                    }
                    if ((course = (OrgCourse)this.orgCourseDao.getById((Serializable)courseId, new String[0])).getCourseType() == CourseTypeEnum.COURSE_TYPE_1v1.getCode()) {
                        List scount = this.orgStudentCourseDao.getStudents(orgId, courseId, Integer.valueOf(0));
                        item.setStudentStatus(CollectionUtils.isEmpty((Collection)scount) ? StudentStatus.YES.getCode() : StudentStatus.NO.getCode());
                    }
                    this.wrapConflictInfo(orgId, item);
                    data.add(item);
                }
                return (LessonScheduleInfoDto)data.get(0);
            }
        }
        return null;
    }

    LessonBaseInfoDto wrap(Long orgId, OrgClassLesson lesson) {
        Long lessonId = lesson.getId();
        LessonBaseInfoDto result = new LessonBaseInfoDto();
        Long courseId = lesson.getCourseId();
        Long roomId = lesson.getRoomId();
        OrgTeacherLesson teacherLesson = this.orgTeacherLessonDao.getByLessonId(orgId, lessonId);
        this.getAndSetCourseInfo(courseId, result);
        this.getAndSetRoomInfo(roomId, result);
        result.setEndTime(lesson.getEndTime().getTime());
        result.setEndTimeStr(BaseUtils.getFormatTime((Date)lesson.getEndTime(), (String)"HH:mm"));
        result.setLessonId(lessonId);
        result.setStartTime(lesson.getStartTime().getTime());
        result.setStartTimeStr(BaseUtils.getFormatTime((Date)lesson.getStartTime(), (String)"HH:mm"));
        result.setTeacherId(teacherLesson.getTeacherId());
        result.setTeacherName(teacherLesson.getTeacherName());
        result.setDayOfWeek(DateUtil.getWeekDay((Date)lesson.getStartTime()));
        result.setDuration(this.calculateDuration(lesson.getStartTime(), lesson.getEndTime()));
        result.setTime(this.getLessonStartTime(lesson.getStartTime()));
        return result;
    }

    String getLessonStartTime(Date date) {
        StringBuffer sb = new StringBuffer();
        SimpleDateFormat sdf = new SimpleDateFormat("M\u6708d\u65e5");
        String time = sdf.format(date);
        String weekDay = DateUtil.getChineseWeekDay((Date)date);
        sb.append(time).append(" ").append("\u661f\u671f").append(weekDay);
        return sb.toString();
    }

    String calculateDuration(Date startTime, Date endTime) {
        long interval = (endTime.getTime() - startTime.getTime()) / 60000L;
        String duration = "";
        if (interval > 60L) {
            BigDecimal bg1 = new BigDecimal(interval);
            BigDecimal bg2 = new BigDecimal(interval);
            duration = bg1.divide(bg2, 1, RoundingMode.HALF_DOWN).toString() + "\u5c0f\u65f6";
        } else {
            duration = interval + "\u5206\u949f";
        }
        return duration;
    }

    void getAndSetCourseInfo(Long courseId, LessonBaseInfoDto result) {
        OrgCourse course = (OrgCourse)this.orgCourseDao.getById((Serializable)courseId, new String[]{"id", "name"});
        if (course != null) {
            result.setCourseId(course.getId());
            result.setCourseName(course.getName());
        }
    }

    void getAndSetRoomInfo(Long roomId, LessonBaseInfoDto result) {
        OrgClassRoom room = (OrgClassRoom)this.orgClassRoomDao.getById((Serializable)roomId, new String[]{"id", "roomName"});
        if (room != null) {
            result.setRoomName(room.getRoomName());
            result.setRoomId(room.getId());
        }
    }

    @Override
    public List<DayScheduleDto> getExportSchedule(Long orgId, TimeTableRequestDto params) {
        List<DayScheduleDto> data = DayScheduleDto.getWeekList(params.getStartTime());
        List<LessonScheduleInfoDto> lessonScheduleList = this.queryCourseLessonsByParams(orgId, params, null);
        if (CollectionUtils.isNotEmpty(lessonScheduleList)) {
            for (LessonScheduleInfoDto lessonInfo : lessonScheduleList) {
                LessonScheduleDto lessonDto = new LessonScheduleDto();
                lessonDto.setCourseId(lessonInfo.getCourseId());
                lessonDto.setLessonId(lessonInfo.getLessonId());
                lessonDto.setStart(lessonInfo.getStartTime());
                lessonDto.setEnd(lessonInfo.getEndTime());
                lessonDto.setCourseName(lessonInfo.getCourseName(), lessonInfo.getCourseType());
                lessonDto.setTeacherName(lessonInfo.getTeacherName());
                lessonDto.setTimeRange(lessonInfo.getStartTime(), lessonInfo.getEndTime());
                lessonDto.setClassRoom(lessonInfo.getRoomName());
                lessonDto.setStudentCount(lessonInfo.getStudentCount());
                Integer weekDay = DateUtil.getWeekDay((Date)new Date(lessonInfo.getStartTime()));
                int index = weekDay == 0 ? 7 : weekDay;
                DayScheduleDto dayScheduleDto = data.get(index - 1);
                dayScheduleDto.getLessons().add(lessonDto);
            }
            for (DayScheduleDto daySchedule : data) {
                List<LessonScheduleDto> lessons = daySchedule.getLessons();
                if (!CollectionUtils.isNotEmpty(lessons)) continue;
                daySchedule.setLessonCount(lessons.size());
                Collections.sort(lessons, new Comparator<LessonScheduleDto>(){

                    @Override
                    public int compare(LessonScheduleDto o1, LessonScheduleDto o2) {
                        int startDiff = new Long(o1.getStart() - o2.getStart()).intValue();
                        if (startDiff < 0 || startDiff > 0) {
                            return startDiff;
                        }
                        int endDiff = new Long(o1.getEnd() - o2.getEnd()).intValue();
                        return endDiff;
                    }
                });
            }
        }
        return data;
    }

    @Override
    public void exportSchedule(HttpServletRequest request, HttpServletResponse response, Long orgId, TimeTableRequestDto params) {
        List<DayScheduleDto> data = this.getExportSchedule(orgId, params);
        String fileName = data.get(0).getDate() + "~" + data.get(data.size() - 1).getDate() + "\u8bfe\u8868.xlsx";
        SXSSFWorkbook workbook = null;
        try {
            workbook = new SXSSFWorkbook(200);
            HashMap<String, CellStyle> cellStyleMap = new HashMap<String, CellStyle>();
            ArrayList exportFields = Lists.newArrayList();
            for (DayScheduleDto dayScheduleDto : data) {
                exportFields.add(new ExportField(dayScheduleDto.getHeader(), "@", 5500));
            }
            ExcelCourseExportService.createScheduleSheet((Workbook)workbook, "\u8bfe\u8868", cellStyleMap, exportFields, data);
            ExcelCourseExportService.exportExcel(request, response, (Workbook)workbook, fileName);
            log.debug("course lesson export success");
        }
        catch (Exception e) {
            log.error("export catch exception:", (Throwable)e);
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u5bfc\u51fa\u6570\u636e\u5904\u7406\u5f02\u5e38");
        }
        finally {
            try {
                workbook.close();
            }
            catch (IOException var19) {
                log.error("close workbook catch error:", (Throwable)var19);
            }
        }
    }
}

