/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.biz.erp.dto.response.exportCourse;

import com.baijia.tianxiao.biz.erp.dto.response.exportCourse.LessonScheduleDto;
import com.baijia.tianxiao.util.date.DateUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.joda.time.LocalDate;

public class DayScheduleDto {
    private String week;
    private String date;
    private String header;
    private int lessonCount;
    private List<LessonScheduleDto> lessons;

    public static List<DayScheduleDto> getWeekList(Long time) {
        ArrayList<DayScheduleDto> list = new ArrayList<DayScheduleDto>();
        Date monday = new LocalDate((Object)time).dayOfWeek().withMinimumValue().toDate();
        int index = 0;
        do {
            Date temp = DateUtil.getDiffDateTime((Date)monday, (int)index);
            String weekDay = DateUtil.getChineseWeekDay((Date)temp);
            DayScheduleDto dto = new DayScheduleDto();
            dto.setWeek("\u5468" + weekDay);
            dto.setDate(DateUtil.getStrByDateFormate((Date)temp, (String)"MM.dd"));
            dto.setHeader(dto.getWeek() + " (" + dto.getDate() + ")");
            ArrayList<LessonScheduleDto> lessonList = new ArrayList<LessonScheduleDto>();
            dto.setLessons(lessonList);
            list.add(dto);
        } while (++index < 7);
        return list;
    }

    public static void main(String[] args) {
        Date today = new Date();
        List<DayScheduleDto> list = DayScheduleDto.getWeekList(today.getTime());
        for (DayScheduleDto dto : list) {
            System.out.println(dto);
        }
        String fileName = list.get(0).getDate() + " ~ " + list.get(list.size() - 1).getDate() + "\u8bfe\u8868.xlsx";
        System.out.println(fileName);
    }

    public String getWeek() {
        return this.week;
    }

    public String getDate() {
        return this.date;
    }

    public String getHeader() {
        return this.header;
    }

    public int getLessonCount() {
        return this.lessonCount;
    }

    public List<LessonScheduleDto> getLessons() {
        return this.lessons;
    }

    public void setWeek(String week) {
        this.week = week;
    }

    public void setDate(String date) {
        this.date = date;
    }

    public void setHeader(String header) {
        this.header = header;
    }

    public void setLessonCount(int lessonCount) {
        this.lessonCount = lessonCount;
    }

    public void setLessons(List<LessonScheduleDto> lessons) {
        this.lessons = lessons;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DayScheduleDto)) {
            return false;
        }
        DayScheduleDto other = (DayScheduleDto)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$week = this.getWeek();
        String other$week = other.getWeek();
        if (this$week == null ? other$week != null : !this$week.equals(other$week)) {
            return false;
        }
        String this$date = this.getDate();
        String other$date = other.getDate();
        if (this$date == null ? other$date != null : !this$date.equals(other$date)) {
            return false;
        }
        String this$header = this.getHeader();
        String other$header = other.getHeader();
        if (this$header == null ? other$header != null : !this$header.equals(other$header)) {
            return false;
        }
        if (this.getLessonCount() != other.getLessonCount()) {
            return false;
        }
        List<LessonScheduleDto> this$lessons = this.getLessons();
        List<LessonScheduleDto> other$lessons = other.getLessons();
        return !(this$lessons == null ? other$lessons != null : !((Object)this$lessons).equals(other$lessons));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DayScheduleDto;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $week = this.getWeek();
        result = result * 59 + ($week == null ? 43 : $week.hashCode());
        String $date = this.getDate();
        result = result * 59 + ($date == null ? 43 : $date.hashCode());
        String $header = this.getHeader();
        result = result * 59 + ($header == null ? 43 : $header.hashCode());
        result = result * 59 + this.getLessonCount();
        List<LessonScheduleDto> $lessons = this.getLessons();
        result = result * 59 + ($lessons == null ? 43 : ((Object)$lessons).hashCode());
        return result;
    }

    public String toString() {
        return "DayScheduleDto(week=" + this.getWeek() + ", date=" + this.getDate() + ", header=" + this.getHeader() + ", lessonCount=" + this.getLessonCount() + ", lessons=" + this.getLessons() + ")";
    }
}

