/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.biz.erp.assignment.impl;

import com.baijia.tianxiao.biz.erp.assignment.AssignmentService;
import com.baijia.tianxiao.biz.erp.dto.AssignmentClassInfoDto;
import com.baijia.tianxiao.biz.erp.dto.AssignmentClassStudentDto;
import com.baijia.tianxiao.biz.erp.dto.AssignmentStudentDto;
import com.baijia.tianxiao.biz.erp.dto.AssignmentStudentInfoDto;
import com.baijia.tianxiao.biz.erp.dto.UserInfoDto;
import com.baijia.tianxiao.dal.enums.CourseTypeEnum;
import com.baijia.tianxiao.dal.org.dao.OrgAccountDao;
import com.baijia.tianxiao.dal.org.dao.OrgCourseDao;
import com.baijia.tianxiao.dal.org.dao.OrgStudentCourseDao;
import com.baijia.tianxiao.dal.org.dao.OrgStudentDao;
import com.baijia.tianxiao.dal.org.po.OrgAccount;
import com.baijia.tianxiao.dal.org.po.OrgCourse;
import com.baijia.tianxiao.dal.org.po.OrgStudent;
import com.baijia.tianxiao.dal.org.po.OrgStudentCourse;
import com.baijia.tianxiao.enums.StudentCourseStatus;
import com.baijia.tianxiao.sal.common.api.OrgStudentApiService;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Service;

@Service
public class AssignmentServiceImpl
implements AssignmentService {
    private static final Logger log = LoggerFactory.getLogger(AssignmentServiceImpl.class);
    @Resource
    private OrgAccountDao orgAccountDao;
    @Resource
    private OrgCourseDao orgCourseDao;
    @Resource
    private OrgStudentDao orgStudentDao;
    @Resource
    private OrgStudentCourseDao orgStudentCourseDao;
    @Resource
    private OrgStudentApiService orgStudentApiService;
    @Resource
    private StringRedisTemplate redisTemplate;

    @Override
    public List<AssignmentClassInfoDto> getClassInfos(Long orgId, Long cascadeId, Integer userRole, String classIds, String className) {
        log.debug("[getClassInfos] orgId={},cascadeId={},userRole={},classIds={}", new Object[]{orgId, cascadeId, userRole, classIds});
        OrgAccount org = this.orgAccountDao.getAccountById(orgId.intValue(), new String[]{"number"});
        if (org == null) {
            throw new IllegalArgumentException("\u673a\u6784id\u4e0d\u6b63\u786e");
        }
        List<Long> classIdList = this.getClassIds(classIds);
        List courses = this.orgCourseDao.getCourseList(Long.valueOf(org.getNumber().longValue()), classIdList, className, null, null, null, null, CourseTypeEnum.IS_CLASS_TRUE.getCode(), null, null, new String[0]);
        return AssignmentClassInfoDto.bulidClassInfos(courses);
    }

    private List<Long> getClassIds(String classIds) {
        if (StringUtils.isEmpty((CharSequence)classIds)) {
            return null;
        }
        ArrayList result = Lists.newArrayList();
        for (String s : classIds.split(",")) {
            result.add(Long.parseLong(s));
        }
        return result;
    }

    @Override
    public List<AssignmentStudentInfoDto> getStudentInfos(Long orgId, Long cascadeId, Integer userRole, String studentIds, Long classId) {
        log.debug("[getStudentInfos] orgId={},cascadeId={},userRole={},studentIds={},classId={}", new Object[]{orgId, cascadeId, userRole, studentIds, classId});
        Preconditions.checkArgument((orgId != null && orgId > 0L ? 1 : 0) != 0, (Object)"\u673a\u6784id\u4e0d\u6b63\u786e");
        List<Long> userIds = this.getUserIds(orgId, studentIds, classId);
        log.debug("userIds={}", userIds);
        if (CollectionUtils.isEmpty(userIds)) {
            return Collections.EMPTY_LIST;
        }
        List students = this.orgStudentDao.getStudentByUserIds(orgId, userIds, new String[0]);
        Map studentAvatarUrlMap = this.orgStudentApiService.batchGetStudentAvatarUrl((Collection)students);
        return this.bulidStudentInfos(students, studentAvatarUrlMap);
    }

    private List<Long> getUserIds(Long orgId, String studentIds, Long classId) {
        List<Long> userIds = Lists.newArrayList();
        if (StringUtils.isNotEmpty((CharSequence)studentIds)) {
            String[] ids;
            for (String id : ids = studentIds.split(",")) {
                userIds.add(Long.parseLong(id));
            }
        }
        if (classId != null) {
            userIds = this.orgStudentCourseDao.getStudents(orgId, classId, Integer.valueOf(StudentCourseStatus.NORMAL.getCode()));
        }
        return userIds;
    }

    private List<AssignmentStudentInfoDto> bulidStudentInfos(List<OrgStudent> students, Map<Long, String> studentAvatarUrlMap) {
        ArrayList result = Lists.newArrayList();
        for (OrgStudent student : students) {
            AssignmentStudentInfoDto dto = new AssignmentStudentInfoDto();
            dto.setId(student.getId());
            dto.setName(student.getName());
            String url = studentAvatarUrlMap.get(student.getId());
            dto.setHeadUrl(url);
            dto.setWechatOpenId(student.getWeixin());
            dto.setMobile(student.getMobile());
            result.add(dto);
        }
        return result;
    }

    @Override
    public List<AssignmentClassStudentDto> getClassStudent(Long orgId) {
        OrgAccount org = this.orgAccountDao.getAccountById(orgId.intValue(), new String[]{"number"});
        if (org == null) {
            throw new IllegalArgumentException("\u673a\u6784id\u4e0d\u6b63\u786e");
        }
        List courses = this.orgCourseDao.getCoursesByCascadeIds(Long.valueOf(org.getNumber().longValue()), null, null, null, null, CourseTypeEnum.IS_CLASS_TRUE.getCode(), null);
        if (CollectionUtils.isEmpty((Collection)courses)) {
            return Collections.EMPTY_LIST;
        }
        List<Long> courseIds = this.getAllClassId(courses);
        Map classStudentMap = this.orgStudentCourseDao.getStudentMapBycourseIds(courseIds, StudentCourseStatus.NORMAL.getCode(), new String[0]);
        return this.buildClassStudent(courses, classStudentMap);
    }

    private List<Long> getAllClassId(List<OrgCourse> courses) {
        ArrayList ids = Lists.newArrayList();
        for (OrgCourse c : courses) {
            ids.add(c.getId());
        }
        return ids;
    }

    private List<AssignmentClassStudentDto> buildClassStudent(List<OrgCourse> courses, Map<Long, List<OrgStudentCourse>> classStudentMap) {
        ArrayList list = Lists.newArrayList();
        for (OrgCourse c : courses) {
            AssignmentClassStudentDto dto = new AssignmentClassStudentDto();
            dto.setId(c.getId());
            dto.setName(c.getName());
            List<OrgStudentCourse> students = classStudentMap.get(c.getId());
            if (CollectionUtils.isNotEmpty(students)) {
                dto.setCount(students.size());
                for (OrgStudentCourse s : students) {
                    AssignmentStudentDto student = new AssignmentStudentDto();
                    student.setId(s.getId());
                    student.setName(s.getStudentName());
                    dto.getStudents().add(student);
                }
                continue;
            }
            dto.setCount(0);
        }
        return list;
    }

    @Override
    public UserInfoDto getChangedStudent(UserInfoDto dto) {
        log.debug("-------------------------[key]={}", (Object)dto);
        int count = 0;
        OrgStudent student = (OrgStudent)this.orgStudentDao.getById((Serializable)dto.getUserId(), new String[0]);
        Map studentAvatarUrlMap = this.orgStudentApiService.batchGetStudentAvatarUrl((Collection)Lists.newArrayList((Object[])new OrgStudent[]{student}));
        String head = (String)studentAvatarUrlMap.get(student.getId());
        if (!student.getMobile().equals(dto.getUserMobile())) {
            dto.setUserMobile(student.getMobile());
            ++count;
        }
        if (!head.equals(dto.getHeadUrl())) {
            dto.setHeadUrl(head);
            ++count;
        }
        if (!student.getName().equals(dto.getUserName())) {
            dto.setUserName(student.getName());
            ++count;
        }
        if (count == 0) {
            return null;
        }
        return dto;
    }
}

