package com.baijia.tianxiao.biz.erp.sync.impl;

import com.baijia.tianxiao.biz.erp.sync.SyncErpService;
import com.baijia.tianxiao.dal.org.dao.OrgAccountDao;
import com.baijia.tianxiao.dal.org.po.OrgAccount;
import com.baijia.tianxiao.sal.course.service.OrgCourseService;
import com.baijia.tianxiao.sal.organization.org.service.TXAccountService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * Created by wengshengli on 2017/7/25.
 */
@Service("syncAccountService")
@Slf4j
public class SyncDataServiceImpl implements SyncErpService {

    @Autowired
    private TXAccountService txAccountService;

    @Autowired
    private OrgAccountDao orgAccountDao;

    @Autowired
    private OrgCourseService orgCourseService;

    @Override
    public void sync() {
        List<Long> allOrgId = txAccountService.getAllTxAccountOrgId();
        log.info("alll tx account size is = {}", allOrgId.size());

        for (Long orgId : allOrgId) {
            OrgAccount orgaccount = orgAccountDao.getAccountById(orgId.intValue());
            if (orgaccount != null) {
                orgCourseService.batchChangeStatus(orgaccount.getNumber().longValue(), null);
            }
        }

    }
}
