package com.baijia.tianxiao.biz.erp.service.impl;

import com.baijia.tianxiao.biz.erp.constant.UCStudentFeedType;
import com.baijia.tianxiao.biz.erp.dto.response.studentCenter.LessonCommentFeed;
import com.baijia.tianxiao.biz.erp.dto.response.studentCenter.LessonSignFeed;
import com.baijia.tianxiao.biz.erp.dto.response.studentCenter.SignupCourseFeed;
import com.baijia.tianxiao.biz.erp.dto.response.studentCenter.StudentCommentFeed;
import com.baijia.tianxiao.biz.erp.dto.response.studentCenter.SystemDefaultFeed;
import com.baijia.tianxiao.biz.erp.dto.response.studentCenter.UCStudentFeed;
import com.baijia.tianxiao.biz.erp.service.UCStudentService;
import com.baijia.tianxiao.consants.UserRole;
import com.baijia.tianxiao.constant.Flag;
import com.baijia.tianxiao.constant.SignStatus;
import com.baijia.tianxiao.dal.comment.dao.OrgLessonCommentDao;
import com.baijia.tianxiao.dal.comment.po.OrgLessonComment;
import com.baijia.tianxiao.dal.constant.ChargeUnit;
import com.baijia.tianxiao.dal.org.constant.StudentType;
import com.baijia.tianxiao.dal.org.dao.OrgClassLessonDao;
import com.baijia.tianxiao.dal.org.dao.OrgCourseDao;
import com.baijia.tianxiao.dal.org.dao.OrgLessonSignDao;
import com.baijia.tianxiao.dal.org.dao.OrgStorageDao;
import com.baijia.tianxiao.dal.org.dao.OrgStudentDao;
import com.baijia.tianxiao.dal.org.dao.OrgTeacherLessonDao;
import com.baijia.tianxiao.dal.org.dao.TXCascadeCredentialDao;
import com.baijia.tianxiao.dal.org.po.OrgClassLesson;
import com.baijia.tianxiao.dal.org.po.OrgCourse;
import com.baijia.tianxiao.dal.org.po.OrgLessonSign;
import com.baijia.tianxiao.dal.org.po.OrgStorage;
import com.baijia.tianxiao.dal.org.po.OrgStudent;
import com.baijia.tianxiao.dal.org.po.TXCascadeCredential;
import com.baijia.tianxiao.dal.roster.dao.TxStudentCommentDao;
import com.baijia.tianxiao.dal.roster.po.TxStudentComment;
import com.baijia.tianxiao.dal.signup.constant.SignupCourseStatus;
import com.baijia.tianxiao.dal.signup.dao.OrgSignupCourseDao;
import com.baijia.tianxiao.dal.signup.po.OrgSignupCourse;
import com.baijia.tianxiao.sal.common.api.OrgStudentApiService;
import com.baijia.tianxiao.sal.common.api.OrgTeacherApiService;
import com.baijia.tianxiao.sal.organization.org.dto.OrgInfoSimpleDto;
import com.baijia.tianxiao.sal.organization.org.service.OrgInfoService;
import com.baijia.tianxiao.sal.student.api.OrgStudentCommentService;
import com.baijia.tianxiao.sal.student.dto.CommentInfoDto;
import com.baijia.tianxiao.util.TwoTuple;
import com.baijia.tianxiao.util.collection.CollectorUtil;
import com.baijia.tianxiao.util.json.JacksonUtil;
import com.baijia.tianxiao.util.storage.StorageUtil;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;

import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.io.IOException;
import java.text.DecimalFormat;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

import lombok.extern.slf4j.Slf4j;

/**
 * @author weihongyan
 * @implNote <(▰˘◡˘▰)>
 * @since 30/08/2017 8:22 PM
 */
@Slf4j
@Service
public class UCStudentServiceImpl implements UCStudentService {

    @Autowired
    private TxStudentCommentDao txStudentCommentDao;

    @Autowired
    private OrgLessonCommentDao orgLessonCommentDao;

    @Autowired
    private OrgLessonSignDao orgLessonSignDao;

    @Autowired
    private OrgSignupCourseDao orgSignupCourseDao;

    @Autowired
    private OrgStudentDao orgStudentDao;

    @Autowired
    private OrgInfoService orgInfoService;

    @Autowired
    private OrgStudentCommentService orgStudentCommentService;

    @Autowired
    private OrgClassLessonDao orgClassLessonDao;

    @Autowired
    private OrgCourseDao orgCourseDao;

    @Autowired
    private TXCascadeCredentialDao txCascadeCredentialDao;

    @Autowired
    private OrgTeacherApiService orgTeacherApiService;

    @Autowired
    private OrgTeacherLessonDao orgTeacherLessonDao;

    @Autowired
    private OrgStudentApiService orgStudentApiService;

    @Autowired
    private OrgStorageDao orgStorageDao;

    private static final String SIGN_CONTENT_TEMPLATE = "%s同学，您的【%s】课程%s！";
    private static final String SIGNUP_CONTENT_TEMPLATE = "%s同学，您的【%s】课程报名成功！";
    private static final String SYSTEM_CONTENT_TEMPLATE = "%s同学，欢迎加入%s！";

    @Override
    public List<UCStudentFeed> getAllFeedsCatalog(Long orgId, Long studentId, Long userId) {
        List<UCStudentFeed> result = Lists.newArrayList();
        result.addAll(getLessonSignFeedsCatalog(orgId, studentId, userId));
        result.addAll(getLessonCommentFeedsCatalog(orgId, studentId, userId));
        result.addAll(getStudentCommentFeedsCatalog(orgId, studentId, userId));
        result.addAll(getSignupCourseFeedsCatalog(orgId, studentId, userId));
        Collections.sort(result, Comparator.comparing(UCStudentFeed::getCreateTime).reversed());

        // 系统通知 最后一条
        OrgStudent orgStudent = orgStudentDao.getById(studentId, "id", "createTime");
        UCStudentFeed feed = new UCStudentFeed();
        feed.setId(orgStudent.getId());
        feed.setCreateTime(orgStudent.getCreateTime());
        feed.setType(UCStudentFeedType.SYSTEM_NOTICE.getType());
        result.add(feed);
        return result;
    }

    private List<UCStudentFeed> getSignupCourseFeedsCatalog(Long orgId, Long studentId, Long userId) {
        List<OrgSignupCourse> signupCourses = orgSignupCourseDao.getByCourseIdAndStudentId(orgId, userId, null,
            SignupCourseStatus.VALIDATE_STATS, "id", "createTime");
        List<UCStudentFeed> result = Lists.newArrayList();
        for (OrgSignupCourse signupCourse : signupCourses) {
            UCStudentFeed feed = new UCStudentFeed();
            feed.setId(signupCourse.getId());
            feed.setCreateTime(signupCourse.getCreateTime());
            feed.setType(UCStudentFeedType.SIGNUP_COURSE.getType());
            result.add(feed);
        }
        log.info("[UCStudentFeed] find signup course feeds size:{} ", result.size());
        return result;
    }

    private List<UCStudentFeed> getLessonSignFeedsCatalog(Long orgId, Long studentId, Long userId) {
        List<OrgLessonSign> signs =
            orgLessonSignDao.listByUserAndStatus(orgId, userId, SignStatus.OPERATED_STATUS, null, "id", "updateTime");
        List<UCStudentFeed> result = Lists.newArrayList();
        for (OrgLessonSign sign : signs) {
            UCStudentFeed feed = new UCStudentFeed();
            feed.setId(sign.getId());
            feed.setCreateTime(sign.getUpdateTime());
            feed.setType(UCStudentFeedType.LESSON_SIGN.getType());
            result.add(feed);
        }
        log.info("[UCStudentFeed] find lesson sign feeds size:{} ", result.size());
        return result;
    }

    private List<UCStudentFeed> getLessonCommentFeedsCatalog(Long orgId, Long studentId, Long userId) {
        List<UCStudentFeed> result = Lists.newArrayList();
        List<OrgLessonComment> sendComments =
            orgLessonCommentDao.getStudentComments(orgId, userId, null, null, "id", "createTime");
        for (OrgLessonComment comment : sendComments) {
            UCStudentFeed feed = new UCStudentFeed();
            feed.setId(comment.getId());
            feed.setCreateTime(comment.getCreateTime());
            feed.setType(UCStudentFeedType.LESSON_SEND_COMMENT.getType());
            result.add(feed);
        }
        List<OrgLessonComment> recieveComment =
            orgLessonCommentDao.getTeacherCommentsOfStudent(orgId, userId, null, null, "id", "createTime");
        for (OrgLessonComment comment : recieveComment) {
            UCStudentFeed feed = new UCStudentFeed();
            feed.setId(comment.getId());
            feed.setCreateTime(comment.getCreateTime());
            feed.setType(UCStudentFeedType.LESSON_RECIEVE_COMMENT.getType());
            result.add(feed);
        }
        log.info("[UCStudentFeed] find lesson comment feeds size:{} ", result.size());
        return result;
    }

    private List<UCStudentFeed> getStudentCommentFeedsCatalog(Long orgId, Long studentId, Long userId) {
        List<TxStudentComment> comments =
            this.txStudentCommentDao.getCommentList(userId, orgId, StudentType.ORG_STUDENTS.getCode(), null,
                Flag.TRUE.getInt(), true, null, "id", "createTime", "type", "isSystem");

        List<UCStudentFeed> result = Lists.newArrayList();

        for (TxStudentComment comment : comments) {
            UCStudentFeed feed = new UCStudentFeed();
            feed.setId(comment.getId());
            feed.setCreateTime(comment.getCreateTime());
            feed.setType(UCStudentFeedType.STUDENT_COMMENT_GROWTH_DOC.getType());
            result.add(feed);
        }
        log.info("[UCStudentFeed] find student comment feeds size:{} ", result.size());
        return result;
    }

    @Override
    public List<UCStudentFeed> getRichFeedsByCatalog(Long orgId, Long studentId, Long userId,
        List<UCStudentFeed> feedsCatalog) {
        if (CollectionUtils.isEmpty(feedsCatalog)) {
            return Lists.newArrayList();
        }
        // 分类id
        List<Long> signIds = Lists.newArrayList();
        List<Long> signupIds = Lists.newArrayList();
        List<Long> lessonCommentIds = Lists.newArrayList();
        List<Long> growthDocIds = Lists.newArrayList();
        for (UCStudentFeed feed : feedsCatalog) {
            UCStudentFeedType type = UCStudentFeedType.getEnumByType(feed.getType());
            if (type == UCStudentFeedType.LESSON_SIGN) {
                signIds.add(feed.getId());
            } else if (type == UCStudentFeedType.SIGNUP_COURSE) {
                signupIds.add(feed.getId());
            } else if (type == UCStudentFeedType.STUDENT_COMMENT_GROWTH_DOC) {
                growthDocIds.add(feed.getId());
            } else if (type == UCStudentFeedType.LESSON_SEND_COMMENT
                || type == UCStudentFeedType.LESSON_RECIEVE_COMMENT) {
                lessonCommentIds.add(feed.getId());
            }
        }

        // 获取原始数据
        List<OrgLessonSign> signs = orgLessonSignDao.getByIds(signIds);
        List<OrgSignupCourse> signups = orgSignupCourseDao.getByIds(signupIds);
        List<OrgLessonComment> orgLessonComments = orgLessonCommentDao.getByIds(lessonCommentIds);
        List<TxStudentComment> growthDocs = txStudentCommentDao.getByIds(growthDocIds);
        OrgStudent orgStudent = orgStudentDao.getById(studentId);
        OrgInfoSimpleDto orgInfo = orgInfoService.getMOrgInfo(orgId);

        // 抽取公共id
        Set<Long> courseIds = Sets.newHashSet();
        Set<Long> lessonIds = Sets.newHashSet();
        Set<Long> teacherUserIds = Sets.newHashSet();
        Set<Integer> cascadeIds = Sets.newHashSet();
        signs.stream().forEach(a -> {
            courseIds.add(a.getCourseId());
            lessonIds.add(a.getLessonId());
            if (a.getTeacherId() > 0) {
                teacherUserIds.add(a.getTeacherId().longValue());
            }
            if (a.getCascadeId() > 0) {
                cascadeIds.add(a.getCascadeId().intValue());
            }
        });
        signups.stream().forEach(a -> courseIds.add(a.getClassId()));
        orgLessonComments.stream().forEach(a -> {
            courseIds.add(a.getCourseId());
            lessonIds.add(a.getLessonId());
            teacherUserIds.add(a.getFromId());
            teacherUserIds.add(a.getToId());
        });

        // 获取公共data
        Map<Long, Long> lessonTeacherMap = orgTeacherLessonDao.queryLessonTeacherIdMap(orgId, lessonIds);
        teacherUserIds.addAll(lessonTeacherMap.values());
        Map<Long, OrgCourse> courseMap = CollectorUtil.collectMap(orgCourseDao.getByIds(courseIds), a -> a.getId());
        Map<Long, OrgClassLesson> lessonMap =
            CollectorUtil.collectMap(orgClassLessonDao.getByIds(lessonIds), a -> a.getId());
        Map<Integer, TXCascadeCredential> cascadeMap = txCascadeCredentialDao.getTxCascadeNameAndAvatar(cascadeIds);
        Map<Long, TwoTuple<String, String>> teacherMap =
            orgTeacherApiService.getNameAndAvatarByUserIds(orgId, teacherUserIds);

        // 搞data
        Map<Long, UCStudentFeed> growthDocFeedMap = getGrowthDocFeedMap(orgId, growthDocs);
        Map<Long, UCStudentFeed> signFeedMap =
            getSignFeedMap(orgStudent, orgInfo, signs, courseMap, lessonMap, cascadeMap, teacherMap, lessonTeacherMap);
        Map<Long, UCStudentFeed> signupFeedMap = getSignupFeedMap(orgStudent, orgInfo, signups, courseMap);
        Map<Long, UCStudentFeed> lessonCommentFeedMap =
            getLessonCommentFeedMap(orgStudent, orgLessonComments, teacherMap);

        // 返回数据
        List<UCStudentFeed> result = Lists.newArrayList();
        for (UCStudentFeed catalog : feedsCatalog) {
            UCStudentFeedType type = UCStudentFeedType.getEnumByType(catalog.getType());
            if (type == UCStudentFeedType.STUDENT_COMMENT_GROWTH_DOC) {
                result.add(growthDocFeedMap.get(catalog.getId()));
            } else if (type == UCStudentFeedType.LESSON_SIGN) {
                result.add(signFeedMap.get(catalog.getId()));
            } else if (type == UCStudentFeedType.LESSON_RECIEVE_COMMENT
                || type == UCStudentFeedType.LESSON_SEND_COMMENT) {
                result.add(lessonCommentFeedMap.get(catalog.getId()));
            } else if (type == UCStudentFeedType.SIGNUP_COURSE) {
                result.add(signupFeedMap.get(catalog.getId()));
            } else if (type == UCStudentFeedType.SYSTEM_NOTICE) {
                SystemDefaultFeed feed = new SystemDefaultFeed();
                feed.setId(orgStudent.getId());
                feed.setCreateTime(orgStudent.getCreateTime());
                feed.setType(UCStudentFeedType.SYSTEM_NOTICE.getType());
                SystemDefaultFeed.DefaultData data = new SystemDefaultFeed.DefaultData();
                data.setOpName(orgInfo.getContacts());
                data.setCreateTime(orgStudent.getCreateTime());
                data.setOpAvatar(orgInfo.getLogo());
                data.setContent(
                    String.format(SYSTEM_CONTENT_TEMPLATE, orgStudent.getNotEmptyName(), orgInfo.getShortName()));
                feed.setData(data);
                result.add(feed);
            }
        }
        return result;
    }

    private Map<Long, UCStudentFeed> getLessonCommentFeedMap(OrgStudent orgStudent,
        List<OrgLessonComment> orgLessonComments, Map<Long, TwoTuple<String, String>> teacherMap) {
        Map<Long, UCStudentFeed> result = Maps.newHashMap();
        Map<Long, String> studentAvatarMap =
            orgStudentApiService.batchGetStudentAvatarUrl(Lists.newArrayList(orgStudent));
        for (OrgLessonComment comment : orgLessonComments) {
            LessonCommentFeed feed = new LessonCommentFeed();
            feed.setId(comment.getId());
            feed.setCreateTime(comment.getCreateTime());
            LessonCommentFeed.CommentData data = new LessonCommentFeed.CommentData();
            if (comment.getUserRole() == UserRole.STUDENT.getRole()) {
                feed.setType(UCStudentFeedType.LESSON_SEND_COMMENT.getType());
                data.setOpName(orgStudent.getName());
                data.setOpAvatar(studentAvatarMap.get(orgStudent.getId()));
            } else if (comment.getUserRole() == UserRole.TEACHER.getRole()) {
                feed.setType(UCStudentFeedType.LESSON_RECIEVE_COMMENT.getType());
                TwoTuple<String, String> teacher = teacherMap.get(comment.getFromId());
                data.setOpName(teacher.getFirst());
                data.setOpAvatar(teacher.getSecond());
            }
            data.setLessonId(comment.getLessonId());
            data.setCreateTime(comment.getCreateTime());
            data.setContent(comment.getContent());
            data.setCustomFastComment(comment.getCustomFastComment());
            if (StringUtils.isNotBlank(comment.getStorageIds())) {
                try {
                    List<Long> storageIds = JacksonUtil.str2List("[" + comment.getStorageIds() + "]", Long.TYPE);
                    Map<Long, OrgStorage> storageMap = orgStorageDao.getOrgStorageMapByIds(storageIds);
                    for (Iterator<Long> it = storageMap.keySet().iterator(); it.hasNext();) {
                        Long key = it.next();
                        OrgStorage storage = storageMap.get(key);
                        data.getPicUrls()
                            .add(StorageUtil.constructUrl(storage.getFid(), storage.getSn(), storage.getMimeType()));
                    }
                } catch (IOException e) {
                    log.error("error:{} ", e);
                }
            }
            data.setSoundLength(comment.getSoundLength());
            if (null != comment.getSoundId() && comment.getSoundId() > 0){
                OrgStorage orgStorage = orgStorageDao.getById(comment.getSoundId());
                data.setSoundLink(StorageUtil.constructUrl(orgStorage.getFid(), orgStorage.getSn(), orgStorage.getMimeType()));
            }
            data.setStarScore(comment.getStarScore());
            feed.setData(data);
            result.put(feed.getId(), feed);
        }
        return result;
    }

    private Map<Long, UCStudentFeed> getSignupFeedMap(OrgStudent orgStudent, OrgInfoSimpleDto orgInfo,
        List<OrgSignupCourse> signups, Map<Long, OrgCourse> courseMap) {
        Map<Long, UCStudentFeed> result = Maps.newHashMap();
        for (OrgSignupCourse signupCourse : signups) {
            SignupCourseFeed feed = new SignupCourseFeed();
            feed.setId(signupCourse.getId());
            feed.setType(UCStudentFeedType.SIGNUP_COURSE.getType());
            feed.setCreateTime(signupCourse.getCreateTime());
            SignupCourseFeed.SignupData data = new SignupCourseFeed.SignupData();
            data.setOpName(orgInfo.getContacts());
            data.setOpAvatar(orgInfo.getLogo());
            data.setCreateTime(signupCourse.getCreateTime());
            OrgCourse course = courseMap.get(signupCourse.getClassId());
            data.setCourseName(course.getName());
            data.setContent(String.format(SIGNUP_CONTENT_TEMPLATE, orgStudent.getNotEmptyName(), course.getName()));
            data.setPrice("￥" + (signupCourse.getOriginPrice().doubleValue() / 100));
            if (signupCourse.getChargeUnit() == ChargeUnit.BY_TIMES.getCode()) {
                data.setAmount(signupCourse.getLessonCount() + "次");
            } else if (signupCourse.getChargeUnit() == ChargeUnit.BY_HOUR.getCode()) {
                data.setAmount(signupCourse.getLessonCount() + "小时");
            } else if (signupCourse.getChargeUnit() == ChargeUnit.BY_MINUTE.getCode()) {
                data.setAmount(
                    new DecimalFormat("#.0").format(signupCourse.getLessonCount().doubleValue() / 60) + "小时");
            } else if (signupCourse.getChargeUnit() == ChargeUnit.BY_HALF_HOUR.getCode()) {
                data.setAmount(
                    new DecimalFormat("#.0").format(signupCourse.getLessonCount().doubleValue() / 60) + "小时");
            } else {
                data.setAmount(signupCourse.getCount().toString());
            }
            feed.setData(data);
            result.put(feed.getId(), feed);
        }
        return result;
    }

    private Map<Long, UCStudentFeed> getSignFeedMap(OrgStudent orgStudent, OrgInfoSimpleDto orgInfo,
        List<OrgLessonSign> signs, Map<Long, OrgCourse> courseMap, Map<Long, OrgClassLesson> lessonMap,
        Map<Integer, TXCascadeCredential> cascadeMap, Map<Long, TwoTuple<String, String>> teacherMap,
        Map<Long, Long> lessonTeacherMap) {
        Map<Long, UCStudentFeed> result = Maps.newHashMap();
        for (OrgLessonSign sign : signs) {
            LessonSignFeed feed = new LessonSignFeed();
            feed.setId(sign.getId());
            feed.setCreateTime(sign.getUpdateTime());
            feed.setType(UCStudentFeedType.LESSON_SIGN.getType());

            LessonSignFeed.SignFeedData data = new LessonSignFeed.SignFeedData();
            data.setCreateTime(sign.getUpdateTime());
            if (sign.getCascadeId() > 0) {
                TXCascadeCredential credential = cascadeMap.get(sign.getCascadeId().intValue());
                data.setOpName(credential.getName());
                data.setOpAvatar(credential.getAvatar());
            } else if (sign.getTeacherId() > 0) {
                TwoTuple<String, String> tuple = teacherMap.get(sign.getTeacherId().longValue());
                data.setOpName(tuple.getFirst());
                data.setOpAvatar(tuple.getSecond());
            } else {
                data.setOpName(orgInfo.getContacts());
                data.setOpAvatar(orgInfo.getLogo());
            }
            OrgCourse course = courseMap.get(sign.getCourseId());
            data.setCourseName(course.getName());
            OrgClassLesson lesson = lessonMap.get(sign.getLessonId());
            data.setStartTime(lesson.getStartTime());
            data.setEndTime(lesson.getEndTime());
            TwoTuple<String, String> tuple = teacherMap.get(lessonTeacherMap.get(sign.getLessonId()));
            data.setTeacherName(null != tuple ? tuple.getFirst() : "");
            if (sign.getStatus() == SignStatus.SIGNED.getCode()) {
                data.setContent(String.format(SIGN_CONTENT_TEMPLATE, orgStudent.getNotEmptyName(),
                    data.getCourseName() + String.format("-第%s节课", lesson.getNumber()), "签到成功"));
            } else if (sign.getStatus() == SignStatus.LEAVE.getCode()) {
                data.setContent(String.format(SIGN_CONTENT_TEMPLATE, orgStudent.getNotEmptyName(),
                    data.getCourseName() + String.format("-第%s节课", lesson.getNumber()), "已请假"));
            } else if (sign.getStatus() == SignStatus.ABSENT.getCode()) {
                data.setContent(String.format(SIGN_CONTENT_TEMPLATE, orgStudent.getNotEmptyName(),
                    data.getCourseName() + String.format("-第%s节课", lesson.getNumber()), "未到课"));
            }
            feed.setData(data);
            result.put(feed.getId(), feed);
        }
        return result;
    }

    private Map<Long, UCStudentFeed> getGrowthDocFeedMap(Long orgId, List<TxStudentComment> growthDocs) {
        List<CommentInfoDto> list = orgStudentCommentService.buildCommentDto(orgId, growthDocs);
        Map<Long, UCStudentFeed> feedMap = Maps.newHashMap();
        for (CommentInfoDto dto : list) {
            StudentCommentFeed feed = new StudentCommentFeed();
            feed.setId(dto.getCommentId());
            feed.setCreateTime(dto.getCreateTime());
            feed.setType(UCStudentFeedType.STUDENT_COMMENT_GROWTH_DOC.getType());
            feed.setData(dto);
            feedMap.put(feed.getId(), feed);
        }
        return feedMap;
    }
}
