package com.baijia.tianxiao.biz.erp.service.impl;

import com.baijia.tianxiao.biz.erp.dto.response.SignupDetailResponse;
import com.baijia.tianxiao.biz.erp.service.SignupRecordService;
import com.baijia.tianxiao.constant.finance.PurchaseTimescardStatus;
import com.baijia.tianxiao.dal.constant.ChargeUnit;
import com.baijia.tianxiao.dal.finance.dao.TxTransferClassRecordDao;
import com.baijia.tianxiao.dal.finance.po.TxTransferClassRecord;
import com.baijia.tianxiao.dal.org.dao.CoursePurchaseDao;
import com.baijia.tianxiao.dal.org.dao.OrgAccountDao;
import com.baijia.tianxiao.dal.org.dao.OrgInfoDao;
import com.baijia.tianxiao.dal.org.po.CoursePurchase;
import com.baijia.tianxiao.dal.org.po.OrgAccount;
import com.baijia.tianxiao.dal.org.po.OrgInfo;
import com.baijia.tianxiao.dal.signup.constant.SignupStatus;
import com.baijia.tianxiao.dal.signup.constant.TransferClassOrder;
import com.baijia.tianxiao.dal.signup.dao.OrgSignupCourseDao;
import com.baijia.tianxiao.dal.signup.dao.OrgSignupRefundDao;
import com.baijia.tianxiao.dal.signup.dao.TxPurchaseTimescardDao;
import com.baijia.tianxiao.dal.signup.dao.TxPurchaseTimescardRefundDao;
import com.baijia.tianxiao.dal.signup.po.OrgSignupCourse;
import com.baijia.tianxiao.dal.signup.po.OrgSignupRefund;
import com.baijia.tianxiao.dal.signup.po.TxPurchaseTimescard;
import com.baijia.tianxiao.dal.signup.po.TxPurchaseTimescardRefund;
import com.baijia.tianxiao.dal.statistic.dao.TxSignupRecordDayDao;
import com.baijia.tianxiao.dal.statistic.po.TxSignupRecordDay;
import com.baijia.tianxiao.enums.CommonErrorCode;
import com.baijia.tianxiao.exception.BussinessException;
import com.baijia.tianxiao.sal.organization.finance.dto.SignupDateRequest;
import com.baijia.tianxiao.sal.organization.finance.dto.SignupRefundRequest;
import com.baijia.tianxiao.sal.organization.finance.dto.SignupRefundResponse;
import com.baijia.tianxiao.sal.organization.finance.dto.StatisticsByDayResponse;
import com.baijia.tianxiao.sal.organization.finance.dto.StatisticsByMonthResponse;
import com.baijia.tianxiao.sal.organization.finance.dto.SummaryExportDto;
import com.baijia.tianxiao.sal.signup.constants.SignupAndRefund;
import com.baijia.tianxiao.sal.signup.constants.SignupSourceType;
import com.baijia.tianxiao.sal.signup.dto.SignupCourseInfoDto;
import com.baijia.tianxiao.sal.signup.dto.request.SingupListRequestDto;
import com.baijia.tianxiao.sal.signup.dto.response.OrgSingupInfoDto;
import com.baijia.tianxiao.sal.signup.dto.response.TimesCardDto;
import com.baijia.tianxiao.util.ArithUtil;
import com.baijia.tianxiao.util.NumberUtil;
import com.baijia.tianxiao.util.collection.CollectorUtil;
import com.baijia.tianxiao.util.date.DateUtil;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;

import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

import javax.servlet.http.HttpServletResponse;

import lombok.extern.slf4j.Slf4j;

@Slf4j
@Service
public class SignupRecordServiceImpl implements SignupRecordService {

    @Autowired
    OrgSignupRefundDao orgSignupRefundDao;
    @Autowired
    TxSignupRecordDayDao txSignupRecordDayDao;
    @Autowired
    CoursePurchaseDao coursePurchaseDao;
    @Autowired
    OrgSignupCourseDao orgSignupCourseDao;
    @Autowired
    OrgInfoDao orgInfoDao;
    @Autowired
    OrgAccountDao orgAccountDao;
    @Autowired
    TxTransferClassRecordDao txTransferClassRecordDao;
    @Autowired
    TxPurchaseTimescardRefundDao timescardRefundDao;
    @Autowired
    TxPurchaseTimescardDao txPurchaseTimescardDao;

    @Override
    public List<StatisticsByDayResponse> getListByMonth(int orgId, SignupDateRequest signupDateRequest) {
        Date beginTime = DateUtil.getDateByYearMonth(signupDateRequest.getYear(), signupDateRequest.getMonth());
        Date endTime = DateUtil.endDateByYearMonth(signupDateRequest.getYear(), signupDateRequest.getMonth());
        //根据机构id获取本月po
        List<TxSignupRecordDay> txSignupRecordDay = txSignupRecordDayDao.getListByMonth(orgId, beginTime, endTime);
        List<StatisticsByDayResponse> statisticsByDayResponse = buildListByMonth(txSignupRecordDay);
        return statisticsByDayResponse;
    }

    private List<StatisticsByDayResponse> buildListByMonth(
            List<TxSignupRecordDay> txSignupRecordDay) {
        List<StatisticsByDayResponse> list = new ArrayList<StatisticsByDayResponse>();
        Map<Date, ArrayList<TxSignupRecordDay>> map = new TreeMap<Date, ArrayList<TxSignupRecordDay>>();
        //将相同日期的po保存到一个map，key为日期，value为po
        for (TxSignupRecordDay s : txSignupRecordDay) {
            if (map.containsKey(s.getMdate())) {
                map.get(s.getMdate()).add(s);
            } else {
                ArrayList<TxSignupRecordDay> polist = new ArrayList<TxSignupRecordDay>();
                polist.add(s);
                map.put(s.getMdate(), polist);
            }
        }
        //将相同日期的po转换为dto
        for (ArrayList<TxSignupRecordDay> values : map.values()) {
            StatisticsByDayResponse dto = new StatisticsByDayResponse();
            for (TxSignupRecordDay value : values) {
                dto.setCreateTime(value.getMdate());
                //报名
                if (value.getOpTo() == SignupAndRefund.SIGNUP.getCode()) {
                    if (value.getOpType() == SignupSourceType.SIGNUP.getCode() || value.getOpType() == SignupSourceType.TX_SIANGUP.getCode()) {
                        dto.setSignup(ArithUtil.round(dto.getSignup() + value.getOpPrice(), 2));
                    } else if (value.getOpType() == SignupSourceType.WANXIAO.getCode()) {
                        dto.setWebsite(ArithUtil.round(dto.getWebsite() + value.getOpPrice(), 2));
                    } else if (value.getOpType() == SignupSourceType.TUIGUANG.getCode()) {
                        dto.setExpend(ArithUtil.round(dto.getExpend() + value.getOpPrice(), 2));
                    }
                    //退款
                } else if (value.getOpTo() == SignupAndRefund.REFUND.getCode()) {
                    dto.setRefund(ArithUtil.round(dto.getRefund() + value.getOpPrice(), 2));
                }
                dto.setCount(ArithUtil.round(dto.getExpend() + dto.getSignup() + dto.getWebsite(), 2));
            }
            list.add(dto);
        }
        Collections.sort(list, new Comparator<StatisticsByDayResponse>() {
            @Override
            public int compare(StatisticsByDayResponse o1, StatisticsByDayResponse o2) {
                return DateUtil.dateCompare(o1.getCreateTime(), o2.getCreateTime());
            }
        });
        return list;
    }

    @Override
    public List<StatisticsByMonthResponse> getListByYear(int orgId, SignupDateRequest signupDateRequest) {
        List<StatisticsByMonthResponse> list = new ArrayList<StatisticsByMonthResponse>();
        Calendar cal = Calendar.getInstance();
        cal.set(signupDateRequest.getYear(), 0, 12);
        for (int i = 1; i < 13; i++) {
            //当前月的第一天
            cal.set(GregorianCalendar.DAY_OF_MONTH, 1);
            Date beginTime = cal.getTime();
            String begin = DateUtil.getAllDayStr(beginTime).substring(0, 10) + " 00:00:00";
            beginTime = DateUtil.getDateByStr(begin);
            //当前月的最后一天
            cal.set(Calendar.DATE, 1);
            cal.roll(Calendar.DATE, -1);
            Date endTime = cal.getTime();
            String end = DateUtil.getAllDayStr(endTime).substring(0, 10) + " 23:59:59";
            endTime = DateUtil.getDateByStr(end);
            cal.set(Calendar.MONTH, i);
            //获取日统计po
            List<TxSignupRecordDay> txSignupRecordDay = txSignupRecordDayDao.getListByMonth(orgId, beginTime, endTime);
            //将日统计po转换为日统计dto
            List<StatisticsByDayResponse> statisticsByDayResponse = buildListByMonth(txSignupRecordDay);
            //根据日统计dto计算月统计dto
            StatisticsByMonthResponse dto = new StatisticsByMonthResponse();
            double count = 0, refund = 0;
            for (StatisticsByDayResponse s : statisticsByDayResponse) {
                count = ArithUtil.round(count + s.getCount(), 2);
                refund = ArithUtil.round(refund + s.getRefund(), 2);
            }
            dto.setYear(signupDateRequest.getYear());
            dto.setMonth(i);
            dto.setCount(count);
            dto.setRefund(refund);
            list.add(dto);
        }
        List<StatisticsByMonthResponse> resultList = Lists.newArrayList();
        for (StatisticsByMonthResponse monthDto : list) {
            if (monthDto.getCount() != 0 || monthDto.getRefund() != 0) {
                resultList.add(monthDto);
            }
        }
        Collections.sort(resultList, new Comparator<StatisticsByMonthResponse>() {
            @Override
            public int compare(StatisticsByMonthResponse o1, StatisticsByMonthResponse o2) {
                return o1.getMonth() < o2.getMonth() ? 1 : -1;
            }
        });
        return resultList;
    }

    @Override
    public SignupDetailResponse buildDetailList(OrgSingupInfoDto dto, long courseId) {
        SignupDetailResponse detailDto = new SignupDetailResponse();
        detailDto.setChinesePrice(dto.getChinesePrice());
        detailDto.setCourseInfos(dto.getCourseInfos());
        detailDto.setCreateTime(dto.getCreateTime());
        detailDto.setFeeItemDtos(dto.getFeeItemDtos());
        detailDto.setId(dto.getId());
        detailDto.setLastSendTime(dto.getLastSendTime());
        detailDto.setOperator(dto.getOperator());
        detailDto.setOrgId(dto.getOrgId());
        detailDto.setOrgLogoUrl(dto.getOrgLogoUrl());
        detailDto.setOrgName(dto.getOrgName());
        detailDto.setPayResult(dto.getPayResult());
        detailDto.setPayResultStr(dto.getPayResultStr());
        detailDto.setPayTypeStr(dto.getPayTypeStr());
        detailDto.setPayUrlWinxin(dto.getPayUrlWinxin());
        detailDto.setSignUpTime(dto.getSignUpTime());
        if (dto.getStatus().intValue() != 2) {
            detailDto.setPayTime(dto.getPayTime());
        }
        detailDto.setCascadeIdStr(dto.getCascadeIdStr());
        detailDto.setStudentName(dto.getStudentName());
        detailDto.setStudentMobile(dto.getStudentMobile());
        detailDto.setSignupPurchaseId(dto.getSignupPurchaseId());
        detailDto.setStatus(dto.getStatus());
        detailDto.setPayType(dto.getPayType());
        detailDto.setSourceType(dto.getSourceType());
        if (courseId == 0) {
            detailDto.setSignupRefundDto(null);
            detailDto.setTotalRefundMoney(0);
            detailDto.setProfit(0);
            SignupCourseInfoDto c = new SignupCourseInfoDto();
            c.setCount(0);
            c.setOrgCourseName("");
            c.setOriginPrice(0.0);
            c.setPayPrice(dto.getTotalPrice());
            c.setPoundage(0.0);
            detailDto.setCourseInfo(c);
        } else {
            List<OrgSignupRefund> refundDtoList = Lists.newArrayList();
            refundDtoList = orgSignupRefundDao.getOrgSignupRefundListByPurchaseId(dto.getOrgId(), dto.getSignupPurchaseId(), courseId);
            //根据订单号，课程号和机构号确定退款列表
            List<SignupRefundResponse> signupRefundDto = new ArrayList<SignupRefundResponse>();
            //将获得都退款po列表转换为dto列表
            for (OrgSignupRefund o : refundDtoList) {
                SignupRefundResponse s = new SignupRefundResponse();
                s.setCourseId(o.getCourseId());
                s.setSignupPurchaseId(o.getSignupPurchaseId());
                s.setRefundMoney(((double) o.getRefundPrice()) / 100);
                s.setRefundTime(o.getCreateTime());
                s.setRemark(o.getRemark());
                s.setRefundType(o.getRefundType());
                signupRefundDto.add(s);
            }
            detailDto.setSignupRefundDto(signupRefundDto);
            //根据课程id找到课程
            for (SignupCourseInfoDto c : dto.getCourseInfos()) {
                if (c.getOrgCourseId() == courseId) {
                    detailDto.setCourseInfo(c);
                }
            }
            //计算累计退款
            double totalRefundMoney = 0;
            for (SignupRefundResponse refund : detailDto.getSignupRefundDto()) {
                totalRefundMoney = ArithUtil.round(totalRefundMoney + refund.getRefundMoney(), 2);
            }
            detailDto.setTotalRefundMoney(totalRefundMoney);
            //获得服务费
            double fee = 0.0;
            CoursePurchase coursePurchase = coursePurchaseDao.getByPurcahseIdCourse(detailDto.getSignupPurchaseId(), detailDto.getCourseInfo().getOrgCourseId());
            if (coursePurchase != null) {
                fee = coursePurchase.getPoundage();
            }
            detailDto.getCourseInfo().setPoundage(fee);
            //实收净润＝订单实收金额-服务费-退款金额
            double profit = ArithUtil.round(detailDto.getCourseInfo().getPayPrice() - fee - detailDto.getTotalRefundMoney(), 2);
            detailDto.setProfit(profit);
        }
        return detailDto;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void refund(Long orgId, SignupRefundRequest signupRefundRequest) {
        //最多退款五次
        int count = orgSignupRefundDao.getRefundTime(orgId, signupRefundRequest.getSignupPurchaseId(), signupRefundRequest.getCourseId());
        if (count < 5) {
            CoursePurchase coursePurchase = coursePurchaseDao.getByPurcahseIdCourse(signupRefundRequest.getSignupPurchaseId(), signupRefundRequest.getCourseId());
            OrgSignupCourse course = orgSignupCourseDao.getByCourseId(orgId, signupRefundRequest.getSignupPurchaseId(), signupRefundRequest.getCourseId());
            //获得服务费
            double fee = 0;
            if (coursePurchase != null) {
                fee = coursePurchase.getPoundage();
            }
            //获得实收款
            double price = 0;
            if (course != null) {
                price = ((double) course.getPayPrice()) / 100;
            }
            //获得累计退款金额
            List<OrgSignupRefund> refundDtoList = orgSignupRefundDao.getOrgSignupRefundListByPurchaseId(orgId, signupRefundRequest.getSignupPurchaseId(), signupRefundRequest.getCourseId());
            double totalRefundMoney = 0;
            for (OrgSignupRefund refund : refundDtoList) {
                totalRefundMoney = ArithUtil.round(totalRefundMoney + refund.getRefundPrice(), 2);
            }
            totalRefundMoney = totalRefundMoney / 100;
            log.debug("****************fee={},price={},refund={}", fee, price, totalRefundMoney);
            //退款金额<=实收款－服务费－累计退款金额
            if (signupRefundRequest.getRefundMoney() <= price - fee - totalRefundMoney) {
                OrgSignupRefund poRefund = new OrgSignupRefund();
                poRefund.setCourseId(signupRefundRequest.getCourseId());
                poRefund.setCreateTime(new Date());
                poRefund.setOrgId(orgId);
                poRefund.setUserId(course != null ? course.getUserId() : coursePurchase.getUserId());
                poRefund.setRefundPrice((long) (signupRefundRequest.getRefundMoney() * 100));
                poRefund.setSignupPurchaseId(signupRefundRequest.getSignupPurchaseId());
                poRefund.setRemark(signupRefundRequest.getRemark() != null ? signupRefundRequest.getRemark() : "");
                poRefund.setRefundType(signupRefundRequest.getRefundType());
                orgSignupRefundDao.save(poRefund);
            } else {
                throw new BussinessException(CommonErrorCode.BUSINESS_ERROR, "退款数目不得超过实收净额");
            }
        } else {
            throw new BussinessException(CommonErrorCode.BUSINESS_ERROR, "退款次数不得超过5次");
        }
    }

    @Override
    public void summaryExport(Integer orgId, SignupDateRequest signupDateRequest, HttpServletResponse response, List<OrgSingupInfoDto> resultList, SingupListRequestDto s) {
        List<TxSignupRecordDay> txSignupRecordDay = Lists.newArrayList();
        //日统计
        if (signupDateRequest.getDate() != null) {
            String sdate = signupDateRequest.getYear() + "-" + signupDateRequest.getMonth() + "-" + signupDateRequest.getDate();
            Date date = DateUtil.getDateByStr(sdate);
            txSignupRecordDay = txSignupRecordDayDao.getListByDate(orgId, date);
        } else {
            Date beginTime = DateUtil.getDateByYearMonth(signupDateRequest.getYear(), signupDateRequest.getMonth());
            Date endTime = DateUtil.endDateByYearMonth(signupDateRequest.getYear(), signupDateRequest.getMonth());
            txSignupRecordDay = txSignupRecordDayDao.getListByMonth(orgId, beginTime, endTime);
        }
        SummaryExportDto signup = new SummaryExportDto();
        SummaryExportDto website = new SummaryExportDto();
        SummaryExportDto expond = new SummaryExportDto();
        int refundCount = 0;
        double refundMoney = 0.0;
        for (TxSignupRecordDay value : txSignupRecordDay) {
            //报名
            if (value.getOpTo() == SignupAndRefund.SIGNUP.getCode()) {
                if (value.getOpType() == SignupSourceType.SIGNUP.getCode() || value.getOpType() == SignupSourceType.TX_SIANGUP.getCode()) {
                    signup.setCount(signup.getCount() + value.getOpCount());
                    signup.setCountPrice(ArithUtil.round(signup.getCountPrice() + value.getOpPrice(), 2));
                    signup.setPoundage(ArithUtil.round(signup.getPoundage() + value.getPoundage(), 2));
                } else if (value.getOpType() == SignupSourceType.WANXIAO.getCode()) {
                    website.setCount(website.getCount() + value.getOpCount());
                    website.setCountPrice(ArithUtil.round(website.getCountPrice() + value.getOpPrice(), 2));
                    website.setPoundage(ArithUtil.round(website.getPoundage() + value.getPoundage(), 2));
                } else if (value.getOpType() == SignupSourceType.TUIGUANG.getCode()) {
                    expond.setCount(expond.getCount() + value.getOpCount());
                    expond.setCountPrice(ArithUtil.round(expond.getCountPrice() + value.getOpPrice(), 2));
                    expond.setPoundage(ArithUtil.round(expond.getPoundage() + value.getPoundage(), 2));
                }
            } else if (value.getOpTo() == SignupAndRefund.REFUND.getCode()) {
                refundCount = refundCount + value.getOpCount();
                refundMoney = ArithUtil.round(refundMoney + value.getOpPrice(), 2);
            }
        }
        signup.setProfit(ArithUtil.round(signup.getCountPrice() - signup.getPoundage(), 2));
        website.setProfit(ArithUtil.round(website.getCountPrice() - website.getPoundage(), 2));
        expond.setProfit(ArithUtil.round(expond.getCountPrice() - expond.getPoundage(), 2));
        String[] header = new String[]{"交易订单总笔数", "订单金额（元）", "商家实收（元）", "服务费（元）", "实收净额（元）"};
        summaryExport(orgId, response, signup, website, expond, signupDateRequest, header, refundCount, refundMoney, resultList, s);
    }

    public void summaryExport(Integer orgId, HttpServletResponse response, SummaryExportDto signup, SummaryExportDto website, SummaryExportDto expond, SignupDateRequest s, String[] header, int refundCount, double refundMoney, List<OrgSingupInfoDto> resultList, SingupListRequestDto sdto) {
        //操作excel
        Workbook wb = new SXSSFWorkbook();
        try {
            Sheet sheet = wb.createSheet("汇总");
            //#天校报名汇总查询
            Row row0 = sheet.createRow(0);
            Cell cell00 = row0.createCell(0);
            cell00.setCellValue("#天校报名汇总查询");
            //#账号：张祥工作室（8739497902）
            OrgInfo orgInfo = orgInfoDao.getOrgInfo(orgId);
            OrgAccount orgAccount = orgAccountDao.getAccountById(orgId);
            Row row1 = sheet.createRow(1);
            Cell cell10 = row1.createCell(0);
            cell10.setCellValue("#账号:" + orgInfo.getShortName() + "(" + orgAccount.getNumber() + ")");
            //#起始日期：[年月日 00:00:00]   终止日期：[年月日 00:00:00]
            Row row2 = sheet.createRow(2);
            Cell cell20 = row2.createCell(0);
            //日统计
            if (s.getDate() != null) {
                Date date = DateUtil.getDateByDay(s.getYear(), s.getMonth(), s.getDate());
                date = DateUtil.getEndOfDay(date);
                //当天实时统计
                if (new Date().getDate() == s.getDate()) {
                    cell20.setCellValue("#起始日期：[" + s.getYear() + "年" + s.getMonth() + "月" + s.getDate() + "日 00:00:00]   终止日期：[" + DateUtil.getStrByDateFormate(new Date(), "yyyy年MM月dd日 HH:mm:ss") + "]");
                } else {
                    cell20.setCellValue("#起始日期：[" + s.getYear() + "年" + s.getMonth() + "月" + s.getDate() + "日 00:00:00]   终止日期：[" + DateUtil.getAllDayStr(date) + "]");
                }
            } else {
                Date startDate, endDate;
                startDate = DateUtil.getDateByYearMonth(s.getYear(), s.getMonth());
                endDate = DateUtil.endDateByYearMonth(s.getYear(), s.getMonth());
                startDate = DateUtil.getStartOfDay(startDate);
                endDate = DateUtil.getEndOfDay(endDate);
                if (DateUtil.getThisMonth() == s.getMonth()) {
                    cell20.setCellValue("#起始日期：[" + s.getYear() + "年" + s.getMonth() + "月1日 00:00:00]   终止日期：[" + DateUtil.getStrByDateFormate(new Date(), "yyyy年MM月dd日 HH:mm:ss") + "]");
                } else {
                    cell20.setCellValue("#起始日期：[" + DateUtil.getAllDayStr(startDate) + "]  终止日期：[" + DateUtil.getAllDayStr(endDate) + "]");
                }
            }
            //#-----------------------------------------业务汇总列表----------------------------------------
            Row row3 = sheet.createRow(3);
            Cell cell30 = row3.createCell(0);
            cell30.setCellValue("#-----------------------------------------业务汇总列表----------------------------------------");
            //	交易订单总笔数	订单金额（元）	商家实收（元）	服务费（元）	实收净额（元）
            Row row4 = sheet.createRow(4);
            for (int j = 1; j < 6; j++) {
                Cell cellTitle = row4.createCell(j);
                cellTitle.setCellValue(header[j - 1]);
            }
            //报名收款
            Row row5 = sheet.createRow(5);
            setColumnWidth(row5, 5);
            row5.createCell(0).setCellValue("报名收款");
            row5.createCell(1).setCellValue(signup.getCount());
            row5.createCell(2).setCellValue(NumberUtil.get2FromDouble(signup.getCountPrice()));
            row5.createCell(3).setCellValue(NumberUtil.get2FromDouble(signup.getCountPrice()));
            row5.createCell(4).setCellValue(NumberUtil.get2FromDouble(signup.getPoundage()));
            row5.createCell(5).setCellValue(NumberUtil.get2FromDouble(signup.getProfit()));
            //微官网报名
            Row row6 = sheet.createRow(6);
            setColumnWidth(row6, 5);
            row6.createCell(0).setCellValue("微官网报名");
            row6.createCell(1).setCellValue(website.getCount());
            row6.createCell(2).setCellValue(NumberUtil.get2FromDouble(website.getCountPrice()));
            row6.createCell(3).setCellValue(NumberUtil.get2FromDouble(website.getCountPrice()));
            row6.createCell(4).setCellValue(NumberUtil.get2FromDouble(website.getPoundage()));
            row6.createCell(5).setCellValue(NumberUtil.get2FromDouble(website.getProfit()));
            //推广报名
            Row row7 = sheet.createRow(7);
            setColumnWidth(row7, 5);
            row7.createCell(0).setCellValue("推广报名");
            row7.createCell(1).setCellValue(expond.getCount());
            row7.createCell(2).setCellValue(NumberUtil.get2FromDouble(expond.getCountPrice()));
            row7.createCell(3).setCellValue(NumberUtil.get2FromDouble(expond.getCountPrice()));
            row7.createCell(4).setCellValue(NumberUtil.get2FromDouble(expond.getPoundage()));
            row7.createCell(5).setCellValue(NumberUtil.get2FromDouble(expond.getProfit()));
            //合计
            Row row8 = sheet.createRow(8);
            setColumnWidth(row8, 5);
            row8.createCell(0).setCellValue("合计");
            row8.createCell(1).setCellValue(signup.getCount() + website.getCount() + expond.getCount());
            row8.createCell(2).setCellValue(NumberUtil.get2FromDouble(signup.getCountPrice() + website.getCountPrice() + expond.getCountPrice()));
            row8.createCell(3).setCellValue(NumberUtil.get2FromDouble(signup.getCountPrice() + website.getCountPrice() + expond.getCountPrice()));
            row8.createCell(4).setCellValue(NumberUtil.get2FromDouble(signup.getPoundage() + website.getPoundage() + expond.getPoundage()));
            row8.createCell(5).setCellValue(NumberUtil.get2FromDouble(signup.getProfit() + website.getProfit() + expond.getProfit()));
            //退款订单总笔数	退款金额（元）	
            Row row9 = sheet.createRow(9);
            row9.createCell(1).setCellValue("退款订单总笔数");
            row9.createCell(2).setCellValue("退款金额（元）");
            //退款
            Row row10 = sheet.createRow(10);
            row10.createCell(0).setCellValue("退款");
            row10.createCell(1).setCellValue(refundCount);
            row10.createCell(2).setCellValue(refundMoney);
            //合计	
            Row row11 = sheet.createRow(11);
            row11.createCell(0).setCellValue("合计");
            row11.createCell(1).setCellValue(refundCount);
            row11.createCell(2).setCellValue(refundMoney);
            //#----------------------------------------业务汇总列表结束-------------------------------------
            Row row12 = sheet.createRow(12);
            Cell cell120 = row12.createCell(0);
            cell120.setCellValue("#----------------------------------------业务汇总列表结束-------------------------------------");
            //#导出时间：[2016年06月19日 04:35:33]
            Row row13 = sheet.createRow(13);
            Cell cell130 = row13.createCell(0);
            cell130.setCellValue("#导出时间：[" + DateUtil.getStrByDateFormate(new Date(), "yyyy年MM月dd日 HH:mm:ss") + "]");
            detailExport(wb, orgId, response, sdto, resultList, s, refundCount, refundMoney);
        } catch (Exception e) {
            throw new RuntimeException("export data error", e);
        } finally {
            IOUtils.closeQuietly(wb);
        }
    }

    public void detailExport(Workbook wb, Integer orgId, HttpServletResponse response, SingupListRequestDto s, List<OrgSingupInfoDto> resultList, SignupDateRequest s2, int refundCount, double refund) {
        String[] header = new String[]{"订单号", "摘要", "创建时间", "支付时间",
                "单价", "数量", "优惠金额", "转班抵扣金额", "实收款（元）", "累计退款金额", "手续费",
                "实收净额", "学员", "订单状态", "支付方式", "订单来源", "收款人"};
        String fileName = "天校报名记录.xlsx";
        //操作excel
        try {
            Sheet sheet = wb.createSheet("明细");
            //#天校业务明细查询
            Row row0 = sheet.createRow(0);
            Cell cell00 = row0.createCell(0);
            cell00.setCellValue("#天校业务明细查询");
            //#账号：张祥工作室（8739497902）
            OrgInfo orgInfo = orgInfoDao.getOrgInfo(orgId);
            OrgAccount orgAccount = orgAccountDao.getAccountById(orgId);
            Row row1 = sheet.createRow(1);
            Cell cell10 = row1.createCell(0);
            cell10.setCellValue("#账号:" + orgInfo.getShortName() + "(" + orgAccount.getNumber() + ")");
            //#起始日期：[年月日 00:00:00]   终止日期：[年月日 00:00:00]
            Row row2 = sheet.createRow(2);
            Cell cell20 = row2.createCell(0);
            //日统计
            if (s2.getDate() != null) {
                Date date = DateUtil.getDateByDay(s2.getYear(), s2.getMonth(), s2.getDate());
                date = DateUtil.getEndOfDay(date);
                //当天实时统计
                if (new Date().getDate() == s2.getDate()) {
                    cell20.setCellValue("#起始日期：[" + s2.getYear() + "年" + s2.getMonth() + "月" + s2.getDate() + "日 00:00:00]   终止日期：[" + DateUtil.getStrByDateFormate(new Date(), "yyyy年MM月dd日 HH:mm:ss") + "]");
                } else {
                    cell20.setCellValue("#起始日期：[" + s2.getYear() + "年" + s2.getMonth() + "月" + s2.getDate() + "日 00:00:00]   终止日期：[" + DateUtil.getAllDayStr(date) + "]");
                }
            } else {
                if (DateUtil.getThisMonth() == s2.getMonth()) {
                    cell20.setCellValue("#起始日期：[" + s2.getYear() + "年" + s2.getMonth() + "月1日 00:00:00]   终止日期：[" + DateUtil.getStrByDateFormate(new Date(), "yyyy年MM月dd日 HH:mm:ss") + "]");
                } else {
                    cell20.setCellValue("#起始日期：[" + DateUtil.getStrByDateFormate(s.getStartTime(), "yyyy年MM月dd日 HH:mm:ss") + "]   终止日期：[" + DateUtil.getStrByDateFormate(s.getEndTime(), "yyyy年MM月dd日 HH:mm:ss") + "]");
                }
            }
            //#-----------------------------------------业务汇总列表----------------------------------------
            Row row3 = sheet.createRow(3);
            Cell cell30 = row3.createCell(0);
            cell30.setCellValue("#-----------------------------------------业务汇总列表----------------------------------------");
            //	交易订单总笔数	订单金额（元）	商家实收（元）	服务费（元）	实收净额（元）
            Row row4 = sheet.createRow(4);
            for (int i = 0; i < header.length; i++) {
                Cell cellTitle = row4.createCell(i);
                cellTitle.setCellValue(header[i]);
            }
            int rowNumber = 5;
            int index = 0;
            double pay = 0.0;
            int count = 0;
            for (OrgSingupInfoDto sdr : resultList) {
                if (!CollectionUtils.isEmpty(sdr.getCourseInfos())) {
                    for (SignupCourseInfoDto c : sdr.getCourseInfos()) {
                        Row row = sheet.createRow(rowNumber++);
                        count++;
                        row.getSheet().setColumnWidth(0, 20 * 256);
                        row.getSheet().setColumnWidth(1, 20 * 256);
                        row.getSheet().setColumnWidth(2, 25 * 256);
                        row.getSheet().setColumnWidth(3, 25 * 256);
                        row.getSheet().setColumnWidth(11, 20 * 256);
                        row.createCell(index++ % header.length).setCellValue(String.valueOf(sdr.getSignupPurchaseId()));
                        row.createCell(index++ % header.length).setCellValue(c.getOrgCourseName());
                        row.createCell(index++ % header.length).setCellValue(DateUtil.getStrByDateFormate(sdr.getSignUpTime(), "yyyy年MM月dd日 HH:mm:ss"));
                        row.createCell(index++ % header.length).setCellValue(DateUtil.getStrByDateFormate(sdr.getPayTime(), "yyyy年MM月dd日 HH:mm:ss"));
                        row.createCell(index++ % header.length).setCellValue(c.getOriginPriceStr());
                        row.createCell(index++ % header.length)
                                .setCellValue(
                                        ChargeUnit.isByTime(c.getChargeUnit())
                                                ? c.getChargeUnit() == ChargeUnit.BY_HOUR.getCode()
                                                ? String.format("%s小时", c.getCount()) : DateUtil.minutesToHourStr(c.getCount())
                                                : String.valueOf(c.getLessonCount()));
                        row.createCell(index++ % header.length).setCellValue(c.getPreferential());
                        row.createCell(index++ % header.length)
                                .setCellValue(sdr.getOrderType() == TransferClassOrder.TRANSFER_ORDER.getCode()
                                        ? sdr.getTransferClassMoney().toString() : "/");
                        row.createCell(index++ % header.length).setCellValue(c.getPayPrice());
                        row.createCell(index++ % header.length).setCellValue(c.getTotalRefundMoney());
                        row.createCell(index++ % header.length).setCellValue(c.getPoundage());
                        row.createCell(index++ % header.length).setCellValue(c.getProfit());
                        String string = sdr.getStudentName() + "(" + sdr.getStudentMobile() + ")";
                        row.createCell(index++ % header.length).setCellValue(string);
                        int status = sdr.getStatus();
                        if (status == SignupStatus.ALL.getCode()) {
                            row.createCell(index++ % header.length).setCellValue("全部");
                        } else if (status == SignupStatus.FINISHED.getCode()) {
                            row.createCell(index++ % header.length).setCellValue("已完成");
                        } else if (status == SignupStatus.NOT_PAY.getCode()) {
                            row.createCell(index++ % header.length).setCellValue("待收款");
                        } else if (status == SignupStatus.NOT_SIGN.getCode()) {
                            row.createCell(index++ % header.length).setCellValue("待处理");
                        }
                        row.createCell(index++ % header.length).setCellValue(sdr.getPayTypeStr());
                        int source = sdr.getSourceType();
                        if (source == SignupSourceType.SIGNUP.getCode() || source == SignupSourceType.TX_SIANGUP.getCode()) {
                            row.createCell(index++ % header.length).setCellValue("报名收款");
                        } else if (source == SignupSourceType.TUIGUANG.getCode()) {
                            row.createCell(index++ % header.length).setCellValue("推广");
                        } else if (source == SignupSourceType.WANXIAO.getCode()) {
                            row.createCell(index++ % header.length).setCellValue("微官网");
                        }
                        row.createCell(index++ % header.length).setCellValue(sdr.getCascadeIdStr());
                        pay = pay + c.getPayPrice();
                    }
                } else {
                    Row row = sheet.createRow(rowNumber++);
                    count++;
                    row.getSheet().setColumnWidth(0, 20 * 256);
                    row.getSheet().setColumnWidth(1, 20 * 256);
                    row.getSheet().setColumnWidth(2, 25 * 256);
                    row.getSheet().setColumnWidth(3, 25 * 256);
                    row.getSheet().setColumnWidth(11, 20 * 256);
                    row.createCell(index++ % header.length).setCellValue(String.valueOf(sdr.getSignupPurchaseId()));
                    if (sdr.getOrderType() == TransferClassOrder.RECHARGE_ORDER.getCode()) {
                        row.createCell(index++ % header.length).setCellValue("学生充值");
                    } else if (sdr.getOrderType() == TransferClassOrder.TIMESCARD_ORDER.getCode()) {
                        row.createCell(index++ % header.length).setCellValue("购买合同次卡");
                    }
                    row.createCell(index++ % header.length).setCellValue(DateUtil.getStrByDateFormate(sdr.getSignUpTime(), "yyyy年MM月dd日 HH:mm:ss"));
                    row.createCell(index++ % header.length).setCellValue(DateUtil.getStrByDateFormate(sdr.getPayTime(), "yyyy年MM月dd日 HH:mm:ss"));
                    row.createCell(index++ % header.length).setCellValue("");
                    row.createCell(index++ % header.length)
                            .setCellValue("");
                    row.createCell(index++ % header.length).setCellValue(0);
                    row.createCell(index++ % header.length)
                            .setCellValue(sdr.getOrderType() == TransferClassOrder.TRANSFER_ORDER.getCode()
                                    ? sdr.getTransferClassMoney().toString() : "/");
                    row.createCell(index++ % header.length).setCellValue(sdr.getTotalPrice());
                    row.createCell(index++ % header.length).setCellValue(0);
                    row.createCell(index++ % header.length).setCellValue(0);
                    row.createCell(index++ % header.length).setCellValue(sdr.getTotalPrice());
                    String string = sdr.getStudentName() + "(" + sdr.getStudentMobile() + ")";
                    row.createCell(index++ % header.length).setCellValue(string);
                    int status = sdr.getStatus();
                    if (status == SignupStatus.ALL.getCode()) {
                        row.createCell(index++ % header.length).setCellValue("全部");
                    } else if (status == SignupStatus.FINISHED.getCode()) {
                        row.createCell(index++ % header.length).setCellValue("已完成");
                    } else if (status == SignupStatus.NOT_PAY.getCode()) {
                        row.createCell(index++ % header.length).setCellValue("待收款");
                    } else if (status == SignupStatus.NOT_SIGN.getCode()) {
                        row.createCell(index++ % header.length).setCellValue("待处理");
                    }
                    row.createCell(index++ % header.length).setCellValue(sdr.getPayTypeStr());
                    int source = sdr.getSourceType();
                    if (source == SignupSourceType.SIGNUP.getCode() || source == SignupSourceType.TX_SIANGUP.getCode()) {
                        row.createCell(index++ % header.length).setCellValue("报名收款");
                    } else if (source == SignupSourceType.TUIGUANG.getCode()) {
                        row.createCell(index++ % header.length).setCellValue("推广");
                    } else if (source == SignupSourceType.WANXIAO.getCode()) {
                        row.createCell(index++ % header.length).setCellValue("微官网");
                    }
                    row.createCell(index++ % header.length).setCellValue(sdr.getCascadeIdStr());
                    pay = pay + sdr.getTotalPrice();
                }
            }
            //#----------------------------------------业务汇总列表结束-------------------------------------
            sheet.createRow(rowNumber++).createCell(0).setCellValue("#----------------------------------------业务汇总列表结束-------------------------------------");
            //#交易合计：2笔，交易金额共198.00元
            String payStr = "#交易合计：" + count + "笔，交易金额共" + NumberUtil.get2FromDouble(pay) + "元";
            sheet.createRow(rowNumber++).createCell(0).setCellValue(payStr);
            //#退款合计：0笔，交易退款金额共0.00元
            String refundStr = "#退款合计：" + refundCount + "笔，交易退款金额共" + refund + "元";
            sheet.createRow(rowNumber++).createCell(0).setCellValue(refundStr);
            //#导出时间：[2016年06月19日 04:35:33]
            sheet.createRow(rowNumber++).createCell(0).setCellValue("#导出时间：[" + DateUtil.getStrByDateFormate(new Date(), "yyyy年MM月dd日 HH:mm:ss") + "]");
            exportExcel(response, wb, fileName);
        } catch (Exception e) {
            throw new RuntimeException("export data error", e);
        } finally {
            IOUtils.closeQuietly(wb);
        }
    }

    public static void exportExcel(HttpServletResponse response, Workbook workBook, String excelFileName) {
        if (StringUtils.isBlank(excelFileName)) {
            excelFileName = System.currentTimeMillis() + ".xlsx";
        }
        response.setContentType("application/vnd.ms-excel");
        try {
            response.setHeader("Content-Disposition",
                    "attachment; filename=" + URLEncoder.encode(excelFileName, "utf-8"));
        } catch (UnsupportedEncodingException e1) {
            response.setHeader("Content-Disposition", "attachment; filename=" + excelFileName);
        }
        try {
            workBook.write(response.getOutputStream());
            response.getOutputStream().flush();
        } catch (IOException e) {
            log.error("export data catch error:", e);
            throw new BussinessException(CommonErrorCode.BUSINESS_ERROR, "导出数据处理失败");
        }
    }

    @Override
    public List<OrgSingupInfoDto> addInfo(List<OrgSingupInfoDto> list) {
        Set<Long> purchaseIds = Sets.newHashSet();
        //获得全部的订单id和课程id，只查询一次数据库
        for (OrgSingupInfoDto o : list) {
            purchaseIds.add(o.getSignupPurchaseId());
        }
        Map<String, List<OrgSignupRefund>> refundMap = Maps.newHashMap();
        Map<Long, List<TxTransferClassRecord>> transferRefundMap = Maps.newHashMap();
        Map<String, CoursePurchase> coursePurchaseMap = Maps.newHashMap();
        Map<String, CoursePurchase> coursePurchaseMap1 = Maps.newHashMap();
        Map<Long, TxPurchaseTimescardRefund> timescardRefundMap = Maps.newHashMap();
        Map<Long, TxPurchaseTimescard> txPurchaseTimescardMap = Maps.newHashMap();
        if (purchaseIds != null && purchaseIds.size() > 0) {
            List<OrgSignupRefund> refundDtoList = orgSignupRefundDao.getByPurcahseIds(purchaseIds);
            List<CoursePurchase> coursePurchaseList = coursePurchaseDao.getByPurcahseIds(purchaseIds);
            List<TxPurchaseTimescardRefund> timescardRefunds = timescardRefundDao.getByPurcahseIds(purchaseIds);
            List<TxPurchaseTimescard> txPurchaseTimescards = txPurchaseTimescardDao.getByPurcahseIds(purchaseIds);

            refundMap = CollectorUtil.group(refundDtoList, new Function<OrgSignupRefund, String>() {
                @Override
                public String apply(OrgSignupRefund input) {
                    return input.getSignupPurchaseId() + "" + input.getCourseId();
                }
            });
            txTransferClassRecordDao.listByInPurchaseIds(purchaseIds).stream().forEach(transfer -> {
                List<TxTransferClassRecord> records = transferRefundMap.getOrDefault(transfer.getInPurchaseId(), new ArrayList<>());
                records.add(transfer);
                transferRefundMap.put(transfer.getInPurchaseId(), records);
            });

            timescardRefundMap = CollectorUtil.collectMap(timescardRefunds, new Function<TxPurchaseTimescardRefund, Long>() {
                @Override
                public Long apply(TxPurchaseTimescardRefund txPurchaseTimescardRefund) {
                    return txPurchaseTimescardRefund.getSignupPurchaseId();
                }
            });

            txPurchaseTimescardMap = CollectorUtil.collectMap(txPurchaseTimescards, new Function<TxPurchaseTimescard, Long>() {
                @Override
                public Long apply(TxPurchaseTimescard txPurchaseTimescard) {
                    return txPurchaseTimescard.getSignupPurchaseId();
                }
            });

            coursePurchaseMap = CollectorUtil.collectMap(coursePurchaseList, new Function<CoursePurchase, String>() {
                @Override
                public String apply(CoursePurchase input) {
                    return input.getPurchaseId() + "" + input.getCourseId();
                }
            });
            coursePurchaseMap1 = CollectorUtil.collectMap(coursePurchaseList, new Function<CoursePurchase, String>() {
                @Override
                public String apply(CoursePurchase input) {
                    return input.getParentPurchaseId() + "" + input.getCourseId();
                }
            });
            coursePurchaseMap.putAll(coursePurchaseMap1);
        }
        //遍历每条订单
        for (OrgSingupInfoDto o : list) {
            //已完成和待付款
            if (o.getCourseInfos().size() > 0) {
                for (Iterator<SignupCourseInfoDto> it = o.getCourseInfos().iterator(); it.hasNext(); ) {
                    SignupCourseInfoDto c = it.next();
                    CoursePurchase cp = coursePurchaseMap.get(o.getSignupPurchaseId() + "" + c.getOrgCourseId());
                    List<OrgSignupRefund> osr = refundMap.get(o.getSignupPurchaseId() + "" + c.getOrgCourseId());
                    List<TxTransferClassRecord> transferClassRecords = transferRefundMap.getOrDefault(o.getSignupPurchaseId(), new ArrayList<>());
                    List<OrgSignupRefund> refundDtoList = Lists.newArrayList();
                    List<SignupRefundResponse> signupRefundDto = new ArrayList<SignupRefundResponse>();
                    if (osr != null) {
                        refundDtoList = osr;
                        //将获得都退款po列表转换为dto列表
                        for (OrgSignupRefund renfund : refundDtoList) {
                            SignupRefundResponse s = new SignupRefundResponse();
                            s.setCourseId(renfund.getCourseId());
                            s.setSignupPurchaseId(o.getSignupPurchaseId());
                            s.setRefundMoney(((double) renfund.getRefundPrice()) / 100);
                            s.setRefundTime(renfund.getCreateTime());
                            s.setRemark(renfund.getRemark());
                            signupRefundDto.add(s);
                        }
                    }
                    c.setSignupRefundDto(signupRefundDto);
                    //计算累计退款
                    double totalRefundMoney = 0;
                    for (SignupRefundResponse refund : c.getSignupRefundDto()) {
                        totalRefundMoney = ArithUtil.round(totalRefundMoney + refund.getRefundMoney(), 2);
                    }
                    for (TxTransferClassRecord refund : transferClassRecords) {
                        totalRefundMoney =
                                ArithUtil.round(totalRefundMoney + new Double(refund.getRefundMoney()) / 100, 2);
                    }
                    c.setTotalRefundMoney(totalRefundMoney);
                    //获得服务费
                    double fee = 0.0;
                    //如果这个课程有服务费
                    if (cp != null && c.getOrgCourseId().longValue() == cp.getCourseId().longValue()) {
                        fee = cp.getPoundage();
                    }
                    c.setPoundage(fee);
                    //实收净润＝订单实收金额-服务费-退款金额
                    double profit = ArithUtil.round(c.getPayPrice() - fee - c.getTotalRefundMoney(), 2);
                    c.setProfit(profit);
                }
            }

            if (o.getOrderType() == TransferClassOrder.TIMESCARD_ORDER.getCode()) {
                TxPurchaseTimescard timescard = txPurchaseTimescardMap.get(o.getSignupPurchaseId().longValue());
                if (timescard != null) {
                    TimesCardDto timesCardDto = new TimesCardDto();
                    timesCardDto.setStatus(timescard.getStatus());
                    o.setTimesCardDto(timesCardDto);
                }
            }
        }
        return list;
    }

    private void setColumnWidth(Row row, int length) {
        for (int i = 0; i <= length; i++) {
            row.getSheet().setColumnWidth(i, 20 * 256);
        }
    }

}
