
/**
 * Baijiahulian.com Inc. Copyright (c) 2014-2016 All Rights Reserved.
 */

package com.baijia.tianxiao.biz.erp.service.impl;

import com.baijia.tianxiao.biz.erp.dto.request.ListLessonsRequestDto;
import com.baijia.tianxiao.biz.erp.dto.request.TimeRangeRequestDto;
import com.baijia.tianxiao.biz.erp.dto.response.H5LessonResponseDto;
import com.baijia.tianxiao.biz.erp.dto.response.LessonResponseDto;
import com.baijia.tianxiao.biz.erp.dto.response.ListLessonResponseDto;
import com.baijia.tianxiao.biz.erp.dto.response.schedule.DateInfoDto;
import com.baijia.tianxiao.biz.erp.dto.response.schedule.DayLessonInfoDto;
import com.baijia.tianxiao.biz.erp.dto.response.schedule.ListLessonDtoInfo;
import com.baijia.tianxiao.biz.erp.service.CourseLessonService;
import com.baijia.tianxiao.constants.TianXiaoConstant;
import com.baijia.tianxiao.biz.erp.service.ScheduleLessonService;
import com.baijia.tianxiao.util.date.DateUtil;


import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import org.springframework.stereotype.Service;

import java.util.*;

import javax.annotation.Resource;

import lombok.extern.slf4j.Slf4j;

/**
 * @title CourseLessonServiceImpl
 * @desc TODO
 * @author bjhl
 * @date 2016年1月4日
 * @version 1.0
 */
@Service
@Slf4j
public class ScheduleLessonServiceImpl implements ScheduleLessonService {

    @Resource
    private CourseLessonService courseLessonService;

    @Override
    public ListLessonDtoInfo getScheduleLessons(Long orgId, ListLessonsRequestDto requestDto, boolean needToday) {
        if (requestDto.getPageSize() == null || requestDto.getPageSize() <= 0) {
            requestDto.setPageSize(40);
        }
        if (requestDto.getFirstLessonStartTime() == null && requestDto.getLastLessonStartTime() == null) {
            requestDto.setFirstLessonStartTime(DateUtil.getCurrentDate().getTime());
        }
        requestDto.setNeedcourseName(true);
        requestDto.setNeedRoomName(true);
        requestDto.setNeedTeacherName(true);
        requestDto.setNeedSignInfo(true);
        ListLessonResponseDto response = this.courseLessonService.listLessons(orgId, requestDto, false);
        // ListLessonResponseDto response = this.courseLessonService.listSignInLessons(orgId, requestDto);
        Map<String, List<LessonResponseDto>> lessonMap = groupLessonMap(response, needToday);
        List<DayLessonInfoDto> dayLessonsList = buildDayLessonInfoDtoList(lessonMap);
        ListLessonDtoInfo listLessonDtoInfo = new ListLessonDtoInfo(dayLessonsList, response.getCourseType(),
            response.getFirstLessonStartTime(), response.getLastLessonStartTime());
        return listLessonDtoInfo;
    }

    @Override
    public ListLessonDtoInfo getSignInScheduleLessons(Long orgId, ListLessonsRequestDto requestDto, boolean needToday) {
        if (requestDto.getPageSize() == null || requestDto.getPageSize() <= 0) {
            requestDto.setPageSize(40);
        }
        if (requestDto.getFirstLessonStartTime() == null && requestDto.getLastLessonStartTime() == null) {
            requestDto.setFirstLessonStartTime(DateUtil.getCurrentDate().getTime());
        }
        requestDto.setNeedcourseName(true);
        requestDto.setNeedRoomName(true);
        requestDto.setNeedTeacherName(true);
        requestDto.setNeedSignInfo(true);
        ListLessonResponseDto response = this.courseLessonService.listSignInLessons(orgId, requestDto);
        Map<String, List<LessonResponseDto>> lessonMap = groupLessonMap(response, needToday);
        List<DayLessonInfoDto> dayLessonsList = buildDayLessonInfoDtoList(lessonMap);
        ListLessonDtoInfo listLessonDtoInfo = new ListLessonDtoInfo(dayLessonsList, response.getCourseType(),
            response.getFirstLessonStartTime(), response.getLastLessonStartTime());
        return listLessonDtoInfo;
    }

    public Map<String, List<LessonResponseDto>> groupLessonMap(ListLessonResponseDto response, boolean needToday) {
        Map<String, List<LessonResponseDto>> result = Maps.newHashMap();
        if (needToday) {
            String today = TianXiaoConstant.DAY_FORMAT.format(new Date());
            result.put(today, Lists.newArrayList());
        }
        Collections.sort(response.getList(), (o1, o2) -> o1.getLessonId().compareTo(o2.getLessonId()));

        for (LessonResponseDto dto : response.getList()) {
            H5LessonResponseDto h5Dto = H5LessonResponseDto.convert(dto);
            if (!result.containsKey(h5Dto.getDate())) {
                result.put(h5Dto.getDate(), Lists.<LessonResponseDto> newArrayList());
            }
            result.get(h5Dto.getDate()).add(h5Dto);
        }
        return result;
    }

    /**
     * 构建按日期组合课节
     * 
     * @param lessonMap
     * @return
     */
    public List<DayLessonInfoDto> buildDayLessonInfoDtoList(Map<String, List<LessonResponseDto>> lessonMap) {
        List<DayLessonInfoDto> list = Lists.newArrayList();
        Iterator<Map.Entry<String, List<LessonResponseDto>>> iterator = lessonMap.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, List<LessonResponseDto>> entry = iterator.next();
            String date = entry.getKey();
            List<LessonResponseDto> lessons = entry.getValue();
            DateInfoDto dateInfo = new DateInfoDto(date);
            DayLessonInfoDto dayLessonInfoDto = new DayLessonInfoDto(lessons, dateInfo);
            list.add(dayLessonInfoDto);
        }
        return list;
    }

    @Override
    public List<LessonResponseDto> getScheduleLessons(Long orgId, TimeRangeRequestDto requestDto) {
        List<LessonResponseDto> list = courseLessonService.findLessonBaseInfoByTimeRange(orgId, requestDto.getStartDate(), requestDto.getEndDate(), requestDto.getPageDto());
        return list;
    }
}
