package com.baijia.tianxiao.biz.erp.service.impl;

import com.baijia.tianxiao.biz.erp.service.OrgClassLessonService;
import com.baijia.tianxiao.dal.org.dao.OrgClassLessonDao;
import com.baijia.tianxiao.dal.org.po.OrgClassLesson;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * Created by wengshengli on 2017/8/18.
 */
@Service
@Slf4j
public class OrgClassLessonServiceImpl implements OrgClassLessonService {

    @Autowired
    private OrgClassLessonDao orgClassLessonDao;

    @Override
    public void reOrderClassLesson(Long classId) {
        List<OrgClassLesson> classLessonList = orgClassLessonDao.list1V1ByClassId(classId);
        log.info("reorder class lesson size = {}", classLessonList == null ? 0 : classLessonList.size());
        if (!CollectionUtils.isEmpty(classLessonList)) {
            int i = 1;
            for (OrgClassLesson orgClassLesson : classLessonList) {
                orgClassLesson.setNumber(i++);
                orgClassLesson.setUpdateTime(orgClassLesson.getUpdateTime());
                orgClassLessonDao.update(orgClassLesson, "number", "updateTime");
            }
        }
    }
}
