package com.baijia.tianxiao.biz.erp.service.impl;

import com.baijia.tianxiao.biz.erp.enums.SyncSignupLessonCount;
import com.baijia.tianxiao.biz.erp.service.CourseClassService;
import com.baijia.tianxiao.biz.erp.service.ErpStudentCourseService;
import com.baijia.tianxiao.dal.constant.ChargeUnit;
import com.baijia.tianxiao.dal.enums.CourseTypeEnum;
import com.baijia.tianxiao.dal.finance.po.TxTransferClassRecord;
import com.baijia.tianxiao.dal.org.constant.DeleteStatus;
import com.baijia.tianxiao.dal.org.dao.OrgCourseDao;
import com.baijia.tianxiao.dal.org.dao.OrgStudentCourseDao;
import com.baijia.tianxiao.dal.org.dao.OrgStudentDao;
import com.baijia.tianxiao.dal.org.dto.StudentCourseKexiaoDocument;
import com.baijia.tianxiao.dal.org.po.OrgCourse;
import com.baijia.tianxiao.dal.org.po.OrgStudent;
import com.baijia.tianxiao.dal.org.po.OrgStudentCourse;
import com.baijia.tianxiao.dal.signup.constant.SignupCourseStatus;
import com.baijia.tianxiao.dal.signup.po.OrgSignupCourse;
import com.baijia.tianxiao.enums.StudentCourseStatus;
import com.baijia.tianxiao.sal.common.api.KexiaoApiService;
import com.baijia.tianxiao.sal.signup.service.SignupCourseService;
import com.baijia.tianxiao.sal.signup.service.TransferClassInfoService;
import com.baijia.tianxiao.sal.wx.api.WxStudentCourseService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.Date;
import java.util.List;

/**
 * Created by wengshengli on 2017/2/20.
 */
@Slf4j
@Service
public class ErpStudentCourseServiceImpl implements ErpStudentCourseService {

    @Resource
    private OrgCourseDao orgCourseDao;

    @Resource
    private OrgStudentDao orgStudentDao;

    @Resource
    private CourseClassService courseClassService;

    @Resource
    private OrgStudentCourseDao studentCourseDao;

    @Autowired
    private SignupCourseService signupCourseService;

    @Resource
    private KexiaoApiService kexiaoApiService;

    @Autowired
    private WxStudentCourseService wxStudentCourseService;

    @Autowired
    private TransferClassInfoService transferClassInfoService;

    @Override
    public OrgStudentCourse signupToStudentCourse(OrgSignupCourse signupCourse, OrgStudentCourse studentCourse) {

        OrgCourse orgCourse = orgCourseDao.getByCourseId(signupCourse.getOrgCourseId());
        if (orgCourse == null) {
            log.error("SignUpCourseProcessor not have course ={}", signupCourse);
        }

        OrgStudent orgstudent = orgStudentDao.getStudentByUserId(signupCourse.getOrgId(), signupCourse.getUserId());
        if (orgstudent == null) {
            log.error("SignUpCourseProcessor not have orgstudent ={}", signupCourse);
        }

        boolean isWangxiaoNewStu = false;
        if (studentCourse == null) {//进班
            log.info("OrgStudentCourse signupToStudentCourse  new class = {},{}", signupCourse, studentCourse);
            if (orgCourse.getCourseType() == CourseTypeEnum.COURSE_TYPE_1v1.getCode()) {
                studentCourse = courseClassService.createClassFor1V1(signupCourse.getOrgId(), signupCourse.getSignupPurchaseId(),
                        signupCourse.getOrgCourseId(), signupCourse.getUserId(), signupCourse.getChargeUnit(), signupCourse.getLessonCount());
            } else {
                studentCourse = newClassStudentCourse(signupCourse, orgstudent);
                if (orgCourse.getCourseType() == CourseTypeEnum.COURSE_TYPE_CLASS_LIVE.getCode()
                        || orgCourse.getCourseType() == CourseTypeEnum.COURSE_TYPE_CLASS_VIDEO.getCode()) {
                    isWangxiaoNewStu = true;
                }
            }
            studentCourse.setSyncLessonCount(SyncSignupLessonCount.SYNC_SIGNUP.getCode());
        } else {//更新合同课次及状态
            studentCourse = updateLessonCountAndStatus(studentCourse, signupCourse);
        }

        studentCourse.setRealCourseId(signupCourse.getOrgCourseId());
        log.info("[SignUpCourseProcessor] studentCourse into =={}", studentCourse);
        studentCourseDao.saveOrUpdate(studentCourse);//进班或更新合同课次
        if (isWangxiaoNewStu && studentCourse.getId() != null && studentCourse.getId() > 0) {
            // 网校学生进班成功,自动排课+计数
            this.wxStudentCourseService.taskProcess(orgCourse, studentCourse);
        }
        return studentCourse;
    }

    private OrgStudentCourse newClassStudentCourse(OrgSignupCourse signupCourse, OrgStudent orgStudent) {
        OrgStudentCourse studentCourse = new OrgStudentCourse();
        studentCourse.setCourseId(signupCourse.getOrgCourseId());
        studentCourse.setRealCourseId(signupCourse.getOrgCourseId());
        studentCourse.setCreateTime(new Date());
        studentCourse.setDelStatus(DeleteStatus.NORMAL.getValue());
        studentCourse.setStatus(StudentCourseStatus.NORMAL.getCode());
        studentCourse.setOrgId(signupCourse.getOrgId());
        studentCourse.setUserId(signupCourse.getUserId());
        studentCourse.setStudentMobile(orgStudent.getMobile());
        studentCourse.setStudentName(orgStudent.getName());
        studentCourse.setChargeUnit(signupCourse.getChargeUnit());
        if (signupCourse.getChargeUnit() == ChargeUnit.BY_HOUR.getCode()) {
            studentCourse.setLessonCount(signupCourse.getLessonCount() * 60);
        } else if (signupCourse.getChargeUnit() == ChargeUnit.BY_HALF_HOUR.getCode()) {
            studentCourse.setLessonCount(signupCourse.getLessonCount() * 30);
        } else {
            studentCourse.setLessonCount(signupCourse.getLessonCount());
        }
        studentCourse.setSignupPurchaseId(signupCourse.getSignupPurchaseId());
        return studentCourse;
    }

    private OrgStudentCourse updateLessonCountAndStatus(OrgStudentCourse studentCourse, OrgSignupCourse signupCourse) {

        Integer count = signupCourseService.sumAllLessonCount(signupCourse.getOrgId(), signupCourse.getOrgCourseId(), signupCourse.getUserId(), SignupCourseStatus.inClassStatus);
        StudentCourseKexiaoDocument financed = kexiaoApiService.finishCountMoney(signupCourse.getOrgId(), signupCourse.getOrgCourseId(), signupCourse.getUserId(), null, SignupCourseStatus.quitClassStatus);
        Integer transferClassCount =
                transferClassInfoService.transferLessonCount(signupCourse.getUserId(), signupCourse.getClassId());

        studentCourse.setChargeUnit(ChargeUnit.BY_HOUR.getCode());
        if (signupCourse.getChargeUnit() == ChargeUnit.BY_HOUR.getCode()
                || signupCourse.getChargeUnit() == ChargeUnit.BY_HALF_HOUR.getCode()
                || signupCourse.getChargeUnit() == ChargeUnit.BY_MINUTE.getCode()) {
            studentCourse.setLessonCount(count + financed.getFinishTime().intValue() - transferClassCount.intValue());
        } else {
            studentCourse.setLessonCount(count + financed.getFinishCount().intValue() - transferClassCount.intValue());
            studentCourse.setChargeUnit(ChargeUnit.BY_TIMES.getCode());
        }

        studentCourse.setSyncLessonCount(SyncSignupLessonCount.SYNC_SIGNUP.getCode());
        if (signupCourse.getStatus().intValue() == SignupCourseStatus.QUIT_CLASS.getCode()) {
            studentCourse.setStatus(StudentCourseStatus.WITHDRAW.getCode());
        } else {
            studentCourse.setStatus(StudentCourseStatus.NORMAL.getCode());
        }

        return studentCourse;
    }

}
