package com.baijia.tianxiao.biz.erp.service.impl;

import com.baijia.tianxiao.biz.erp.dto.request.ListLessonsRequestDto;
import com.baijia.tianxiao.biz.erp.dto.response.LessonResponseDto;
import com.baijia.tianxiao.biz.erp.dto.response.ListLessonResponseDto;
import com.baijia.tianxiao.biz.erp.dto.response.studentCenter.StudentCenterCourseListDto;
import com.baijia.tianxiao.biz.erp.dto.response.studentCenter.StudentCenterInfoDto;
import com.baijia.tianxiao.biz.erp.dto.response.studentCenter.StuentCenterCourseLessonDto;
import com.baijia.tianxiao.biz.erp.service.CourseLessonService;
import com.baijia.tianxiao.biz.erp.service.ErpStudentCenterService;
import com.baijia.tianxiao.consants.UserRole;
import com.baijia.tianxiao.constant.ClassOrderCompleteStatus;
import com.baijia.tianxiao.dal.constant.ChargeUnit;
import com.baijia.tianxiao.dal.org.dao.OrgStudentDao;
import com.baijia.tianxiao.dal.org.dao.OrgTeacherLessonDao;
import com.baijia.tianxiao.dal.org.po.OrgInfo;
import com.baijia.tianxiao.dal.org.po.OrgStudent;
import com.baijia.tianxiao.dal.org.po.TXAccount;
import com.baijia.tianxiao.dal.org.po.TXCommonRule;
import com.baijia.tianxiao.dal.wechat.dao.AuthorizationInfoDao;
import com.baijia.tianxiao.dto.smstoken.StudentSmsTokenDto;
import com.baijia.tianxiao.enums.CommonErrorCode;
import com.baijia.tianxiao.enums.RedisKeyEnums;
import com.baijia.tianxiao.exception.BussinessException;
import com.baijia.tianxiao.sal.comment.dto.CommentInfoDto;
import com.baijia.tianxiao.sal.comment.service.LessonCommentService;
import com.baijia.tianxiao.sal.common.api.KexiaoApiService;
import com.baijia.tianxiao.sal.common.api.RedisDefaultService;
import com.baijia.tianxiao.sal.common.dto.KexiaoStatisticsSuper;
import com.baijia.tianxiao.sal.common.dto.kexiao.KexiaoStatistics;
import com.baijia.tianxiao.sal.course.dto.response.ClassLessonInfoDto;
import com.baijia.tianxiao.sal.course.dto.response.CourseListReponseDto;
import com.baijia.tianxiao.sal.course.dto.response.TeacherResponseDto;
import com.baijia.tianxiao.sal.course.service.CourseStudentService;
import com.baijia.tianxiao.sal.course.service.CourseTeacherService;
import com.baijia.tianxiao.sal.course.service.OrgCourseListService;
import com.baijia.tianxiao.sal.course.service.OrgCourseService;
import com.baijia.tianxiao.sal.course.service.SmsService;
import com.baijia.tianxiao.sal.organization.constant.ClientType;
import com.baijia.tianxiao.sal.organization.constant.DeviceType;
import com.baijia.tianxiao.sal.organization.constant.DoorgodUserRole;
import com.baijia.tianxiao.sal.organization.dto.AuthToken;
import com.baijia.tianxiao.sal.organization.org.dto.OrgBaseInfoModel;
import com.baijia.tianxiao.sal.organization.org.service.OrgBaseService;
import com.baijia.tianxiao.sal.organization.org.service.OrgInfoService;
import com.baijia.tianxiao.sal.organization.org.service.TXAccountService;
import com.baijia.tianxiao.sal.organization.org.service.TXCommonRuleService;
import com.baijia.tianxiao.sal.wechat.constant.webauth.WebAuthScope;
import com.baijia.tianxiao.sal.wechat.helper.webauthlink.WechatWebAuthLinkBuilder;
import com.baijia.tianxiao.sqlbuilder.dto.PageDto;
import com.baijia.tianxiao.util.BaseUtils;
import com.baijia.tianxiao.util.StringUtils;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;

import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;
import java.util.Map;

import javax.annotation.Resource;

import lombok.NonNull;
import lombok.extern.slf4j.Slf4j;

@Slf4j
@Service
public class ErpStudentCenterServiceImpl implements ErpStudentCenterService {

    @Resource
    private CourseLessonService courseLessonService;

    @Resource
    private OrgCourseService orgCourseService;

    @Resource
    private OrgCourseListService orgCourseListService;

    @Resource
    private CourseStudentService orgCourseStudentService;

    @Resource
    private OrgBaseService orgBaseService;

    @Resource
    private LessonCommentService lessonCommentService;

    @Resource
    private CourseTeacherService courseTeacherService;

    @Resource
    private OrgTeacherLessonDao orgTeacherLessonDao;

    @Resource
    private OrgStudentDao orgStudentDao;

    @Resource
    private SmsService smsService;

    @Resource
    private TXAccountService txAccountService;

    @Autowired
    private KexiaoApiService kexiaoApiService;

    @Autowired
    private RedisDefaultService redisDefaultService;

    @Autowired
    private TXCommonRuleService txCommonRuleService;

    @Autowired
    private OrgInfoService orgInfoService;

    @Autowired
    private AuthorizationInfoDao authorizationInfoDao;

    // @Override
    // public StudentCenterLessonListDto getLessonList(Long orgId, Long studentId, Date firstLessonStartTime,
    // Date lastLessonStartTime, PageDto pageDto) {
    // StudentCenterLessonListDto lessonListDto = new StudentCenterLessonListDto();
    //
    // // 设置查询参数
    // ListLessonsRequestDto params = new ListLessonsRequestDto();
    // params.setFirstLessonStartTime(firstLessonStartTime.getTime());
    // params.setLastLessonStartTime(lastLessonStartTime.getTime());
    // params.setNeedcourseName(true);
    // params.setNeedRoomName(true);
    // params.setNeedTeacherName(true);
    // params.setPageDto(pageDto);
    // params.setStudentId(studentId);
    //
    // ListLessonResponseDto dto = courseLessonService.listLessons(orgId, params);
    //
    // return lessonListDto;
    //
    // }

    @Override
    @Transactional(readOnly = true)
    public StudentCenterCourseListDto getCourseList(Long orgId, Long studentId, PageDto pageDto) {
        log.info("orgId={},studentId={},page={}", orgId, studentId, pageDto);
        OrgBaseInfoModel orgBaseInfoModel = this.orgBaseService.getOrgBaseInfoModel(orgId);
        StudentCenterCourseListDto dto = new StudentCenterCourseListDto();
        dto.setLogo(orgBaseInfoModel.getLogo());
        dto.setOrgName(orgBaseInfoModel.getShortName());
        List<CourseListReponseDto> list = orgCourseListService.getCourseList(orgId, studentId, pageDto);
        OrgStudent orgstudent = orgStudentDao.getById(studentId);
        if (orgstudent == null) {
            throw new BussinessException(CommonErrorCode.PARAM_ERROR, "学生不存在");
        }
        for (CourseListReponseDto courseDto : list) {
            dto.addCourseListReponseDto(courseDto, buildKexiaoString(orgId, orgstudent.getUserId(), courseDto.getOrgCourseId()));
        }

        TXCommonRule txCommonRule = txCommonRuleService.getByOrgId(orgId.intValue());
        if (txCommonRule != null) {
            dto.setLeftKexiaoRule(txCommonRule.getLeftKexiaoRule());
        }
        return dto;
    }

    @Override
    @Transactional(readOnly = true)
    public StudentCenterInfoDto getInfo(@NonNull Long orgId, @NonNull Long studentId) {
        Map<String, String> map = this.orgCourseStudentService.getStudentNameAndAvatar(orgId, studentId);
        Map<String, Integer> courseLessonInfoMap =
                this.orgCourseStudentService.getStudentCourseLessonInfo(orgId, studentId);
        StudentCenterInfoDto studentCenterInfoDto = new StudentCenterInfoDto();
        studentCenterInfoDto.setAvatarUrl(map.get("avatarUrl"));
        studentCenterInfoDto.setName(map.get("name"));
        studentCenterInfoDto.setLessonToday(courseLessonInfoMap.get("lessonToday"));
        studentCenterInfoDto.setCourseCount(courseLessonInfoMap.get("courseCount"));
        studentCenterInfoDto.setCommentCount(courseLessonInfoMap.get("commentCount"));

        TXAccount superAccount = txAccountService.getTXAccountByOrgId(orgId.intValue());

        OrgInfo orgInfo = orgInfoService.getOrgInfoByOrgId(orgId.intValue());

        if (orgInfo != null) {

            List<String> accountModuleAuth = null;
            if (superAccount != null && !StringUtils.isEmpty(superAccount.getModuleAuth())) {
                accountModuleAuth = BaseUtils.strToList(superAccount.getModuleAuth(), ",");
            }
            if (CollectionUtils.isNotEmpty(accountModuleAuth) && accountModuleAuth.contains(String.valueOf(ClientType.HW.getCode()))) {
                studentCenterInfoDto.setHwCenter(AuthToken.assignMentStudentToken(orgId, orgInfo.getShortName(), studentId, map.get("name"), DoorgodUserRole.STUDENT.getRole(), ClientType.HW));
            }
            if (CollectionUtils.isNotEmpty(accountModuleAuth) && accountModuleAuth.contains(String.valueOf(ClientType.EXAM.getCode()))) {
                studentCenterInfoDto.setExamCenter(AuthToken.assignMentStudentToken(orgId, orgInfo.getShortName(), studentId, map.get("name"), DoorgodUserRole.STUDENT.getRole(), ClientType.EXAM));
            }
            if (CollectionUtils.isNotEmpty(accountModuleAuth) && accountModuleAuth.contains(String.valueOf(ClientType.GRADE.getCode()))) {
                studentCenterInfoDto.setGradeCenter(AuthToken.assignMentStudentToken(orgId, orgInfo.getShortName(), studentId, map.get("name"), DoorgodUserRole.STUDENT.getRole(), ClientType.GRADE));
            }
            if (CollectionUtils.isNotEmpty(accountModuleAuth) && accountModuleAuth.contains(String.valueOf(ClientType.POINTS.getCode()))) {
                studentCenterInfoDto.setPointsCenter(AuthToken.assignMentStudentToken(orgId, orgInfo.getShortName(), studentId, map.get("name"), DoorgodUserRole.STUDENT.getRole(), ClientType.POINTS));
            }
        }
        return studentCenterInfoDto;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public StuentCenterCourseLessonDto getCourseLesson(Long orgId, Long courseId, Long studentId, PageDto pageDto) {

        Long userId = this.orgStudentDao.getUserId(studentId);
        Preconditions.checkArgument(userId != null && userId > 0, "student not exist!");

        OrgBaseInfoModel orgBaseInfoModel = this.orgBaseService.getOrgBaseInfoModel(orgId);
        StuentCenterCourseLessonDto dto = new StuentCenterCourseLessonDto();
        dto.setLogo(orgBaseInfoModel.getLogo());
        dto.setOrgName(orgBaseInfoModel.getShortName());
        dto.setExtension(orgBaseInfoModel.getExtension());
        smsService.viewSms(orgId, courseId, userId, UserRole.STUDENT.getRole());
        ListLessonsRequestDto params = new ListLessonsRequestDto();
        params.setCourseId(courseId);
        params.setStudentId(studentId);
        params.setNeedStudentSignStatus(true);
        params.setNeedRoomName(true);
        params.setNeedTeacherName(true);
        params.setNeedcourseName(true);
        params.setPageDto(pageDto);

        dto.setKexiaoStr(buildKexiaoString(orgId, userId, courseId));

        ListLessonResponseDto listResponse = courseLessonService.listLessons(orgId, params, false);
        dto.setLessonCount(listResponse.getList().size());

        List<Long> lessonIds = Lists.newArrayList();
        for (LessonResponseDto respDto : listResponse.getList()) {
            lessonIds.add(respDto.getLessonId());
        }
        Map<Long, Boolean> commentMap = lessonCommentService.getStudentLessonCommentMap(userId, lessonIds);
        if (listResponse != null && !CollectionUtils.isEmpty(listResponse.getList())) {
            log.debug("respose list = {}", listResponse.getList());
            for (LessonResponseDto respDto : listResponse.getList()) {
                ClassLessonInfoDto classLessonInfoDto = new ClassLessonInfoDto();
                classLessonInfoDto.setLessonId(respDto.getLessonId());
                classLessonInfoDto.setIndex(respDto.getIndex());
                classLessonInfoDto.setStartTime(respDto.getLessonStartTime());
                classLessonInfoDto.setEndTime(respDto.getLessonEndTime());
                classLessonInfoDto.setHasComment(commentMap.get(respDto.getLessonId()));
                classLessonInfoDto.setSignStatus(respDto.getSignStatus());
                classLessonInfoDto.setSignStatusStr(respDto.getSignStatusStr());
                classLessonInfoDto.setTeacherName(respDto.getTeacherName());
                classLessonInfoDto.setIsOver(respDto.getIsOver());
                classLessonInfoDto.setCourseName(respDto.getCourseName());
                classLessonInfoDto.setRoomName(respDto.getRoomName());
                classLessonInfoDto.setLessonName(respDto.getLessonName());
                dto.getLessons().add(classLessonInfoDto);
            }
        }
        CourseListReponseDto courseListReponseDto = orgCourseService.getOrgBasicCourseInfo(orgId, courseId);
        if (courseListReponseDto != null) {
            dto.setCourseName(courseListReponseDto.getCourseName());
            dto.setCourseUrl(courseListReponseDto.getCoverUrl());
        }

        log.debug("dto = {}", dto);
        return dto;
    }

    @Override
    @Transactional(readOnly = true)
    public Map<String, Object> buildStudentCommentDetail(Long orgId, Long lessonId, Long studentId, Integer userRole) {

        Long userId = this.orgStudentDao.getUserId(studentId);
        Preconditions.checkArgument(userId != null, "student not exists!");
        if (userRole == null) {
            userRole = UserRole.STUDENT.getRole();
        }
        CommentInfoDto commentInfoDto =
                lessonCommentService.getCommentDetail(lessonId, userId, orgId, userRole);
        log.debug("commentInfoDto = {}", commentInfoDto);
        Map<String, Object> map = Maps.newHashMap();
        OrgBaseInfoModel orgBaseInfoModel = this.orgBaseService.getOrgBaseInfoModel(orgId);
        map.put("orgName", orgBaseInfoModel.getShortName());
        map.put("logo", orgBaseInfoModel.getLogo());
        map.put("courseName", commentInfoDto.getCourseName());
        List<Long> teacherIds = orgTeacherLessonDao.getUserIds(lessonId, orgId);
        TeacherResponseDto teacherResponseDto = null;
        if (CollectionUtils.isNotEmpty(teacherIds)) {
            teacherResponseDto = courseTeacherService.getTeacher(teacherIds.get(0), orgId);
            if (teacherResponseDto != null) {
                map.put("teacherName", teacherResponseDto.getTeacherName());
                map.put("avatarUrl", teacherResponseDto.getAvatar());
            }
        }
        map.put("index", commentInfoDto.getIndex());
        map.put("startTime", commentInfoDto.getStartTime());
        map.put("endTime", commentInfoDto.getEndTime());
        map.put("score", commentInfoDto.getScore());
        map.put("content", commentInfoDto.getContent() == null ? "" : commentInfoDto.getContent());
        map.put("urls", commentInfoDto.getUrls() == null ? "" : commentInfoDto.getUrls());
        map.put("customFastComment",
                null == commentInfoDto.getCustomFastComment() ? "" : commentInfoDto.getCustomFastComment());
        return map;
    }

    @Override
    @Transactional(readOnly = true)
    public Map<String, Object> buildLessonInfo(Long orgId, Long lessonId, Long studentId) {

        Map<String, Object> map = orgCourseService.buildLessonInfo(orgId, lessonId, studentId);
        OrgBaseInfoModel orgBaseInfoModel = this.orgBaseService.getOrgBaseInfoModel(orgId);
        map.put("orgName", orgBaseInfoModel.getShortName());
        map.put("logo", orgBaseInfoModel.getLogo());
        map.put("extension", orgBaseInfoModel.getExtension());
        return map;

    }

    @Override
    public void quitStudentCenter(String token) {
        String key = RedisKeyEnums.ERP.QUIT_STUDENT_CENTER_TOKEN + token;
        log.info("quit student center key== {}", key);
        if (redisDefaultService.get(key) == null) {
            log.info("quit student center == {},{}", key, redisDefaultService);
            redisDefaultService.setWithExpire(key, "success".getBytes(), 24 * 60);
        }
    }

    @Override
    public String getStudentCenterLoginUrl(String smsToken) {
        String url = "";
        try {
            StudentSmsTokenDto token = StudentSmsTokenDto.fromTokenStr(smsToken);
            if (token != null) {
                url = WechatWebAuthLinkBuilder.studentCenter(WebAuthScope.BASE, token.getWechatAppId());
            }
        } catch (Exception e) {
            log.warn("get student center login url e={}", e);
        }
        return url;
    }

    private String buildKexiaoString(Long orgId, Long userId, Long courseId) {
        TXCommonRule txCommonRule = txCommonRuleService.getByOrgId(orgId.intValue());
        if (txCommonRule != null && txCommonRule.getLeftKexiaoRule().intValue() == 0) {
            return "";
        }

        KexiaoStatistics statistics = kexiaoApiService.queryKexiaoStatByStudentClass(orgId, userId, courseId);
        if (statistics.getCompleteStatus() != ClassOrderCompleteStatus.COMPLETED.getCode() && !statistics.isRefund()) {
            return "";
        }
        KexiaoStatisticsSuper orgCourseDto = new KexiaoStatisticsSuper();
        kexiaoApiService.fillKexiaoData(orgCourseDto, statistics);

        StringBuffer stringBuffer = new StringBuffer();
        if (ChargeUnit.isByTimes(statistics.getChargeUnit())) {
            stringBuffer.append("总").append(orgCourseDto.getTotalClassTimesForKexiao()).append("次/");
            stringBuffer.append("已上").append(orgCourseDto.getFinishClassTimesForKexiao()).append("次/");
            stringBuffer.append("剩余").append(orgCourseDto.getLeftClassTimesForKexiao()).append("次");
        } else {
            stringBuffer.append("总").append(orgCourseDto.getTotalClassTimesForKexiao()).append("小时/");
            stringBuffer.append("已上").append(orgCourseDto.getFinishClassTimesForKexiao()).append("小时/");
            stringBuffer.append("剩余").append(orgCourseDto.getLeftClassTimesForKexiao()).append("小时");
        }
        return stringBuffer.toString();
    }
}

