/**
 * Baijiahulian.com Inc. Copyright (c) 2014-2016 All Rights Reserved.
 */

package com.baijia.tianxiao.biz.erp.service.impl;

import com.baijia.tianxiao.biz.erp.constant.SmsContentConfig;
import com.baijia.tianxiao.biz.erp.dto.response.studentCenter.StudentSendReceiveCommentsDto;
import com.baijia.tianxiao.biz.erp.service.ErpLessonCommentService;
import com.baijia.tianxiao.consants.UserRole;
import com.baijia.tianxiao.constants.UserRoleEnum;
import com.baijia.tianxiao.constants.sms.TxSmsCodeType;
import com.baijia.tianxiao.dal.comment.dao.OrgLessonCommentSmsDao;
import com.baijia.tianxiao.dal.comment.po.OrgLessonCommentSms;
import com.baijia.tianxiao.dal.org.dao.OrgClassLessonDao;
import com.baijia.tianxiao.dal.org.dao.OrgCourseDao;
import com.baijia.tianxiao.dal.org.dao.OrgInfoDao;
import com.baijia.tianxiao.dal.org.dao.OrgStudentDao;
import com.baijia.tianxiao.dal.org.dao.OrgStudentLessonDao;
import com.baijia.tianxiao.dal.org.dao.OrgTeacherLessonDao;
import com.baijia.tianxiao.dal.org.po.OrgClassLesson;
import com.baijia.tianxiao.dal.org.po.OrgCourse;
import com.baijia.tianxiao.dal.org.po.OrgInfo;
import com.baijia.tianxiao.dal.org.po.OrgStudent;
import com.baijia.tianxiao.dal.org.po.OrgStudentLesson;
import com.baijia.tianxiao.dal.org.po.OrgTeacherLesson;
import com.baijia.tianxiao.dal.user.dao.TeacherDao;
import com.baijia.tianxiao.dal.user.po.Teacher;
import com.baijia.tianxiao.dal.wechat.constant.WechateTemplateMsgType;
import com.baijia.tianxiao.exception.BussinessException;
import com.baijia.tianxiao.sal.comment.dto.CommentAuditDto;
import com.baijia.tianxiao.sal.comment.dto.CommentInfoDto;
import com.baijia.tianxiao.sal.comment.service.LessonCommentAudiService;
import com.baijia.tianxiao.sal.comment.service.LessonCommentService;
import com.baijia.tianxiao.sal.common.api.CommonMsgService;
import com.baijia.tianxiao.sal.common.dto.msg.SendMsgRequest;
import com.baijia.tianxiao.sal.common.dto.wechatMsgRequest.AfterCourseCommentMsg;
import com.baijia.tianxiao.sal.common.utils.NotifyMessageUtils;
import com.baijia.tianxiao.sal.common.utils.WechatTemplateMsgHelper;
import com.baijia.tianxiao.sal.course.constant.CourseErrorCode;
import com.baijia.tianxiao.sal.course.constant.RestConfig;
import com.baijia.tianxiao.sal.course.dto.response.TeacherResponseDto;
import com.baijia.tianxiao.sal.course.service.CourseTeacherService;
import com.baijia.tianxiao.sal.organization.org.service.TXSaleClueRuleService;
import com.baijia.tianxiao.sal.student.api.OrgStudentService;
import com.baijia.tianxiao.sal.student.dto.response.StudentInfoReponseDto;
import com.baijia.tianxiao.sal.teacher.api.TeacherService;
import com.baijia.tianxiao.sal.teacher.dto.OrgTeacherResponseDto;
import com.baijia.tianxiao.sqlbuilder.dto.PageDto;
import com.baijia.tianxiao.util.CourseSmsTokenUtil;
import com.baijia.tianxiao.util.ShortUrlUtil;
import com.baijia.tianxiao.util.SmsContentHelper;
import com.baijia.tianxiao.util.collection.CollectorUtil;
import com.baijia.tianxiao.util.mobile.MaskUtil;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;

import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;

import javax.annotation.Resource;

import lombok.NonNull;
import lombok.extern.slf4j.Slf4j;

/**
 * @title ErpLessonCommentServiceImpl
 * @desc
 * @author shanyu
 * @date 2016年1月7日
 * @version 1.0
 */
@Slf4j
@Service
public class ErpLessonCommentServiceImpl implements ErpLessonCommentService {

    @Deprecated
    public static String lessonStartStudent = "%s，你在%s的%s将在%s开始上课。赶快出发吧。如需请假，请拨打4000122166转%s。";

    private static String defaultName = "-";

    private static String remark = "点击这里去给老师评价吧";

    @Resource
    private OrgStudentLessonDao orgStudentLessonDao;

    @Resource
    private OrgTeacherLessonDao orgTeacherLessonDao;

    @Resource
    private OrgLessonCommentSmsDao orgLessonCommentSmsDao;

    @Resource
    private OrgClassLessonDao orgClassLessonDao;

    @Resource
    private OrgStudentDao orgStudentDao;

    @Resource
    private OrgCourseDao orgCourseDao;

    @Resource
    private TeacherDao teacherDao;

    @Resource
    private TeacherService teacherService;

    @Resource
    private LessonCommentService lessonCommentService;

    @Resource
    private LessonCommentAudiService LessonCommentAudiService;

    @Resource
    private OrgStudentService orgStudentService;

    @Resource
    private CourseTeacherService courseTeacherService;

    @Resource
    private OrgInfoDao orgInfoDao;

    @Autowired(required = false)
    private CommonMsgService commonMsgService;

    @Resource
    private Environment environment;

    @Resource
    private TXSaleClueRuleService tXSaleClueRuleService;

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void sendStudentSms(Long orgId, Long lessonId) {
        // if(!checkOrgPermissionEvaluateMsg(orgId)){
        // return;
        // }
        Preconditions.checkArgument(orgId != null, "orgId is null!");
        Preconditions.checkArgument(lessonId != null, "lessonId is null!");
        OrgClassLesson lesson = this.orgClassLessonDao.getById(lessonId);
        OrgInfo orgInfo = this.orgInfoDao.getOrgInfo(orgId.intValue());
        if (lesson == null) {
            throw new BussinessException(CourseErrorCode.LESSON_NOT_EXIST);
        }
        if (this.orgTeacherLessonDao.getByLessonId(orgId, lessonId) == null) {
            throw new BussinessException(CourseErrorCode.LESSON_NOT_SET_TEACHER_SMS);
        }
        List<Long> userIds = this.orgStudentLessonDao.getUserIds(lessonId, orgId);
        Map<Long, OrgStudent> studentMap = this.orgStudentDao.getStudentMap(userIds, orgId);
        OrgCourse course = this.orgCourseDao.getById(lesson.getCourseId(), "name");
        OrgTeacherLesson teacherLesson = this.orgTeacherLessonDao.getByLessonId(orgId, lessonId);
        Teacher teacher = null;
        if (teacherLesson != null) {
            teacher = this.teacherDao.getByUserId(teacherLesson.getTeacherId());
        }
        for (Long userId : userIds) {
            OrgStudent student = studentMap.get(userId);
            if (student != null) {
                String url = getStudentCommentUrl(orgId, lesson.getCourseId(), course.getName(), student,
                    lesson.getNumber(), lessonId);
                url = ShortUrlUtil.getShortUrl(url);
                String smsContent = SmsContentHelper.createNotifyCommentToStuSmsMsg(teacher.getRealName(),
                    lesson.getStartTime().getTime(), url, orgInfo.getShortName());

                String name = student.getName();
                if (StringUtils.isBlank(name)) {
                    name = student.getNickName();
                }
                if (StringUtils.isBlank(name)) {
                    name = MaskUtil.maskMobile(student.getMobile());
                }

                AfterCourseCommentMsg msg =
                    AfterCourseCommentMsg.newInstance(name, course.getName(), teacher.getRealName(), url);
                SendMsgRequest createSendMsgRequestToStu =
                    WechatTemplateMsgHelper.createSendMsgRequestToStu(orgId, student.getMobile(), student.getId(),
                        student.getWeixin(), smsContent, WechateTemplateMsgType.COURSE_EVALUATION_TO_STU, msg);

                try {
                    createSendMsgRequestToStu.setSmsCodeType(TxSmsCodeType.NOTIFY_TO_COMMENT);
                    if (commonMsgService.sendMsg(createSendMsgRequestToStu)) {
                        updateSmsCount(orgId, userId, lessonId);
                    }
                } catch (Exception e) {
                    log.error(e.getMessage());
                }

            }
        }
    }

    /**
     * 构造学生评价提醒信息
     * 
     * @param teacherName
     * @param smsContent
     * @param content
     * @param lesson
     * @param course
     * @param orgInfo
     * @param student
     * @param url
     * @return
     */
    @SuppressWarnings("unused")
    @Deprecated
    private SendMsgRequest getStudentCommentRemend(String teacherName, String smsContent, String content,
        OrgClassLesson lesson, OrgCourse course, OrgInfo orgInfo, OrgStudent student, String url) {
        SendMsgRequest request = new SendMsgRequest();
        request.setOrgId(orgInfo.getOrgId().longValue());
        request.setMobile(student.getMobile());
        request.setCountSms(false);
        request.setReceiverId(student.getId());
        request.setWeixinOpenId(student.getWeixin());
        request.setReceiverRole(UserRoleEnum.STUDENT);
        request.setSenderId(orgInfo.getOrgId().longValue());
        request.setSenderRole(UserRoleEnum.ORG);
        request.setWechatTemplateId(WechateTemplateMsgType.COURSE_EVALUATION_TO_STU.getValue());
        Map<String, Object> params = Maps.newHashMap();
        request.setSmsContent(smsContent);
        params.put("first", content);
        params.put("remark", remark);
        params.put("keyword1", getStringValue(student.getName()));
        params.put("keyword2",
            getStringValue(course.getName()) + NotifyMessageUtils.generateLessonName(lesson.getName(), true));
        params.put("keyword3", getStringValue(teacherName));
        params.put("url", url);
        request.setWechatParams(params);

        log.debug("remind student comment the course! data={}", request);
        return request;
    }

    /**
     * 没有名称返回“－”
     * 
     * @param message
     * @return
     */
    private String getStringValue(String message) {
        if (StringUtils.isBlank(message)) {
            return defaultName;
        }
        return message;
    }

    /**
     * 获取学生评价提醒短信内容
     * 
     * @param orgId
     * @param lessonName
     * @param lessonId
     * @return
     */
    @Transactional(readOnly = true)
    public String getStudentSmsContent(Long orgId, Long courseId, String courseName, String lessonName,
        OrgStudent student, Integer index, Long lessonId, boolean withUrl) {
        String url = getStudentCommentUrl(orgId, courseId, courseName, student, index, lessonId);
        String name = student.getName();
        if (StringUtils.isBlank(name)) {
            name = student.getNickName();
        }
        if (StringUtils.isBlank(name)) {
            name = MaskUtil.maskMobile(student.getMobile());
        }
        url = ShortUrlUtil.getShortUrl(url);
        StringBuilder sb = new StringBuilder();
        sb.append(String.format(SmsContentConfig.LESSON_COMMENT_STUDENT_SMS, name, courseName,
            NotifyMessageUtils.generateLessonName(lessonName, false)));
        if (withUrl) {
            return sb.append(String.format(SmsContentConfig.URL, url)).toString();
        } else {
            return sb.toString();
        }
    }

    /**
     * 获取学员评价提醒url
     * 
     * @param orgId
     * @param courseId
     * @param courseName
     * @param student
     * @param index
     * @param lessonId
     * @return
     */
    private String getStudentCommentUrl(Long orgId, Long courseId, String courseName, OrgStudent student, Integer index,
        Long lessonId) {
        Map<String, Object> params = Maps.newHashMap();
        params.put("studentId", student.getId());
        params.put("courseId", courseId);
        String token;
        try {
            token = CourseSmsTokenUtil.encodeExpireToken(params, orgId, null);
            String url = environment.getProperty(RestConfig.student_center_add_comment_url);
            url = String.format(url, token, lessonId);
            return url;
        } catch (Exception e) {
            log.warn("get lesson student comment error", e);
            return null;
        }
    }

    public static void main(String[] args) throws Exception {
        Map<String, Object> params = Maps.newHashMap();
        params.put("studentId", 11114);
        params.put("courseId", 727);
        String token = CourseSmsTokenUtil.encodeToken(params, (long) 3618);
        System.out.println(token);
    }

    /**
     * 更新短信通知次数
     * 
     * @param orgId
     * @param userId
     * @param lessonId
     */
    private void updateSmsCount(Long orgId, Long userId, Long lessonId) {
        OrgLessonCommentSms sms =
            orgLessonCommentSmsDao.getCommentSms(orgId, lessonId, userId, UserRole.STUDENT.getRole());
        if (sms == null) {
            sms = new OrgLessonCommentSms();
            sms.setLessonId(lessonId);
            sms.setOrgId(orgId);
            sms.setSend(1);
            sms.setUserId(userId);
            sms.setUserRole(UserRole.STUDENT.getRole());
            this.orgLessonCommentSmsDao.save(sms);
        } else {
            sms.setSend(sms.getSend() + 1);
            this.orgLessonCommentSmsDao.update(sms, "send");
        }
    }

    @Override
    public List<CommentInfoDto> queryComments(Long orgId, Collection<Long> courseIds, Collection<Long> teacherIds,
        Integer commentReqType, Boolean isSystem, Integer userRole, PageDto pageDto) {
        List<CommentInfoDto> comments = this.lessonCommentService.queryComments(orgId, courseIds, teacherIds,
            commentReqType, isSystem, userRole, pageDto);
        Set<Long> fromIds = Sets.newHashSet();
        Set<Long> toIds = Sets.newHashSet();
        for (CommentInfoDto commentInfoDto : comments) {
            fromIds.add(commentInfoDto.getFromId());
            toIds.add(commentInfoDto.getToId());
        }
        getAndSetNameAndAVatar(orgId, fromIds, toIds, userRole, comments);
        return comments;
    }

    @Override
    @Transactional(readOnly = true)
    public CommentInfoDto getCommentByCommentId(Long orgId, Long commentId) {
        CommentInfoDto dto = lessonCommentService.getComment(orgId, commentId);
        if (null != dto) {
            Set<Long> fromIds = Sets.newHashSet();
            Set<Long> toIds = Sets.newHashSet();
            fromIds.add(dto.getFromId());
            toIds.add(dto.getToId());
            getAndSetNameAndAVatar(orgId, fromIds, toIds, dto.getUserRole(), Lists.newArrayList(dto));
            return dto;
        }
        return null;
    }

    @Override
    @Transactional(readOnly = true)
    public StudentSendReceiveCommentsDto getStudentSendAndRecieveComments(@NonNull Long orgId, @NonNull Long lessonId,
        @NonNull Long studentUserId) {
        StudentSendReceiveCommentsDto result = new StudentSendReceiveCommentsDto();
        OrgTeacherLesson teacherLesson = orgTeacherLessonDao.getByLessonId(orgId, lessonId);
        OrgStudentLesson studentLesson = orgStudentLessonDao.getByLessonIdAndUserId(lessonId, studentUserId);
        if (null != studentLesson && null != teacherLesson) {

            List<CommentInfoDto> sendComments = this.lessonCommentService.getComments(orgId, lessonId,
                Lists.newArrayList(studentUserId), null, UserRole.STUDENT.getRole());
            if (CollectionUtils.isNotEmpty(sendComments)) {
                Set<Long> fromIds = Sets.newHashSet();
                Set<Long> toIds = Sets.newHashSet();
                for (CommentInfoDto commentInfoDto : sendComments) {
                    fromIds.add(commentInfoDto.getFromId());
                    toIds.add(commentInfoDto.getToId());
                }
                getAndSetNameAndAVatar(orgId, fromIds, toIds, UserRole.STUDENT.getRole(), sendComments);
                result.setSendComments(sendComments);
            }

            List<CommentInfoDto> revieveComments = this.lessonCommentService.getComments(orgId, lessonId, null,
                Lists.newArrayList(studentUserId), UserRole.TEACHER.getRole());
            if (CollectionUtils.isNotEmpty(revieveComments)) {
                Set<Long> fromIds = Sets.newHashSet();
                Set<Long> toIds = Sets.newHashSet();
                for (CommentInfoDto commentInfoDto : revieveComments) {
                    fromIds.add(commentInfoDto.getFromId());
                    toIds.add(commentInfoDto.getToId());
                }
                getAndSetNameAndAVatar(orgId, fromIds, toIds, UserRole.TEACHER.getRole(), revieveComments);
                result.setReceiveComments(revieveComments);
            }
        }
        return result;
    }

    /**
     * 设置名字和头像信息
     * 
     * @param orgId
     * @param fromIds
     * @param toIds
     * @param userRole
     * @param comments
     */
    private void getAndSetNameAndAVatar(Long orgId, Collection<Long> fromIds, Collection<Long> toIds, Integer userRole,
        List<CommentInfoDto> comments) {
        if (userRole.intValue() == UserRole.STUDENT.getRole()) {// 学员评价
            Map<Long, StudentInfoReponseDto> studentMap = this.orgStudentService.getUserIdStudentDtoMap(fromIds, orgId);
            Map<Long, OrgTeacherResponseDto> teacherMap = this.teacherService.getOrgTeacherMap(orgId, toIds);
            log.debug("studentMap={}", studentMap);
            log.debug("teachermap={}", teacherMap);
            for (CommentInfoDto commentInfoDto : comments) {
                StudentInfoReponseDto student = studentMap.get(commentInfoDto.getFromId());
                OrgTeacherResponseDto teacher = teacherMap.get(commentInfoDto.getToId());
                if (student != null) {
                    commentInfoDto.setFromName(student.getName());
                    commentInfoDto.setFromAvatar(student.getAvatarUrl());
                    // commentInfoDto.setFromId(student.getStudentId());
                }
                if (teacher != null) {
                    commentInfoDto.setToName(teacher.getTeacherName());
                    commentInfoDto.setToAvatar(teacher.getAvatar());
                }
            }
        } else {// 老师评价
            Map<Long, StudentInfoReponseDto> studentMap = this.orgStudentService.getUserIdStudentDtoMap(toIds, orgId);
            Map<Long, OrgTeacherResponseDto> teacherMap = this.teacherService.getOrgTeacherMap(orgId, fromIds);
            log.debug("studentMap={}", studentMap);
            log.debug("teachermap={}", teacherMap);
            for (CommentInfoDto commentInfoDto : comments) {
                StudentInfoReponseDto student = studentMap.get(commentInfoDto.getToId());
                OrgTeacherResponseDto teacher = teacherMap.get(commentInfoDto.getFromId());
                if (teacher != null) {
                    commentInfoDto.setFromName(teacher.getTeacherName());
                    commentInfoDto.setFromAvatar(teacher.getAvatar());
                }
                if (student != null) {
                    commentInfoDto.setToName(student.getName());
                    commentInfoDto.setToAvatar(student.getAvatarUrl());
                    // commentInfoDto.setToId(student.getStudentId());
                }
            }
        }
    }

    @Override
    public List<CommentAuditDto> getTeacherAuditList(Long orgId, Integer userRole, Boolean isSystem, PageDto pageDto) {
        List<TeacherResponseDto> teachers = this.courseTeacherService.listOrgTeacher(null, orgId, null, null, pageDto);
        Map<Long, TeacherResponseDto> teacherMap =
            CollectorUtil.collectMap(teachers, new Function<TeacherResponseDto, Long>() {
                @Override
                public Long apply(TeacherResponseDto arg0) {
                    return arg0.getTeacherId();
                }
            });
        List<CommentAuditDto> comments =
            this.LessonCommentAudiService.getTeacherAuditList(orgId, teacherMap.keySet(), userRole, isSystem);
        for (CommentAuditDto commentAuditDto : comments) {
            TeacherResponseDto teacher = teacherMap.get(commentAuditDto.getId());
            if (teacher != null) {
                commentAuditDto.setAvatarUrl(teacher.getAvatar());
                commentAuditDto.setName(teacher.getTeacherName());
            }
        }
        return comments;
    }

    @Override
    @Transactional(readOnly = true)
    public List<CommentInfoDto> getLessonCommentsWithLessonInfo(Long orgId, Long studentId, Integer userRole,
        PageDto pageDto) {
        List<CommentInfoDto> list =
            lessonCommentService.getLessonCommentsWithLessonInfo(orgId, studentId, userRole, pageDto);
        Set<Long> fromIds = Sets.newHashSet();
        Set<Long> toIds = Sets.newHashSet();
        for (CommentInfoDto commentInfoDto : list) {
            fromIds.add(commentInfoDto.getFromId());
            toIds.add(commentInfoDto.getToId());
        }
        getAndSetNameAndAVatar(orgId, fromIds, toIds, userRole, list);
        return list;
    }

}
