
/**
 * Baijiahulian.com Inc. Copyright (c) 2014-2016 All Rights Reserved.
 */

package com.baijia.tianxiao.biz.erp.service;

import com.baijia.tianxiao.biz.erp.dto.request.ListLessonsRequestDto;
import com.baijia.tianxiao.biz.erp.dto.request.TimeRangeRequestDto;
import com.baijia.tianxiao.biz.erp.dto.response.LessonResponseDto;
import com.baijia.tianxiao.biz.erp.dto.response.schedule.ListLessonDtoInfo;

import java.util.List;

/**
 * @title CourseLessonService
 * @desc TODO
 * @author bjhl
 * @date 2016年1月4日
 * @version 1.0
 */

public interface ScheduleLessonService {

    /**
     * 获取课表
     * 
     * @param orgId
     * @param requestDto
     * @return
     */
    ListLessonDtoInfo getScheduleLessons(Long orgId, ListLessonsRequestDto requestDto, boolean needToday);

    /**
     * @param orgId
     * @param requestDto
     * @param needToday
     * @return
     */
        
    ListLessonDtoInfo getSignInScheduleLessons(Long orgId, ListLessonsRequestDto requestDto, boolean needToday);

    /**
     * 获取指定时间范围内的课节列表
     * @param orgId
     * @param requestDto
     * @return 一天内的课节
     */
    List<LessonResponseDto> getScheduleLessons(Long orgId, TimeRangeRequestDto requestDto);
}
