
/**
 * Baijiahulian.com Inc. Copyright (c) 2014-2016 All Rights Reserved.
 */

package com.baijia.tianxiao.biz.erp.service;

import com.baijia.tianxiao.biz.erp.dto.response.studentCenter.StudentSendReceiveCommentsDto;
import com.baijia.tianxiao.sal.comment.dto.CommentAuditDto;
import com.baijia.tianxiao.sal.comment.dto.CommentInfoDto;
import com.baijia.tianxiao.sqlbuilder.dto.PageDto;

import lombok.NonNull;
import org.springframework.stereotype.Service;

import java.util.Collection;
import java.util.List;

/**
 * @title ErpLessonCommentService
 * @desc TODO
 * @author shanyu
 * @date 2016年1月7日
 * @version 1.0
 */

@Service
public interface ErpLessonCommentService {

    /**
     * 一键提醒学员评价
     * 
     * @param orgId
     * @param lessonId
     */
    public void sendStudentSms(Long orgId, Long lessonId);

    /**
     * 学员评价列表
     * 
     * @param orgId 机构id
     * @param courseIds 班级
     * @param teacherIds 老师
     * @param commentReqType
     * @param isSystem
     * @param pageDto
     * @return
     */
    List<CommentInfoDto> queryComments(Long orgId, Collection<Long> courseIds, Collection<Long> teacherIds,
        Integer commentReqType, Boolean isSystem, Integer userRole, PageDto pageDto);

    /**
     * 获取老师评价统计列表
     * 
     * @param orgId
     * @param userRole
     * @param isSystem
     * @param pageDto
     * @return
     */
    List<CommentAuditDto> getTeacherAuditList(Long orgId, Integer userRole, Boolean isSystem, PageDto pageDto);

    StudentSendReceiveCommentsDto getStudentSendAndRecieveComments(@NonNull Long orgId, @NonNull Long lessonId, @NonNull Long studentUserId);

    CommentInfoDto getCommentByCommentId(Long orgId, Long commentId);

    List<CommentInfoDto> getLessonCommentsWithLessonInfo(Long orgId, Long studentId, Integer userRole, PageDto pageDto);
}
