package com.baijia.tianxiao.biz.erp.dto.response.studentCenter;

import java.util.List;

import com.baijia.tianxiao.dal.constant.ChargeUnit;
import com.baijia.tianxiao.sal.common.dto.KexiaoStatisticsSuper;
import com.baijia.tianxiao.sal.common.dto.kexiao.KexiaoStatistics;
import com.baijia.tianxiao.util.NumberUtil;
import com.fasterxml.jackson.annotation.JsonIgnore;
import lombok.Data;

import com.baijia.tianxiao.sal.course.dto.response.CourseListReponseDto;
import com.google.common.collect.Lists;

@Data
public class StudentCenterCourseListDto {
    private String orgName;
    private String logo;
    private String page_str;
    private Integer leftKexiaoRule;
    // private String orgUrl;
    private List<OrgCourseDto> list = Lists.newArrayList();

    public void addCourseListReponseDto(CourseListReponseDto dto, String kexiaoString) {
        OrgCourseDto orgCourseDto = new OrgCourseDto();
        orgCourseDto.setCourseName(dto.getCourseName());
        orgCourseDto.setOrgCourseId(dto.getOrgCourseId());
        orgCourseDto.setCourseUrl(dto.getCoverUrl());
        orgCourseDto.setOrgCourseNumber(dto.getOrgCourseNumber());
        orgCourseDto.setLessonCount(dto.getLessonCount() == null ? 0 : dto.getLessonCount());
        orgCourseDto.setStatus(dto.getStatus());

        orgCourseDto.setKexiaoStr(kexiaoString);

        list.add(orgCourseDto);
    }

    @Data
    public static class OrgCourseDto {
        private Long orgCourseId;
        private Long orgCourseNumber;
        private String courseUrl;
        private String courseName;
        private Integer lessonCount = 0;
        private Integer status;
        private String kexiaoStr;

    }
}
