
/**
 * Baijiahulian.com Inc. Copyright (c) 2014-2016 All Rights Reserved.
 */

package com.baijia.tianxiao.biz.erp.dto.response.schedule;

import lombok.Data;

import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;

/**
 * @title ListLessonDtoInfo
 * @desc TODO
 * @author shanyu
 * @date 2016年1月3日
 * @version 1.0
 */
@Data
public class ListLessonDtoInfo {

    private List<DayLessonInfoDto> list;
    
    private Integer courseType;

    private Date firstLessonStartTime;

    private Date lastLessonStartTime;

    private String type;

    private String page_str;

    private int teacherSignin;

    /**
     * 按日期正序排序
     * 
     * @param lessons
     * @param firstLessonStartTime
     * @param lastLessonStartTime
     */
    public ListLessonDtoInfo(List<DayLessonInfoDto> lessons, Integer courseType, Date firstLessonStartTime, Date lastLessonStartTime) {
        this.firstLessonStartTime = firstLessonStartTime;
        this.lastLessonStartTime = lastLessonStartTime;
        this.list = lessons;
        this.courseType = courseType;
        Collections.sort(this.list, new Comparator<DayLessonInfoDto>() {
            @Override
            public int compare(DayLessonInfoDto o1, DayLessonInfoDto o2) {
                return o1.getDateInfo().getDate().compareTo(o2.getDateInfo().getDate());
            }
        });
    }

}
