
/**
 * Baijiahulian.com Inc. Copyright (c) 2014-2016 All Rights Reserved.
 */

package com.baijia.tianxiao.biz.erp.dto.response.schedule;

import com.baijia.tianxiao.biz.erp.dto.response.LessonResponseDto;
import lombok.Data;

import java.util.Collections;
import java.util.Comparator;
import java.util.List;

/**
 * @title DayLessonInfoDto
 * @desc 一天的课节信息
 * @author shanyu
 * @date 2016年1月4日
 * @version 1.0
 */
@Data
public class DayLessonInfoDto {
    /**
     * 课节信息
     */
    private List<LessonResponseDto> lessons;

    /**
     * 日期信息
     */
    private DateInfoDto dateInfo;

    /**
     * 排序，按时间正序排列
     * 
     * @param lessons
     * @param dateInfo
     */
    public DayLessonInfoDto(List<LessonResponseDto> lessons, DateInfoDto dateInfo) {
        this.lessons = lessons;
        this.dateInfo = dateInfo;
        Collections.sort(this.lessons, new Comparator<LessonResponseDto>() {
            @Override
            public int compare(LessonResponseDto o1, LessonResponseDto o2) {
                return o1.getLessonStartTime().compareTo(o2.getLessonStartTime());
            }
        });
    }
}
