
/**
 * Baijiahulian.com Inc. Copyright (c) 2014-2016 All Rights Reserved.
 */

package com.baijia.tianxiao.biz.erp.dto.response.schedule;

import com.baijia.tianxiao.util.date.DateUtil;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.Date;

/**
 * @title DateTimeInfoDto
 * @desc TODO
 * @author shanyu
 * @date 2016年1月3日
 * @version 1.0
 */
@Data
@NoArgsConstructor
public class DateInfoDto {

    private Integer weekDay;

    private String date;

    private Boolean isToday;

    public DateInfoDto(String date) {
        this.date = date;
        Date day = DateUtil.getDateByStr(date);
        this.weekDay = DateUtil.getWeekDay(day);
        isToday = date.equals(DateUtil.getStrByDateFormate(new Date(), "yyyy-MM-dd"));
    }

}
