
/**
 * Baijiahulian.com Inc. Copyright (c) 2014-2015 All Rights Reserved.
 */
package com.baijia.tianxiao.biz.erp.dto.response;

import com.baijia.tianxiao.biz.erp.constant.CourseSignStatus;
import com.baijia.tianxiao.enums.PermissionType;
import com.baijia.tianxiao.sal.course.dto.response.OrgStudentsChooseListDto;
import com.baijia.tianxiao.util.date.DateUtil;
import lombok.Data;

import java.util.Calendar;
import java.util.Date;
import java.util.List;

/**
 * @author cxm
 * @version 1.0
 * @title LessonTimeTableRequestDto
 * @desc TODO
 * @date 2015年12月29日
 */
@Data
public class LessonTimeTableResponseDto {

    private Long lessonId;

    private String lessonName;

    private int index;

    private Date startTime;

    private Date endTime;

    private Long teacherId;

    private String teacherName;

    private Long roomId;

    private String roomName;

    private Long courseId;

    private Integer courseType;

    private String courseName;

    private Date createTime;

    private Date updateTime;

    private String dayStr;

    private int week;

    private String beginTimeStr;

    private String endTimeStr;

    private String courseColor;

    private int studentCount;

    private int signCount;

    private List<OrgStudentsChooseListDto> students;

    private int signStatus;

    private String signStatusStr;

    private String signRemark;

    private Integer courseFinish;

    private Integer editable = PermissionType.FORBIDDEN.getType();//课节是否可以编辑，1：可编辑，2：不能编辑

    private Integer signable = PermissionType.FORBIDDEN.getType();//是否可以签到,1:可签到，2：不能签到

    private Integer commentable = PermissionType.FORBIDDEN.getType();//是否可以评价,1:可评价，2：不能评价

    public void setStartTime(Date startTime) {
        this.startTime = startTime;
        String format = DateUtil.getStrByDateFormate(startTime, "MM月dd日 HH:mm");
        String[] formats = format.split(" ");
        Calendar cal = Calendar.getInstance();
        cal.setTime(startTime);
        this.week = cal.get(Calendar.DAY_OF_WEEK);
        this.beginTimeStr = formats[1];
        this.dayStr = formats[0];
    }

    public void setEndTime(Date endTime) {
        this.endTime = endTime;
        this.endTimeStr = DateUtil.getStrByDateFormate(endTime, "HH:mm");
    }

    public void setSignStatusEnum(CourseSignStatus signStatusEnum) {
        if (signStatusEnum != null) {
            this.signStatus = signStatusEnum.getCode();
            this.signStatusStr = signStatusEnum.getNote();
        }
    }

    public void setStudents(List<OrgStudentsChooseListDto> students) {
        this.students = students;
        if (students != null) {
            this.studentCount = students.size();
        }
    }

    public void increaseSignStudent() {
        this.signCount++;
    }
}
