package com.baijia.tianxiao.biz.erp.dto.request;

import com.baijia.tianxiao.sqlbuilder.dto.PageRequestDto;
import com.baijia.tianxiao.util.date.DateUtil;

import java.util.Date;

import lombok.Data;

/**
 * @author weihongyan
 * @description TODO
 * @date 29/11/2016
 */
@Data
public class TimeRangeRequestDto extends PageRequestDto {
    private Long startTime;
    private Long endTime;

    private transient Date startDate;
    private transient Date endDate;

    public Date getStartDate() {
        if (null == startDate) {
            startDate = new Date(startTime);
        }
        return startDate;
    }

    public Date getEndDate() {
        if (null == endDate) {
            endDate = new Date(endTime);
        }
        return endDate;
    }

    public Date getStartMonthStartDate() {
        return DateUtil.getFirstDate(getStartDate());
    }

    public Date getEndMonthEndDate() {
        return DateUtil.getNextMonthFirstDate(getEndDate());
    }
}
