package com.baijia.tianxiao.biz.erp.dto;

import com.baijia.tianxiao.dal.org.po.OrgCourse;
import com.google.common.collect.Lists;
import lombok.Data;
import org.apache.commons.collections.CollectionUtils;

import java.util.List;

/**
 * Created by hanlaijin on 17/3/13.
 */
@Data
public class AssignmentClassInfoDto {
    private long id;

    private String name;

    private String classNumber;

    public static List<AssignmentClassInfoDto> bulidClassInfos(List<OrgCourse> courses) {
        List<AssignmentClassInfoDto> list = Lists.newArrayList();
        if(CollectionUtils.isEmpty(courses)){
            return list;
        }
        for(OrgCourse c : courses){
            AssignmentClassInfoDto dto = new AssignmentClassInfoDto();
            dto.setId(c.getId());
            dto.setName(c.getName());
            dto.setClassNumber(c.getNumber() + "");
            list.add(dto);
        }
        return list;
    }
}
