package com.baijia.tianxiao.biz.erp.constant;

import lombok.Getter;

/**
 * @author weihongyan
 * @implNote <(▰˘◡˘▰)>
 * @since 30/08/2017 8:25 PM
 */
public enum UCStudentFeedType {

    STUDENT_COMMENT_GROWTH_DOC(1, "成长记录"),

    SIGNUP_COURSE(2, "报名通知"),

    SYSTEM_NOTICE(3, "系统通知"),
    
    LESSON_RECIEVE_COMMENT(6, "收到的评价"),

    LESSON_SEND_COMMENT(7, "发出的评价"),

    LESSON_SIGN(8, "签到通知"),

    ;

    @Getter
    private final int type;
    @Getter
    private final String desc;

    UCStudentFeedType(int type, String desc) {
        this.type = type;
        this.desc = desc;
    }
    
    public static UCStudentFeedType getEnumByType(Integer type) {
        if (null != type) {
            for (UCStudentFeedType ucStudentFeedType : values()) {
                if (ucStudentFeedType.getType() == type) {
                    return ucStudentFeedType;
                }
            }
        }
        return null;
    }

}
