package com.baijia.tianxiao.biz.erp.thread;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;

import com.baijia.tianxiao.dal.signup.po.OrgSignupCourse;
import com.baijia.tianxiao.enums.RedisKeyEnums;
import com.baijia.tianxiao.sal.course.service.OrgSignupCourseLessonService;
import com.baijia.tianxiao.util.date.DateUtil;

import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.springframework.dao.DataAccessException;
import org.springframework.data.redis.connection.RedisConnection;
import org.springframework.data.redis.core.RedisCallback;
import org.springframework.data.redis.core.StringRedisTemplate;

import com.baijia.tianxiao.biz.erp.constant.UploadFileStatus;
import com.baijia.tianxiao.biz.erp.service.impl.ErpUploadServiceImpl;
import com.baijia.tianxiao.biz.erp.vo.ImportStudent;
import com.baijia.tianxiao.dal.constant.ChargeUnit;
import com.baijia.tianxiao.dal.org.constant.DeleteStatus;
import com.baijia.tianxiao.dal.org.dao.OrgClassLessonDao;
import com.baijia.tianxiao.dal.org.dao.OrgStudentLessonDao;
import com.baijia.tianxiao.dal.org.po.OrgClassLesson;
import com.baijia.tianxiao.dal.org.po.OrgCourse;
import com.baijia.tianxiao.dal.org.po.OrgStudentCourse;
import com.baijia.tianxiao.dal.org.po.OrgStudentLesson;
import com.baijia.tianxiao.enums.CommonErrorCode;
import com.baijia.tianxiao.exception.BussinessException;
import com.baijia.tianxiao.sal.course.service.OrgCourseService;
import com.baijia.tianxiao.sal.course.service.OrgSignupCourseService;
import com.baijia.tianxiao.sal.student.api.OrgStudentCourseService;
import com.baijia.tianxiao.sal.student.api.OrgStudentService;
import com.baijia.tianxiao.sal.student.dto.StudentInfoDto;
import com.baijia.tianxiao.sal.student.dto.response.OrgStudentAddresponseDto;
import com.baijia.tianxiao.util.json.JacksonUtil;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;

import lombok.Data;
import lombok.extern.slf4j.Slf4j;

@Data
@Slf4j
public class SaveStudentsThread implements Runnable {
    private StringRedisTemplate redisTemplate;
    private OrgStudentService orgStudentService;
    private OrgStudentCourseService orgStudentCourseService;
    private OrgStudentLessonDao orgStudentLessonDao;
    private OrgCourseService orgCourseService;
    private OrgClassLessonDao orgClassLessonDao;
    private OrgSignupCourseService orgSignupCourseService;
    private OrgSignupCourseLessonService signupCourseLessonService;

    private Integer orgId;// 机构id
    private Integer cascadeId;// 子账号id
    private String taskId;// 批导任务id
    private int id;// 用于区分线程
    private Map<Integer, Boolean> map;
    private List<ImportStudent> importStudents = Lists.newArrayList();

    public SaveStudentsThread() {

    }
    
    public Integer getRealLessonCount(ImportStudent importStudent, Integer courseChargeUnit){
    	Integer lessonCount = 0;
    	
    	if (courseChargeUnit == ChargeUnit.BY_TIMES.getCode()) {
    		if(importStudent.getLessonCount()==null || importStudent.getLessonCount()<=0){
       		 	throw new BussinessException(CommonErrorCode.BUSINESS_ERROR, "按次计费班级,剩余总课次为必填项");
    		}
    		lessonCount = importStudent.getLessonCount();
    		
    	}else{
    		if(importStudent.getLessonCount()!=null){
    			lessonCount += importStudent.getLessonCount() * 60;  
    		}
    		if(importStudent.getLessonCountExtra()!=null){
    			lessonCount += importStudent.getLessonCountExtra();  
    		}
    	}
    	
    	if(lessonCount<=0){
   		 	throw new BussinessException(CommonErrorCode.BUSINESS_ERROR, "剩余总课次（时）必须大于0");
		}
    	
    	return lessonCount;
    }

    public void run() {
        try {
            List<String> courseNames = Lists.newArrayList();
            List<String> studentMobiles = Lists.newArrayList();
            for (ImportStudent importStudent : importStudents) {
                courseNames.add(importStudent.getCourseName());
                studentMobiles.add(importStudent.getStudentMobile());
            }

            long between0 = 0;// 总查询耗时
            long between1 = 0;// 一个学生导入耗时
            long between2 = 0;// 一条课节导入耗时
            long addStudentTime = 0;
            long addLessonTime = 0;
            Date begin0 = new Date();// 查询前……

            Map<String, OrgCourse> orgCoursesMap = orgCourseService.getAllOrgCoursesMapByNames_class(orgId.longValue(), courseNames);
            List<Long> orgCourseIds = Lists.newArrayList();
            for (OrgCourse orgCourse : orgCoursesMap.values()) {
                orgCourseIds.add(orgCourse.getId());
            }
            
            Map<Long, List<OrgClassLesson>> allLessonsMap = orgClassLessonDao.querylessonsByStartTime(null, orgCourseIds, orgId.longValue());
            Map<Long, List<OrgClassLesson>> unStartLessonsMap = orgClassLessonDao.querylessonsByStartTime(new Date(), orgCourseIds, orgId.longValue());
            

            Date end0 = new Date();// 查询后……
            between0 = (end0.getTime() - begin0.getTime());// 得到两者的毫秒数

            if (CollectionUtils.isNotEmpty(importStudents)) {
                for (final ImportStudent importStudent : importStudents) {
                    OrgSignupCourse orgSignupCourse = null;
                    try {
                        String courseName = importStudent.getCourseName();
                        OrgCourse orgCourse = orgCoursesMap.get(courseName);
                        Long orgCourseId = orgCourse.getId();

                        List<OrgClassLesson> allLessons = new ArrayList<OrgClassLesson>();
                        List<OrgClassLesson> unStartLessons = new ArrayList<OrgClassLesson>();
                        //List<OrgClassLesson> endLessons = new ArrayList<OrgClassLesson>();
                        if (MapUtils.isNotEmpty(allLessonsMap)) {
                        	allLessons = allLessonsMap.get(orgCourseId);
                        }
                        if (MapUtils.isNotEmpty(unStartLessonsMap)) {
                            unStartLessons = unStartLessonsMap.get(orgCourseId);
                        }
//                        if (MapUtils.isNotEmpty(endLessonsMap)) {
//                            if (endLessonsMap.get(orgCourseId) != null) {
//                                endLessons = endLessonsMap.get(orgCourseId);
//                            }
//                        }
                        Date begin1 = new Date();// 插入学生前……

                        // 不存在orgstudent，创建
                        // 不存在orgstudentclass，创建
                        // 按照逻辑创建org_student_lesson
                        // 系统异常时，把当前数据从validlist删除，再插入errlist，修改错误和正确数目
                        StudentInfoDto orgStudent = null;
                        List<StudentInfoDto> dtos = orgStudentService.listOrgStudentByMobile(orgId.longValue(),
                            importStudent.getStudentMobile().toString());

                        if (CollectionUtils.isNotEmpty(dtos)) {
                            for (StudentInfoDto dto : dtos) {
                                if (importStudent.getStudentMobile().equals(dto.getMobile())
                                    && importStudent.getStudentName().equals(dto.getName())) {
                                    log.debug("*************can find dto:{}", dto);
                                    orgStudent = dto;
                                }
                            }
                        }
                        if (orgStudent == null) {
                            orgStudent = new StudentInfoDto();
                            orgStudent.setMobile(importStudent.getStudentMobile().toString());
                            orgStudent.setName(importStudent.getStudentName().toString());
                            orgStudent.setAddCascadeId(cascadeId == null ? 0 : cascadeId);
                            OrgStudentAddresponseDto addDto = orgStudentService.addStudentIgnoreExistMobile(orgStudent,
                                null, null, orgId.longValue());
                            orgStudent.setStudentId(addDto.getUserId());
                        }
                        log.debug("**************orgStudent:{}", orgStudent);

                        Date end1 = new Date();// 插入学生后……课节前……
                        between1 = end1.getTime() - begin1.getTime();// 得到两者的毫秒数
                        addStudentTime += between1;

                        OrgStudentCourse orgStudentCourse = orgStudentCourseService.getBySidAndCid(orgId.longValue(), orgStudent.getStudentId(), orgCourse.getId());
                        
                        if (orgStudentCourse == null) {
                            orgStudentCourse = new OrgStudentCourse();
                            orgStudentCourse.setCourseId(orgCourse.getId());
                            orgStudentCourse.setRealCourseId(orgCourse.getId());
                            orgStudentCourse.setCreateTime(new Date());
                            orgStudentCourse.setDelStatus(DeleteStatus.NORMAL.getValue());
                            orgStudentCourse.setOrgId(orgId.longValue());
                            orgStudentCourse.setStudentMobile(orgStudent.getMobile());
                            orgStudentCourse.setStudentName(orgStudent.getName());
                            orgStudentCourse.setUserId(orgStudent.getStudentId());
                            Integer chargeUnit = orgCourse.getChargeUnit();
                            
                            if (chargeUnit == null || chargeUnit == ChargeUnit.BY_OTHER.getCode()) {
                                chargeUnit = ChargeUnit.BY_TIMES.getCode();
                            }
                            
                            
                            orgStudentCourse.setLessonCount( getRealLessonCount(importStudent,chargeUnit) );
                            orgStudentCourse.setChargeUnit(chargeUnit);
                            orgStudentCourse.setStatus(0);
                            orgStudentCourseService.saveOrgStudentCourse(orgStudentCourse);
                            
                            //处理按分钟类型的报名
                            Integer signupChargeUnit = orgCourse.getChargeUnit();
                            Integer lessonCount = importStudent.getLessonCount();
                            Integer lessonCountExtra = importStudent.getLessonCountExtra();
                            if(orgCourse.getChargeUnit().intValue()!= ChargeUnit.BY_TIMES.getCode()){
                            	if(lessonCountExtra!=null && lessonCountExtra>0){
                            		signupChargeUnit = ChargeUnit.BY_MINUTE.getCode();
                            		
                            		if(lessonCount==null){
                            			lessonCount = 0;
                            		}
                            		lessonCount = lessonCount*60+lessonCountExtra;
                            	}
                            }
                            orgSignupCourse = orgSignupCourseService.saveOrgSignupCourseByExcel(orgId.longValue(), null,
                                orgCourse, orgStudent.getStudentId(), lessonCount, importStudent.getPayPrice(),signupChargeUnit);
                        } else {

                            if (orgStudentCourse.getDelStatus().intValue() != DeleteStatus.DELETED.getValue()
                                && orgStudentCourse.getStatus().intValue() == 0) {
                            	
                                throw new BussinessException(CommonErrorCode.BUSINESS_ERROR, "系统中该课程已有该学员，无法导入");
                            }

                            if (orgStudentCourse.getDelStatus() == DeleteStatus.DELETED.getValue()) {
                                orgStudentCourse.setDelStatus(DeleteStatus.NORMAL.getValue());
                            }
                            if (orgStudentCourse.getStatus().intValue() != 0) {
                                orgStudentCourse.setStatus(0);
                            }
                            
                            orgStudentCourse.setLessonCount( orgStudentCourse.getLessonCount() + getRealLessonCount(importStudent,orgStudentCourse.getChargeUnit()) );
                            
                            orgStudentCourseService.updateOrgStudentCourse(orgStudentCourse);
                            
                            //处理按分钟类型的报名
                            Integer signupChargeUnit = orgCourse.getChargeUnit();
                            Integer lessonCount = importStudent.getLessonCount();
                            Integer lessonCountExtra = importStudent.getLessonCountExtra();
                            if(orgCourse.getChargeUnit().intValue()!= ChargeUnit.BY_TIMES.getCode()){
                            	if(lessonCountExtra!=null && lessonCountExtra>0){
                            		signupChargeUnit = ChargeUnit.BY_MINUTE.getCode();
                            		
                            		if(lessonCount==null){
                            			lessonCount = 0;
                            		}
                            		lessonCount = lessonCount*60+lessonCountExtra;
                            	}
                            }
                            orgSignupCourse = orgSignupCourseService.saveOrgSignupCourseByExcel(orgId.longValue(), null,
                                orgCourse, orgStudent.getStudentId(), lessonCount, importStudent.getPayPrice(), signupChargeUnit);
                        }

                        
                        // 改为不排课，也让导入
                        if (CollectionUtils.isNotEmpty(unStartLessons)) {
                            // 学员从班级下一个待开课课次开排，直至班级结课
                        	// 指定了插入课节 则从指定课节开始排 (陶宏玉)
                            // 这里看mrd比较好，pm找周希，rd找曹亮
                        	
                            List<OrgStudentLesson> orgStudentLessons = Lists.newArrayList();
                            
                            if(orgCourse.getChargeUnit().intValue() == ChargeUnit.BY_TIMES.getCode()){
                            	//按次
	                            if (importStudent.getInsertCount() == null) {
	                                // 总课次不为空，插入课次为空
	                                Integer lessonCount = getRealLessonCount(importStudent,orgStudentCourse.getChargeUnit());
	                                if (lessonCount >= unStartLessons.size()) {
	                                    for (OrgClassLesson orgClassLesson : unStartLessons) {
	                                        orgStudentLessons.add( lessonInit(orgClassLesson, orgStudent) );
	                                    }
	                                } else {
	                                    for (int i = 0; i < lessonCount; i++) {
	                                        OrgClassLesson orgClassLesson = unStartLessons.get(i);
	                                        orgStudentLessons.add( lessonInit(orgClassLesson, orgStudent) );
	                                    }
	                                }
	                            } else if (importStudent.getInsertCount() != null) {
	                            	// 总课次不为空，插入课次不为空
	                                Integer insertCount = importStudent.getInsertCount().intValue();
	                                Integer lessonCount = getRealLessonCount(importStudent,orgStudentCourse.getChargeUnit());
	                                int start = insertCount-1;
	                                int end = start + lessonCount;
	
	                                if (end > allLessons.size()) {
	                                    end = allLessons.size();
	                                }
	                                
	                                for (; start < end; start++) {
	                                    OrgClassLesson orgClassLesson = allLessons.get(start);
	                                    orgStudentLessons.add( lessonInit(orgClassLesson, orgStudent) );
	                                }
	                            }
	                            
                            }else if(orgCourse.getChargeUnit().intValue() == ChargeUnit.BY_HOUR.getCode()){
                            	Long lessonMinute = getRealLessonCount(importStudent, orgCourse.getChargeUnit()).longValue();
                            	//按小时
                            	if (importStudent.getLessonCount() != null && importStudent.getInsertCount() == null) {
	                                // 总课次不为空，插入课次为空
	                                
	                                for (OrgClassLesson orgClassLesson : unStartLessons) {
	                                	lessonMinute -= orgClassLesson.getDurationMinute();
	                                	if(lessonMinute<0){
	                                		break;
	                                	}
                                        orgStudentLessons.add( lessonInit(orgClassLesson, orgStudent) );
                                    }
	                            } else if (importStudent.getLessonCount() != null && importStudent.getInsertCount() != null) {
	                            	// 总课次不为空，插入课次不为空
	                                Integer insertCount = importStudent.getInsertCount().intValue();
	                                
	                                int start = insertCount-1;
	                                
	                                for (; start < allLessons.size(); start++) {
	                                    OrgClassLesson orgClassLesson = allLessons.get(start);
	                                    lessonMinute -= orgClassLesson.getDurationMinute();
	                                	if(lessonMinute<0){
	                                		break;
	                                	}
	                                    orgStudentLessons.add( lessonInit(orgClassLesson, orgStudent) );
	                                }
	                            }
                            	
                            }else{
                            	throw new BussinessException(CommonErrorCode.BUSINESS_ERROR, "未知的班级计费单位");
                            }
                            
                            

                            Long studentId = orgStudent.getStudentId();// 学生id
                            Map<Long, OrgStudentLesson> orgStudentLessonMap = Maps.newHashMap();// 插入课节
                            for (OrgStudentLesson orgStudentLesson : orgStudentLessons) {
                                Long lessonId = orgStudentLesson.getLessonId();
                                orgStudentLessonMap.put(lessonId, orgStudentLesson);
                            }
                            List<OrgStudentLesson> orgStudentLessonsList = orgStudentLessonDao.getLessonsOfStudent(
                                orgId.longValue(), studentId.longValue(), orgStudentLessonMap.keySet());

                            List<OrgStudentLesson> updateList = Lists.newArrayList();// 数据库中需要更新的课节(数据库中删除过)
                            if (CollectionUtils.isNotEmpty(orgStudentLessonsList)) {
                                for (OrgStudentLesson orgStudentLessonDb : orgStudentLessonsList) {
                                    Long lessonDbId = orgStudentLessonDb.getLessonId();
                                    orgStudentLessonMap.remove(lessonDbId);
                                    if (orgStudentLessonDb.getDelStatus() == 1) {
                                        orgStudentLessonDb.setDelStatus(0);
                                        orgStudentLessonDb.setStartStatus(0);
                                        orgStudentLessonDb.setKexiaoStatus(0);
                                        orgStudentLessonDb.setUpdateTime(new Date());
                                        updateList.add(orgStudentLessonDb);
                                    }
                                }
                            }

                            if (CollectionUtils.isNotEmpty(updateList)) {
                            	//处理按分钟的报名
                            	orgSignupCourse.setChargeUnit(orgCourse.getChargeUnit());
                            	
                                signupCourseLessonService.saveSignupCourseLessons(orgId.longValue(), orgCourseId, updateList, orgSignupCourse);
                                for (OrgStudentLesson orgStudentLesson : updateList) {
                                    orgStudentLessonDao.update(orgStudentLesson);
                                }
                            }
                            
                            if (MapUtils.isNotEmpty(orgStudentLessonMap)) {
                            	//处理按分钟的报名
                            	orgSignupCourse.setChargeUnit(orgCourse.getChargeUnit());
                            	
                                signupCourseLessonService.saveSignupCourseLessons(orgId.longValue(), orgCourseId, orgStudentLessonMap.values(), orgSignupCourse);
                                
                                for (OrgStudentLesson orgStudentLesson : orgStudentLessonMap.values()) {
                                    try {
                                        orgStudentLessonDao.save(orgStudentLesson);
                                    } catch (Exception e) {
                                        log.error("save orgStudentLesson:{} failed", orgStudentLesson);
                                    }
                                }
                            }
                        }

                        Date end2 = new Date();// 插入课节后
                        between2 = end2.getTime() - end1.getTime();// 得到两者的毫秒数
                        addLessonTime += between2;
                    } catch (final BussinessException be) {
                        importStudent.setErrReason(be.getMessage());
                        appendErrorData(taskId, importStudent);
                        
                        redisTemplate.execute(new RedisCallback<List<ImportStudent>>() {

                            @Override
                            public List<ImportStudent> doInRedis(RedisConnection connection) throws DataAccessException {
                                List<ImportStudent> data = Lists.newArrayList();
                                Long size = redisTemplate.opsForList().size(getErrDataKey(taskId));
                                if (size != null && size > 0) {
                                    for (int i = 0; i < size; i++) {
                                        try {
                                            String o = redisTemplate.opsForList().rightPop(getErrDataKey(taskId));
                                            if (o!=null) {
                                                data.add(JacksonUtil.str2Obj(o,
                                                        ImportStudent.class));
                                            }
                                        } catch (Exception e) {
                                            e.printStackTrace();
                                            log.error("getInValidStudentList getValidList error!", e);
                                        }
                                    }
                                }
                                log.debug("getInValidStudentList:{}", data);
                                if (CollectionUtils.isNotEmpty(data)) {
                                    for (ImportStudent importStudent : data) {
                                        redisTemplate.opsForList().leftPush(getErrDataKey(taskId), JacksonUtil.obj2Str(importStudent));
                                    }
                                }
                                
								return data;

                            }
                        });
                    } catch (Exception e) {
                        // 错误追加
                        importStudent.setErrReason("系统无法插入此数据，请联系天校工作人员为您排查");
                        appendErrorData(taskId, importStudent);
                    }
                }

                map.put(id, true);
                log.info("查询耗时：{} ms", between0);
                log.info("插入学生总时间：{} ms", addStudentTime);
                ;
                log.info("插入学生课程、课结的总时间：{} ms", addLessonTime);
            }
        } catch (Throwable t) {
            log.error("save student to orgcourse error!", t);
            setTaskStatusError(taskId);
        }
    }

    
    OrgStudentLesson lessonInit(OrgClassLesson orgClassLesson, StudentInfoDto orgStudent) {
    	OrgStudentLesson orgStudentLesson = new OrgStudentLesson();
        orgStudentLesson.setCreateTime(new Date());
        orgStudentLesson.setDelStatus(DeleteStatus.NORMAL.getValue());
        orgStudentLesson.setLessonId(orgClassLesson.getId());
        orgStudentLesson.setOrgId(orgId.longValue());
        orgStudentLesson.setStudentMobile(orgStudent.getMobile());
        orgStudentLesson.setStudentName(orgStudent.getName());
        orgStudentLesson.setUserId(orgStudent.getStudentId());
        orgStudentLesson.setCourseId(orgClassLesson.getCourseId());
        orgStudentLesson.setLessonDuration(DateUtil.getMinuteDiff(orgClassLesson.getStartTime(), orgClassLesson.getEndTime()));
        return orgStudentLesson;
    }
    
    
    /**
     * @param taskId
     */

    protected void setTaskStatusError(final String taskId) {
        redisTemplate.execute(new RedisCallback<Boolean>() {

            @Override
            public Boolean doInRedis(RedisConnection connection) throws DataAccessException {
                connection.setEx(getStatusKey(taskId).getBytes(), ErpUploadServiceImpl.EXPIRE,
                    UploadFileStatus.ERROR.getCode().toString().getBytes());
                return true;
            }
        });
    }

    private final String getStatusKey(String taskId) {
        return RedisKeyEnums.ERP.STATUS_SUFFIX.getRedisKey() + taskId;
    }

    private final String getErrDataKey(String taskId) {
        return RedisKeyEnums.ERP.INVALID_LIST_SUFFIX.getRedisKey() + taskId;
    }

    private final String getErrDataSizeKey(String taskId) {
        return RedisKeyEnums.ERP.INVALID_LIST_SIZE_SUFFIX.getRedisKey() + taskId;
    }

    private final String getValidDataSizeKey(String taskId) {
        return RedisKeyEnums.ERP.VALID_LIST_SIZE_SUFFIX.getRedisKey() + taskId;
    }

    /**
     * @param taskId
     * @param
     */

    protected void appendErrorData(final String taskId, final Object data) {
        redisTemplate.execute(new RedisCallback<Boolean>() {

            @Override
            public Boolean doInRedis(RedisConnection connection) throws DataAccessException {
                redisTemplate.opsForList().leftPush(getErrDataKey(taskId), JacksonUtil.obj2Str(data));
                connection.expire(getErrDataKey(taskId).getBytes(), ErpUploadServiceImpl.EXPIRE);
                connection.incr(getErrDataSizeKey(taskId).getBytes());
                connection.expire(getErrDataSizeKey(taskId).getBytes(), ErpUploadServiceImpl.EXPIRE);
                connection.decr(getValidDataSizeKey(taskId).getBytes());
                connection.expire(getValidDataSizeKey(taskId).getBytes(), ErpUploadServiceImpl.EXPIRE);
                return true;
            }
        });
    }
}
