package com.baijia.tianxiao.biz.erp.dto.response.exportCourse;

import com.baijia.tianxiao.dal.enums.CourseTypeEnum;
import com.baijia.tianxiao.util.date.DateUtil;
import lombok.Data;
import lombok.Getter;
import lombok.Setter;

import java.util.Date;

/**
 * 导出课节信息
 * Created by wangsixia on 2016/11/30.
 */
public class LessonScheduleDto {
    @Getter
    @Setter
    private Long lessonId;
    @Getter
    @Setter
    private Long courseId;
    @Getter
    @Setter
    private Long start;
    @Getter
    @Setter
    private Long end;

    @Getter
    private String courseName;
    @Getter
    private String teacherName;
    @Getter
    private String timeRange;
    @Getter
    private String classRoom;
    @Getter
    private String studentCount;

    public void setCourseName(String courseName, int courseType) {
        this.courseName = courseName + " (" + (CourseTypeEnum.COURSE_TYPE_CLASS.getCode() == courseType ? CourseTypeEnum.COURSE_TYPE_CLASS.getMsg() : CourseTypeEnum.COURSE_TYPE_1v1.getMsg()) + ")";
    }

    public void setTeacherName(String teacherName) {
        this.teacherName = "老师: " + teacherName;
    }

    public void setClassRoom(String classRoom) {
        this.classRoom = classRoom + "教室";
    }

    public void setStudentCount(int count) {
        this.studentCount = "学生人数: " + count + "人";
    }

    public void setTimeRange(Long start, Long end) {
        if (start != null && end != null) {
            this.timeRange = DateUtil.getStrByDateFormate(new Date(start),"HH:mm") + " ~ " + DateUtil.getStrByDateFormate(new Date(end),"HH:mm");
        }
    }
    /**
     * 获取课节内容(导出)
     * @return
     */
    public String getScheduleContent() {
        return this.courseName + System.lineSeparator() + this.teacherName + System.lineSeparator() + this.timeRange + System.lineSeparator() + this.classRoom + System.lineSeparator() + this.studentCount;
    }
    public static void main(String[] args) {
        LessonScheduleDto dto = new LessonScheduleDto();
        dto.setCourseName("课程一", 1);
        dto.setTeacherName("张老师");
        dto.setTimeRange(1480262400545L, 1480262400700L);
        dto.setClassRoom("'教室一");
        dto.setStudentCount(3);
        System.out.println(dto.getScheduleContent());

    }
}
