package com.baijia.tianxiao.biz.erp.dto.response.exportCourse;

import lombok.Data;

import java.util.ArrayList;
import java.util.List;

/**
 * 班级信息导出
 * Created by wangsixia on 2016/11/29.
 */
@Data
public class ExportCourseInfoDto {
    // 班级id
    private Long courseId;
    // 班级名称
    private String courseName;
    // 授课老师
    private String teachers;
    // 课程类型 CourseTypeEnum :1.班课;2.一对一
    private String courseType;
    // 教室
    private String classRooms;
    // 学员人数
    private int studentCount;
    //收费类型
    private int chargeUnit;
    // 班级学员
    List<CourseStudent> studentList;

    /**
     * 获取班级信息列表-----用于导出班级时按顺序填充班级信息
     * @return
     */
    public List<Object> getCourseValueList() {
        List<Object> list = new ArrayList<>();
        list.add(this.getCourseName());
        list.add(this.getTeachers());
        list.add(this.getCourseType());
        list.add(this.getClassRooms());
        list.add(this.getStudentCount());
        return list;
    }
}
