package com.baijia.tianxiao.biz.erp.dto.response.exportCourse;

import com.baijia.tianxiao.dal.constant.ChargeUnit;
import com.baijia.tianxiao.sal.common.utils.KexiaoUtil;
import com.google.common.collect.Lists;
import lombok.Data;

import java.util.ArrayList;
import java.util.List;

/**
 * 班级导出学员信息
 * Created by wangsixia on 2016/11/30.
 */
@Data
public class CourseStudent {
    // 学员id
    private Long studentId;
    // 学员姓名
    private String studentName;
    // 学员手机
    private String mobile;
    // 排课课次
    private int totalLessons;
    // 已上课次
    private int finishLessons;
    // 剩余课次
    private int leftLessons;

    /**
     * 获取导出学员列表--用于导出班级信息时按顺序填充excel的学员信息
     * @return
     */
    public List<Object> getStudentValueList(int chargeUnit) {
        List<Object> list = new ArrayList<>();
        list.add(this.studentName);
        list.add(this.mobile);
        if(ChargeUnit.isByTime(chargeUnit)){
            list.add(KexiaoUtil.classHourFormat(totalLessons));
            list.add(KexiaoUtil.classHourFormat(finishLessons));
            list.add(KexiaoUtil.classHourFormat(leftLessons));
        }else {
            list.add(this.totalLessons);
            list.add(this.finishLessons);
            list.add(this.leftLessons);
        }

        return list;
    }

    public static List<Object> getDefaultValueList() {
        List list = Lists.newArrayList("", "", "", "", "");
        return list;
    }
}
