/**
 * Baijiahulian.com Inc. Copyright (c) 2014-2015 All Rights Reserved.
 */

package com.baijia.tianxiao.biz.erp.dto.response;

import com.baijia.tianxiao.annotation.Show;
import com.baijia.tianxiao.constants.OrgCourseStatus;
import com.baijia.tianxiao.constants.TianXiaoConstant;
import lombok.Data;
import org.apache.commons.lang3.StringUtils;

import java.util.Date;
import java.util.List;

/**
 * @author shanyu
 * @version 1.0
 * @title CourseListInfoDto
 * @desc 机构课程列表
 * @date 2015年12月28日
 */
@Data
public class CourseListInfoDto {
    private Integer arranged; // 排课状态

    private String color; // 颜色

    private Long orgCourseId; // 课程ID

    private Long courseId; // 课程ID

    public void setOrgCourseId(Long orgCourseId) {
        this.orgCourseId = orgCourseId;
        this.courseId = orgCourseId;
    }

    private Long orgCourseNumber; // 课程number

    private String courseUrl; // 课程url

    public void setCoverUrl(String coverUrl) {
        if (StringUtils.isBlank(coverUrl)) {
            this.coverUrl = TianXiaoConstant.DEFAULT_CLASS_COVER;
        } else {
            this.coverUrl = coverUrl;
        }
    }

    @Show(name = "封面", lock = 1, operate = 0)
    private String coverUrl; // 课程url

    @Show(name = "课程名称", poName = "name")
    private String courseName; // 课程名称

    private String courseNamePinYin;

    @Show(name = "招生情况", operate = 0)
    public String getEnrollState() {
        if (maxStudent == null && studentCount != null) {
            return studentCount + "/" + 0;
        }
        if (maxStudent != null && studentCount != null) {
            return studentCount + "/" + maxStudent;
        } else {
            return "-";
        }
    }

    private Integer maxStudent; // 最大学生数

    private Integer studentCount; // 学生数量

    private Integer teacherCount; // 老师数量

    private Integer roomCount; // 教室数量

    @Show(name = "上课次数", type = 1, operate = 0)
    private Integer freq; // 计划课节

    private Integer lessonCount;// 排课课节

    private Integer lessonFinish; // 上完的课节

    @Show(name = "开课时间", poName = "beginTime", type = 2)
    private Date startTime; // 开始时间

    @Show(name = "添加时间", poName = "createTime", type = 2)
    private Date createTime;// 添加时间

    private Date endTime; // 结束时间

    private Double attendanceRate;// 到课率

    @Show(name = "价格", type = 1)
    private Double price;// 课程价格

    @Show(name = "上课地址", operate = 0, viewType = 0)
    private String address;// 上课地址

    @Show(name = "教室", operate = 0, viewType = 0)
    private String roomNames;

    private List<String> roomNameList;

    @Show(name = "老师", operate = 0)
    private String teacherNames;

    private List<String> teacherNameList;

    private String studentNames;

    private List<String> studentNameList;

    @Show(name = "课消规则", operate = 0)
    private String consumerRule;

    @Show(name = "状态", poName = "status")
    private String statusStr;

    private Integer status;

    private Integer courseType;

    private Integer cascadeId;

    private Integer isClass;

    private Integer isCourse;

    private Integer isFinish;

    @Show(name = "班主任", poName = "cascadeId")
    private String cascadeIdStr;

    @Show(name = "付费类型", poName = "chargeType")
    private Integer chargeType;

    @Show(name = "计费单位", poName = "chargeUnit")
    private Integer chargeUnit;

    private Date kexiaoTime;

    private Integer kexiaoCascadeId;

    private String kexiaoCascadeName;

    private Integer remainClassHour; // 是否有剩余课时，1代表有，0代表无

    private Integer remainClassTime; // 是否有剩余课次，1代表有，0代表无

    private Integer finishedMinutes; // 已上分钟

    private Integer arrangedMinutes; // 已排分钟

    private Integer paidMinutes; // 计划安排

    private Long studentId;

    private String studentName;

    private String studentMobile;

    private Long signUpCourseId;

    private String signUpCourseName;

    private Integer fullStatus;

    private Integer fullEnrollRule;

    private Integer finishStatus;//结课

    public void setStatus(Integer status) {
        this.status = status;
        statusStr = OrgCourseStatus.getNote(status);
    }

}
