
/**
 * Baijiahulian.com Inc. Copyright (c) 2014-2015 All Rights Reserved.
 */
package com.baijia.tianxiao.biz.erp.constant;

import java.util.HashMap;
import java.util.Map;

/**
 * @title SignStatus
 * @desc TODO
 * @author cxm
 * @date 2015年12月29日
 * @version 1.0
 */
public enum CourseSignStatus {

    HAS_NOT_STARTED(0, "未开始"),

    SIGNING(1, "签到中"),

    NO_SIGN(2, "未签到"),

    SIGNED(3, "已签到"),

    ;

    private int code;

    private String note;

    private static Map<Integer, CourseSignStatus> map;

    private CourseSignStatus(int code, String note) {
        this.code = code;
        this.note = note;
    }

    static {
        map = new HashMap<>();
        for (CourseSignStatus sign : CourseSignStatus.values()) {
            map.put(sign.code, sign);
        }
    }

    public int getCode() {
        return this.code;
    }

    public String getNote() {
        return this.note;
    }

    public CourseSignStatus getSignByCode(Integer code) {
        return map.get(code);
    }
}
