/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.biz.erp.teacherCenter.service;

import com.baijia.tianxiao.biz.erp.dto.response.LessonTimeTableResponseDto;
import com.baijia.tianxiao.biz.erp.dto.response.exportCourse.CourseStudent;
import com.baijia.tianxiao.biz.erp.dto.response.exportCourse.DayScheduleDto;
import com.baijia.tianxiao.biz.erp.dto.response.exportCourse.ExportCourseInfoDto;
import com.baijia.tianxiao.biz.erp.dto.response.exportCourse.LessonScheduleDto;
import com.baijia.tianxiao.biz.erp.teacherCenter.dto.LessonMergeParams;
import com.baijia.tianxiao.dal.constant.ChargeUnit;
import com.baijia.tianxiao.dal.signup.constant.TransferClassOrder;
import com.baijia.tianxiao.dto.UniverseErrorCode;
import com.baijia.tianxiao.enums.CommonErrorCode;
import com.baijia.tianxiao.excel.dto.ExportField;
import com.baijia.tianxiao.exception.BussinessException;
import com.baijia.tianxiao.sal.course.dto.response.OrgTeacherLessonInfoDto;
import com.baijia.tianxiao.sal.signup.dto.SignupCourseInfoDto;
import com.baijia.tianxiao.sal.signup.dto.response.OrgSingupInfoDto;
import com.baijia.tianxiao.util.date.DateUtil;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.beanutils.PropertyUtilsBean;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.DataFormat;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.ss.util.RegionUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExcelCourseExportService {
    private static final Logger log = LoggerFactory.getLogger(ExcelCourseExportService.class);
    private static String HEADER_FORMAT = "@";
    public static final String EXPORT_DATE_FORMAT = "yyyy-MM-dd HH:mm:ss";
    public static final String UNIT_LESSON_MONEY_FORMULA = "IF(E%d>0,E%d*D%d/60,0)";
    public static final String LESSON_MONEY_FORMULA = "SUM(F%d:F%d)";
    private static final short CELL_HEIGHT = 2000;
    public static PropertyUtilsBean propertyUtilsBean = new PropertyUtilsBean();

    private static CellStyle createCellStyle(Workbook workBook, String format) {
        CellStyle cellStyle = workBook.createCellStyle();
        DataFormat dataFormat = workBook.createDataFormat();
        cellStyle.setAlignment((short)2);
        cellStyle.setVerticalAlignment((short)1);
        cellStyle.setDataFormat(dataFormat.getFormat(format));
        cellStyle.setBorderBottom((short)1);
        cellStyle.setBorderLeft((short)1);
        cellStyle.setBorderRight((short)1);
        cellStyle.setBorderTop((short)1);
        return cellStyle;
    }

    public static Sheet createSheet(Workbook workbook, String sheetName, List<String> titles, Map<String, CellStyle> cellStyleMap, List<ExportField> exportFields, List<LessonTimeTableResponseDto> datas, Date startDate) {
        Sheet sheet = workbook.createSheet(sheetName);
        int columnSize = 0;
        for (ExportField field : exportFields) {
            columnSize += field.getExportFieldSize();
        }
        int startTime = 5;
        ExcelCourseExportService.createTitleRow(sheet, cellStyleMap, titles, columnSize);
        int row = titles != null ? titles.size() : 0;
        ExcelCourseExportService.createHeaderRow(sheet, cellStyleMap, exportFields, row++);
        ArrayList<LessonMergeParams> mergeList = new ArrayList<LessonMergeParams>();
        for (LessonTimeTableResponseDto ltt : datas) {
            int index = DateUtil.getDateDiff((Date)startDate, (Date)ltt.getStartTime()) + 1;
            int startHourDiff = Math.round((float)DateUtil.getMinuteDiff((Date)startDate, (Date)ltt.getStartTime()) / 60.0f) - startTime - (index - 1) * 24;
            int endHourDiff = Math.round((float)DateUtil.getMinuteDiff((Date)startDate, (Date)ltt.getEndTime()) / 60.0f) - startTime - (index - 1) * 24 - 1;
            if (endHourDiff < startHourDiff) {
                ++endHourDiff;
            }
            LessonMergeParams mergeParam = new LessonMergeParams();
            mergeParam.setIndex(index);
            mergeParam.setStartHour(startHourDiff);
            mergeParam.setEndHour(endHourDiff);
            mergeParam.setCourseName(ltt.getCourseName());
            mergeList.add(mergeParam);
        }
        for (int j = 0; j < 24 - startTime; ++j) {
            int rowNum = row;
            Row courseRow = sheet.createRow(rowNum += j);
            ExcelCourseExportService.createCell(courseRow, 0, startTime + j + ":00", cellStyleMap, exportFields.get(0));
            for (LessonMergeParams lessonMerge : mergeList) {
                if (j < lessonMerge.getStartHour() || j > lessonMerge.getEndHour()) continue;
                ExcelCourseExportService.createCell(courseRow, lessonMerge.getIndex(), lessonMerge.getCourseName(), cellStyleMap, exportFields.get(lessonMerge.getIndex()));
            }
        }
        for (LessonMergeParams lmr : mergeList) {
            ExcelCourseExportService.mergeCell(sheet, lmr.getStartHour() + row, lmr.getEndHour() + row, lmr.getIndex(), lmr.getIndex());
        }
        return sheet;
    }

    public static void createCourseSheet(Workbook workbook, String sheetName, Map<String, CellStyle> cellStyleMap, List<ExportField> exportFields, ExportCourseInfoDto courseInfo) {
        Sheet sheet = workbook.createSheet(sheetName);
        int row = 0;
        ExcelCourseExportService.createHeaderRow(sheet, cellStyleMap, exportFields, row++);
        List<Object> courseInfoValueList = courseInfo.getCourseValueList();
        for (int rowIndex = 0; rowIndex <= courseInfo.getStudentCount(); ++rowIndex) {
            int columnIndex;
            Row courseRow = sheet.createRow(row++);
            if (rowIndex != 0 && rowIndex >= courseInfo.getStudentCount()) continue;
            for (columnIndex = 0; columnIndex < courseInfoValueList.size(); ++columnIndex) {
                ExcelCourseExportService.createCell(courseRow, columnIndex, courseInfoValueList.get(columnIndex), cellStyleMap, exportFields.get(columnIndex));
            }
            List<Object> studentValueList = null;
            studentValueList = courseInfo.getStudentCount() == 0 ? CourseStudent.getDefaultValueList() : courseInfo.getStudentList().get(rowIndex).getStudentValueList(courseInfo.getChargeUnit());
            int studentValueIndex = 0;
            while (columnIndex < exportFields.size()) {
                ExcelCourseExportService.createCell(courseRow, columnIndex, studentValueList.get(studentValueIndex++), cellStyleMap, exportFields.get(columnIndex));
                ++columnIndex;
            }
        }
        if (courseInfo.getStudentCount() > 1) {
            for (int mergeIndex = 0; mergeIndex < courseInfoValueList.size(); ++mergeIndex) {
                ExcelCourseExportService.mergeCell(sheet, 1, courseInfo.getStudentCount(), mergeIndex, mergeIndex);
            }
        }
    }

    public static void createScheduleSheet(Workbook workbook, String sheetName, Map<String, CellStyle> cellStyleMap, List<ExportField> exportFields, List<DayScheduleDto> data) {
        Sheet sheet = workbook.createSheet(sheetName);
        int maxColumnCount = 0;
        for (DayScheduleDto dayScheduleDto : data) {
            if (maxColumnCount >= dayScheduleDto.getLessonCount()) continue;
            maxColumnCount = dayScheduleDto.getLessonCount();
        }
        int row = 0;
        ExcelCourseExportService.createHeaderRow(sheet, cellStyleMap, exportFields, row++);
        CellStyle newLineStyle = ExcelCourseExportService.createCellStyle(workbook, "@");
        newLineStyle.setWrapText(true);
        newLineStyle.setAlignment((short)1);
        HashMap<Integer, Row> lessonRowMap = new HashMap<Integer, Row>();
        for (int lessonIndex = 0; lessonIndex < maxColumnCount; ++lessonIndex) {
            Row lessonRow = sheet.createRow(row++);
            lessonRow.setHeight((short)2000);
            lessonRowMap.put(lessonIndex, lessonRow);
        }
        int columnIndex = 0;
        for (DayScheduleDto dayScheduleDto : data) {
            List<LessonScheduleDto> lessons = dayScheduleDto.getLessons();
            int size = dayScheduleDto.getLessonCount();
            for (int index = 0; index < maxColumnCount; ++index) {
                String value = "";
                Row lessonRow = (Row)lessonRowMap.get(index);
                if (index < size) {
                    LessonScheduleDto lessonScheduleDto = lessons.get(index);
                    value = lessonScheduleDto.getScheduleContent();
                }
                Cell cell = ExcelCourseExportService.createCell(lessonRow, columnIndex, value, cellStyleMap, exportFields.get(columnIndex));
                cell.setCellStyle(newLineStyle);
            }
            ++columnIndex;
        }
    }

    public static Sheet createSignupSheet(Workbook workbook, String sheetName, List<String> titles, Map<String, CellStyle> cellStyleMap, List<ExportField> exportFields, List<OrgSingupInfoDto> list) {
        Sheet sheet = workbook.createSheet(sheetName);
        int columnSize = 0;
        for (ExportField field : exportFields) {
            columnSize += field.getExportFieldSize();
        }
        ExcelCourseExportService.createTitleRow(sheet, cellStyleMap, titles, columnSize);
        int row = titles != null ? titles.size() : 0;
        ExcelCourseExportService.createHeaderRow(sheet, cellStyleMap, exportFields, row++);
        ArrayList<LessonMergeParams> mergeList = new ArrayList<LessonMergeParams>();
        int i = 0;
        for (OrgSingupInfoDto dto : list) {
            int rowNum = row;
            rowNum += i;
            log.debug("--------------status={}", (Object)dto.getStatus());
            if (dto.getCourseInfos() == null || dto.getCourseInfos().size() == 0) {
                Object statusStr;
                if (dto.getOrderType() == TransferClassOrder.NORMAL_ORDER.getCode() || dto.getOrderType() == TransferClassOrder.TRANSFER_ORDER.getCode()) {
                    Row signupRow = sheet.createRow(rowNum);
                    ExcelCourseExportService.createCell(signupRow, 0, " ", cellStyleMap, exportFields.get(0));
                    ExcelCourseExportService.createCell(signupRow, 1, " ", cellStyleMap, exportFields.get(1));
                    ExcelCourseExportService.createCell(signupRow, 2, dto.getRealTotalMoney(), cellStyleMap, exportFields.get(2));
                    ExcelCourseExportService.createCell(signupRow, 3, " ", cellStyleMap, exportFields.get(3));
                    ExcelCourseExportService.createCell(signupRow, 4, " ", cellStyleMap, exportFields.get(4));
                    ExcelCourseExportService.createCell(signupRow, 5, " ", cellStyleMap, exportFields.get(5));
                    ExcelCourseExportService.createCell(signupRow, 6, "-", cellStyleMap, exportFields.get(6));
                    ExcelCourseExportService.createCell(signupRow, 7, " ", cellStyleMap, exportFields.get(7));
                    ExcelCourseExportService.createCell(signupRow, 8, dto.getTransferClassMoney(), cellStyleMap, exportFields.get(8));
                    ExcelCourseExportService.createCell(signupRow, 9, dto.getTotalPrice(), cellStyleMap, exportFields.get(9));
                    ExcelCourseExportService.createCell(signupRow, 10, dto.getTransferRefundMoney(), cellStyleMap, exportFields.get(10));
                    ExcelCourseExportService.createCell(signupRow, 11, DateUtil.getStrByDateFormate((Date)dto.getUpdateTime(), (String)"yyyy-MM-dd hh:MM:ss"), cellStyleMap, exportFields.get(11));
                    statusStr = dto.getStatus() == 1 ? "\u5df2\u5b8c\u6210" : (dto.getStatus() == 2 ? "\u5f85\u6536\u6b3e" : "\u5f85\u62a5\u540d");
                    ExcelCourseExportService.createCell(signupRow, 12, statusStr, cellStyleMap, exportFields.get(12));
                    ExcelCourseExportService.createCell(signupRow, 13, dto.getCascadeIdStr(), cellStyleMap, exportFields.get(13));
                    ++i;
                    continue;
                }
                if (dto.getOrderType() == TransferClassOrder.RECHARGE_ORDER.getCode()) {
                    Row signupRow = sheet.createRow(rowNum);
                    ExcelCourseExportService.createCell(signupRow, 0, dto.getStudentName(), cellStyleMap, exportFields.get(0));
                    ExcelCourseExportService.createCell(signupRow, 1, dto.getStudentMobile(), cellStyleMap, exportFields.get(1));
                    ExcelCourseExportService.createCell(signupRow, 2, dto.getRealTotalMoney(), cellStyleMap, exportFields.get(2));
                    ExcelCourseExportService.createCell(signupRow, 3, "\u5b66\u751f\u5145\u503c", cellStyleMap, exportFields.get(3));
                    ExcelCourseExportService.createCell(signupRow, 4, "-", cellStyleMap, exportFields.get(4));
                    ExcelCourseExportService.createCell(signupRow, 5, "-", cellStyleMap, exportFields.get(5));
                    ExcelCourseExportService.createCell(signupRow, 6, "-", cellStyleMap, exportFields.get(6));
                    ExcelCourseExportService.createCell(signupRow, 7, dto.getTotalPrice(), cellStyleMap, exportFields.get(7));
                    ExcelCourseExportService.createCell(signupRow, 8, dto.getTransferClassMoney(), cellStyleMap, exportFields.get(8));
                    ExcelCourseExportService.createCell(signupRow, 9, dto.getTotalPrice(), cellStyleMap, exportFields.get(9));
                    ExcelCourseExportService.createCell(signupRow, 10, dto.getTransferRefundMoney(), cellStyleMap, exportFields.get(10));
                    ExcelCourseExportService.createCell(signupRow, 11, DateUtil.getStrByDateFormate((Date)dto.getUpdateTime(), (String)"yyyy-MM-dd hh:MM:ss"), cellStyleMap, exportFields.get(11));
                    statusStr = dto.getStatus() == 1 ? "\u5df2\u5b8c\u6210" : (dto.getStatus() == 2 ? "\u5f85\u6536\u6b3e" : "\u5f85\u62a5\u540d");
                    ExcelCourseExportService.createCell(signupRow, 12, statusStr, cellStyleMap, exportFields.get(12));
                    ExcelCourseExportService.createCell(signupRow, 13, dto.getCascadeIdStr(), cellStyleMap, exportFields.get(13));
                    ++i;
                    continue;
                }
                if (dto.getOrderType() != TransferClassOrder.TIMESCARD_ORDER.getCode()) continue;
                Row signupRow = sheet.createRow(rowNum);
                ExcelCourseExportService.createCell(signupRow, 0, dto.getStudentName(), cellStyleMap, exportFields.get(0));
                ExcelCourseExportService.createCell(signupRow, 1, dto.getStudentMobile(), cellStyleMap, exportFields.get(1));
                ExcelCourseExportService.createCell(signupRow, 2, dto.getRealTotalMoney(), cellStyleMap, exportFields.get(2));
                ExcelCourseExportService.createCell(signupRow, 3, "\u8d2d\u4e70\u6b21\u5361", cellStyleMap, exportFields.get(3));
                ExcelCourseExportService.createCell(signupRow, 4, "-", cellStyleMap, exportFields.get(4));
                ExcelCourseExportService.createCell(signupRow, 5, "-", cellStyleMap, exportFields.get(5));
                ExcelCourseExportService.createCell(signupRow, 6, "-", cellStyleMap, exportFields.get(6));
                ExcelCourseExportService.createCell(signupRow, 7, dto.getTotalPrice(), cellStyleMap, exportFields.get(7));
                ExcelCourseExportService.createCell(signupRow, 8, dto.getTransferClassMoney(), cellStyleMap, exportFields.get(8));
                ExcelCourseExportService.createCell(signupRow, 9, dto.getTotalPrice(), cellStyleMap, exportFields.get(9));
                ExcelCourseExportService.createCell(signupRow, 10, dto.getTransferRefundMoney(), cellStyleMap, exportFields.get(10));
                ExcelCourseExportService.createCell(signupRow, 11, DateUtil.getStrByDateFormate((Date)dto.getUpdateTime(), (String)"yyyy-MM-dd hh:MM:ss"), cellStyleMap, exportFields.get(11));
                statusStr = dto.getStatus() == 1 ? "\u5df2\u5b8c\u6210" : (dto.getStatus() == 2 ? "\u5f85\u6536\u6b3e" : "\u5f85\u62a5\u540d");
                ExcelCourseExportService.createCell(signupRow, 12, statusStr, cellStyleMap, exportFields.get(12));
                ExcelCourseExportService.createCell(signupRow, 13, dto.getCascadeIdStr(), cellStyleMap, exportFields.get(13));
                ++i;
                continue;
            }
            int j = 0;
            for (SignupCourseInfoDto signupCourseInfoDto : dto.getCourseInfos()) {
                Row signupRow = sheet.createRow(rowNum + j);
                Number timeCount = ExcelCourseExportService.getCount(signupCourseInfoDto.getChargeUnit(), signupCourseInfoDto.getLessonCount());
                ExcelCourseExportService.createCell(signupRow, 0, dto.getStudentName(), cellStyleMap, exportFields.get(0));
                ExcelCourseExportService.createCell(signupRow, 1, dto.getStudentMobile(), cellStyleMap, exportFields.get(1));
                ExcelCourseExportService.createCell(signupRow, 2, dto.getRealTotalMoney(), cellStyleMap, exportFields.get(2));
                ExcelCourseExportService.createCell(signupRow, 3, signupCourseInfoDto.getOrgCourseName(), cellStyleMap, exportFields.get(3));
                ExcelCourseExportService.createCell(signupRow, 4, signupCourseInfoDto.getOriginPrice(), cellStyleMap, exportFields.get(4));
                ExcelCourseExportService.createCell(signupRow, 5, timeCount, cellStyleMap, exportFields.get(5));
                ExcelCourseExportService.createCell(signupRow, 6, signupCourseInfoDto.getPreferential(), cellStyleMap, exportFields.get(6));
                ExcelCourseExportService.createCell(signupRow, 7, signupCourseInfoDto.getPayPrice(), cellStyleMap, exportFields.get(7));
                ExcelCourseExportService.createCell(signupRow, 8, signupCourseInfoDto.getTransferClassDeduction(), cellStyleMap, exportFields.get(8));
                if (dto.getStatus() == 2) {
                    ExcelCourseExportService.createCell(signupRow, 9, "--", cellStyleMap, exportFields.get(9));
                } else {
                    ExcelCourseExportService.createCell(signupRow, 9, signupCourseInfoDto.getStudentPayPrice() + signupCourseInfoDto.getRealPayPrice(), cellStyleMap, exportFields.get(9));
                }
                ExcelCourseExportService.createCell(signupRow, 10, signupCourseInfoDto.getRefundAmount(), cellStyleMap, exportFields.get(10));
                ExcelCourseExportService.createCell(signupRow, 11, DateUtil.getStrByDateFormate((Date)dto.getUpdateTime(), (String)"yyyy-MM-dd hh:MM:ss"), cellStyleMap, exportFields.get(11));
                String statusStr = dto.getStatus() == 1 ? "\u5df2\u5b8c\u6210" : (dto.getStatus() == 2 ? "\u5f85\u6536\u6b3e" : "\u5f85\u62a5\u540d");
                ExcelCourseExportService.createCell(signupRow, 12, statusStr, cellStyleMap, exportFields.get(12));
                ExcelCourseExportService.createCell(signupRow, 13, dto.getCascadeIdStr(), cellStyleMap, exportFields.get(13));
                ++j;
            }
            i += j;
            if (j <= 1) continue;
            LessonMergeParams mergeParams = new LessonMergeParams();
            mergeParams.setStartHour(rowNum);
            mergeParams.setEndHour(rowNum + j - 1);
            mergeList.add(mergeParams);
        }
        System.out.println(mergeList);
        for (LessonMergeParams lmr : mergeList) {
            ExcelCourseExportService.mergeCell(sheet, lmr.getStartHour(), lmr.getEndHour(), 0, 0);
            ExcelCourseExportService.mergeCell(sheet, lmr.getStartHour(), lmr.getEndHour(), 1, 1);
            ExcelCourseExportService.mergeCell(sheet, lmr.getStartHour(), lmr.getEndHour(), 2, 2);
            ExcelCourseExportService.mergeCell(sheet, lmr.getStartHour(), lmr.getEndHour(), 9, 9);
            ExcelCourseExportService.mergeCell(sheet, lmr.getStartHour(), lmr.getEndHour(), 10, 10);
            ExcelCourseExportService.mergeCell(sheet, lmr.getStartHour(), lmr.getEndHour(), 11, 11);
        }
        return sheet;
    }

    private static Number getCount(int chargeUnit, int count) {
        if (chargeUnit == ChargeUnit.BY_MINUTE.getCode()) {
            return new BigDecimal(count).divide(new BigDecimal(60), 2, RoundingMode.HALF_UP).doubleValue();
        }
        return count;
    }

    public static void main(String[] args) {
        System.out.println(ExcelCourseExportService.getCount(2, 118));
    }

    private static void mergeCell(Sheet sheet, int firstRow, int lastRow, int firstColumn, int lastColumn) {
        CellRangeAddress rangeAddress = new CellRangeAddress(firstRow, lastRow, firstColumn, lastColumn);
        sheet.addMergedRegion(rangeAddress);
        try {
            RegionUtil.setBorderBottom((int)1, (CellRangeAddress)rangeAddress, (Sheet)sheet, (Workbook)sheet.getWorkbook());
            RegionUtil.setBorderTop((int)1, (CellRangeAddress)rangeAddress, (Sheet)sheet, (Workbook)sheet.getWorkbook());
            RegionUtil.setBorderLeft((int)1, (CellRangeAddress)rangeAddress, (Sheet)sheet, (Workbook)sheet.getWorkbook());
            RegionUtil.setBorderRight((int)1, (CellRangeAddress)rangeAddress, (Sheet)sheet, (Workbook)sheet.getWorkbook());
        }
        catch (Exception e) {
            log.warn("\u5904\u7406\u8fb9\u6846\u5931\u8d25");
            e.printStackTrace();
        }
    }

    private static void createLessonRow(Row lessonRow, int baseColumn, OrgTeacherLessonInfoDto lessonInfo, List<ExportField> exportFields, Map<String, CellStyle> cellStyleMap) {
        ExcelCourseExportService.createCell(lessonRow, ++baseColumn, lessonInfo.getLessonNumberInfo(), cellStyleMap, exportFields.get(baseColumn));
        ExcelCourseExportService.createCell(lessonRow, ++baseColumn, lessonInfo.getRoomName(), cellStyleMap, exportFields.get(baseColumn));
        ExcelCourseExportService.createCell(lessonRow, ++baseColumn, lessonInfo.getStartTime(), cellStyleMap, exportFields.get(baseColumn));
        ExcelCourseExportService.createCell(lessonRow, ++baseColumn, lessonInfo.getLessonTime(), cellStyleMap, exportFields.get(baseColumn));
        ExcelCourseExportService.createCell(lessonRow, ++baseColumn, lessonInfo.getMinutes(), cellStyleMap, exportFields.get(baseColumn));
        ExcelCourseExportService.createCell(lessonRow, ++baseColumn, lessonInfo.getStudentCount(), cellStyleMap, exportFields.get(baseColumn));
        ExcelCourseExportService.createCell(lessonRow, ++baseColumn, lessonInfo.getSignCount(), cellStyleMap, exportFields.get(baseColumn));
        ExcelCourseExportService.createCell(lessonRow, ++baseColumn, lessonInfo.getLeaveCount(), cellStyleMap, exportFields.get(baseColumn));
        ExcelCourseExportService.createCell(lessonRow, ++baseColumn, lessonInfo.getAbsentCount(), cellStyleMap, exportFields.get(baseColumn));
        ExcelCourseExportService.createCell(lessonRow, ++baseColumn, lessonInfo.getUnsignCount(), cellStyleMap, exportFields.get(baseColumn));
        ExcelCourseExportService.createCell(lessonRow, ++baseColumn, lessonInfo.getSignRate(), cellStyleMap, exportFields.get(baseColumn));
    }

    private static Cell createCell(Row row, int column, Object value, Map<String, CellStyle> cellStyleMap, ExportField exportField) {
        Cell cell = row.createCell(column);
        String localFormat = null;
        Object object = value = value != null ? value : exportField.getDefaultVal();
        if (value != null) {
            if (value instanceof Date) {
                row.getSheet().setColumnWidth(cell.getColumnIndex(), 5120);
                localFormat = EXPORT_DATE_FORMAT;
                cell.setCellValue((Date)value);
            } else if (value instanceof Number && ((Number)value).longValue() < Integer.MAX_VALUE) {
                cell.setCellType(0);
                if (value instanceof Double) {
                    localFormat = "0.00";
                    cell.setCellValue(((Number)value).doubleValue());
                } else {
                    localFormat = "0";
                    cell.setCellValue((double)((Number)value).longValue());
                }
            } else {
                cell.setCellType(1);
                cell.setCellValue(value.toString());
                localFormat = "@";
            }
        } else {
            cell.setCellValue("");
        }
        cell.setCellStyle(ExcelCourseExportService.getCellStyle(row.getSheet().getWorkbook(), cellStyleMap, exportField.getFormat() != null ? exportField.getFormat() : localFormat));
        return cell;
    }

    private static CellStyle getCellStyle(Workbook workbook, Map<String, CellStyle> cellStyleMap, String format) {
        if (!cellStyleMap.containsKey(format)) {
            cellStyleMap.put(format, ExcelCourseExportService.createCellStyle(workbook, format));
        }
        return cellStyleMap.get(format);
    }

    private static void createHeaderRow(Sheet sheet, Map<String, CellStyle> cellStyleMap, List<ExportField> exportFields, int row) {
        Row headerRow = sheet.createRow(row);
        int column = 0;
        CellStyle style = ExcelCourseExportService.getCellStyle(sheet.getWorkbook(), cellStyleMap, HEADER_FORMAT);
        for (ExportField field : exportFields) {
            column = ExcelCourseExportService.createHeaderCell(headerRow, style, field, column);
        }
    }

    private static int createHeaderCell(Row row, CellStyle style, ExportField field, int column) {
        if (CollectionUtils.isEmpty((Collection)field.getChildren())) {
            row.getSheet().setColumnWidth(column, field.getWidth());
            Cell cell = row.createCell(column++);
            cell.setCellStyle(style);
            cell.setCellValue(field.getName());
        } else {
            for (ExportField child : field.getChildren()) {
                column = ExcelCourseExportService.createHeaderCell(row, style, child, column);
            }
        }
        return column;
    }

    private static void createTitleRow(Sheet sheet, Map<String, CellStyle> cellStyleMap, List<String> titles, int headerSize) {
        int row = 0;
        if (CollectionUtils.isNotEmpty(titles)) {
            for (String title : titles) {
                Row titleRow = sheet.createRow(row);
                Cell cell = titleRow.createCell(0);
                cell.setCellValue(title);
                cell.setCellStyle(ExcelCourseExportService.getCellStyle(sheet.getWorkbook(), cellStyleMap, HEADER_FORMAT));
                ExcelCourseExportService.mergeCell(sheet, row, row, 0, headerSize - 1);
                ++row;
            }
        }
    }

    public static void exportExcel(HttpServletResponse response, Workbook workBook, String excelFileName) {
        if (StringUtils.isBlank((CharSequence)excelFileName)) {
            excelFileName = System.currentTimeMillis() + ".xlsx";
        }
        response.setContentType("application/vnd.ms-excel");
        try {
            response.setHeader("Content-Disposition", "attachment; filename=" + URLEncoder.encode(excelFileName, "utf-8"));
        }
        catch (UnsupportedEncodingException e1) {
            response.setHeader("Content-Disposition", "attachment; filename=" + excelFileName);
        }
        try {
            workBook.write((OutputStream)response.getOutputStream());
            response.getOutputStream().flush();
        }
        catch (IOException e) {
            log.error("export data catch error:", (Throwable)e);
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u5bfc\u51fa\u6570\u636e\u5904\u7406\u5931\u8d25");
        }
    }

    public static void exportExcel(HttpServletRequest request, HttpServletResponse response, Workbook workBook, String excelFileName) {
        if (StringUtils.isBlank((CharSequence)excelFileName)) {
            excelFileName = System.currentTimeMillis() + ".xlsx";
        }
        response.setContentType("application/vnd.ms-excel");
        try {
            String agent = request.getHeader("User-Agent");
            String encodeFileName = "";
            encodeFileName = agent.contains("Trident") ? URLEncoder.encode(excelFileName, "UTF-8") : "\"" + new String(excelFileName.getBytes("UTF-8"), "iso-8859-1") + "\"";
            response.setHeader("Content-Disposition", "attachment; filename=" + encodeFileName);
        }
        catch (UnsupportedEncodingException e1) {
            response.setHeader("Content-Disposition", "attachment; filename=\"" + excelFileName + "\"");
        }
        try {
            workBook.write((OutputStream)response.getOutputStream());
            response.getOutputStream().flush();
        }
        catch (IOException e) {
            log.error("export data catch error:", (Throwable)e);
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u5bfc\u51fa\u6570\u636e\u5904\u7406\u5931\u8d25");
        }
    }
}

