/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.biz.erp.sync.impl;

import com.baijia.tianxiao.biz.erp.enums.SyncSignupLessonCount;
import com.baijia.tianxiao.biz.erp.service.ErpStudentCourseService;
import com.baijia.tianxiao.biz.erp.sync.SyncErpService;
import com.baijia.tianxiao.dal.org.dao.OrgStudentCourseDao;
import com.baijia.tianxiao.dal.org.po.OrgStudentCourse;
import com.baijia.tianxiao.dal.signup.constant.SignupCourseStatus;
import com.baijia.tianxiao.dal.signup.dao.OrgSignupCourseDao;
import com.baijia.tianxiao.dal.signup.po.OrgSignupCourse;
import com.baijia.tianxiao.dal.sync.constant.MsgSyncType;
import com.baijia.tianxiao.dal.sync.dao.TxMsgSyncTimestampDao;
import com.baijia.tianxiao.dal.sync.po.TxMsgSyncTimestamp;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="syncSignupCourseSercieImpl")
public class SyncSignupCourseSercieImpl
implements SyncErpService {
    private static final Logger log = LoggerFactory.getLogger(SyncSignupCourseSercieImpl.class);
    @Autowired
    private OrgSignupCourseDao signupCourseDao;
    @Autowired
    private OrgStudentCourseDao studentCourseDao;
    @Resource
    private TxMsgSyncTimestampDao txMsgSyncTimestampDao;
    @Resource
    private ErpStudentCourseService erpStudentCourseService;
    private AtomicBoolean coureFlag = new AtomicBoolean(false);

    @Override
    public void sync() {
        TxMsgSyncTimestamp syncInfo = this.getSyncInfo(MsgSyncType.SYNC_SIGNUP_COURSE_ID);
        try {
            if (!this.coureFlag.get()) {
                log.info("sync pay coursePurchase stat info :{}", (Object)syncInfo);
                this.coureFlag.set(true);
                this.syncSignupCourseInfo(syncInfo);
                this.coureFlag.set(false);
            } else {
                log.warn("has not finish,skip");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error("sync task error :{}", (Throwable)e);
        }
        finally {
            this.coureFlag.set(false);
        }
        log.info("save sync info:{}", (Object)syncInfo);
        this.txMsgSyncTimestampDao.saveOrUpdate((Object)syncInfo, new String[0]);
    }

    private void syncSignupCourseInfo(TxMsgSyncTimestamp syncInfo) {
        List signupCourseList = this.signupCourseDao.getCousePurchaseListByMinId(syncInfo.getSyncId(), syncInfo.getSyncTime(), 100, SignupCourseStatus.inStudentCourseStatus, new String[0]);
        log.info("save syncSignupCourseInfo:{} success", (Object)signupCourseList);
        if (CollectionUtils.isNotEmpty((Collection)signupCourseList)) {
            for (OrgSignupCourse signupCourse : signupCourseList) {
                try {
                    if (signupCourse.getUpdateTime().after(syncInfo.getSyncTime())) {
                        syncInfo.setSyncTime(signupCourse.getUpdateTime());
                    }
                    boolean isNeedSyncLessonCount = true;
                    if (!SignupCourseStatus.statusInStudentCourse((int)signupCourse.getStatus())) {
                        isNeedSyncLessonCount = false;
                    }
                    if (signupCourse.getSyncLessonCount().intValue() == SyncSignupLessonCount.SYNC_SIGNUP.getCode()) {
                        isNeedSyncLessonCount = false;
                    }
                    OrgStudentCourse orgStudentCourse = this.studentCourseDao.getStudentCourseByRealCourseId(signupCourse.getOrgId(), signupCourse.getOrgCourseId(), signupCourse.getUserId());
                    if (isNeedSyncLessonCount) {
                        orgStudentCourse = this.erpStudentCourseService.signupToStudentCourse(signupCourse, orgStudentCourse);
                        log.info("[SignUpCourseProcessor] orgStudentCourse = {}", (Object)orgStudentCourse);
                        boolean hasChange = false;
                        if (orgStudentCourse != null && signupCourse.getClassId() <= 0L) {
                            signupCourse.setClassId(orgStudentCourse.getCourseId());
                            hasChange = true;
                        }
                        if (signupCourse.getSyncLessonCount().intValue() != orgStudentCourse.getSyncLessonCount()) {
                            signupCourse.setSyncLessonCount(Integer.valueOf(orgStudentCourse.getSyncLessonCount()));
                            hasChange = true;
                        }
                        if (!hasChange) continue;
                        log.info("SignUpCourseProcessor =={},", (Object)signupCourse);
                        this.signupCourseDao.update((Object)signupCourse, new String[]{"classId", "syncLessonCount"});
                        continue;
                    }
                    if (orgStudentCourse == null || signupCourse.getClassId() > 0L) continue;
                    signupCourse.setClassId(orgStudentCourse.getCourseId());
                    this.signupCourseDao.update((Object)signupCourse, new String[]{"classId"});
                }
                catch (Exception e) {
                    log.warn("sygn course purchase fail {}", (Throwable)e);
                }
            }
        }
    }

    private TxMsgSyncTimestamp getSyncInfo(MsgSyncType syncType) {
        TxMsgSyncTimestamp syncInfo = this.txMsgSyncTimestampDao.getSyncTimestampByType(syncType.getSyncType());
        if (syncInfo == null) {
            syncInfo = new TxMsgSyncTimestamp();
            syncInfo.setSyncId(Long.valueOf(0L));
            syncInfo.setSyncTime(new Date());
            syncInfo.setSyncType(Integer.valueOf(syncType.getSyncType()));
        }
        return syncInfo;
    }
}

