/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.biz.erp.service.impl;

import com.baijia.tianxiao.biz.erp.dto.AssignmentPublishDto;
import com.baijia.tianxiao.biz.erp.service.SendMessageService;
import com.baijia.tianxiao.common.service.WechatMsgRenderService;
import com.baijia.tianxiao.dal.org.dao.OrgCourseDao;
import com.baijia.tianxiao.dal.org.dao.OrgInfoDao;
import com.baijia.tianxiao.dal.org.dao.OrgStudentDao;
import com.baijia.tianxiao.dal.org.dao.OrgTeacherDao;
import com.baijia.tianxiao.dal.org.po.OrgStudent;
import com.baijia.tianxiao.dal.org.po.OrgTeacher;
import com.baijia.tianxiao.dal.user.dao.TeacherDao;
import com.baijia.tianxiao.dal.user.po.Teacher;
import com.baijia.tianxiao.dal.wechat.constant.WechateTemplateMsgType;
import com.baijia.tianxiao.dto.UniverseErrorCode;
import com.baijia.tianxiao.enums.CommonErrorCode;
import com.baijia.tianxiao.exception.BussinessException;
import com.google.common.collect.Maps;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class SendMessageServiceImpl
implements SendMessageService {
    private static final Logger log = LoggerFactory.getLogger(SendMessageServiceImpl.class);
    @Resource
    private WechatMsgRenderService wechatService;
    @Resource
    private OrgStudentDao orgStudentDao;
    @Resource
    private OrgTeacherDao yunyingTeacherDao;
    @Resource
    private TeacherDao cdbTeacherDao;
    @Resource
    private OrgCourseDao orgCourseDao;
    @Resource
    private OrgInfoDao orgInfoDao;

    @Override
    public boolean send(AssignmentPublishDto assignmentPublishDto) {
        log.debug("[assignmentPublishDto]={},", (Object)assignmentPublishDto);
        this.paramCheck(assignmentPublishDto);
        Map<String, Object> params = this.buildSendMsgRequest(assignmentPublishDto);
        if (MapUtils.isEmpty(params)) {
            return false;
        }
        log.debug("[send wx message param]={}", params);
        Object wechatMsg = this.wechatService.render(assignmentPublishDto.getTemplateId(), params);
        boolean result = this.wechatService.sendMsg(assignmentPublishDto.getOrgId(), wechatMsg);
        return result;
    }

    private void paramCheck(AssignmentPublishDto assignmentPublishDto) {
        if (assignmentPublishDto == null) {
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u6ca1\u6709\u63a5\u6536\u5230\u8bf7\u6c42\u53c2\u6570");
        }
        if (assignmentPublishDto.getStudentId() == null || assignmentPublishDto.getStudentId() < 0L) {
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u5b66\u751fid\u9519\u8bef");
        }
    }

    private Map<String, Object> buildSendMsgRequest(AssignmentPublishDto assignmentPublishDto) {
        Teacher teacher = new Teacher();
        HashMap params = Maps.newHashMap();
        OrgStudent student = (OrgStudent)this.orgStudentDao.getById((Serializable)assignmentPublishDto.getStudentId(), new String[0]);
        OrgTeacher orgTeacher = (OrgTeacher)this.yunyingTeacherDao.getById((Serializable)assignmentPublishDto.getTeacherId(), new String[0]);
        if (orgTeacher == null) {
            teacher.setRealName("\u673a\u6784");
        } else {
            teacher = this.cdbTeacherDao.getByUserId(orgTeacher.getUserId(), new String[0]);
        }
        if (assignmentPublishDto.getTemplateId().equals(WechateTemplateMsgType.HOMEWORK_PUBLISH_TO_STU.getValue())) {
            params.put("template_id", WechateTemplateMsgType.HOMEWORK_PUBLISH_TO_STU.getValue());
            assignmentPublishDto.setFirst(String.format(assignmentPublishDto.getFirst(), teacher.getRealName() + "\u8001\u5e08"));
            if (StringUtils.isBlank((CharSequence)student.getWeixin())) {
                throw new BussinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "student.weixin is empty! " + student);
            }
            params.put("touser", student.getWeixin());
        } else if (assignmentPublishDto.getTemplateId().equals(WechateTemplateMsgType.HOMEWORK_FINISH_TO_TEACHER.getValue())) {
            params.put("template_id", WechateTemplateMsgType.HOMEWORK_FINISH_TO_TEACHER.getValue());
            assignmentPublishDto.setKeyword1(String.format(assignmentPublishDto.getKeyword1(), student.getName()));
            if (orgTeacher == null || StringUtils.isBlank((CharSequence)orgTeacher.getWeixin())) {
                throw new BussinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "orgTeacher.weixin is empty!" + orgTeacher);
            }
            params.put("touser", orgTeacher.getWeixin());
        } else if (assignmentPublishDto.getTemplateId().equals(WechateTemplateMsgType.HOMEWORK_CORRECT_TO_STU.getValue())) {
            params.put("template_id", WechateTemplateMsgType.HOMEWORK_CORRECT_TO_STU.getValue());
            assignmentPublishDto.setFirst(String.format(assignmentPublishDto.getFirst(), student.getName()));
            assignmentPublishDto.setKeyword2(this.orgCourseDao.getCourseNameById(assignmentPublishDto.getClassId()));
            if (StringUtils.isBlank((CharSequence)student.getWeixin())) {
                throw new BussinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "student.weixin is empty! " + student);
            }
            params.put("touser", student.getWeixin());
        } else if (assignmentPublishDto.getTemplateId().equals(WechateTemplateMsgType.EXAM_PUBLISH_TO_STU.getValue())) {
            params.put("template_id", WechateTemplateMsgType.EXAM_PUBLISH_TO_STU.getValue());
            assignmentPublishDto.setFirst(String.format(assignmentPublishDto.getFirst(), this.getOrgName(assignmentPublishDto.getOrgId())));
            assignmentPublishDto.setKeyword3(assignmentPublishDto.getKeyword3() + "\u5206\u949f");
            if (StringUtils.isBlank((CharSequence)student.getWeixin())) {
                throw new BussinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "student.weixin is empty! " + student);
            }
            params.put("touser", student.getWeixin());
        } else if (assignmentPublishDto.getTemplateId().equals(WechateTemplateMsgType.EXAM_CORRECT_TO_STU.getValue())) {
            params.put("template_id", WechateTemplateMsgType.EXAM_CORRECT_TO_STU.getValue());
            assignmentPublishDto.setFirst(String.format(assignmentPublishDto.getFirst(), student.getName()));
            if (StringUtils.isBlank((CharSequence)student.getWeixin())) {
                throw new BussinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "student.weixin is empty! " + student);
            }
            params.put("touser", student.getWeixin());
        } else if (assignmentPublishDto.getTemplateId().equals(WechateTemplateMsgType.GRADE_OPEN_TO_STU.getValue())) {
            params.put("template_id", WechateTemplateMsgType.GRADE_OPEN_TO_STU.getValue());
            if (StringUtils.isBlank((CharSequence)student.getWeixin())) {
                throw new BussinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "student.weixin is empty! " + student);
            }
            params.put("touser", student.getWeixin());
        }
        params.put("url", assignmentPublishDto.getUrl());
        params.put("first", assignmentPublishDto.getFirst());
        params.put("keyword1", assignmentPublishDto.getKeyword1());
        params.put("keyword2", assignmentPublishDto.getKeyword2());
        params.put("keyword3", assignmentPublishDto.getKeyword3());
        params.put("remark", assignmentPublishDto.getRemark());
        return params;
    }

    private String getOrgName(Long orgId) {
        return this.orgInfoDao.getOrgShortNameByOrgId(Integer.valueOf(orgId.intValue()));
    }
}

