/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.biz.erp.service.impl;

import com.baijia.tianxiao.biz.erp.dto.response.studentCenter.StudentCenterInfoDto;
import com.baijia.tianxiao.biz.erp.service.PersonalCenterService;
import com.baijia.tianxiao.constant.Flag;
import com.baijia.tianxiao.dal.org.dao.OrgAccountDao;
import com.baijia.tianxiao.dal.org.dao.OrgInfoDao;
import com.baijia.tianxiao.dal.org.dao.OrgStudentDao;
import com.baijia.tianxiao.dal.org.dao.OrgTeacherDao;
import com.baijia.tianxiao.dal.org.po.OrgAccount;
import com.baijia.tianxiao.dal.org.po.OrgBaseInfoDto;
import com.baijia.tianxiao.dal.org.po.OrgInfo;
import com.baijia.tianxiao.dal.org.po.OrgStudent;
import com.baijia.tianxiao.dal.org.po.OrgTeacher;
import com.baijia.tianxiao.dal.wechat.constant.WechatOpenIdEntityType;
import com.baijia.tianxiao.dal.wechat.dao.AuthorizationInfoDao;
import com.baijia.tianxiao.dal.wechat.dao.OrgWechatOpenIdRecordDao;
import com.baijia.tianxiao.dal.wechat.dao.UnifiedWechatAccountDao;
import com.baijia.tianxiao.dal.wechat.po.OrgWechatOpenIdRecord;
import com.baijia.tianxiao.dto.smstoken.StudentSmsTokenDto;
import com.baijia.tianxiao.dto.smstoken.TeacherSmsTokenDto;
import com.baijia.tianxiao.sal.common.utils.OrgInfoCampare;
import com.baijia.tianxiao.sal.course.dto.response.TeacherResponseDto;
import com.baijia.tianxiao.sal.organization.dto.OrgSelectionDto;
import com.baijia.tianxiao.sal.wechat.api.WechatFreeVersionService;
import com.baijia.tianxiao.sal.wechat.constant.webauth.WebAuthScope;
import com.baijia.tianxiao.sal.wechat.helper.WechatProperties;
import com.baijia.tianxiao.sal.wechat.helper.webauthlink.WechatWebAuthLinkBuilder;
import com.baijia.tianxiao.util.GenericsUtils;
import com.baijia.tianxiao.util.HanZiPinYinUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PersonalCenterServiceImpl
implements PersonalCenterService {
    private static final Logger log = LoggerFactory.getLogger(PersonalCenterServiceImpl.class);
    @Autowired(required=false)
    private WechatFreeVersionService freeVersionService;
    @Autowired
    private OrgAccountDao orgAccountDao;
    @Autowired
    private OrgWechatOpenIdRecordDao orgWechatOpenIdRecordDao;
    @Autowired
    private OrgInfoDao orgInfoDao;
    @Autowired
    private AuthorizationInfoDao authorizationInfoDao;
    @Autowired
    private UnifiedWechatAccountDao unifiedWechatAccountDao;
    @Autowired
    private OrgStudentDao orgStudentDao;
    @Autowired
    private OrgTeacherDao orgTeacherDao;

    @Override
    public void fillStudentCenterInfoDto(StudentCenterInfoDto dto, String sms_token) throws Exception {
        if (dto == null || StringUtils.isBlank((CharSequence)sms_token)) {
            log.error("wrong param dto:{},wechatAppId:{}", (Object)dto, (Object)sms_token);
            return;
        }
        StudentSmsTokenDto token = StudentSmsTokenDto.fromTokenStr((String)sms_token);
        Long orgId = token.getOrgId();
        String wechatAppId = token.getWechatAppId();
        String openId = token.getOpenId();
        OrgAccount orgAccount = this.orgAccountDao.getAccountById(orgId.intValue(), new String[0]);
        String websiteFmt = "%si/%s";
        websiteFmt = String.format(websiteFmt, WechatProperties.getWebMTianXiaoUrlPrefix(), orgAccount.getNumber());
        dto.setWebsite(websiteFmt);
        dto.setOrgId(orgId);
        if (wechatAppId != null && this.freeVersionService.isFreeAccount(wechatAppId.toString())) {
            dto.setFromFV(Flag.TRUE.getInt());
            dto.setImsite(WechatWebAuthLinkBuilder.imSite((WebAuthScope)WebAuthScope.BASE, (String)wechatAppId.toString(), (String)sms_token));
            List records = this.orgWechatOpenIdRecordDao.listBy(wechatAppId, openId, WechatOpenIdEntityType.STUDENT);
            if (CollectionUtils.isNotEmpty((Collection)records)) {
                ArrayList<OrgSelectionDto> list = new ArrayList<OrgSelectionDto>();
                OrgSelectionDto orgSelectionDto = null;
                HashMap<Long, Integer> counterMap = new HashMap<Long, Integer>();
                for (OrgWechatOpenIdRecord record : records) {
                    if (counterMap.get((long)record.getOrgId()) != null) continue;
                    counterMap.put(record.getOrgId(), Flag.TRUE.getInt());
                    if (this.authorizationInfoDao.getByOrgId(Integer.valueOf(record.getOrgId().intValue())) != null) continue;
                    orgSelectionDto = new OrgSelectionDto();
                    OrgBaseInfoDto orgInfo = this.orgInfoDao.getBaseInfo(record.getOrgId().intValue());
                    orgSelectionDto.setShortName(orgInfo.getShortName());
                    orgSelectionDto.setOrgId(Long.valueOf(orgInfo.getOrgId().longValue()));
                    orgSelectionDto.setUrl(WechatWebAuthLinkBuilder.studentCenter((WebAuthScope)WebAuthScope.BASE, (String)record.getAuthorizerAppId(), (Long)record.getOrgId()));
                    list.add(orgSelectionDto);
                }
                dto.setOrgList(list);
            }
        } else {
            ArrayList<OrgSelectionDto> list = new ArrayList<OrgSelectionDto>();
            List listAllCampusWithAnyOneOrgInfo = this.unifiedWechatAccountDao.listAllCampusWithAnyOneOrgInfo(orgId, true);
            if (GenericsUtils.notNullAndEmpty((Object)listAllCampusWithAnyOneOrgInfo)) {
                List fieldList = GenericsUtils.toFieldList((Collection)listAllCampusWithAnyOneOrgInfo, (String)"orgId");
                ArrayList orgIds = Lists.newArrayListWithExpectedSize((int)fieldList.size());
                for (Long orgId_ : fieldList) {
                    orgIds.add(orgId_.intValue());
                }
                List students = this.orgStudentDao.findStudentWithOrgAndOpenId((List)orgIds, openId, new String[0]);
                HashMap orgStudentMapper = Maps.newHashMap();
                if (GenericsUtils.notNullAndEmpty((Object)students)) {
                    Map mapperTmp = GenericsUtils.toFieldMap((Collection)students, (String[])new String[]{"orgId"});
                    orgStudentMapper.putAll(mapperTmp);
                }
                Map orgInfoMap = this.orgInfoDao.getOrgInfoMap((Collection)orgIds, new String[0]);
                ArrayList orgInfos = new ArrayList(orgInfoMap.values());
                Collections.sort(orgInfos, new Comparator<OrgInfo>(){

                    @Override
                    public int compare(OrgInfo o1, OrgInfo o2) {
                        return OrgInfoCampare.compareUsePinyin((String)o1.getShortName(), (String)o2.getShortName());
                    }
                });
                for (OrgInfo orgInfo : orgInfos) {
                    Integer orgId_ = orgInfo.getOrgId();
                    OrgStudent orgStudent = (OrgStudent)orgStudentMapper.get(orgId_.longValue());
                    if (orgStudent == null) {
                        log.info("campus :{} has not contain the student with openId :{} ", (Object)orgId_, (Object)openId);
                        continue;
                    }
                    OrgSelectionDto orgSelectionDto = new OrgSelectionDto();
                    orgSelectionDto.setOrgId(Long.valueOf(orgInfo.getOrgId().longValue()));
                    orgSelectionDto.setShortName(orgInfo.getShortName());
                    orgSelectionDto.setUrl(WechatWebAuthLinkBuilder.studentCenter((WebAuthScope)WebAuthScope.BASE, (String)wechatAppId, (Long)orgInfo.getOrgId().longValue()));
                    list.add(orgSelectionDto);
                }
                dto.setOrgList(list);
                dto.setFromType(1);
            }
        }
    }

    @Override
    public void fillTeacherCenterInfoDto(TeacherResponseDto dto, String sms_token) throws Exception {
        if (dto == null || StringUtils.isBlank((CharSequence)sms_token)) {
            log.error("wrong param dto:{},wechatAppId:{}", (Object)dto, (Object)sms_token);
            return;
        }
        TeacherSmsTokenDto token = TeacherSmsTokenDto.fromTokenStr((String)sms_token);
        Long orgId = token.getOrgId();
        String wechatAppId = token.getWechatAppId();
        String openId = token.getOpenId();
        OrgAccount orgAccount = this.orgAccountDao.getAccountById(orgId.intValue(), new String[0]);
        String websiteFmt = "%si/%s";
        websiteFmt = String.format(websiteFmt, WechatProperties.getWebMTianXiaoUrlPrefix(), orgAccount.getNumber());
        dto.setWebsite(websiteFmt);
        dto.setOrgId(orgId);
        if (wechatAppId != null && this.freeVersionService.isFreeAccount(wechatAppId.toString())) {
            dto.setFromFV(Integer.valueOf(Flag.TRUE.getInt()));
            List records = this.orgWechatOpenIdRecordDao.listBy(wechatAppId, openId, WechatOpenIdEntityType.TEACHER);
            if (CollectionUtils.isNotEmpty((Collection)records)) {
                ArrayList<OrgSelectionDto> list = new ArrayList<OrgSelectionDto>();
                OrgSelectionDto orgSelectionDto = null;
                HashMap<Long, Integer> counterMap = new HashMap<Long, Integer>();
                for (OrgWechatOpenIdRecord record : records) {
                    if (counterMap.get((long)record.getOrgId()) != null) continue;
                    counterMap.put(record.getOrgId(), Flag.TRUE.getInt());
                    if (this.authorizationInfoDao.getByOrgId(Integer.valueOf(record.getOrgId().intValue())) != null) continue;
                    orgSelectionDto = new OrgSelectionDto();
                    OrgBaseInfoDto orgInfo = this.orgInfoDao.getBaseInfo(record.getOrgId().intValue());
                    orgSelectionDto.setShortName(orgInfo.getShortName());
                    orgSelectionDto.setOrgId(Long.valueOf(orgInfo.getOrgId().longValue()));
                    orgSelectionDto.setUrl(WechatWebAuthLinkBuilder.teacherCenter((WebAuthScope)WebAuthScope.BASE, (String)record.getAuthorizerAppId(), (Long)record.getOrgId()));
                    list.add(orgSelectionDto);
                }
                dto.setOrgList(list);
            }
        } else {
            ArrayList<OrgSelectionDto> list = new ArrayList<OrgSelectionDto>();
            List listAllCampusWithAnyOneOrgInfo = this.unifiedWechatAccountDao.listAllCampusWithAnyOneOrgInfo(orgId, true);
            if (GenericsUtils.notNullAndEmpty((Object)listAllCampusWithAnyOneOrgInfo)) {
                List fieldList = GenericsUtils.toFieldList((Collection)listAllCampusWithAnyOneOrgInfo, (String)"orgId");
                ArrayList orgIds = Lists.newArrayListWithExpectedSize((int)fieldList.size());
                for (Long orgId_ : fieldList) {
                    orgIds.add(orgId_.intValue());
                }
                List orgTeachers = this.orgTeacherDao.findStudentWithOrgAndOpenId((List)orgIds, openId, new String[0]);
                log.info("orgTeachers are : {} ", (Object)orgTeachers);
                HashMap orgTeacherMapper = Maps.newHashMap();
                if (GenericsUtils.notNullAndEmpty((Object)orgTeachers)) {
                    Map mapperTmp = GenericsUtils.toFieldMap((Collection)orgTeachers, (String[])new String[]{"orgId"});
                    orgTeacherMapper.putAll(mapperTmp);
                }
                log.info("orgTeacherMapper is :{} ", (Object)orgTeacherMapper);
                Map orgInfoMap = this.orgInfoDao.getOrgInfoMap((Collection)orgIds, new String[0]);
                ArrayList orgInfos = new ArrayList(orgInfoMap.values());
                Collections.sort(orgInfos, new Comparator<OrgInfo>(){

                    @Override
                    public int compare(OrgInfo o1, OrgInfo o2) {
                        return OrgInfoCampare.compareUsePinyin((String)o1.getShortName(), (String)o2.getShortName());
                    }
                });
                for (OrgInfo orgInfo : orgInfos) {
                    Integer orgId_ = orgInfo.getOrgId();
                    OrgTeacher orgTeacher = (OrgTeacher)orgTeacherMapper.get(orgId_.longValue());
                    log.info("find orgStudent is :{} ", (Object)orgTeacher);
                    if (orgTeacher == null) {
                        log.info("campus :{} has not contain the student with openId :{} ", (Object)orgId_, (Object)openId);
                        continue;
                    }
                    OrgSelectionDto orgSelectionDto = new OrgSelectionDto();
                    orgSelectionDto.setOrgId(Long.valueOf(orgInfo.getOrgId().longValue()));
                    orgSelectionDto.setShortName(orgInfo.getShortName());
                    orgSelectionDto.setUrl(WechatWebAuthLinkBuilder.teacherCenter((WebAuthScope)WebAuthScope.BASE, (String)wechatAppId, (Long)orgInfo.getOrgId().longValue()));
                    list.add(orgSelectionDto);
                }
                dto.setOrgList(list);
                dto.setFromType(Integer.valueOf(1));
            }
        }
    }

    public static void main(String[] args) {
        String n1 = "1234";
        String n2 = "\u5206\u6821\u533a";
        String pn1 = HanZiPinYinUtils.trans2PinYin((String)n1);
        String pn2 = HanZiPinYinUtils.trans2PinYin((String)n2);
        pn1 = pn1.toLowerCase();
        pn2 = pn2.toLowerCase();
        System.out.print("pn1:" + pn1 + " ,pn2 :" + pn2 + " is : " + pn1.compareTo(pn2));
    }
}

