/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.biz.erp.service.impl;

import com.baijia.tianxiao.biz.erp.enums.SyncSignupLessonCount;
import com.baijia.tianxiao.biz.erp.service.CourseClassService;
import com.baijia.tianxiao.biz.erp.service.ErpStudentCourseService;
import com.baijia.tianxiao.dal.constant.ChargeUnit;
import com.baijia.tianxiao.dal.enums.CourseTypeEnum;
import com.baijia.tianxiao.dal.org.constant.DeleteStatus;
import com.baijia.tianxiao.dal.org.dao.OrgCourseDao;
import com.baijia.tianxiao.dal.org.dao.OrgStudentCourseDao;
import com.baijia.tianxiao.dal.org.dao.OrgStudentDao;
import com.baijia.tianxiao.dal.org.dto.StudentCourseKexiaoDocument;
import com.baijia.tianxiao.dal.org.po.OrgCourse;
import com.baijia.tianxiao.dal.org.po.OrgStudent;
import com.baijia.tianxiao.dal.org.po.OrgStudentCourse;
import com.baijia.tianxiao.dal.signup.constant.SignupCourseStatus;
import com.baijia.tianxiao.dal.signup.po.OrgSignupCourse;
import com.baijia.tianxiao.enums.StudentCourseStatus;
import com.baijia.tianxiao.sal.common.api.KexiaoApiService;
import com.baijia.tianxiao.sal.signup.service.SignupCourseService;
import com.baijia.tianxiao.sal.signup.service.TransferClassInfoService;
import com.baijia.tianxiao.sal.wx.api.WxStudentCourseService;
import java.util.Date;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ErpStudentCourseServiceImpl
implements ErpStudentCourseService {
    private static final Logger log = LoggerFactory.getLogger(ErpStudentCourseServiceImpl.class);
    @Resource
    private OrgCourseDao orgCourseDao;
    @Resource
    private OrgStudentDao orgStudentDao;
    @Resource
    private CourseClassService courseClassService;
    @Resource
    private OrgStudentCourseDao studentCourseDao;
    @Autowired
    private SignupCourseService signupCourseService;
    @Resource
    private KexiaoApiService kexiaoApiService;
    @Autowired
    private WxStudentCourseService wxStudentCourseService;
    @Autowired
    private TransferClassInfoService transferClassInfoService;

    @Override
    public OrgStudentCourse signupToStudentCourse(OrgSignupCourse signupCourse, OrgStudentCourse studentCourse) {
        OrgStudent orgstudent;
        OrgCourse orgCourse = this.orgCourseDao.getByCourseId(signupCourse.getOrgCourseId(), new String[0]);
        if (orgCourse == null) {
            log.error("SignUpCourseProcessor not have course ={}", (Object)orgCourse);
        }
        if ((orgstudent = this.orgStudentDao.getStudentByUserId(signupCourse.getOrgId(), signupCourse.getUserId(), new String[0])) == null) {
            log.error("SignUpCourseProcessor not have orgstudent ={}", (Object)orgstudent);
        }
        boolean isWangxiaoNewStu = false;
        if (studentCourse == null) {
            log.info("OrgStudentCourse signupToStudentCourse  new class = {},{}", (Object)signupCourse, (Object)studentCourse);
            if (orgCourse.getCourseType() == CourseTypeEnum.COURSE_TYPE_1v1.getCode()) {
                studentCourse = this.courseClassService.createClassFor1V1(signupCourse.getOrgId(), signupCourse.getSignupPurchaseId(), signupCourse.getOrgCourseId(), signupCourse.getUserId(), signupCourse.getChargeUnit(), signupCourse.getLessonCount());
            } else {
                studentCourse = this.newClassStudentCourse(signupCourse, orgstudent);
                if (orgCourse.getCourseType() == CourseTypeEnum.COURSE_TYPE_CLASS_LIVE.getCode() || orgCourse.getCourseType() == CourseTypeEnum.COURSE_TYPE_CLASS_VIDEO.getCode()) {
                    isWangxiaoNewStu = true;
                }
            }
            studentCourse.setSyncLessonCount(SyncSignupLessonCount.SYNC_SIGNUP.getCode());
        } else {
            OrgCourse orgClass = this.orgCourseDao.getByCourseId((studentCourse = this.updateLessonCountAndStatus(studentCourse, signupCourse)).getCourseId(), new String[0]);
            if (orgClass != null && orgClass.getIsDel().intValue() == DeleteStatus.DELETED.getValue()) {
                orgClass.setIsDel(Integer.valueOf(DeleteStatus.NORMAL.getValue()));
                this.orgCourseDao.update((Object)orgClass, new String[]{"isDel"});
            }
        }
        studentCourse.setRealCourseId(signupCourse.getOrgCourseId());
        log.info("[SignUpCourseProcessor] studentCourse into =={}", (Object)studentCourse);
        this.studentCourseDao.saveOrUpdate((Object)studentCourse, new String[0]);
        if (isWangxiaoNewStu && studentCourse.getId() != null && studentCourse.getId() > 0L) {
            this.wxStudentCourseService.taskProcess(orgCourse, studentCourse);
        }
        return studentCourse;
    }

    private OrgStudentCourse newClassStudentCourse(OrgSignupCourse signupCourse, OrgStudent orgStudent) {
        OrgStudentCourse studentCourse = new OrgStudentCourse();
        studentCourse.setCourseId(signupCourse.getOrgCourseId());
        studentCourse.setRealCourseId(signupCourse.getOrgCourseId());
        studentCourse.setCreateTime(new Date());
        studentCourse.setDelStatus(Integer.valueOf(DeleteStatus.NORMAL.getValue()));
        studentCourse.setStatus(Integer.valueOf(StudentCourseStatus.NORMAL.getCode()));
        studentCourse.setOrgId(signupCourse.getOrgId());
        studentCourse.setUserId(signupCourse.getUserId());
        studentCourse.setStudentMobile(orgStudent.getMobile());
        studentCourse.setStudentName(orgStudent.getName());
        studentCourse.setChargeUnit(signupCourse.getChargeUnit());
        if (signupCourse.getChargeUnit().intValue() == ChargeUnit.BY_HOUR.getCode()) {
            studentCourse.setLessonCount(Integer.valueOf(signupCourse.getLessonCount() * 60));
        } else if (signupCourse.getChargeUnit().intValue() == ChargeUnit.BY_HALF_HOUR.getCode()) {
            studentCourse.setLessonCount(Integer.valueOf(signupCourse.getLessonCount() * 30));
        } else {
            studentCourse.setLessonCount(signupCourse.getLessonCount());
        }
        studentCourse.setSignupPurchaseId(signupCourse.getSignupPurchaseId());
        return studentCourse;
    }

    private OrgStudentCourse updateLessonCountAndStatus(OrgStudentCourse studentCourse, OrgSignupCourse signupCourse) {
        Integer count = this.signupCourseService.sumAllLessonCount(signupCourse.getOrgId(), signupCourse.getOrgCourseId(), signupCourse.getUserId(), SignupCourseStatus.inClassStatus, new String[0]);
        StudentCourseKexiaoDocument financed = this.kexiaoApiService.finishCountMoney(signupCourse.getOrgId(), signupCourse.getOrgCourseId(), signupCourse.getUserId(), null, SignupCourseStatus.quitClassStatus);
        Integer transferClassCount = this.transferClassInfoService.transferLessonCount(signupCourse.getUserId(), signupCourse.getClassId());
        studentCourse.setChargeUnit(Integer.valueOf(ChargeUnit.BY_HOUR.getCode()));
        if (signupCourse.getChargeUnit().intValue() == ChargeUnit.BY_HOUR.getCode() || signupCourse.getChargeUnit().intValue() == ChargeUnit.BY_HALF_HOUR.getCode() || signupCourse.getChargeUnit().intValue() == ChargeUnit.BY_MINUTE.getCode()) {
            studentCourse.setLessonCount(Integer.valueOf(count + financed.getFinishTime().intValue() - transferClassCount));
        } else {
            studentCourse.setLessonCount(Integer.valueOf(count + financed.getFinishCount().intValue() - transferClassCount));
            studentCourse.setChargeUnit(Integer.valueOf(ChargeUnit.BY_TIMES.getCode()));
        }
        studentCourse.setSyncLessonCount(SyncSignupLessonCount.SYNC_SIGNUP.getCode());
        if (signupCourse.getStatus().intValue() == SignupCourseStatus.QUIT_CLASS.getCode()) {
            studentCourse.setStatus(Integer.valueOf(StudentCourseStatus.WITHDRAW.getCode()));
        } else {
            studentCourse.setStatus(Integer.valueOf(StudentCourseStatus.NORMAL.getCode()));
        }
        return studentCourse;
    }
}

