/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.biz.erp.service.impl;

import com.baijia.tianxiao.biz.erp.dto.request.ListLessonsRequestDto;
import com.baijia.tianxiao.biz.erp.dto.response.LessonResponseDto;
import com.baijia.tianxiao.biz.erp.dto.response.ListLessonResponseDto;
import com.baijia.tianxiao.biz.erp.dto.response.studentCenter.StudentCenterCourseListDto;
import com.baijia.tianxiao.biz.erp.dto.response.studentCenter.StudentCenterInfoDto;
import com.baijia.tianxiao.biz.erp.dto.response.studentCenter.StuentCenterCourseLessonDto;
import com.baijia.tianxiao.biz.erp.service.CourseLessonService;
import com.baijia.tianxiao.biz.erp.service.ErpStudentCenterService;
import com.baijia.tianxiao.consants.UserRole;
import com.baijia.tianxiao.constant.ClassOrderCompleteStatus;
import com.baijia.tianxiao.dal.constant.ChargeUnit;
import com.baijia.tianxiao.dal.org.dao.OrgStudentDao;
import com.baijia.tianxiao.dal.org.dao.OrgTeacherLessonDao;
import com.baijia.tianxiao.dal.org.po.OrgStudent;
import com.baijia.tianxiao.dal.org.po.TXAccount;
import com.baijia.tianxiao.dal.org.po.TXCommonRule;
import com.baijia.tianxiao.dal.wechat.dao.AuthorizationInfoDao;
import com.baijia.tianxiao.dto.UniverseErrorCode;
import com.baijia.tianxiao.dto.smstoken.StudentSmsTokenDto;
import com.baijia.tianxiao.enums.CommonErrorCode;
import com.baijia.tianxiao.enums.RedisKeyEnums;
import com.baijia.tianxiao.exception.BussinessException;
import com.baijia.tianxiao.sal.comment.dto.CommentInfoDto;
import com.baijia.tianxiao.sal.comment.service.LessonCommentService;
import com.baijia.tianxiao.sal.common.api.KexiaoApiService;
import com.baijia.tianxiao.sal.common.api.RedisDefaultService;
import com.baijia.tianxiao.sal.common.dto.KexiaoStatisticsSuper;
import com.baijia.tianxiao.sal.common.dto.kexiao.KexiaoStatistics;
import com.baijia.tianxiao.sal.course.dto.response.ClassLessonInfoDto;
import com.baijia.tianxiao.sal.course.dto.response.CourseListReponseDto;
import com.baijia.tianxiao.sal.course.dto.response.TeacherResponseDto;
import com.baijia.tianxiao.sal.course.service.CourseStudentService;
import com.baijia.tianxiao.sal.course.service.CourseTeacherService;
import com.baijia.tianxiao.sal.course.service.OrgCourseListService;
import com.baijia.tianxiao.sal.course.service.OrgCourseService;
import com.baijia.tianxiao.sal.course.service.SmsService;
import com.baijia.tianxiao.sal.organization.constant.ClientType;
import com.baijia.tianxiao.sal.organization.constant.DoorgodUserRole;
import com.baijia.tianxiao.sal.organization.dto.AuthToken;
import com.baijia.tianxiao.sal.organization.org.dto.OrgBaseInfoModel;
import com.baijia.tianxiao.sal.organization.org.service.OrgBaseService;
import com.baijia.tianxiao.sal.organization.org.service.TXAccountService;
import com.baijia.tianxiao.sal.organization.org.service.TXCommonRuleService;
import com.baijia.tianxiao.sal.wechat.constant.webauth.WebAuthScope;
import com.baijia.tianxiao.sal.wechat.helper.webauthlink.WechatWebAuthLinkBuilder;
import com.baijia.tianxiao.sqlbuilder.dto.PageDto;
import com.baijia.tianxiao.util.BaseUtils;
import com.baijia.tianxiao.util.StringUtils;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import lombok.NonNull;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ErpStudentCenterServiceImpl
implements ErpStudentCenterService {
    private static final Logger log = LoggerFactory.getLogger(ErpStudentCenterServiceImpl.class);
    @Resource
    private CourseLessonService courseLessonService;
    @Resource
    private OrgCourseService orgCourseService;
    @Resource
    private OrgCourseListService orgCourseListService;
    @Resource
    private CourseStudentService orgCourseStudentService;
    @Resource
    private OrgBaseService orgBaseService;
    @Resource
    private LessonCommentService lessonCommentService;
    @Resource
    private CourseTeacherService courseTeacherService;
    @Resource
    private OrgTeacherLessonDao orgTeacherLessonDao;
    @Resource
    private OrgStudentDao orgStudentDao;
    @Resource
    private SmsService smsService;
    @Resource
    private TXAccountService txAccountService;
    @Autowired
    private KexiaoApiService kexiaoApiService;
    @Autowired
    private RedisDefaultService redisDefaultService;
    @Autowired
    private TXCommonRuleService txCommonRuleService;
    @Autowired
    private AuthorizationInfoDao authorizationInfoDao;

    @Override
    @Transactional(readOnly=true)
    public StudentCenterCourseListDto getCourseList(Long orgId, Long studentId, PageDto pageDto) {
        log.info("orgId={},studentId={},page={}", new Object[]{orgId, studentId, pageDto});
        OrgBaseInfoModel orgBaseInfoModel = this.orgBaseService.getOrgBaseInfoModel(orgId);
        StudentCenterCourseListDto dto = new StudentCenterCourseListDto();
        dto.setLogo(orgBaseInfoModel.getLogo());
        dto.setOrgName(orgBaseInfoModel.getShortName());
        List list = this.orgCourseListService.getCourseList(orgId, studentId, pageDto);
        OrgStudent orgstudent = (OrgStudent)this.orgStudentDao.getById((Serializable)studentId, new String[0]);
        if (orgstudent == null) {
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u5b66\u751f\u4e0d\u5b58\u5728");
        }
        for (CourseListReponseDto courseDto : list) {
            dto.addCourseListReponseDto(courseDto, this.buildKexiaoString(orgId, orgstudent.getUserId(), courseDto.getOrgCourseId()));
        }
        TXCommonRule txCommonRule = this.txCommonRuleService.getByOrgId(Integer.valueOf(orgId.intValue()));
        if (txCommonRule != null) {
            dto.setLeftKexiaoRule(txCommonRule.getLeftKexiaoRule());
        }
        return dto;
    }

    @Override
    @Transactional(readOnly=true)
    public StudentCenterInfoDto getInfo(@NonNull Long orgId, @NonNull Long studentId) {
        if (orgId == null) {
            throw new NullPointerException("orgId");
        }
        if (studentId == null) {
            throw new NullPointerException("studentId");
        }
        Map map = this.orgCourseStudentService.getStudentNameAndAvatar(orgId, studentId);
        Map courseLessonInfoMap = this.orgCourseStudentService.getStudentCourseLessonInfo(orgId, studentId);
        StudentCenterInfoDto studentCenterInfoDto = new StudentCenterInfoDto();
        studentCenterInfoDto.setAvatarUrl((String)map.get("avatarUrl"));
        studentCenterInfoDto.setName((String)map.get("name"));
        studentCenterInfoDto.setLessonToday((Integer)courseLessonInfoMap.get("lessonToday"));
        studentCenterInfoDto.setCourseCount((Integer)courseLessonInfoMap.get("courseCount"));
        studentCenterInfoDto.setCommentCount((Integer)courseLessonInfoMap.get("commentCount"));
        TXAccount superAccount = this.txAccountService.getTXAccountByOrgId(Integer.valueOf(orgId.intValue()), new String[0]);
        List accountModuleAuth = null;
        if (superAccount != null && !StringUtils.isEmpty((String)superAccount.getModuleAuth())) {
            accountModuleAuth = BaseUtils.strToList((String)superAccount.getModuleAuth(), (String)",");
        }
        if (CollectionUtils.isNotEmpty(accountModuleAuth) && accountModuleAuth.contains(String.valueOf(ClientType.HW.getCode()))) {
            studentCenterInfoDto.setHwCenter(AuthToken.assignMentStudentToken((Long)orgId, (Long)studentId, (String)((String)map.get("name")), (Integer)DoorgodUserRole.STUDENT.getRole(), (ClientType)ClientType.HW));
        }
        if (CollectionUtils.isNotEmpty(accountModuleAuth) && accountModuleAuth.contains(String.valueOf(ClientType.EXAM.getCode()))) {
            studentCenterInfoDto.setExamCenter(AuthToken.assignMentStudentToken((Long)orgId, (Long)studentId, (String)((String)map.get("name")), (Integer)DoorgodUserRole.STUDENT.getRole(), (ClientType)ClientType.EXAM));
        }
        if (CollectionUtils.isNotEmpty((Collection)accountModuleAuth) && accountModuleAuth.contains(String.valueOf(ClientType.GRADE.getCode()))) {
            studentCenterInfoDto.setGradeCenter(AuthToken.assignMentStudentToken((Long)orgId, (Long)studentId, (String)((String)map.get("name")), (Integer)DoorgodUserRole.STUDENT.getRole(), (ClientType)ClientType.GRADE));
        }
        return studentCenterInfoDto;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public StuentCenterCourseLessonDto getCourseLesson(Long orgId, Long courseId, Long studentId) {
        CourseListReponseDto courseListReponseDto;
        Long userId = this.orgStudentDao.getUserId(studentId);
        Preconditions.checkArgument((userId != null && userId > 0L ? 1 : 0) != 0, (Object)"student not exist!");
        OrgBaseInfoModel orgBaseInfoModel = this.orgBaseService.getOrgBaseInfoModel(orgId);
        StuentCenterCourseLessonDto dto = new StuentCenterCourseLessonDto();
        dto.setLogo(orgBaseInfoModel.getLogo());
        dto.setOrgName(orgBaseInfoModel.getShortName());
        dto.setExtension(orgBaseInfoModel.getExtension());
        this.smsService.viewSms(orgId, courseId, userId, Integer.valueOf(UserRole.STUDENT.getRole()));
        ListLessonsRequestDto params = new ListLessonsRequestDto();
        params.setCourseId(courseId);
        params.setStudentId(studentId);
        params.setNeedStudentSignStatus(true);
        params.setNeedRoomName(true);
        params.setNeedTeacherName(true);
        params.setNeedcourseName(true);
        dto.setKexiaoStr(this.buildKexiaoString(orgId, userId, courseId));
        ListLessonResponseDto listResponse = this.courseLessonService.listLessons(orgId, params, false);
        dto.setLessonCount(listResponse.getList().size());
        ArrayList lessonIds = Lists.newArrayList();
        for (LessonResponseDto lessonResponseDto : listResponse.getList()) {
            lessonIds.add(lessonResponseDto.getLessonId());
        }
        Map commentMap = this.lessonCommentService.getStudentLessonCommentMap(userId, (Collection)lessonIds);
        if (listResponse != null && !CollectionUtils.isEmpty(listResponse.getList())) {
            log.debug("respose list = {}", listResponse.getList());
            for (LessonResponseDto respDto : listResponse.getList()) {
                ClassLessonInfoDto classLessonInfoDto = new ClassLessonInfoDto();
                classLessonInfoDto.setLessonId(respDto.getLessonId());
                classLessonInfoDto.setIndex(Integer.valueOf(respDto.getIndex()));
                classLessonInfoDto.setStartTime(respDto.getLessonStartTime());
                classLessonInfoDto.setEndTime(respDto.getLessonEndTime());
                classLessonInfoDto.setHasComment((Boolean)commentMap.get(respDto.getLessonId()));
                classLessonInfoDto.setSignStatus(Integer.valueOf(respDto.getSignStatus()));
                classLessonInfoDto.setSignStatusStr(respDto.getSignStatusStr());
                classLessonInfoDto.setTeacherName(respDto.getTeacherName());
                classLessonInfoDto.setIsOver(Integer.valueOf(respDto.getIsOver()));
                classLessonInfoDto.setCourseName(respDto.getCourseName());
                classLessonInfoDto.setRoomName(respDto.getRoomName());
                classLessonInfoDto.setLessonName(respDto.getLessonName());
                dto.getLessons().add(classLessonInfoDto);
            }
        }
        if ((courseListReponseDto = this.orgCourseService.getOrgBasicCourseInfo(orgId, courseId)) != null) {
            dto.setCourseName(courseListReponseDto.getCourseName());
            dto.setCourseUrl(courseListReponseDto.getCoverUrl());
        }
        log.debug("dto = {}", (Object)dto);
        return dto;
    }

    @Override
    @Transactional(readOnly=true)
    public Map<String, Object> buildStudentCommentDetail(Long orgId, Long lessonId, Long studentId, Integer userRole) {
        Long userId = this.orgStudentDao.getUserId(studentId);
        Preconditions.checkArgument((userId != null ? 1 : 0) != 0, (Object)"student not exists!");
        if (userRole == null) {
            userRole = UserRole.STUDENT.getRole();
        }
        CommentInfoDto commentInfoDto = this.lessonCommentService.getCommentDetail(lessonId, userId, orgId, userRole);
        log.debug("commentInfoDto = {}", (Object)commentInfoDto);
        HashMap map = Maps.newHashMap();
        OrgBaseInfoModel orgBaseInfoModel = this.orgBaseService.getOrgBaseInfoModel(orgId);
        map.put("orgName", orgBaseInfoModel.getShortName());
        map.put("logo", orgBaseInfoModel.getLogo());
        map.put("courseName", commentInfoDto.getCourseName());
        List teacherIds = this.orgTeacherLessonDao.getUserIds(lessonId, orgId);
        TeacherResponseDto teacherResponseDto = null;
        if (CollectionUtils.isNotEmpty((Collection)teacherIds) && (teacherResponseDto = this.courseTeacherService.getTeacher((Long)teacherIds.get(0), orgId)) != null) {
            map.put("teacherName", teacherResponseDto.getTeacherName());
            map.put("avatarUrl", teacherResponseDto.getAvatar());
        }
        map.put("index", commentInfoDto.getIndex());
        map.put("startTime", commentInfoDto.getStartTime());
        map.put("endTime", commentInfoDto.getEndTime());
        map.put("score", commentInfoDto.getScore());
        map.put("content", commentInfoDto.getContent() == null ? "" : commentInfoDto.getContent());
        map.put("urls", commentInfoDto.getUrls() == null ? "" : commentInfoDto.getUrls());
        return map;
    }

    @Override
    @Transactional(readOnly=true)
    public Map<String, Object> buildLessonInfo(Long orgId, Long lessonId, Long studentId) {
        Map map = this.orgCourseService.buildLessonInfo(orgId, lessonId, studentId);
        OrgBaseInfoModel orgBaseInfoModel = this.orgBaseService.getOrgBaseInfoModel(orgId);
        map.put("orgName", orgBaseInfoModel.getShortName());
        map.put("logo", orgBaseInfoModel.getLogo());
        map.put("extension", orgBaseInfoModel.getExtension());
        return map;
    }

    @Override
    public void quitStudentCenter(String token) {
        String key = RedisKeyEnums.ERP.QUIT_STUDENT_CENTER_TOKEN + token;
        log.info("quit student center key== {}", (Object)key);
        if (this.redisDefaultService.get(key) == null) {
            log.info("quit student center == {},{}", (Object)key, (Object)this.redisDefaultService);
            this.redisDefaultService.setWithExpire(key, "success".getBytes(), 1440L);
        }
    }

    @Override
    public String getStudentCenterLoginUrl(String smsToken) {
        String url = "";
        try {
            StudentSmsTokenDto token = StudentSmsTokenDto.fromTokenStr((String)smsToken);
            if (token != null) {
                url = WechatWebAuthLinkBuilder.studentCenter((WebAuthScope)WebAuthScope.BASE, (String)token.getWechatAppId());
            }
        }
        catch (Exception e) {
            log.warn("get student center login url e={}", (Throwable)e);
        }
        return url;
    }

    private String buildKexiaoString(Long orgId, Long userId, Long courseId) {
        TXCommonRule txCommonRule = this.txCommonRuleService.getByOrgId(Integer.valueOf(orgId.intValue()));
        if (txCommonRule != null && txCommonRule.getLeftKexiaoRule() == 0) {
            return "";
        }
        KexiaoStatistics statistics = this.kexiaoApiService.queryKexiaoStatByStudentClass(orgId.longValue(), userId.longValue(), courseId.longValue());
        if (statistics.getCompleteStatus() != ClassOrderCompleteStatus.COMPLETED.getCode().intValue() && !statistics.isRefund()) {
            return "";
        }
        KexiaoStatisticsSuper orgCourseDto = new KexiaoStatisticsSuper();
        this.kexiaoApiService.fillKexiaoData(orgCourseDto, statistics);
        StringBuffer stringBuffer = new StringBuffer();
        if (ChargeUnit.isByTimes((int)statistics.getChargeUnit())) {
            stringBuffer.append("\u603b").append(orgCourseDto.getTotalClassTimesForKexiao()).append("\u6b21/");
            stringBuffer.append("\u5df2\u4e0a").append(orgCourseDto.getFinishClassTimesForKexiao()).append("\u6b21/");
            stringBuffer.append("\u5269\u4f59").append(orgCourseDto.getLeftClassTimesForKexiao()).append("\u6b21");
        } else {
            stringBuffer.append("\u603b").append(orgCourseDto.getTotalClassTimesForKexiao()).append("\u5c0f\u65f6/");
            stringBuffer.append("\u5df2\u4e0a").append(orgCourseDto.getFinishClassTimesForKexiao()).append("\u5c0f\u65f6/");
            stringBuffer.append("\u5269\u4f59").append(orgCourseDto.getLeftClassTimesForKexiao()).append("\u5c0f\u65f6");
        }
        return stringBuffer.toString();
    }
}

