/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.biz.erp.service.impl;

import com.baijia.tianxiao.biz.erp.dto.OrgCourseInfoPcDto;
import com.baijia.tianxiao.biz.erp.dto.response.exportCourse.CourseStudent;
import com.baijia.tianxiao.biz.erp.dto.response.exportCourse.ExportCourseInfoDto;
import com.baijia.tianxiao.biz.erp.dto.response.schedule.CommonInfoTipsDto;
import com.baijia.tianxiao.biz.erp.dto.response.schedule.CourseBaseInfoDto;
import com.baijia.tianxiao.biz.erp.dto.response.schedule.CourseNameAndIdDto;
import com.baijia.tianxiao.biz.erp.dto.response.schedule.VipClassDetailDto;
import com.baijia.tianxiao.biz.erp.service.CourseLessonService;
import com.baijia.tianxiao.biz.erp.service.ErpCourseService;
import com.baijia.tianxiao.biz.erp.service.ErpStudentService;
import com.baijia.tianxiao.biz.erp.teacherCenter.service.ExcelCourseExportService;
import com.baijia.tianxiao.dal.constant.ChargeUnit;
import com.baijia.tianxiao.dal.enums.CourseTypeEnum;
import com.baijia.tianxiao.dal.org.constant.DeleteStatus;
import com.baijia.tianxiao.dal.org.dao.OrgAccountDao;
import com.baijia.tianxiao.dal.org.dao.OrgClassLessonDao;
import com.baijia.tianxiao.dal.org.dao.OrgCourseConsumeRuleDao;
import com.baijia.tianxiao.dal.org.dao.OrgCourseDao;
import com.baijia.tianxiao.dal.org.dao.OrgInfoDao;
import com.baijia.tianxiao.dal.org.dao.OrgLessonSignDao;
import com.baijia.tianxiao.dal.org.dao.OrgStudentCourseDao;
import com.baijia.tianxiao.dal.org.dao.OrgStudentDao;
import com.baijia.tianxiao.dal.org.dao.OrgStudentLessonDao;
import com.baijia.tianxiao.dal.org.dao.TXCascadeAccountDao;
import com.baijia.tianxiao.dal.org.dao.TXCascadeCredentialDao;
import com.baijia.tianxiao.dal.org.po.OrgAccount;
import com.baijia.tianxiao.dal.org.po.OrgCourse;
import com.baijia.tianxiao.dal.org.po.OrgCourseConsumeRule;
import com.baijia.tianxiao.dal.org.po.OrgInfo;
import com.baijia.tianxiao.dal.org.po.OrgStudent;
import com.baijia.tianxiao.dal.org.po.OrgStudentCourse;
import com.baijia.tianxiao.dal.org.po.TXCascadeAccount;
import com.baijia.tianxiao.dal.org.po.TXCascadeCredential;
import com.baijia.tianxiao.dto.IdNameDto;
import com.baijia.tianxiao.dto.PersonBaseDto;
import com.baijia.tianxiao.dto.UniverseErrorCode;
import com.baijia.tianxiao.enums.CommonErrorCode;
import com.baijia.tianxiao.excel.dto.ExportField;
import com.baijia.tianxiao.exception.BussinessException;
import com.baijia.tianxiao.filter.TianxiaoPCContext;
import com.baijia.tianxiao.sal.common.api.KexiaoApiService;
import com.baijia.tianxiao.sal.common.dto.kexiao.KexiaoStatistics;
import com.baijia.tianxiao.sal.course.dto.OrgCourseInfoDto;
import com.baijia.tianxiao.sal.course.dto.response.TeacherResponseDto;
import com.baijia.tianxiao.sal.course.enums.CourseConsumeRuleEnum;
import com.baijia.tianxiao.sal.course.service.CourseStudentService;
import com.baijia.tianxiao.sal.course.service.CourseTeacherService;
import com.baijia.tianxiao.sal.course.service.OrgCourseConsumeRuleService;
import com.baijia.tianxiao.sal.course.service.OrgCourseService;
import com.baijia.tianxiao.sal.organization.constant.CascadeType;
import com.baijia.tianxiao.sal.organization.constant.DeviceType;
import com.baijia.tianxiao.sal.organization.constant.TXPermissionConst;
import com.baijia.tianxiao.sal.organization.org.service.TxAccountPermissionService;
import com.baijia.tianxiao.sal.room.dto.ClassRoomDto;
import com.baijia.tianxiao.sal.room.service.ClassRoomService;
import com.baijia.tianxiao.sal.student.enums.StudentErrorCode;
import com.baijia.tianxiao.sqlbuilder.dto.PageDto;
import com.baijia.tianxiao.util.BaseUtils;
import com.baijia.tianxiao.util.json.JacksonUtil;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Transformer;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ErpCourseServiceImpl
implements ErpCourseService {
    private static final Logger log = LoggerFactory.getLogger(ErpCourseServiceImpl.class);
    private static final String DEFAULT_CLASS_MASTER = "\u672a\u8bbe\u7f6e";
    private static final List<String> timeExportHeader = Lists.newArrayList((Object[])new String[]{"\u73ed\u7ea7\u540d\u79f0", "\u6388\u8bfe\u8001\u5e08", "\u8bfe\u7a0b\u7c7b\u578b", "\u6559\u5ba4", "\u5b66\u5458\u4eba\u6570", "\u73ed\u7ea7\u5b66\u5458", "\u5b66\u5458\u7535\u8bdd", "\u6392\u8bfe\u8bfe\u6b21", "\u5df2\u4e0a\u8bfe\u6b21", "\u5269\u4f59\u8bfe\u6b21"});
    private static final List<String> hourExportHeader = Lists.newArrayList((Object[])new String[]{"\u73ed\u7ea7\u540d\u79f0", "\u6388\u8bfe\u8001\u5e08", "\u8bfe\u7a0b\u7c7b\u578b", "\u6559\u5ba4", "\u5b66\u5458\u4eba\u6570", "\u73ed\u7ea7\u5b66\u5458", "\u5b66\u5458\u7535\u8bdd", "\u6392\u8bfe\u8bfe\u65f6", "\u5df2\u4e0a\u8bfe\u65f6", "\u5269\u4f59\u8bfe\u65f6"});
    @Resource
    private OrgCourseDao orgCourseDao;
    @Resource
    private CourseTeacherService courseTeacherService;
    @Resource
    private TXCascadeAccountDao cascadeAccountDao;
    @Resource
    private ClassRoomService classRoomService;
    @Resource
    private TXCascadeCredentialDao credentialDao;
    @Resource
    private OrgStudentCourseDao orgStudentCourseDao;
    @Resource
    private OrgClassLessonDao orgClassLessonDao;
    @Resource
    private OrgCourseService orgCourseService;
    @Resource
    private ErpStudentService erpStudentService;
    @Resource
    private OrgCourseConsumeRuleDao orgCourseConsumeRuleDao;
    @Resource
    private OrgAccountDao orgAccountDao;
    @Resource
    private CourseStudentService courseStudentService;
    @Resource
    private OrgInfoDao orgInfoDao;
    @Resource
    private TxAccountPermissionService permissionService;
    @Resource
    private OrgLessonSignDao orgLessonSignDao;
    @Resource
    private OrgCourseConsumeRuleService orgCourseConsumeRuleService;
    @Resource
    private OrgStudentDao orgStudentDao;
    @Resource
    private OrgStudentLessonDao orgStudentLessonDao;
    @Resource
    private CourseLessonService courseLessonService;
    @Resource
    private KexiaoApiService kexiaoApiService;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public CourseBaseInfoDto getCourseDetailById(Long orgId, Long courseId) {
        Preconditions.checkArgument((orgId != null && orgId > 0L ? 1 : 0) != 0, (Object)"illegal orgId");
        Preconditions.checkArgument((courseId != null && courseId > 0L ? 1 : 0) != 0, (Object)"illegal courseId");
        CourseBaseInfoDto orgCourseInfoDto = new CourseBaseInfoDto();
        OrgCourse course = null;
        if (courseId != null && courseId > 0L && (course = (OrgCourse)this.orgCourseDao.getById((Serializable)courseId, new String[0])) != null) {
            orgCourseInfoDto.setCourseNumber(course.getNumber());
            orgCourseInfoDto.setCourseId(courseId);
            orgCourseInfoDto.setCourseName(course.getName());
            orgCourseInfoDto.setCoursePrice(course.getPrice());
            orgCourseInfoDto.setAddress(course.getAddress());
            orgCourseInfoDto.setStartTime(course.getBeginTime());
            orgCourseInfoDto.setEndTime(course.getEndTime());
            orgCourseInfoDto.setCourseType(course.getCourseType());
            orgCourseInfoDto.setTotalLessons(course.getFreq() == null ? 0 : course.getFreq());
            orgCourseInfoDto.setTeacherInfo(this.getCourseTeacherTips(orgId, courseId));
            orgCourseInfoDto.setClassMaster(this.getAccountName(orgId, course.getCascadeId()));
            orgCourseInfoDto.setRoomInfo(this.getCourseRoomTips(orgId, courseId));
            if (course.getChargeUnit().intValue() == ChargeUnit.BY_HOUR.getCode()) {
                orgCourseInfoDto.setFinishedLessons(this.getFinishedLessonMinute(orgId, courseId));
            } else {
                orgCourseInfoDto.setFinishedLessons(this.getFinishedLessonCount(orgId, courseId));
            }
            orgCourseInfoDto.setStudentCount(this.getCourseStudentCount(orgId, courseId));
            orgCourseInfoDto.setChargeType(course.getChargeType());
            orgCourseInfoDto.setChargeUnit(course.getChargeUnit());
            String consumRuleName = "\u672a\u8bbe\u7f6e\u8bfe\u6d88\u89c4\u5219";
            OrgCourseConsumeRule courseConsumRule = this.orgCourseConsumeRuleDao.getRuleByCourseId(orgId, courseId);
            if (courseConsumRule != null) {
                orgCourseInfoDto.setConsumRuleId(courseConsumRule.getId());
                int consumVal = courseConsumRule.getRuleValue();
                consumRuleName = CourseConsumeRuleEnum.getRuleDescByValue((Integer)consumVal);
            }
            orgCourseInfoDto.setConsumeRuleName(consumRuleName);
            orgCourseInfoDto.setMaxStudent(course.getMaxStudent());
        }
        log.info("ErpCourseServiceImpl.getCourseDetailById.orgId:{}, courseId:{}, data:{}", new Object[]{orgId, courseId, orgCourseInfoDto});
        return orgCourseInfoDto;
    }

    @Override
    public VipClassDetailDto getVipClassDetailById(Long orgId, Long courseId) {
        Preconditions.checkArgument((orgId != null && orgId > 0L ? 1 : 0) != 0, (Object)"illegal orgId");
        Preconditions.checkArgument((courseId != null && courseId > 0L ? 1 : 0) != 0, (Object)"illegal courseId");
        VipClassDetailDto vipClassDetailDto = new VipClassDetailDto();
        OrgCourse classInfo = (OrgCourse)this.orgCourseDao.getById((Serializable)courseId, new String[0]);
        if (classInfo == null || classInfo.getIsClass() != CourseTypeEnum.IS_CLASS_TRUE.getCode() || classInfo.getIsDel().intValue() == DeleteStatus.DELETED.getValue()) {
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.NOT_FOUND, "\u73ed\u7ea7\u4e0d\u5b58\u5728\u6216\u5df2\u88ab\u5220\u9664");
        }
        OrgCourse orgCourseInfo = (OrgCourse)this.orgCourseDao.getById((Serializable)classInfo.getParentId(), new String[0]);
        vipClassDetailDto.setCourseId(classInfo.getId());
        vipClassDetailDto.setClassName(classInfo.getName());
        vipClassDetailDto.setTeacherInfo(this.getCourseTeacherTips(orgId, classInfo.getId()));
        vipClassDetailDto.setRoomInfo(this.getCourseRoomTips(orgId, classInfo.getId()));
        vipClassDetailDto.setClassMaster(this.getAccountName(orgId, classInfo.getCascadeId()));
        OrgStudentCourse course = this.getOneToOne(orgId, courseId);
        if (course != null) {
            KexiaoStatistics statistics = this.kexiaoApiService.queryKexiaoStatByStudentClass(orgId.longValue(), course.getUserId().longValue(), courseId.longValue());
            vipClassDetailDto.setFinishedLessons((int)statistics.getKexiaoNumber());
            vipClassDetailDto.setTotalLessons((int)statistics.getBuyNumber());
        }
        vipClassDetailDto.setCoursePrice(classInfo.getPrice() == null ? 0.0 : classInfo.getPrice());
        vipClassDetailDto.setCreateTime(classInfo.getCreateTime());
        vipClassDetailDto.setStudentCount(this.getCourseStudentCount(orgId, courseId));
        vipClassDetailDto.setStudentStatus(vipClassDetailDto.getStudentCount() == 0 ? 1 : 0);
        vipClassDetailDto.setTotalPrice(0.0);
        vipClassDetailDto.setAddress(classInfo.getAddress());
        OrgCourseConsumeRule courseConsumRule = this.orgCourseConsumeRuleDao.getRuleByCourseId(orgId, orgCourseInfo.getId());
        if (courseConsumRule == null) {
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.NOT_FOUND, "\u8bfe\u6d88\u89c4\u5219\u672a\u8bbe\u7f6e");
        }
        int consumeVal = courseConsumRule.getRuleValue();
        vipClassDetailDto.setConsumeRuleId(consumeVal);
        vipClassDetailDto.setConsumeRuleName(CourseConsumeRuleEnum.getRuleDescByValue((Integer)consumeVal));
        vipClassDetailDto.setChargeType(classInfo.getChargeType());
        vipClassDetailDto.setChargeUnit(classInfo.getChargeUnit());
        return vipClassDetailDto;
    }

    private OrgStudentCourse getOneToOne(Long orgId, Long courseId) {
        List list = this.orgStudentCourseDao.getStudentListByCourseId(orgId, courseId, new String[0]);
        if (CollectionUtils.isEmpty((Collection)list)) {
            return null;
        }
        OrgStudentCourse studentCourse = (OrgStudentCourse)list.get(0);
        return studentCourse;
    }

    private Integer getFinishedVipBuyLength(Long orgId, Long courseId) {
        List list = this.orgStudentCourseDao.getStudentListByCourseId(orgId, courseId, new String[0]);
        if (CollectionUtils.isEmpty((Collection)list)) {
            return 0;
        }
        OrgStudentCourse studentCourse = (OrgStudentCourse)list.get(0);
        return studentCourse.getLessonCount();
    }

    private Integer getFinishedVipLessonLength(Long orgId, Long courseId) {
        Map finishLessonLengthMap = this.orgClassLessonDao.getFinishLessonLengthMap(orgId, Arrays.asList(courseId), Integer.valueOf(DeleteStatus.NORMAL.getValue()));
        Map fMap = (Map)finishLessonLengthMap.get(courseId);
        int finish = fMap != null ? this.intSum(fMap.values()) : 0;
        return finish;
    }

    private Integer getFinishedVipLessonCount(Long orgId, Long courseId, Long parentCourseId) {
        OrgCourseConsumeRule orgCourseConsumeRule = this.orgCourseConsumeRuleDao.getRuleByCourseId(orgId, parentCourseId);
        int ruleValue = orgCourseConsumeRule.getRuleValue();
        int count = this.orgLessonSignDao.getVipLessonSignCount(orgId, courseId, ruleValue);
        return count;
    }

    private String getAccountName(Long orgId, Integer cascadeId) {
        if (cascadeId != null && cascadeId > 0) {
            TXCascadeAccount cascadeAccount = (TXCascadeAccount)this.cascadeAccountDao.getById((Serializable)cascadeId, new String[0]);
            if (cascadeAccount == null || cascadeAccount.getIsdel() == 1 || cascadeAccount.getStatus() == 1) {
                log.warn("[Wechat] Message TXCascadeAccount is invalidate.cascadeAccount={}", (Object)cascadeAccount);
            } else {
                TXCascadeCredential credential = this.credentialDao.getTXCascadeCredentialByCredentialId(cascadeAccount.getCredentialId());
                if (credential != null) {
                    return credential.getName() == null ? credential.getMobile() : credential.getName();
                }
                log.error("[Wechat] Message TXCascadeCredential is invalidate.credentialId=" + cascadeAccount.getCredentialId());
            }
        } else if (cascadeId == 0) {
            OrgInfo orgInfo = this.orgInfoDao.getOrgInfo(Integer.valueOf(orgId.intValue()), new String[]{"contacts"});
            return orgInfo != null && StringUtils.isNotBlank((CharSequence)orgInfo.getContacts()) ? orgInfo.getContacts() : "";
        }
        return DEFAULT_CLASS_MASTER;
    }

    private CommonInfoTipsDto getCourseRoomTips(Long orgId, Long courseId) {
        List data = this.classRoomService.listOrgCourseRooms(orgId, courseId);
        CommonInfoTipsDto tips = null;
        if (CollectionUtils.isNotEmpty((Collection)data)) {
            tips = new CommonInfoTipsDto();
            int count = data.size();
            Set names = BaseUtils.getPropertiesList((List)data, (String)"roomName");
            tips.setCount(count);
            tips.setNames(names);
        }
        log.info("getCourseRoomTips.tips:{}", (Object)tips);
        return tips;
    }

    private CommonInfoTipsDto getCourseTeacherTips(Long orgId, Long courseId) {
        List data = this.courseTeacherService.listCourseTeacher(orgId, courseId);
        CommonInfoTipsDto tips = null;
        if (CollectionUtils.isNotEmpty((Collection)data)) {
            tips = new CommonInfoTipsDto();
            int count = data.size();
            Set names = BaseUtils.getPropertiesList((List)data, (String)"teacherName");
            tips.setCount(count);
            tips.setNames(names);
        }
        log.info("getCourseTeacherTips.tips:{}", (Object)tips);
        return tips;
    }

    private int getCourseStudentCount(Long orgId, Long courseId) {
        List studentIds = this.orgStudentCourseDao.getStudents(orgId, courseId, Integer.valueOf(0));
        return CollectionUtils.isNotEmpty((Collection)studentIds) ? studentIds.size() : 0;
    }

    private int getFinishedLessonMinute(Long orgId, Long courseId) {
        int finishedLessonCount = 0;
        Map finishLessonLengthMap = this.orgClassLessonDao.getFinishLessonLengthMap(orgId, Arrays.asList(courseId), Integer.valueOf(DeleteStatus.NORMAL.getValue()));
        Map lengthMap = (Map)finishLessonLengthMap.get(courseId);
        finishedLessonCount = lengthMap != null ? this.intSum(lengthMap.values()) : 0;
        return finishedLessonCount;
    }

    private int getFinishedLessonCount(Long orgId, Long courseId) {
        int finishedLessonCount = this.orgClassLessonDao.getFinishLessonCount(orgId, courseId, Integer.valueOf(DeleteStatus.NORMAL.getValue()));
        return finishedLessonCount;
    }

    private Integer intSum(Collection<Integer> values) {
        int sum = 0;
        if (CollectionUtils.isNotEmpty(values)) {
            for (Integer value : values) {
                sum += value.intValue();
            }
        }
        return sum;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long saveOrUpdateCourse(Long orgId, OrgCourseInfoPcDto course) {
        Long courseId = this.orgCourseService.saveOrUpdateCourse(orgId, (OrgCourseInfoDto)course, true, true);
        if (courseId == null || courseId <= 0L) {
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.SYSTEM_ERROR, "\u4fdd\u5b58\u8bfe\u7a0b\u5931\u8d25");
        }
        List roomIds = Lists.newArrayList();
        List studentIds = Lists.newArrayList();
        try {
            if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{course.getRoomIds()})) {
                roomIds = JacksonUtil.str2List((String)course.getRoomIds(), Long.class);
            }
            if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{course.getStudentIds()})) {
                studentIds = JacksonUtil.str2List((String)course.getStudentIds(), Long.class);
            }
        }
        catch (Exception e) {
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u6559\u5ba4\u3001\u5b66\u751f\u53c2\u6570\u9519\u8bef");
        }
        this.classRoomService.saveCourseRooms(orgId, courseId, (Collection)roomIds);
        this.erpStudentService.saveCourseStudents(orgId, courseId, studentIds);
        if (course.getCascadeId() != null) {
            boolean hasPermission;
            Integer curCascadeId = TianxiaoPCContext.getTXCascadeId();
            if (curCascadeId != null && curCascadeId > 0 && !(hasPermission = this.permissionService.checkPermission(orgId, curCascadeId, DeviceType.PC, Long.valueOf(TXPermissionConst.DISTRIBUTE_CLASSMANAGER.getPCode())))) {
                throw new BussinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u6ca1\u6709\u5206\u914d\u73ed\u4e3b\u4efb\u7684\u6743\u9650");
            }
            OrgCourse orgCourse = this.orgCourseDao.getByCourseId(courseId, new String[]{"id", "cascadeId"});
            if (course.getCascadeId() == 0L) {
                orgCourse.setCascadeId(Integer.valueOf(0));
            } else if (course.getCascadeId() < 0L) {
                orgCourse.setCascadeId(Integer.valueOf(-1));
            } else {
                TXCascadeAccount cascadeAccount = this.cascadeAccountDao.getByIdAndOrgId(Integer.valueOf(course.getCascadeId().intValue()), Integer.valueOf(orgId.intValue()), new String[0]);
                if (cascadeAccount != null && cascadeAccount.getCredentialId() != null && cascadeAccount.getCredentialId() > 0) {
                    TXCascadeCredential txCascadeCredential = this.credentialDao.getTXCascadeCredentialByCredentialId(cascadeAccount.getCredentialId());
                    if (txCascadeCredential == null) {
                        throw new BussinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u5b50\u5e10\u53f7\u5f02\u5e38");
                    }
                    orgCourse.setCascadeId(cascadeAccount.getId());
                } else {
                    throw new BussinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u5b50\u5e10\u53f7\u5f02\u5e38");
                }
            }
            this.orgCourseDao.update((Object)orgCourse, Boolean.valueOf(false), new String[]{"cascadeId"});
        }
        return courseId;
    }

    @Override
    public List<CourseNameAndIdDto> fuzzyQuery(Long orgId, String courseName, Integer type, PageDto pageDto) {
        HashSet<Long> courseIds = new HashSet<Long>();
        if (TianxiaoPCContext.getTXCascadeId() != null) {
            TXCascadeAccount txCascadeAccount = (TXCascadeAccount)this.cascadeAccountDao.getById((Serializable)TianxiaoPCContext.getTXCascadeId(), new String[0]);
            if (txCascadeAccount == null) {
                throw new BussinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u5b50\u5e10\u53f7\u4e0d\u5b58\u5728");
            }
            if (txCascadeAccount.getAccountType().intValue() == CascadeType.STAFF.getValue()) {
                this.courseLessonService.handleStaffCourseIds(orgId, TianxiaoPCContext.getTXCascadeId(), courseIds);
                if (courseIds.isEmpty()) {
                    return Lists.newArrayList();
                }
            }
        }
        OrgAccount orgAccount = (OrgAccount)this.orgAccountDao.getById((Serializable)TianxiaoPCContext.getOrgId(), new String[0]);
        List courses = this.orgCourseDao.fuzzyQueryByCourseType(orgAccount.getNumber(), courseName, courseIds, type, pageDto);
        List data = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty((Collection)courses)) {
            data = (List)CollectionUtils.collect((Collection)courses, (Transformer)new Transformer(){

                public Object transform(Object input) {
                    CourseNameAndIdDto dto = new CourseNameAndIdDto();
                    OrgCourse course = (OrgCourse)input;
                    dto.setId(course.getId());
                    dto.setName(course.getName());
                    dto.setCourseType(course.getCourseType());
                    dto.setFinishStatus(course.getFinishStatus());
                    return dto;
                }
            });
        }
        return data;
    }

    @Override
    public OrgCourseInfoPcDto getOrgCourseInfoPc(Long orgId, Long courseId) throws IllegalAccessException, InvocationTargetException {
        Preconditions.checkArgument((orgId != null && orgId > 0L ? 1 : 0) != 0, (Object)"orgId is illegal");
        Preconditions.checkArgument((courseId != null && courseId > 0L ? 1 : 0) != 0, (Object)"courseId is illegal");
        OrgAccount orgAccount = (OrgAccount)this.orgAccountDao.getById((Serializable)orgId, new String[]{"isDel", "mobile"});
        OrgInfo orgInfo = this.orgInfoDao.getOrgInfo(Integer.valueOf(orgId.intValue()), new String[]{"contacts"});
        if (orgAccount == null || orgAccount.getIsDel().intValue() == DeleteStatus.DELETED.getValue() || orgInfo == null) {
            throw new BussinessException((UniverseErrorCode)StudentErrorCode.ORG_NOT_EXIST);
        }
        OrgCourse orgCourse = this.orgCourseDao.getByCourseId(courseId, new String[]{"id", "cascadeId", "chargeUnit"});
        if (orgCourse == null) {
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u673a\u6784id\u9519\u8bef");
        }
        OrgCourseInfoPcDto courseDto = new OrgCourseInfoPcDto();
        OrgCourseInfoDto courseInfo = this.orgCourseService.getOrgCourseInfo(orgId, courseId);
        if (courseInfo == null) {
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u53c2\u6570\u9519\u8bef");
        }
        BeanUtils.copyProperties((Object)((Object)courseDto), (Object)courseInfo);
        List rooms = this.classRoomService.listOrgCourseRooms(orgId, courseId);
        ArrayList roomList = Lists.newArrayList();
        for (ClassRoomDto room : rooms) {
            IdNameDto roomDto = new IdNameDto();
            roomDto.setId(Integer.valueOf(room.getRoomId().intValue()));
            roomDto.setName(room.getRoomName());
            roomList.add(roomDto);
        }
        courseDto.setRooms(roomList);
        courseDto.setTotalLessons(courseInfo.getFreq() == null ? 0 : courseInfo.getFreq());
        Integer lessonCount = this.orgClassLessonDao.getLessonCount(orgId, courseId, Integer.valueOf(0));
        Map lessonLength = this.orgClassLessonDao.getLessonLengthMap(orgId, Arrays.asList(courseId), Integer.valueOf(DeleteStatus.NORMAL.getValue()));
        Map map = (Map)lessonLength.get(courseId);
        if (orgCourse.getChargeUnit().intValue() == ChargeUnit.BY_HOUR.getCode()) {
            courseDto.setScheduleLessons(map != null ? this.intSum(map.values()) : 0);
        } else {
            courseDto.setScheduleLessons(lessonCount == null ? 0 : lessonCount);
        }
        List students = this.courseStudentService.getCourseStudentsBase(orgId, courseId);
        courseDto.setStudents(students);
        List teachers = courseInfo.getTeachers();
        ArrayList teacherList = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty((Collection)teachers)) {
            for (TeacherResponseDto teacher : teachers) {
                PersonBaseDto teacherDto = new PersonBaseDto();
                teacherDto.setId(teacher.getTeacherId());
                teacherDto.setName(teacher.getTeacherName());
                teacherDto.setAvatarUrl(teacher.getAvatar());
                teacherList.add(teacherDto);
            }
        }
        courseDto.setCourseTeachers(teacherList);
        if (orgCourse.getCascadeId() == null || orgCourse.getCascadeId() == 0) {
            courseDto.setCascadeId(0L);
            courseDto.setCascadeName(orgInfo.getContacts());
        } else if (orgCourse.getCascadeId() == -1) {
            courseDto.setCascadeId(-1L);
        } else {
            TXCascadeAccount cascadeAccount = this.cascadeAccountDao.getByIdAndOrgId(orgCourse.getCascadeId(), Integer.valueOf(orgId.intValue()), new String[0]);
            if (cascadeAccount == null) {
                courseDto.setCascadeId(0L);
                courseDto.setCascadeName(orgInfo.getContacts());
            } else if (cascadeAccount.getCredentialId() != null && cascadeAccount.getCredentialId() > 0) {
                TXCascadeCredential cascadeCredential = this.credentialDao.getTXCascadeCredentialByCredentialId(cascadeAccount.getCredentialId());
                courseDto.setCascadeId(cascadeAccount.getId().longValue());
                if (cascadeCredential != null) {
                    courseDto.setCascadeName(cascadeCredential.getName());
                    if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{cascadeCredential.getAvatar()})) {
                        courseDto.setCascadeAvatarUrl(cascadeCredential.getAvatar());
                    } else {
                        courseDto.setCascadeAvatarUrl("https://imgs.genshuixue.com/21565943_l6z55rbz.png");
                    }
                }
            }
        }
        return courseDto;
    }

    @Override
    public void exportCourseInfo(HttpServletRequest request, HttpServletResponse response, Long orgId, Long courseId) {
        Preconditions.checkArgument((orgId != null && orgId > 0L ? 1 : 0) != 0, (Object)"illegal orgId");
        Preconditions.checkArgument((courseId != null && courseId > 0L ? 1 : 0) != 0, (Object)"illegal courseId");
        OrgCourse course = (OrgCourse)this.orgCourseDao.getById((Serializable)courseId, new String[0]);
        if (course == null || course.getIsDel().intValue() == DeleteStatus.DELETED.getValue()) {
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u8bfe\u7a0b\u4e0d\u5b58\u5728\u6216\u5df2\u88ab\u5220\u9664!");
        }
        ExportCourseInfoDto data = this.getExportCourseInfo(orgId, course);
        this.export(request, response, data);
    }

    private ExportCourseInfoDto getExportCourseInfo(Long orgId, OrgCourse course) {
        CommonInfoTipsDto classRoomDto;
        ExportCourseInfoDto data = new ExportCourseInfoDto();
        data.setCourseId(course.getId());
        data.setCourseName(course.getName());
        data.setCourseType(course.getCourseType() == CourseTypeEnum.COURSE_TYPE_CLASS.getCode() ? CourseTypeEnum.COURSE_TYPE_CLASS.getMsg() : CourseTypeEnum.COURSE_TYPE_1v1.getMsg());
        CommonInfoTipsDto teacherDto = this.getCourseTeacherTips(orgId, course.getId());
        if (teacherDto != null && !CollectionUtils.isEmpty(teacherDto.getNames())) {
            data.setTeachers(StringUtils.join(teacherDto.getNames(), (String)","));
        }
        if ((classRoomDto = this.getCourseRoomTips(orgId, course.getId())) != null && !CollectionUtils.isEmpty(classRoomDto.getNames())) {
            data.setClassRooms(StringUtils.join(classRoomDto.getNames(), (String)","));
        }
        List<CourseStudent> courseStudents = this.getCourseStudents(orgId, course.getId());
        data.setStudentList(courseStudents);
        data.setStudentCount(CollectionUtils.isEmpty(courseStudents) ? 0 : courseStudents.size());
        data.setChargeUnit(course.getChargeUnit());
        return data;
    }

    private List<CourseStudent> getCourseStudents(Long orgId, Long courseId) {
        Preconditions.checkArgument((orgId != null && orgId > 0L ? 1 : 0) != 0, (Object)"orgId is illegal");
        Preconditions.checkArgument((courseId != null && courseId > 0L ? 1 : 0) != 0, (Object)"courseId is illegal");
        ArrayList<CourseStudent> result = new ArrayList<CourseStudent>();
        List courseStudents = this.orgStudentCourseDao.getStudentListByCourseId(orgId, courseId, new String[0]);
        if (CollectionUtils.isEmpty((Collection)courseStudents)) {
            return result;
        }
        ArrayList normalStudents = Lists.newArrayList();
        for (OrgStudentCourse orgStudentCourse : courseStudents) {
            if (orgStudentCourse.getStatus() != 0) continue;
            normalStudents.add(orgStudentCourse.getUserId());
        }
        if (CollectionUtils.isEmpty((Collection)normalStudents)) {
            return result;
        }
        List orgStudents = this.orgStudentDao.getStudents(orgId, (List)normalStudents, "", Integer.valueOf(DeleteStatus.NORMAL.getValue()), null, new String[]{"id", "name", "userId", "mobile"});
        if (CollectionUtils.isNotEmpty((Collection)orgStudents)) {
            Set queryStudents = BaseUtils.getPropertiesList((List)orgStudents, (String)"userId");
            Map statMap = this.kexiaoApiService.queryKexiaoStatByClassIdAndUserIds(orgId.longValue(), courseId.longValue(), (Collection)queryStudents);
            for (OrgStudent orgStudent : orgStudents) {
                KexiaoStatistics stat = (KexiaoStatistics)statMap.get(orgStudent.getUserId());
                CourseStudent dto = new CourseStudent();
                dto.setStudentId(orgStudent.getId());
                dto.setStudentName(orgStudent.getName());
                dto.setMobile(orgStudent.getMobile());
                if (stat != null) {
                    dto.setTotalLessons((int)stat.getArrangeNumber());
                    dto.setLeftLessons((int)stat.getLeftNumber());
                    dto.setFinishLessons((int)stat.getKexiaoNumber());
                }
                result.add(dto);
            }
        }
        return result;
    }

    private void export(HttpServletRequest request, HttpServletResponse response, ExportCourseInfoDto data) {
        String fileName = data.getCourseName() + "-\u73ed\u7ea7\u5bfc\u51fa\u4fe1\u606f.xlsx";
        SXSSFWorkbook workbook = null;
        try {
            workbook = new SXSSFWorkbook(200);
            HashMap<String, CellStyle> cellStyleMap = new HashMap<String, CellStyle>();
            ArrayList exportFields = Lists.newArrayList();
            List<String> exportHeader = null;
            exportHeader = ChargeUnit.isByTime((int)data.getChargeUnit()) ? hourExportHeader : timeExportHeader;
            for (String header : exportHeader) {
                exportFields.add(new ExportField(header, "@", 5120));
            }
            ExcelCourseExportService.createCourseSheet((Workbook)workbook, "\u73ed\u7ea7\u4fe1\u606f", cellStyleMap, exportFields, data);
            ExcelCourseExportService.exportExcel(request, response, (Workbook)workbook, fileName);
            log.debug("export course info success");
        }
        catch (Exception e) {
            log.error("export course info catch exception:", (Throwable)e);
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u5bfc\u51fa\u6570\u636e\u5904\u7406\u5f02\u5e38");
        }
        finally {
            try {
                workbook.close();
            }
            catch (IOException var19) {
                log.error("close workbook catch error:", (Throwable)var19);
            }
        }
    }
}

