/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.biz.erp.dto.response.exportCourse;

import com.baijia.tianxiao.dal.enums.CourseTypeEnum;
import com.baijia.tianxiao.util.date.DateUtil;
import java.util.Date;

public class LessonScheduleDto {
    private Long lessonId;
    private Long courseId;
    private Long start;
    private Long end;
    private String courseName;
    private String teacherName;
    private String timeRange;
    private String classRoom;
    private String studentCount;

    public void setCourseName(String courseName, int courseType) {
        this.courseName = courseName + " (" + (CourseTypeEnum.COURSE_TYPE_CLASS.getCode() == courseType ? CourseTypeEnum.COURSE_TYPE_CLASS.getMsg() : CourseTypeEnum.COURSE_TYPE_1v1.getMsg()) + ")";
    }

    public void setTeacherName(String teacherName) {
        this.teacherName = "\u8001\u5e08: " + teacherName;
    }

    public void setClassRoom(String classRoom) {
        this.classRoom = classRoom + "\u6559\u5ba4";
    }

    public void setStudentCount(int count) {
        this.studentCount = "\u5b66\u751f\u4eba\u6570: " + count + "\u4eba";
    }

    public void setTimeRange(Long start, Long end) {
        if (start != null && end != null) {
            this.timeRange = DateUtil.getStrByDateFormate((Date)new Date(start), (String)"HH:mm") + " ~ " + DateUtil.getStrByDateFormate((Date)new Date(end), (String)"HH:mm");
        }
    }

    public String getScheduleContent() {
        return this.courseName + System.lineSeparator() + this.teacherName + System.lineSeparator() + this.timeRange + System.lineSeparator() + this.classRoom + System.lineSeparator() + this.studentCount;
    }

    public static void main(String[] args) {
        LessonScheduleDto dto = new LessonScheduleDto();
        dto.setCourseName("\u8bfe\u7a0b\u4e00", 1);
        dto.setTeacherName("\u5f20\u8001\u5e08");
        dto.setTimeRange(1480262400545L, 1480262400700L);
        dto.setClassRoom("'\u6559\u5ba4\u4e00");
        dto.setStudentCount(3);
        System.out.println(dto.getScheduleContent());
    }

    public Long getLessonId() {
        return this.lessonId;
    }

    public void setLessonId(Long lessonId) {
        this.lessonId = lessonId;
    }

    public Long getCourseId() {
        return this.courseId;
    }

    public void setCourseId(Long courseId) {
        this.courseId = courseId;
    }

    public Long getStart() {
        return this.start;
    }

    public void setStart(Long start) {
        this.start = start;
    }

    public Long getEnd() {
        return this.end;
    }

    public void setEnd(Long end) {
        this.end = end;
    }

    public String getCourseName() {
        return this.courseName;
    }

    public String getTeacherName() {
        return this.teacherName;
    }

    public String getTimeRange() {
        return this.timeRange;
    }

    public String getClassRoom() {
        return this.classRoom;
    }

    public String getStudentCount() {
        return this.studentCount;
    }
}

