package com.baijia.tianxiao.biz.erp.sync.impl;

import com.baijia.tianxiao.biz.erp.service.CourseClassService;
import com.baijia.tianxiao.biz.erp.sync.SyncPayService;
import com.baijia.tianxiao.consants.DataStatus;
import com.baijia.tianxiao.consants.UserRole;
import com.baijia.tianxiao.constant.StudentFiannceOpType;
import com.baijia.tianxiao.constants.sms.SmsMessageType;
import com.baijia.tianxiao.dal.constant.ChargeUnit;
import com.baijia.tianxiao.dal.enums.CourseTypeEnum;
import com.baijia.tianxiao.dal.org.constant.DeleteStatus;
import com.baijia.tianxiao.dal.org.dao.OrgCourseDao;
import com.baijia.tianxiao.dal.org.dao.OrgInfoDao;
import com.baijia.tianxiao.dal.org.dao.OrgStudentCourseDao;
import com.baijia.tianxiao.dal.org.dao.OrgStudentDao;
import com.baijia.tianxiao.dal.org.po.*;
import com.baijia.tianxiao.dal.signup.constant.SignupCourseStatus;
import com.baijia.tianxiao.dal.signup.constant.TransferClassOrder;
import com.baijia.tianxiao.dal.signup.dao.OrgSignupCourseDao;
import com.baijia.tianxiao.dal.signup.dao.OrgSignupInfoDao;
import com.baijia.tianxiao.dal.signup.po.OrgSignupCourse;
import com.baijia.tianxiao.dal.signup.po.OrgSignupInfo;
import com.baijia.tianxiao.enums.StudentCourseStatus;
import com.baijia.tianxiao.sal.common.api.TXStudentCommentAPIService;
import com.baijia.tianxiao.sal.organization.org.service.TXAccountService;
import com.baijia.tianxiao.sal.organization.org.service.TXSaleClueRuleService;
import com.baijia.tianxiao.sal.signup.constants.SignupSourceType;
import com.baijia.tianxiao.sal.signup.service.TransferClassInfoService;
import com.baijia.tianxiao.sal.signup.service.TxStudentFinanceAccountService;
import com.baijia.tianxiao.util.GenericsUtils;
import com.baijia.tianxiao.util.SmsSendUtil;
import com.baijia.tianxiao.util.collection.CollectorUtil;
import com.google.common.base.Function;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import lombok.NonNull;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.Date;
import java.util.List;
import java.util.Map;

/**
 * Created with IntelliJ IDEA.
 * User: Victor Weng
 * Date: 16/9/23
 * Time: 上午11:28
 * To change this template use File | Settings | File Templates.
 */
@Service("syncSignupSuccessAndSyncFail")
@Slf4j
public class SyncSignupSuccessAndSyncFail implements SyncPayService {


    String SIGNUP_SMS_CONTENT_TEMPLATE = "您已成功在%s报名了课程%s!";

    @Resource
    private OrgSignupInfoDao orgSignupInfoDao;

    @Resource
    private OrgSignupCourseDao orgSignupCourseDao;

    @Resource
    private OrgCourseDao orgCourseDao;

    @Resource
    private OrgInfoDao orgInfoDao;

    @Resource
    private OrgStudentDao orgStudentDao;

    @Resource
    private TXSaleClueRuleService tXSaleClueRuleService;

    @Resource
    private TransferClassInfoService transferClassInfoService;

    @Resource
    private TXAccountService txAccountService;

    @Autowired
    private TXStudentCommentAPIService txStudentCommentAPIService;

    @Resource
    private TxStudentFinanceAccountService txStudentFinanceAccountService;


    @Override
    public void sync() {

        try {
            List<OrgSignupInfo> syncSignupInfoList = orgSignupInfoDao.getSignupSuccessAndNotSync();
            log.info("SyncSignupSuccessAndSyncFail  syncSignupInfoList=={}", syncSignupInfoList);
            if (CollectionUtils.isNotEmpty(syncSignupInfoList)) {
                for (OrgSignupInfo signupInfo : syncSignupInfoList) {
                    List<OrgSignupCourse> signupCourses = orgSignupCourseDao.loadByPurchaseId(signupInfo.getSignupPurchaseId());
                    if (CollectionUtils.isEmpty(signupCourses)) {
                        continue;
                    }
                    signupInfo.setOrgSignupCourses(signupCourses);


                    if (signupInfo.getTransferClassOrder().intValue() == TransferClassOrder.TRANSFER_ORDER.getCode()) {
                        transferClassInfoService.confirmTransferClass(signupInfo.getSignupPurchaseId());
                    }

                    Map<Long, OrgSignupCourse> courseMap =
                            CollectorUtil.collectMap(signupCourses, new Function<OrgSignupCourse, Long>() {
                                @Override
                                public Long apply(OrgSignupCourse orgSignupCourse) {
                                    return orgSignupCourse.getOrgCourseId();
                                }
                            });
                    StringBuilder sb = new StringBuilder();
                    List<String> names = Lists.newArrayList();

                    List<OrgCourse> courseList = orgCourseDao.getByIds(courseMap.keySet());
                    for (int i = 0; i < courseList.size(); i++) {
                        OrgCourse tempCourse = courseList.get(i);
                        sb.append("“" + tempCourse.getName() + "“");
                        names.add(tempCourse.getName());
                        if (i < courseList.size() - 1) {
                            sb.append("、");
                        }

                        //课消预发布版本兼容线上，修改合同课次lesson_count = count where lesson_count=0
                        if (tempCourse.getCourseType().intValue() == CourseTypeEnum.COURSE_TYPE_1v1.getCode().intValue()) {
                            orgSignupCourseDao.updateLessonCountByPurchaseId(signupInfo.getSignupPurchaseId(), tempCourse.getId());
                        }
                    }


                    // 如果课程已经修改收费方式，支付完成后自动补信息
                    updateSignupCourseCharge(courseList, courseMap);

                    Map<Long, OrgCourse> courseMap_ = GenericsUtils.toFieldMap(courseList, "id");
                    log.info("courseMap_ is :{} ", courseMap_);
                    OrgSignupInfo orgSignupInfo = signupInfo;
                    Map<Long, OrgSignupCourse> orgSignupCourseMap = Maps.newHashMap();
                    Map<Long, OrgCourse> orgCourseMap = Maps.newHashMap();
                    if (CollectionUtils.isNotEmpty(signupCourses)) {
                        for (OrgSignupCourse orgSignupCourse : signupCourses) {
                            orgCourseMap.put(orgSignupCourse.getOrgCourseId(),
                                    courseMap_.get(orgSignupCourse.getOrgCourseId()));
                            orgSignupCourseMap.put(orgSignupCourse.getOrgCourseId(), orgSignupCourse);
                        }
                    }
                    // 记录跟进记录
                    txStudentCommentAPIService.saveBySignUpPurchase(orgSignupInfo, orgSignupCourseMap, orgCourseMap);

                    Integer orgId = signupInfo.getOrgId().intValue();
                    OrgInfo orginfo = orgInfoDao.getOrgInfo(orgId, "shortname");
                    log.info("SignupInfoSmsProcessor :orgsignupInfo={}", signupInfo);


                    /**
                     * 修改为支付成功
                     */
                    orgSignupCourseDao.updateStatusByPurchaseId(signupInfo.getSignupPurchaseId(), SignupCourseStatus.HAS_PAY.getCode());

                    if (signupInfo.getStudentPayPrice().longValue() > 0) {
                        OrgStudent orgStudent = orgStudentDao.getStudent(orgId.longValue(), signupInfo.getUserId(),
                                DataStatus.NORMAL.getValue());
                        if (orgStudent != null) {
                            txStudentFinanceAccountService.changeStudentFiannceAccount(orgId.longValue(), -1,
                                    orgStudent.getId(), StudentFiannceOpType.PAY_SUCCESS, signupInfo.getStudentPayPrice(),
                                    "支付成功", "");
                        }
                    }

                    TXSaleClueRule txSaleClueRule = tXSaleClueRuleService.getByOrgId(orgId);
                    // 机构是否报名发短信设置设置
                    if (txSaleClueRule != null && txSaleClueRule.getSignupMsg() != null
                            && txSaleClueRule.getSignupMsg().intValue() == 0) {
                        SmsSendUtil.sendSms(signupInfo.getMobile(),
                                String.format(SIGNUP_SMS_CONTENT_TEMPLATE, orginfo.getShortName(), sb.toString()),
                                SmsMessageType.TIANXIAO_NOTIFY.getCode(), orgId, UserRole.ORGANIZATION.getRole(), true,
                                txAccountService.getTxAccountSmsGate(orgId));
                    }

                    if (signupInfo != null) {
                        signupInfo.setSmsSend(1);// 已发送
                        log.info("sms before orgsignupinfo = {},result={}", signupInfo,
                                signupInfo.getSourceType().intValue() != SignupSourceType.TUIGUANG.getCode());

                        orgSignupInfoDao.update(signupInfo);

                    }
                }
            }
        } catch (Exception e) {
            log.warn("sy signup sms fail {}", e);
        }
    }

    private void updateSignupCourseCharge(List<OrgCourse> courseList, Map<Long, OrgSignupCourse> signupCourseMap) {
        for (OrgCourse orgCourse : courseList) {
            OrgSignupCourse orgSignupCourse = signupCourseMap.get(orgCourse.getId());
            if (orgSignupCourse.getChargeUnit() == ChargeUnit.BY_OTHER.getCode()
                    && orgCourse.getChargeUnit() != ChargeUnit.BY_OTHER.getCode()) {
                orgSignupCourseDao.update(orgSignupCourse, "chargeUnit");
            }
        }
    }

}
