package com.baijia.tianxiao.biz.erp.service.impl;


import com.baijia.tianxiao.biz.erp.service.FinanceDataService;
import com.baijia.tianxiao.dal.org.dao.OrgFinanceAccountRecordDao;
import com.baijia.tianxiao.dal.signup.dao.OrgSignupInfoDao;
import com.baijia.tianxiao.dal.statistic.dao.TxSignupRecordDayDao;
import com.baijia.tianxiao.dal.statistic.po.TxSignupRecordDay;
import com.baijia.tianxiao.sal.organization.finance.constant.FinanceOpTo;
import com.baijia.tianxiao.sal.signup.constants.SignupSourceType;
import com.baijia.tianxiao.util.date.DateUtil;
import com.google.common.collect.Lists;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.List;

@Slf4j
@Service
public class FinanceDataServiceImpl implements FinanceDataService {

    @Resource
    private TxSignupRecordDayDao txSignupRecordDayDao;

    @Resource
    private OrgSignupInfoDao orgSignupInfoDao;

    @Resource
    private OrgFinanceAccountRecordDao orgFinanceAccountRecordDao;

    @Override
    public List<TxSignupRecordDay> checkErrorSignupData() {
        Integer maxId = txSignupRecordDayDao.maxSignupRecordId();
        log.info("finance data get Error signup record = {}", maxId);
        List<TxSignupRecordDay> result = Lists.newArrayList();

        long recordId = INIT_SIGNUP_RECORED;
        while (recordId < maxId) {
            List<TxSignupRecordDay> txSignupRecordDayList =
                    txSignupRecordDayDao.getTxSignupRecordListByMinId(recordId, null, 100);
            for (TxSignupRecordDay txSignupRecordDay : txSignupRecordDayList) {
                recordId = txSignupRecordDay.getId();
                if (txSignupRecordDay.getOpTo() == FinanceOpTo.EXPEND.getCode()) {
                    continue;
                }
                Long dateSignupDayPrice = txSignupRecordDayDao.getSignupPriceByDay(txSignupRecordDay.getOrgId(), DateUtil.getStrByDate(txSignupRecordDay.getMdate()), txSignupRecordDay.getOpType());

                Long dateSignupPrice = orgSignupInfoDao.getSignupPriceByDay(txSignupRecordDay.getOrgId(), DateUtil.getStrByDate(txSignupRecordDay.getMdate()), txSignupRecordDay.getOpType());

                log.info("finance data checkout error signup data :{},{},{}", txSignupRecordDay, dateSignupPrice == null ? 0 : dateSignupPrice.longValue(), dateSignupDayPrice);

                if (dateSignupPrice == null || dateSignupPrice.longValue() != dateSignupDayPrice) {
                    result.add(txSignupRecordDay);
                }
            }
        }
        return result;
    }


    @Override
    public void dealErrorSignuoData(Long orgId, String mdate) {
        for (SignupSourceType signupSourceType : SignupSourceType.values()) {
            Long dateSignupPrice = orgSignupInfoDao.getSignupPriceByDay(orgId, mdate, signupSourceType.getCode());
            Integer numSignupPrice = orgSignupInfoDao.countSignupPriceByDay(orgId, mdate, signupSourceType.getCode());
            if (dateSignupPrice != null && numSignupPrice != null && dateSignupPrice.longValue() > 0 && numSignupPrice.intValue() > 0) {
                TxSignupRecordDay txSignupRecordDay = txSignupRecordDayDao.getByDayType(orgId, mdate, signupSourceType.getCode(), FinanceOpTo.INCOME.getCode());
                if (txSignupRecordDay != null) {
                    txSignupRecordDay.setOpPrice(dateSignupPrice.doubleValue() / 100);
                    txSignupRecordDay.setOpCount(numSignupPrice);
                    log.info("deal error signup data from {},{},{},to=={}", orgId, mdate, signupSourceType.getCode(), txSignupRecordDay);
                    txSignupRecordDayDao.update(txSignupRecordDay, "opPrice", "opCount");
                }
            }
        }

    }


    @Override
    public List<TxSignupRecordDay> checkErrorFianaceInfo() {
        Integer maxId = orgFinanceAccountRecordDao.maxFinanceInfoRecordId();
        log.info("finance data get Error finance info = {}", maxId);
        List<TxSignupRecordDay> result = Lists.newArrayList();

        long recordId = INIT_FINANCE_RECORED;
        while (recordId < maxId) {
            List<TxSignupRecordDay> txSignupRecordDayList =
                    txSignupRecordDayDao.getTxSignupRecordListByMinId(recordId, null, 100);
            for (TxSignupRecordDay txSignupRecordDay : txSignupRecordDayList) {
                recordId = txSignupRecordDay.getId();
                if (txSignupRecordDay.getOpTo() == FinanceOpTo.EXPEND.getCode()) {
                    continue;
                }
                Long dateSignupDayPrice = txSignupRecordDayDao.getSignupPriceByDay(txSignupRecordDay.getOrgId(), DateUtil.getStrByDate(txSignupRecordDay.getMdate()), txSignupRecordDay.getOpType());

                Long dateSignupPrice = orgSignupInfoDao.getSignupPriceByDay(txSignupRecordDay.getOrgId(), DateUtil.getStrByDate(txSignupRecordDay.getMdate()), txSignupRecordDay.getOpType());

                log.info("finance data checkout error signup data :{},{},{}", txSignupRecordDay, dateSignupPrice == null ? 0 : dateSignupPrice.longValue(), dateSignupDayPrice);

                if (dateSignupPrice == null || dateSignupPrice.longValue() != dateSignupDayPrice) {
                    result.add(txSignupRecordDay);
                }
            }
        }
        return result;
    }


    @Override
    public void dealErrorFinanceInfo(Long orgId, String mdate) {
        for (SignupSourceType signupSourceType : SignupSourceType.values()) {
            Long dateSignupPrice = orgSignupInfoDao.getSignupPriceByDay(orgId, mdate, signupSourceType.getCode());
            Integer numSignupPrice = orgSignupInfoDao.countSignupPriceByDay(orgId, mdate, signupSourceType.getCode());
            if (dateSignupPrice != null && numSignupPrice != null && dateSignupPrice.longValue() > 0 && numSignupPrice.intValue() > 0) {
                TxSignupRecordDay txSignupRecordDay = txSignupRecordDayDao.getByDayType(orgId, mdate, signupSourceType.getCode(), FinanceOpTo.INCOME.getCode());
                if (txSignupRecordDay != null) {
                    txSignupRecordDay.setOpPrice(dateSignupPrice.doubleValue() / 100);
                    txSignupRecordDay.setOpCount(numSignupPrice);
                    log.info("deal error signup data from {},{},{},to=={}", orgId, mdate, signupSourceType.getCode(), txSignupRecordDay);
                    txSignupRecordDayDao.update(txSignupRecordDay, "opPrice", "opCount");
                }
            }
        }

    }
}
