package com.baijia.tianxiao.biz.erp.service.impl;

import com.baijia.tianxiao.biz.erp.service.DealErpData;
import com.baijia.tianxiao.dal.org.dao.*;
import com.baijia.tianxiao.dal.org.po.*;
import com.baijia.tianxiao.dal.signup.constant.SignupCourseStatus;
import com.baijia.tianxiao.dal.signup.dao.OrgSignupCourseDao;
import com.baijia.tianxiao.dal.signup.po.OrgSignupCourse;
import com.baijia.tianxiao.util.BaseUtils;
import com.google.common.collect.Sets;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Map;
import java.util.Set;

/**
 * Created by wengshengli on 2017/4/5.
 */
@Service
@Slf4j
public class DealErpDataImpl implements DealErpData {

    @Autowired
    private OrgCourseStudentOpDao orgCourseStudentOpDao;

    @Autowired
    private OrgStudentDao orgStudentDao;

    @Autowired
    private OrgCourseDao orgCourseDao;

    @Autowired
    private OrgStudentCourseDao orgStudentCourseDao;

    @Autowired
    private OrgSignupCourseDao orgSignupCourseDao;

    @Autowired
    private OrgLessonSignDao orgLessonSignDao;


    @Override
    public void checkQuitButSignin(Long orgId) {
        List<OrgCourseStudentOp> opslist = orgCourseStudentOpDao.listByOrgId(orgId);
        Set<Long> studentIds = BaseUtils.getPropertiesList(opslist, "studentId");
        Set<Long> courseIds = BaseUtils.getPropertiesList(opslist, "fromCourseId");

        List<OrgStudent> studentList = orgStudentDao.getByIds(studentIds);
        List<OrgCourse> courseList = orgCourseDao.getByIds(courseIds);

        Map<Long, OrgStudent> studentMap = BaseUtils.listToMap(studentList, "id");
        Map<Long, OrgCourse> courseMap = BaseUtils.listToMap(courseList, "id");

        Set<String> hasDeal = Sets.newHashSet();

        if (CollectionUtils.isNotEmpty(opslist)) {
            for (OrgCourseStudentOp orgCourseStudentOp : opslist) {
                OrgCourse orgCourse = courseMap.get(orgCourseStudentOp.getFromCourseId().longValue());
                if (orgCourse != null) {
                    OrgStudent orgStudent = studentMap.get(orgCourseStudentOp.getStudentId().longValue());
                    if (orgStudent != null) {
                        List<OrgLessonSign> lessonSigns = orgLessonSignDao.listByUserClass(orgStudent.getOrgId(), orgStudent.getUserId(), orgCourse.getId(), orgCourseStudentOp.getCreateTime());
                        if (CollectionUtils.isNotEmpty(lessonSigns) && lessonSigns.size() > 0) {
                            OrgStudentCourse studentCourse = orgStudentCourseDao.getStudentCourse(orgStudent.getOrgId(), orgCourse.getId(), orgStudent.getUserId());
                            if (studentCourse != null && studentCourse.getStatus().intValue() != 0) {
                                String key = studentCourse.getCourseId() + "_" + studentCourse.getUserId();
                                if (!hasDeal.contains(key)) {
                                    log.info("checkQuitButSignin student course = {}", studentCourse);
                                    studentCourse.setStatus(0);
                                    hasDeal.add(key);
                                    //orgStudentCourseDao.update(studentCourse, "status");
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    @Override
    public void changeErpStudentCourseStatus(Long orgId) {

        List<OrgCourseStudentOp> opslist = orgCourseStudentOpDao.listByOrgId(orgId);
        Set<Long> studentIds = BaseUtils.getPropertiesList(opslist, "studentId");
        Set<Long> courseIds = BaseUtils.getPropertiesList(opslist, "fromCourseId");

        List<OrgStudent> studentList = orgStudentDao.getByIds(studentIds);
        List<OrgCourse> courseList = orgCourseDao.getByIds(courseIds);

        Map<Long, OrgStudent> studentMap = BaseUtils.listToMap(studentList, "id");
        Map<Long, OrgCourse> courseMap = BaseUtils.listToMap(courseList, "id");

        if (CollectionUtils.isNotEmpty(opslist)) {
            for (OrgCourseStudentOp orgCourseStudentOp : opslist) {
                OrgCourse orgCourse = courseMap.get(orgCourseStudentOp.getFromCourseId().longValue());
                if (orgCourse != null) {
                    if (orgCourse.getParentId().longValue() != 0) {
                        orgCourse = orgCourseDao.getByCourseId(orgCourse.getParentId());
                    }
                    OrgStudent orgStudent = studentMap.get(orgCourseStudentOp.getStudentId().longValue());
                    if (orgStudent != null) {
                        List<OrgSignupCourse> signupCourseList = orgSignupCourseDao.getByCourseIdAndStudentId(orgCourseStudentOp.getOrgId(), orgStudent.getUserId(), orgCourse.getId(), null);
                        if (CollectionUtils.isNotEmpty(signupCourseList) && signupCourseList.size() == 1 && !SignupCourseStatus.statusInQuitCourse(signupCourseList.get(0).getStatus().intValue())) {
                            OrgStudentCourse studentCourse = orgStudentCourseDao.getStudentCourse(signupCourseList.get(0).getOrgId(), signupCourseList.get(0).getOrgCourseId(), signupCourseList.get(0).getUserId());
                            if (studentCourse != null && studentCourse.getStatus().intValue() == 0) {
                                log.info("changeErpStudentCourseStatus student course = {}", studentCourse);
                                studentCourse.setStatus(orgCourseStudentOp.getStatus());
                                //orgStudentCourseDao.update(studentCourse, "status");
                            }
                        }
                    }
                }
            }
        }
    }
}
