/**
 * Baijiahulian.com Inc. Copyright (c) 2014-2015 All Rights Reserved.
 */

package com.baijia.tianxiao.biz.erp.dto.response;

import com.baijia.tianxiao.annotation.Show;
import com.baijia.tianxiao.constants.TianXiaoConstant;
import com.baijia.tianxiao.dal.constant.ChargeUnit;
import lombok.Data;
import org.apache.commons.lang3.StringUtils;

import java.util.Date;

/**
 * @author zhangrui
 * @version 1.0
 */
@Data
public class ClassListInfoDtoForVip {

    private String color; // 颜色

    private Long orgCourseId; // 课程ID

    private Long courseId; // 课程ID

    public void setOrgCourseId(Long orgCourseId) {
        this.orgCourseId = orgCourseId;
        this.courseId = orgCourseId;
    }

    private Long orgCourseNumber; // 课程number

    private String courseUrl; // 课程url

    public void setCoverUrl(String coverUrl) {
        if (StringUtils.isBlank(coverUrl)) {
            this.coverUrl = TianXiaoConstant.DEFAULT_CLASS_COVER;
        } else {
            this.coverUrl = coverUrl;
        }
    }

    @Show(name = "封面", lock = 1, operate = 0)
    private String coverUrl; // 课程url

    @Show(name = "班级名称", poName = "className", operate = 0)
    private String className;

    @Show(name = "购买数量", type = 1, poName = "freq")
    private Integer buyLessonCount;

    @Show(name = "添加时间", poName = "createTime", type = 2)
    private Date createTime;// 添加时间

    @Show(name = "单价", type = 1, poName = "price")
    private Double oneLessonPrice;
    
    @Show(name = "计费单位", poName = "chargeUnit")
    private Integer chargeUnit = ChargeUnit.BY_TIMES.getCode(); // 计费单位
    
    // @Show(name = "缴费总额", type = 1)
    // private Double totalPrice;

    @Show(name = "老师", operate = 0)
    private String teacherNames;

    private Integer courseType;

    private Integer cascadeId;

    @Show(name = "班主任", poName = "cascadeId")
    private String cascadeIdStr;


}
