package com.baijia.tianxiao.biz.erp.dto;

import java.util.List;
import lombok.Data;
import lombok.EqualsAndHashCode;
import com.baijia.tianxiao.dto.IdNameDto;
import com.baijia.tianxiao.dto.PersonBaseDto;
import com.baijia.tianxiao.sal.course.dto.OrgCourseInfoDto;
/**
 * pc-erp课程信息
 * @author wangsixia
 *
 */
@Data
@EqualsAndHashCode(callSuper=false)
public class OrgCourseInfoPcDto extends OrgCourseInfoDto {
    // 班主任id
    private Long cascadeId;
    // 班主任姓名
    private String cascadeName;
    // 班主任头像
    private String cascadeAvatarUrl;
    // 班级教室(resp)
    private List<IdNameDto> rooms;
    // 班级教室(req)
    private String roomIds;
    // 班级学生(resp)
    private List<PersonBaseDto> students;
    // 班级学生(req)
    private String studentIds;
    // 班级老师（resp)，与OrgCourseInfoDto里的teachers意义相同，这里重新封装，用于前端统一处理
    private List<PersonBaseDto> courseTeachers;
    //总课节数
    private Integer totalLessons;
    //已排课次
    private Integer scheduleLessons;
    
    private Integer chargeType;
    private Integer chargeUnit;
}
