/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.biz.erp.kexiao.impl;

import com.baijia.tianxiao.biz.erp.kexiao.KexiaoComputeService;
import com.baijia.tianxiao.constant.KexiaoChangeEvent;
import com.baijia.tianxiao.constant.LessonStatus;
import com.baijia.tianxiao.dal.enums.CourseTypeEnum;
import com.baijia.tianxiao.dal.org.dao.OrgClassLessonDao;
import com.baijia.tianxiao.dal.org.dao.OrgCourseConsumeRuleDao;
import com.baijia.tianxiao.dal.org.dao.OrgCourseDao;
import com.baijia.tianxiao.dal.org.dao.OrgLessonSignDao;
import com.baijia.tianxiao.dal.org.dao.OrgStudentKexiaoRecordDao;
import com.baijia.tianxiao.dal.org.dao.OrgStudentLessonDao;
import com.baijia.tianxiao.dal.org.po.KexiaoChangeLog;
import com.baijia.tianxiao.dal.org.po.OrgClassLesson;
import com.baijia.tianxiao.dal.org.po.OrgCourse;
import com.baijia.tianxiao.dal.org.po.OrgCourseConsumeRule;
import com.baijia.tianxiao.dal.org.po.OrgLessonSign;
import com.baijia.tianxiao.dal.org.po.OrgStudentKexiaoRecord;
import com.baijia.tianxiao.dal.org.po.OrgStudentLesson;
import com.baijia.tianxiao.dal.signup.dao.OrgSignupCourseLessonDao;
import com.baijia.tianxiao.dal.signup.po.OrgSignupCourseLesson;
import com.baijia.tianxiao.sal.course.service.OrgSignupCourseLessonService;
import com.baijia.tianxiao.sal.kexiao.dto.BatchSignInfo;
import com.baijia.tianxiao.sal.kexiao.dto.ClassLessonInfo;
import com.baijia.tianxiao.sal.kexiao.dto.FastSignInfo;
import com.baijia.tianxiao.sal.kexiao.dto.LessonStartInfo;
import com.baijia.tianxiao.sal.kexiao.dto.RuleChangeInfo;
import com.baijia.tianxiao.sal.kexiao.dto.SignUpCourseInfo;
import com.baijia.tianxiao.sal.kexiao.dto.StudentLessonInfo;
import com.baijia.tianxiao.sal.kexiao.utils.KexiaoUtil;
import com.baijia.tianxiao.util.CollectionHelper;
import com.baijia.tianxiao.util.ListUtil;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.gson.Gson;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class KexiaoComputeServiceImpl
implements KexiaoComputeService {
    private static final Logger log = LoggerFactory.getLogger(KexiaoComputeServiceImpl.class);
    @Autowired
    private OrgCourseConsumeRuleDao courseConsumeRuleDao;
    @Autowired
    private OrgStudentKexiaoRecordDao kexiaoRecordDao;
    @Autowired
    private OrgStudentLessonDao studentLessonDao;
    @Autowired
    private OrgClassLessonDao classLessonDao;
    @Autowired
    private OrgSignupCourseLessonDao signupCourseLessonDao;
    @Autowired
    private OrgLessonSignDao lessonSignDao;
    @Autowired
    private OrgCourseDao courseDao;
    @Autowired
    private OrgSignupCourseLessonService signupCourseLessonService;

    @Override
    public void computeKexiao(Long orgId, Collection<KexiaoChangeLog> logs) {
        ArrayList<KexiaoChangeLog> ruleChangeLogs = new ArrayList<KexiaoChangeLog>();
        ArrayList<KexiaoChangeLog> hisCompleteChangeLogs = new ArrayList<KexiaoChangeLog>();
        ArrayList<KexiaoChangeLog> batchSignChangeLogs = new ArrayList<KexiaoChangeLog>();
        ArrayList<KexiaoChangeLog> lessonStartChangeLogs = new ArrayList<KexiaoChangeLog>();
        ArrayList<KexiaoChangeLog> fastSignChangeLogs = new ArrayList<KexiaoChangeLog>();
        ArrayList<KexiaoChangeLog> delLessonChangeLogs = new ArrayList<KexiaoChangeLog>();
        ArrayList<KexiaoChangeLog> delStuLessonChangeLogs = new ArrayList<KexiaoChangeLog>();
        ArrayList<KexiaoChangeLog> cancelSignChangeLogs = new ArrayList<KexiaoChangeLog>();
        ArrayList<KexiaoChangeLog> stuLessonChangeLogs = new ArrayList<KexiaoChangeLog>();
        if (logs != null && logs.size() > 0) {
            block11: for (KexiaoChangeLog changeLog : logs) {
                KexiaoChangeEvent event = KexiaoChangeEvent.getByType((int)changeLog.getEventType());
                switch (event) {
                    case KEXIAO_REUL: {
                        ruleChangeLogs.add(changeLog);
                        continue block11;
                    }
                    case START: {
                        lessonStartChangeLogs.add(changeLog);
                        continue block11;
                    }
                    case ADD_SIGNUP_INFO: {
                        hisCompleteChangeLogs.add(changeLog);
                        continue block11;
                    }
                    case BATCH_SIGN: {
                        batchSignChangeLogs.add(changeLog);
                        continue block11;
                    }
                    case FAST_SIGN: {
                        fastSignChangeLogs.add(changeLog);
                        continue block11;
                    }
                    case DEL_LESSON: {
                        delLessonChangeLogs.add(changeLog);
                        continue block11;
                    }
                    case DEL_STUDENT_LESSON: {
                        delStuLessonChangeLogs.add(changeLog);
                        continue block11;
                    }
                    case CANCEL_SIGN: {
                        cancelSignChangeLogs.add(changeLog);
                        continue block11;
                    }
                    case STUDENT_LESSON_CHANGE: {
                        stuLessonChangeLogs.add(changeLog);
                        continue block11;
                    }
                }
                log.warn("[Kexiao] KexiaoChangeLog={}", (Object)changeLog);
                throw new RuntimeException("KexiaoChangeEvent error");
            }
        }
        if (ruleChangeLogs.size() > 0) {
            this.computeByKexiaoRule(orgId, ruleChangeLogs);
        }
        if (lessonStartChangeLogs.size() > 0) {
            this.computeByStaredTime(orgId, lessonStartChangeLogs);
        }
        if (batchSignChangeLogs.size() > 0) {
            this.computeByBatchSign(orgId, batchSignChangeLogs);
        }
        if (fastSignChangeLogs.size() > 0) {
            this.computeByFastSign(orgId, fastSignChangeLogs);
        }
        if (hisCompleteChangeLogs.size() > 0) {
            this.computeByCompleteSignUpInfo(orgId, hisCompleteChangeLogs);
        }
        if (delLessonChangeLogs.size() > 0) {
            this.deleteByDelLessonIds(orgId, delLessonChangeLogs);
        }
        if (delStuLessonChangeLogs.size() > 0) {
            this.deleteByDelStuLessonIds(orgId, delStuLessonChangeLogs);
        }
        if (cancelSignChangeLogs.size() > 0) {
            this.deleteByCancelSign(orgId, cancelSignChangeLogs);
        }
        if (stuLessonChangeLogs.size() > 0) {
            this.computeByStudentLessons(orgId, (Collection<KexiaoChangeLog>)stuLessonChangeLogs);
        }
    }

    @Transactional
    public void computeByKexiaoRule(Long orgId, Collection<KexiaoChangeLog> logs) {
        log.info("[Kexiao] compute kexiao by rule.orgId={},logs={}", (Object)orgId, logs);
        if (logs != null) {
            Gson gson = new Gson();
            for (KexiaoChangeLog changeLog : logs) {
                OrgClassLesson classLesson;
                RuleChangeInfo ruleChange = (RuleChangeInfo)gson.fromJson(changeLog.getInfo(), RuleChangeInfo.class);
                List classLessons = this.classLessonDao.getLessonByCourseIds(Arrays.asList(ruleChange.getCourseId()), Integer.valueOf(0), new String[0]);
                Map classLessonMap = CollectionHelper.toKeyMap((Collection)classLessons, (String)"id");
                List lessonIds = ListUtil.toKeyList((Collection)classLessons, (String)"id", OrgClassLesson.class);
                List stuLessons = this.studentLessonDao.getOrgStudentLessonsByLessonIds((Collection)lessonIds, new String[0]);
                List userIds = ListUtil.toKeyList((Collection)stuLessons, (String)"userId", OrgStudentLesson.class);
                if (lessonIds.isEmpty() || userIds.isEmpty()) {
                    log.warn("[Kexiao] compute kexiao by rule.orgId={},lessonIds={},userIds={}", new Object[]{orgId, lessonIds, userIds});
                    continue;
                }
                Map signUpLessonsMap = this.signupCourseLessonDao.selectLessonInfoMap(orgId, (Collection)lessonIds, (Collection)userIds);
                List lessonSignList = this.lessonSignDao.getStudentLessonSign(changeLog.getOrgId(), null, (Collection)lessonIds, new String[0]);
                HashMap<String, OrgLessonSign> signMap = new HashMap<String, OrgLessonSign>();
                if (lessonSignList != null) {
                    for (OrgLessonSign sign : lessonSignList) {
                        signMap.put(this.getKey(sign), sign);
                    }
                }
                ArrayList<OrgStudentKexiaoRecord> records = new ArrayList<OrgStudentKexiaoRecord>();
                HashSet<Long> unFinishedLessonIds = new HashSet<Long>();
                if (ruleChange.getRuleValue() == 0) {
                    for (OrgStudentLesson studentLesson : stuLessons) {
                        classLesson = (OrgClassLesson)classLessonMap.get(studentLesson.getLessonId());
                        if (classLesson.getStartTime().compareTo(new Date()) <= 0) {
                            OrgSignupCourseLesson signUpLesson = (OrgSignupCourseLesson)signUpLessonsMap.get(this.getKey(studentLesson));
                            if (signUpLesson == null) {
                                log.info("[Kexiao] Info is not complete.studentLesson={}", (Object)studentLesson);
                                continue;
                            }
                            OrgStudentKexiaoRecord record = this.constructKexiaoRecord(studentLesson, classLesson, signUpLesson, changeLog.getCreateTime());
                            records.add(record);
                            continue;
                        }
                        unFinishedLessonIds.add(studentLesson.getId());
                    }
                } else {
                    for (OrgStudentLesson studentLesson : stuLessons) {
                        classLesson = (OrgClassLesson)classLessonMap.get(studentLesson.getLessonId());
                        OrgLessonSign lessonSign = (OrgLessonSign)signMap.get(this.getKey(studentLesson));
                        LessonStatus status = LessonStatus.UN_START;
                        if (lessonSign != null) {
                            status = KexiaoUtil.getKexiaoStatus((int)lessonSign.getStatus(), (int)ruleChange.getRuleValue());
                        }
                        if (status == LessonStatus.FINISHED) {
                            OrgSignupCourseLesson signUpLesson = (OrgSignupCourseLesson)signUpLessonsMap.get(this.getKey(studentLesson));
                            OrgStudentKexiaoRecord record = this.constructKexiaoRecord(studentLesson, classLesson, signUpLesson, changeLog.getCreateTime());
                            records.add(record);
                            continue;
                        }
                        unFinishedLessonIds.add(studentLesson.getId());
                    }
                }
                HashMap<String, List> condition = new HashMap<String, List>();
                condition.put("studentLessonId", ListUtil.toKeyList((Collection)stuLessons, (String)"id", OrgStudentLesson.class));
                this.kexiaoRecordDao.delByCondition(condition);
                this.kexiaoRecordDao.batchInsertRecords(records);
            }
        }
    }

    @Transactional
    private void computeByBatchSign(Long orgId, Collection<KexiaoChangeLog> logs) {
        log.info("[Kexiao] compute batch sign.orgId={},logs={}", (Object)orgId, logs);
        Gson gson = new Gson();
        for (KexiaoChangeLog changeLog : logs) {
            BatchSignInfo extend = (BatchSignInfo)gson.fromJson(changeLog.getInfo(), BatchSignInfo.class);
            this.computeBySign(this.toFastSign(extend), orgId);
        }
    }

    private FastSignInfo toFastSign(BatchSignInfo batchSign) {
        HashMap<Long, Integer> stuStatus = new HashMap<Long, Integer>();
        for (Long userId : batchSign.getUserIds()) {
            stuStatus.put(userId, batchSign.getStatus());
        }
        return new FastSignInfo(batchSign.getClassLessonIds(), stuStatus);
    }

    @Transactional
    private void computeByFastSign(Long orgId, Collection<KexiaoChangeLog> logs) {
        log.info("[Kexiao] compute fast sign.orgId={},logs={}", (Object)orgId, logs);
        Gson gson = new Gson();
        for (KexiaoChangeLog changeLog : logs) {
            FastSignInfo extend = (FastSignInfo)gson.fromJson(changeLog.getInfo(), FastSignInfo.class);
            this.computeBySign(extend, orgId);
        }
    }

    @Transactional
    private void computeByCompleteSignUpInfo(Long orgId, Collection<KexiaoChangeLog> logs) {
        log.info("[Kexiao] compute complete signup info kexiao.orgId={},logs={}", (Object)orgId, logs);
        Gson gson = new Gson();
        for (KexiaoChangeLog changeLog : logs) {
            SignUpCourseInfo info = (SignUpCourseInfo)gson.fromJson(changeLog.getInfo(), SignUpCourseInfo.class);
            List baseList = info.getSingUpCourseList();
            HashSet<Long> courseIds = new HashSet<Long>();
            HashSet<Long> userIds = new HashSet<Long>();
            for (SignUpCourseInfo.SingUpCourseBase base : baseList) {
                courseIds.add(base.getOrgCourseId());
                userIds.add(base.getUserId());
            }
            List courses = this.courseDao.getByIds(courseIds, new String[]{"id", "parentId", "isCourse", "isClass"});
            List classIds = ListUtil.toKeyList((Collection)courses, (String)"id", OrgCourse.class);
            log.info("[Kexiao] courses={}", (Object)courses);
            List lessons = this.studentLessonDao.getByCourseIdsUserIds(orgId, (Collection)classIds, userIds, new String[0]);
            if (lessons == null || lessons.size() < 1) {
                log.info("[Kexiao] lessons={}", (Object)lessons);
                return;
            }
            HashMap<Long, List> lessonMap = new HashMap<Long, List>();
            HashSet<Long> classLessonIds = new HashSet<Long>();
            for (OrgStudentLesson lesson : lessons) {
                List lessonList = (List)lessonMap.get(lesson.getCourseId());
                if (lessonList == null) {
                    lessonList = Lists.newArrayList();
                    lessonMap.put(lesson.getCourseId(), lessonList);
                }
                lessonList.add(lesson);
                classLessonIds.add(lesson.getLessonId());
            }
            List classLessonList = this.classLessonDao.getByIds(classLessonIds, new String[]{"id", "startTime"});
            final Map classLessonMap = CollectionHelper.toIdMap((Collection)classLessonList);
            Set keySet = lessonMap.keySet();
            Date date = new Date();
            for (Long classId : keySet) {
                List list = (List)lessonMap.get(classId);
                Collections.sort(list, new Comparator<OrgStudentLesson>(){

                    @Override
                    public int compare(OrgStudentLesson o1, OrgStudentLesson o2) {
                        OrgClassLesson lesson1 = (OrgClassLesson)classLessonMap.get(o1.getLessonId());
                        OrgClassLesson lesson2 = (OrgClassLesson)classLessonMap.get(o2.getLessonId());
                        if (lesson1 == null || lesson2 == null) {
                            log.warn("[Kexiao] StudentLesson1={},StudentLesson2={}", (Object)o1, (Object)o2);
                            return -1;
                        }
                        return lesson1.getStartTime().compareTo(lesson2.getStartTime());
                    }
                });
                if (list == null || list.size() <= 0) continue;
                this.signupCourseLessonService.saveSignupCourseLessons(orgId, classId, (Collection)list);
                for (OrgStudentLesson studentLesson : list) {
                    studentLesson.setUpdateTime(date);
                    this.studentLessonDao.update((Object)studentLesson, new String[0]);
                }
            }
        }
    }

    @Transactional
    private void computeBySign(FastSignInfo extend, Long orgId) {
        Collection classLessonIds = extend.getClassLessonIds();
        List studentLessons = this.studentLessonDao.getOrgStudentLessonsByLessonIds(classLessonIds, new String[0]);
        BatchData data = this.getBatchData(orgId, studentLessons);
        ArrayList<OrgStudentKexiaoRecord> records = new ArrayList<OrgStudentKexiaoRecord>();
        HashSet studentLessonIds = Sets.newHashSet();
        for (OrgStudentLesson studentLesson : studentLessons) {
            OrgClassLesson classLesson = data.getClassLesson(studentLesson.getLessonId());
            OrgSignupCourseLesson signUpLesson = data.getSignUpCourseLesson(this.getKey(studentLesson));
            OrgCourseConsumeRule rule = data.getRuleByClassId(classLesson.getCourseId());
            if (signUpLesson == null) {
                log.info("[Kexiao] Info is not complete.studentLesson={}", (Object)studentLesson);
                continue;
            }
            if (rule != null && rule.getRuleValue() > 0) {
                Integer status = (Integer)extend.getStuStatus().get(studentLesson.getUserId());
                if (status == null) continue;
                studentLessonIds.add(studentLesson.getId());
                LessonStatus lessonStatus = KexiaoUtil.getKexiaoStatus((int)status, (int)rule.getRuleValue());
                if (lessonStatus == LessonStatus.FINISHED) {
                    OrgStudentKexiaoRecord record = this.constructKexiaoRecord(studentLesson, classLesson, signUpLesson, classLesson.getStartTime());
                    OrgCourse course = data.getOrgClass(classLesson.getCourseId());
                    record.setCourseType(course.getCourseType());
                    records.add(record);
                    continue;
                }
                log.info("[Kexiao] Not need to compute kexiao.orgId={},ruleId={},value={}", new Object[]{orgId, rule.getId(), status});
                continue;
            }
            log.info("[Kexiao] Rule is not exist.orgId={},courseId={}", (Object)orgId, (Object)classLesson.getCourseId());
        }
        log.info("[Kexiao] compute sign and time kexiao.studentLessonIds={}", (Object)studentLessonIds);
        if (studentLessonIds.size() > 0) {
            HashMap<String, HashSet> condition = new HashMap<String, HashSet>();
            condition.put("studentLessonId", studentLessonIds);
            this.kexiaoRecordDao.delByCondition(condition);
        }
        if (records.size() > 0) {
            this.kexiaoRecordDao.batchInsertRecords(records);
        }
    }

    @Transactional
    public void computeByStaredTime(Long orgId, Collection<KexiaoChangeLog> logs) {
        log.info("[Kexiao] compute by startTime.orgId={},logs={}", (Object)orgId, logs);
        Gson gson = new Gson();
        for (KexiaoChangeLog changeLog : logs) {
            LessonStartInfo extend = (LessonStartInfo)gson.fromJson(changeLog.getInfo(), LessonStartInfo.class);
            HashSet stuLessonIds = new HashSet(extend.getStuLessonIds());
            List studentLessons = this.studentLessonDao.getByIds(stuLessonIds, new String[0]);
            ArrayList<OrgStudentKexiaoRecord> records = new ArrayList<OrgStudentKexiaoRecord>();
            BatchData data = this.getBatchData(orgId, studentLessons);
            HashSet studentLessonIds = Sets.newHashSet();
            for (OrgStudentLesson studentLesson : studentLessons) {
                OrgClassLesson classLesson = data.getClassLesson(studentLesson.getLessonId());
                OrgSignupCourseLesson signUpLesson = data.getSignUpCourseLesson(this.getKey(studentLesson));
                if (signUpLesson == null) {
                    log.info("[Kexiao] Info is not complete.studentLesson={}", (Object)studentLesson);
                    continue;
                }
                OrgCourseConsumeRule rule = data.getRuleByClassId(studentLesson.getCourseId());
                if (rule == null || rule.getRuleValue() == 0) {
                    studentLessonIds.add(studentLesson.getId());
                    if (extend.getStatus() != LessonStatus.FINISHED.getStatus()) continue;
                    OrgStudentKexiaoRecord record = this.constructKexiaoRecord(studentLesson, classLesson, signUpLesson, classLesson.getStartTime());
                    OrgCourse course = data.getOrgClass(classLesson.getCourseId());
                    record.setCourseType(course.getCourseType());
                    records.add(record);
                    continue;
                }
                log.info("[Kexiao] Not need to compute kexiao.orgId={},rule={},value={}", new Object[]{orgId, rule, extend.getStatus()});
            }
            if (studentLessonIds.size() > 0) {
                HashMap<String, HashSet> condition = new HashMap<String, HashSet>();
                condition.put("studentLessonId", studentLessonIds);
                this.kexiaoRecordDao.delByCondition(condition);
            }
            if (records.size() <= 0) continue;
            this.kexiaoRecordDao.batchInsertRecords(records);
        }
    }

    @Transactional
    public void computeByStudentLessons(Long orgId, Collection<KexiaoChangeLog> logs) {
        log.info("[Kexiao] compute by startTime.orgId={},logs={}", (Object)orgId, logs);
        Gson gson = new Gson();
        for (KexiaoChangeLog changeLog : logs) {
            StudentLessonInfo extend = (StudentLessonInfo)gson.fromJson(changeLog.getInfo(), StudentLessonInfo.class);
            HashSet stuLessonIds = new HashSet(extend.getStuLessonIds());
            List studentLessons = this.studentLessonDao.getByIds(stuLessonIds, new String[0]);
            this.computeByStudentLessons(orgId, studentLessons);
        }
    }

    @Transactional
    private void computeByStudentLessons(Long orgId, List<OrgStudentLesson> studentLessons) {
        log.info("[Kexiao] compute by studentLessons.orgId={},studentLessons={}", (Object)orgId, studentLessons);
        ArrayList<OrgStudentKexiaoRecord> records = new ArrayList<OrgStudentKexiaoRecord>();
        BatchData data = this.getBatchData(orgId, studentLessons);
        HashSet studentLessonIds = Sets.newHashSet();
        ArrayList userIds = Lists.newArrayList();
        ArrayList lessonIds = Lists.newArrayList();
        for (OrgStudentLesson studentLesson : studentLessons) {
            userIds.add(studentLesson.getUserId());
            lessonIds.add(studentLesson.getLessonId());
        }
        HashMap<String, OrgLessonSign> signMap = new HashMap<String, OrgLessonSign>();
        List signList = this.lessonSignDao.getByOrgIdCourseIdLessonIdsStudentIds(orgId, null, (List)lessonIds, (List)userIds, new String[0]);
        if (signList != null) {
            for (OrgLessonSign sign : signList) {
                signMap.put(this.getKey(sign), sign);
            }
        }
        for (OrgStudentLesson studentLesson : studentLessons) {
            if (studentLesson.getDelStatus() == 1) {
                studentLessonIds.add(studentLesson.getId());
                continue;
            }
            OrgClassLesson classLesson = data.getClassLesson(studentLesson.getLessonId());
            OrgSignupCourseLesson signUpLesson = data.getSignUpCourseLesson(this.getKey(studentLesson));
            if (signUpLesson == null) {
                log.info("[Kexiao] Info is not complete.studentLesson={}", (Object)studentLesson);
                continue;
            }
            OrgCourseConsumeRule rule = data.getRuleByClassId(studentLesson.getCourseId());
            if (rule == null || rule.getRuleValue() == 0) {
                studentLessonIds.add(studentLesson.getId());
                if (studentLesson.getStartStatus().intValue() != LessonStatus.FINISHED.getStatus()) continue;
                OrgStudentKexiaoRecord record = this.constructKexiaoRecord(studentLesson, classLesson, signUpLesson, classLesson.getStartTime());
                OrgCourse course = data.getOrgClass(classLesson.getCourseId());
                record.setCourseType(course.getCourseType());
                records.add(record);
                continue;
            }
            OrgLessonSign sign = (OrgLessonSign)signMap.get(this.getKey(studentLesson));
            if (sign == null) continue;
            Integer status = sign.getStatus();
            studentLessonIds.add(studentLesson.getId());
            LessonStatus lessonStatus = KexiaoUtil.getKexiaoStatus((int)status, (int)rule.getRuleValue());
            if (lessonStatus == LessonStatus.FINISHED) {
                OrgStudentKexiaoRecord record = this.constructKexiaoRecord(studentLesson, classLesson, signUpLesson, classLesson.getStartTime());
                OrgCourse course = data.getOrgClass(classLesson.getCourseId());
                record.setCourseType(course.getCourseType());
                records.add(record);
                continue;
            }
            log.info("[Kexiao] Not need to compute kexiao.orgId={},ruleId={},value={}", new Object[]{orgId, rule.getId(), status});
        }
        if (studentLessonIds.size() > 0) {
            HashMap<String, HashSet> condition = new HashMap<String, HashSet>();
            condition.put("studentLessonId", studentLessonIds);
            this.kexiaoRecordDao.delByCondition(condition);
        }
        if (records.size() > 0) {
            this.kexiaoRecordDao.batchInsertRecords(records);
        }
    }

    @Transactional
    public void deleteByDelLessonIds(Long orgId, Collection<KexiaoChangeLog> logs) {
        log.info("[Kexiao] compute by startTime.orgId={},logs={}", (Object)orgId, logs);
        Gson gson = new Gson();
        for (KexiaoChangeLog changeLog : logs) {
            ClassLessonInfo info = (ClassLessonInfo)gson.fromJson(changeLog.getInfo(), ClassLessonInfo.class);
            HashMap<String, Collection> condition = new HashMap<String, Collection>();
            condition.put("lessonId", info.getLessonIds());
            this.kexiaoRecordDao.delByCondition(condition);
        }
    }

    @Transactional
    public void deleteByDelStuLessonIds(Long orgId, Collection<KexiaoChangeLog> logs) {
        log.info("[Kexiao] compute by startTime.orgId={},logs={}", (Object)orgId, logs);
        Gson gson = new Gson();
        for (KexiaoChangeLog changeLog : logs) {
            StudentLessonInfo info = (StudentLessonInfo)gson.fromJson(changeLog.getInfo(), StudentLessonInfo.class);
            HashMap<String, Collection> condition = new HashMap<String, Collection>();
            condition.put("studentLessonId", info.getStuLessonIds());
            this.kexiaoRecordDao.delByCondition(condition);
        }
    }

    public void deleteByCancelSign(Long orgId, Collection<KexiaoChangeLog> logs) {
        log.info("[Kexiao] compute by startTime.orgId={},logs={}", (Object)orgId, logs);
        Gson gson = new Gson();
        for (KexiaoChangeLog changeLog : logs) {
            StudentLessonInfo info = (StudentLessonInfo)gson.fromJson(changeLog.getInfo(), StudentLessonInfo.class);
            HashMap<String, Collection> condition = new HashMap<String, Collection>();
            condition.put("studentLessonId", info.getStuLessonIds());
            this.kexiaoRecordDao.delByCondition(condition);
        }
    }

    private OrgStudentKexiaoRecord constructKexiaoRecord(OrgStudentLesson studentLesson, OrgClassLesson classLesson, OrgSignupCourseLesson signUpLesson, Date markTime) {
        OrgStudentKexiaoRecord record = new OrgStudentKexiaoRecord();
        record.setOrgId(studentLesson.getOrgId());
        record.setStudentLessonId(studentLesson.getId());
        record.setCourseId(signUpLesson.getCourseId());
        record.setDelStatus(Integer.valueOf(0));
        record.setLessonId(signUpLesson.getLessonId());
        record.setAmount(signUpLesson.getAmount());
        record.setCreateTime(new Date());
        record.setLessonDuration(signUpLesson.getLessonDuration());
        record.setLessonType(studentLesson.getLessonType());
        record.setMarkTime(markTime);
        record.setStartTime(classLesson.getStartTime());
        record.setUserId(studentLesson.getUserId());
        record.setClassId(signUpLesson.getClassId());
        record.setChargeUnit(signUpLesson.getChargeUnit());
        record.setKexiaoDuration(studentLesson.getKexiaoDuration());
        return record;
    }

    private String getKey(OrgStudentLesson studentLesson) {
        return studentLesson.getUserId() + "_" + studentLesson.getLessonId();
    }

    private String getKey(OrgLessonSign sign) {
        return sign.getUserId() + "_" + sign.getLessonId();
    }

    private BatchData getBatchData(Long orgId, List<OrgStudentLesson> studentLessons) {
        BatchData data = new BatchData();
        if (studentLessons == null || studentLessons.size() < 1) {
            return data;
        }
        HashMap classCourseMap = Maps.newHashMap();
        HashMap classMap = Maps.newHashMap();
        HashSet<Long> classLessonIds = new HashSet<Long>();
        HashSet<Long> userIds = new HashSet<Long>();
        for (OrgStudentLesson studentLesson : studentLessons) {
            classLessonIds.add(studentLesson.getLessonId());
            userIds.add(studentLesson.getUserId());
        }
        List classLessons = this.classLessonDao.getByIds(classLessonIds, new String[0]);
        Map classLessonMap = CollectionHelper.toKeyMap((Collection)classLessons, (String)"id");
        Map signUpLessonsMap = this.signupCourseLessonDao.selectLessonInfoMap(orgId, classLessonIds, userIds);
        List classIds = ListUtil.toKeyList((Collection)classLessons, (String)"courseId", OrgClassLesson.class);
        List courses = this.courseDao.getByIds((Collection)classIds, new String[]{"id", "parentId", "isCourse", "isClass", "courseType"});
        for (OrgCourse course : courses) {
            if (course.getIsClass() == CourseTypeEnum.IS_CLASS_TRUE.getCode() && course.getIsCourse() == CourseTypeEnum.IS_COURSE_FALSE.getCode()) {
                classCourseMap.put(course.getId(), course.getParentId());
            } else {
                classCourseMap.put(course.getId(), course.getId());
            }
            classMap.put(course.getId(), course);
        }
        List rules = this.courseConsumeRuleDao.queryConsumRuleListByCourseIds(orgId, classCourseMap.values(), new String[0]);
        Map ruleMap = CollectionHelper.toKeyMap((Collection)rules, (String)"courseId");
        data.setClassLessonMap(classLessonMap);
        data.setSignUpLessonsMap(signUpLessonsMap);
        data.setClassMap(classMap);
        data.setClassCourseMap(classCourseMap);
        data.setRuleMap(ruleMap);
        return data;
    }

    private Map<Long, Long> getClassIdToCourseId(List<OrgCourse> courses) {
        HashMap classCourseMap = Maps.newHashMap();
        for (OrgCourse course : courses) {
            if (course.getIsClass() == CourseTypeEnum.IS_CLASS_TRUE.getCode() && course.getIsCourse() == CourseTypeEnum.IS_COURSE_FALSE.getCode()) {
                classCourseMap.put(course.getId(), course.getParentId());
                continue;
            }
            classCourseMap.put(course.getId(), course.getId());
        }
        return classCourseMap;
    }

    private static class BatchData {
        Map<Long, Long> classCourseMap = Maps.newHashMap();
        Map<Long, OrgCourse> classMap = Maps.newHashMap();
        Map<Long, OrgCourseConsumeRule> ruleMap = Maps.newHashMap();
        Map<Long, OrgClassLesson> classLessonMap = Maps.newHashMap();
        Map<String, OrgSignupCourseLesson> signUpLessonsMap = Maps.newHashMap();

        public OrgCourse getOrgClass(Long classId) {
            return this.classMap.get(classId);
        }

        public OrgCourseConsumeRule getRuleByClassId(Long classId) {
            Long courseId = this.getClassCourseMap().get(classId);
            return this.ruleMap.get(courseId);
        }

        public OrgClassLesson getClassLesson(Long lessonId) {
            return this.classLessonMap.get(lessonId);
        }

        public OrgSignupCourseLesson getSignUpCourseLesson(String key) {
            return this.signUpLessonsMap.get(key);
        }

        public Map<Long, Long> getClassCourseMap() {
            return this.classCourseMap;
        }

        public Map<Long, OrgCourse> getClassMap() {
            return this.classMap;
        }

        public Map<Long, OrgCourseConsumeRule> getRuleMap() {
            return this.ruleMap;
        }

        public Map<Long, OrgClassLesson> getClassLessonMap() {
            return this.classLessonMap;
        }

        public Map<String, OrgSignupCourseLesson> getSignUpLessonsMap() {
            return this.signUpLessonsMap;
        }

        public void setClassCourseMap(Map<Long, Long> classCourseMap) {
            this.classCourseMap = classCourseMap;
        }

        public void setClassMap(Map<Long, OrgCourse> classMap) {
            this.classMap = classMap;
        }

        public void setRuleMap(Map<Long, OrgCourseConsumeRule> ruleMap) {
            this.ruleMap = ruleMap;
        }

        public void setClassLessonMap(Map<Long, OrgClassLesson> classLessonMap) {
            this.classLessonMap = classLessonMap;
        }

        public void setSignUpLessonsMap(Map<String, OrgSignupCourseLesson> signUpLessonsMap) {
            this.signUpLessonsMap = signUpLessonsMap;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof BatchData)) {
                return false;
            }
            BatchData other = (BatchData)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Map<Long, Long> this$classCourseMap = this.getClassCourseMap();
            Map<Long, Long> other$classCourseMap = other.getClassCourseMap();
            if (this$classCourseMap == null ? other$classCourseMap != null : !((Object)this$classCourseMap).equals(other$classCourseMap)) {
                return false;
            }
            Map<Long, OrgCourse> this$classMap = this.getClassMap();
            Map<Long, OrgCourse> other$classMap = other.getClassMap();
            if (this$classMap == null ? other$classMap != null : !((Object)this$classMap).equals(other$classMap)) {
                return false;
            }
            Map<Long, OrgCourseConsumeRule> this$ruleMap = this.getRuleMap();
            Map<Long, OrgCourseConsumeRule> other$ruleMap = other.getRuleMap();
            if (this$ruleMap == null ? other$ruleMap != null : !((Object)this$ruleMap).equals(other$ruleMap)) {
                return false;
            }
            Map<Long, OrgClassLesson> this$classLessonMap = this.getClassLessonMap();
            Map<Long, OrgClassLesson> other$classLessonMap = other.getClassLessonMap();
            if (this$classLessonMap == null ? other$classLessonMap != null : !((Object)this$classLessonMap).equals(other$classLessonMap)) {
                return false;
            }
            Map<String, OrgSignupCourseLesson> this$signUpLessonsMap = this.getSignUpLessonsMap();
            Map<String, OrgSignupCourseLesson> other$signUpLessonsMap = other.getSignUpLessonsMap();
            return !(this$signUpLessonsMap == null ? other$signUpLessonsMap != null : !((Object)this$signUpLessonsMap).equals(other$signUpLessonsMap));
        }

        protected boolean canEqual(Object other) {
            return other instanceof BatchData;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Map<Long, Long> $classCourseMap = this.getClassCourseMap();
            result = result * 59 + ($classCourseMap == null ? 43 : ((Object)$classCourseMap).hashCode());
            Map<Long, OrgCourse> $classMap = this.getClassMap();
            result = result * 59 + ($classMap == null ? 43 : ((Object)$classMap).hashCode());
            Map<Long, OrgCourseConsumeRule> $ruleMap = this.getRuleMap();
            result = result * 59 + ($ruleMap == null ? 43 : ((Object)$ruleMap).hashCode());
            Map<Long, OrgClassLesson> $classLessonMap = this.getClassLessonMap();
            result = result * 59 + ($classLessonMap == null ? 43 : ((Object)$classLessonMap).hashCode());
            Map<String, OrgSignupCourseLesson> $signUpLessonsMap = this.getSignUpLessonsMap();
            result = result * 59 + ($signUpLessonsMap == null ? 43 : ((Object)$signUpLessonsMap).hashCode());
            return result;
        }

        public String toString() {
            return "KexiaoComputeServiceImpl.BatchData(classCourseMap=" + this.getClassCourseMap() + ", classMap=" + this.getClassMap() + ", ruleMap=" + this.getRuleMap() + ", classLessonMap=" + this.getClassLessonMap() + ", signUpLessonsMap=" + this.getSignUpLessonsMap() + ")";
        }
    }
}

