/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.biz.erp.dto.request;

import com.baijia.tianxiao.biz.erp.dto.LessonTime;
import com.baijia.tianxiao.constants.TianXiaoConstant;
import com.baijia.tianxiao.util.date.TimeStamp;
import com.baijia.tianxiao.util.json.JacksonUtil;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import org.apache.commons.lang3.StringUtils;

public class EditLessonRequestDto {
    private Long lessonId;
    private String lessonName;
    private Long lessonDay;
    private String startTime;
    private String endTime;
    private Long teacherId;
    private Long roomId;
    private String studentIds;
    private LessonTime lessonTime;

    public Date getStartTime() {
        return this.initLessonTime().getStartTime();
    }

    public Date getEndTime() {
        return this.initLessonTime().getEndTime();
    }

    private LessonTime initLessonTime() {
        if (this.lessonTime == null) {
            if (this.lessonDay == null || this.lessonDay <= 0L) {
                throw new IllegalArgumentException("\u8bfe\u8282\u7684\u6240\u5728\u65e5\u671f\u4e0d\u6b63\u786e");
            }
            Date date = new Date(this.lessonDay);
            if (date.after(TianXiaoConstant.MAX_TIMESTAMP_CALEN.getTime())) {
                throw new IllegalArgumentException("\u8bfe\u8282\u7684\u6240\u5728\u65e5\u671f\u8bf7\u4e0d\u8981\u8d85\u8fc72037\u5e741\u67081\u65e5");
            }
            Calendar cal = Calendar.getInstance();
            cal.setTime(date);
            if (StringUtils.isBlank((CharSequence)this.startTime)) {
                throw new IllegalArgumentException("\u8bfe\u8282\u5f00\u59cb\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a,\u683c\u5f0f\u4e3aHH:mm");
            }
            if (StringUtils.isBlank((CharSequence)this.endTime)) {
                throw new IllegalArgumentException("\u8bfe\u8282\u7ed3\u675f\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a,\u683c\u5f0f\u4e3aHH:mm");
            }
            this.lessonTime = new LessonTime(cal, TimeStamp.parse((String)this.startTime), TimeStamp.parse((String)this.endTime));
        }
        return this.lessonTime;
    }

    public Collection<Long> getStudentIds() {
        if (StringUtils.isBlank((CharSequence)this.studentIds)) {
            return Collections.emptyList();
        }
        try {
            return JacksonUtil.str2List((String)this.studentIds, Long.class);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("\u5b66\u751fID\u6570\u7ec4\u53c2\u6570\u683c\u5f0f\u4e0d\u6b63\u786e");
        }
    }

    public void validate() {
        Preconditions.checkArgument((this.getLessonId() != null && this.getLessonId() > 0L ? 1 : 0) != 0, (Object)"\u8bfe\u8282ID\u4e0d\u6b63\u786e");
        Preconditions.checkArgument((boolean)this.getStartTime().before(this.getEndTime()), (Object)"\u8bfe\u8282\u7ed3\u675f\u65f6\u95f4\u4e0d\u80fd\u65e9\u4e8e\u5f00\u59cb\u65f6\u95f4");
        Preconditions.checkArgument((this.getLessonName() != null && this.getLessonName().length() < 21 ? 1 : 0) != 0, (Object)"\u8bfe\u8282\u540d\u79f0\u4e3a\u7a7a\u6216\u957f\u5ea6\u8d85\u8fc720");
    }

    public Long getLessonId() {
        return this.lessonId;
    }

    public String getLessonName() {
        return this.lessonName;
    }

    public Long getLessonDay() {
        return this.lessonDay;
    }

    public Long getTeacherId() {
        return this.teacherId;
    }

    public Long getRoomId() {
        return this.roomId;
    }

    public LessonTime getLessonTime() {
        return this.lessonTime;
    }

    public void setLessonId(Long lessonId) {
        this.lessonId = lessonId;
    }

    public void setLessonName(String lessonName) {
        this.lessonName = lessonName;
    }

    public void setLessonDay(Long lessonDay) {
        this.lessonDay = lessonDay;
    }

    public void setStartTime(String startTime) {
        this.startTime = startTime;
    }

    public void setEndTime(String endTime) {
        this.endTime = endTime;
    }

    public void setTeacherId(Long teacherId) {
        this.teacherId = teacherId;
    }

    public void setRoomId(Long roomId) {
        this.roomId = roomId;
    }

    public void setStudentIds(String studentIds) {
        this.studentIds = studentIds;
    }

    public void setLessonTime(LessonTime lessonTime) {
        this.lessonTime = lessonTime;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EditLessonRequestDto)) {
            return false;
        }
        EditLessonRequestDto other = (EditLessonRequestDto)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$lessonId = this.getLessonId();
        Long other$lessonId = other.getLessonId();
        if (this$lessonId == null ? other$lessonId != null : !((Object)this$lessonId).equals(other$lessonId)) {
            return false;
        }
        String this$lessonName = this.getLessonName();
        String other$lessonName = other.getLessonName();
        if (this$lessonName == null ? other$lessonName != null : !this$lessonName.equals(other$lessonName)) {
            return false;
        }
        Long this$lessonDay = this.getLessonDay();
        Long other$lessonDay = other.getLessonDay();
        if (this$lessonDay == null ? other$lessonDay != null : !((Object)this$lessonDay).equals(other$lessonDay)) {
            return false;
        }
        Date this$startTime = this.getStartTime();
        Date other$startTime = other.getStartTime();
        if (this$startTime == null ? other$startTime != null : !((Object)this$startTime).equals(other$startTime)) {
            return false;
        }
        Date this$endTime = this.getEndTime();
        Date other$endTime = other.getEndTime();
        if (this$endTime == null ? other$endTime != null : !((Object)this$endTime).equals(other$endTime)) {
            return false;
        }
        Long this$teacherId = this.getTeacherId();
        Long other$teacherId = other.getTeacherId();
        if (this$teacherId == null ? other$teacherId != null : !((Object)this$teacherId).equals(other$teacherId)) {
            return false;
        }
        Long this$roomId = this.getRoomId();
        Long other$roomId = other.getRoomId();
        if (this$roomId == null ? other$roomId != null : !((Object)this$roomId).equals(other$roomId)) {
            return false;
        }
        Collection<Long> this$studentIds = this.getStudentIds();
        Collection<Long> other$studentIds = other.getStudentIds();
        if (this$studentIds == null ? other$studentIds != null : !((Object)this$studentIds).equals(other$studentIds)) {
            return false;
        }
        LessonTime this$lessonTime = this.getLessonTime();
        LessonTime other$lessonTime = other.getLessonTime();
        return !(this$lessonTime == null ? other$lessonTime != null : !((Object)this$lessonTime).equals(other$lessonTime));
    }

    protected boolean canEqual(Object other) {
        return other instanceof EditLessonRequestDto;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $lessonId = this.getLessonId();
        result = result * 59 + ($lessonId == null ? 43 : ((Object)$lessonId).hashCode());
        String $lessonName = this.getLessonName();
        result = result * 59 + ($lessonName == null ? 43 : $lessonName.hashCode());
        Long $lessonDay = this.getLessonDay();
        result = result * 59 + ($lessonDay == null ? 43 : ((Object)$lessonDay).hashCode());
        Date $startTime = this.getStartTime();
        result = result * 59 + ($startTime == null ? 43 : ((Object)$startTime).hashCode());
        Date $endTime = this.getEndTime();
        result = result * 59 + ($endTime == null ? 43 : ((Object)$endTime).hashCode());
        Long $teacherId = this.getTeacherId();
        result = result * 59 + ($teacherId == null ? 43 : ((Object)$teacherId).hashCode());
        Long $roomId = this.getRoomId();
        result = result * 59 + ($roomId == null ? 43 : ((Object)$roomId).hashCode());
        Collection<Long> $studentIds = this.getStudentIds();
        result = result * 59 + ($studentIds == null ? 43 : ((Object)$studentIds).hashCode());
        LessonTime $lessonTime = this.getLessonTime();
        result = result * 59 + ($lessonTime == null ? 43 : ((Object)$lessonTime).hashCode());
        return result;
    }

    public String toString() {
        return "EditLessonRequestDto(lessonId=" + this.getLessonId() + ", lessonName=" + this.getLessonName() + ", lessonDay=" + this.getLessonDay() + ", startTime=" + this.getStartTime() + ", endTime=" + this.getEndTime() + ", teacherId=" + this.getTeacherId() + ", roomId=" + this.getRoomId() + ", studentIds=" + this.getStudentIds() + ", lessonTime=" + this.getLessonTime() + ")";
    }
}

